/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.operations;

import java.time.temporal.TemporalAmount;
import org.neo4j.exceptions.CypherTypeException;
import org.neo4j.values.AnyValue;
import org.neo4j.values.storable.ArrayValue;
import org.neo4j.values.storable.DurationValue;
import org.neo4j.values.storable.FloatingPointValue;
import org.neo4j.values.storable.IntegralValue;
import org.neo4j.values.storable.NumberValue;
import org.neo4j.values.storable.PointValue;
import org.neo4j.values.storable.TemporalValue;
import org.neo4j.values.storable.TextValue;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;
import org.neo4j.values.virtual.ListValue;
import org.neo4j.values.virtual.VirtualValues;

public final class CypherMath {
    private CypherMath() {
        throw new UnsupportedOperationException("Do not instantiate");
    }

    public static AnyValue add(AnyValue lhs, AnyValue rhs) {
        boolean lhsIsListValue;
        assert (lhs != Values.NO_VALUE && rhs != Values.NO_VALUE) : "NO_VALUE checks need to happen outside this call";
        if (lhs instanceof NumberValue && rhs instanceof NumberValue) {
            try {
                return ((NumberValue)lhs).plus((NumberValue)rhs);
            }
            catch (ArithmeticException e) {
                throw new org.neo4j.exceptions.ArithmeticException(e.getMessage(), (Throwable)e);
            }
        }
        if (lhs instanceof ArrayValue) {
            lhs = VirtualValues.fromArray((ArrayValue)((ArrayValue)lhs));
        }
        if (rhs instanceof ArrayValue) {
            rhs = VirtualValues.fromArray((ArrayValue)((ArrayValue)rhs));
        }
        if ((lhsIsListValue = lhs instanceof ListValue) && rhs instanceof ListValue) {
            return ((ListValue)lhs).appendAll((ListValue)rhs);
        }
        if (lhsIsListValue) {
            return ((ListValue)lhs).append(rhs);
        }
        if (rhs instanceof ListValue) {
            return ((ListValue)rhs).prepend(lhs);
        }
        if (lhs instanceof TextValue && rhs instanceof TextValue) {
            return ((TextValue)lhs).plus((TextValue)rhs);
        }
        if (lhs instanceof TextValue) {
            if (rhs instanceof Value) {
                if (!(rhs instanceof TemporalValue || rhs instanceof DurationValue || rhs instanceof PointValue)) {
                    return Values.stringValue((String)(((TextValue)lhs).stringValue() + ((Value)rhs).prettyPrint()));
                }
                return Values.stringValue((String)(((TextValue)lhs).stringValue() + String.valueOf(rhs)));
            }
        } else if (rhs instanceof TextValue && lhs instanceof Value) {
            if (!(lhs instanceof TemporalValue || lhs instanceof DurationValue || lhs instanceof PointValue)) {
                return Values.stringValue((String)(((Value)lhs).prettyPrint() + ((TextValue)rhs).stringValue()));
            }
            return Values.stringValue((String)(String.valueOf(lhs) + ((TextValue)rhs).stringValue()));
        }
        if (lhs instanceof TemporalValue && rhs instanceof DurationValue) {
            return ((TemporalValue)lhs).plus((TemporalAmount)((DurationValue)rhs));
        }
        if (lhs instanceof DurationValue) {
            if (rhs instanceof TemporalValue) {
                return ((TemporalValue)rhs).plus((TemporalAmount)((DurationValue)lhs));
            }
            if (rhs instanceof DurationValue) {
                return ((DurationValue)lhs).add((DurationValue)rhs);
            }
        }
        throw new CypherTypeException(String.format("Cannot add `%s` and `%s`", lhs.getTypeName(), rhs.getTypeName()));
    }

    public static AnyValue subtract(AnyValue lhs, AnyValue rhs) {
        assert (lhs != Values.NO_VALUE && rhs != Values.NO_VALUE) : "NO_VALUE checks need to happen outside this call";
        if (lhs instanceof NumberValue && rhs instanceof NumberValue) {
            try {
                return ((NumberValue)lhs).minus((NumberValue)rhs);
            }
            catch (ArithmeticException e) {
                throw new org.neo4j.exceptions.ArithmeticException(e.getMessage(), (Throwable)e);
            }
        }
        if (lhs instanceof TemporalValue && rhs instanceof DurationValue) {
            return ((TemporalValue)lhs).minus((TemporalAmount)((DurationValue)rhs));
        }
        if (lhs instanceof DurationValue && rhs instanceof DurationValue) {
            return ((DurationValue)lhs).sub((DurationValue)rhs);
        }
        throw new CypherTypeException(String.format("Cannot subtract `%s` from `%s`", rhs.getTypeName(), lhs.getTypeName()));
    }

    public static AnyValue multiply(AnyValue lhs, AnyValue rhs) {
        assert (lhs != Values.NO_VALUE && rhs != Values.NO_VALUE) : "NO_VALUE checks need to happen outside this call";
        if (lhs instanceof NumberValue && rhs instanceof NumberValue) {
            try {
                return ((NumberValue)lhs).times((NumberValue)rhs);
            }
            catch (ArithmeticException e) {
                throw new org.neo4j.exceptions.ArithmeticException(e.getMessage(), (Throwable)e);
            }
        }
        if (lhs instanceof DurationValue && rhs instanceof NumberValue) {
            return ((DurationValue)lhs).mul((NumberValue)rhs);
        }
        if (rhs instanceof DurationValue && lhs instanceof NumberValue) {
            return ((DurationValue)rhs).mul((NumberValue)lhs);
        }
        throw new CypherTypeException(String.format("Cannot multiply `%s` and `%s`", lhs.getTypeName(), rhs.getTypeName()));
    }

    public static boolean divideCheckForNull(AnyValue lhs, AnyValue rhs) {
        if (rhs instanceof IntegralValue && rhs.equals((Object)Values.ZERO_INT)) {
            throw new org.neo4j.exceptions.ArithmeticException("/ by zero", null);
        }
        return lhs == Values.NO_VALUE || rhs == Values.NO_VALUE;
    }

    public static AnyValue divide(AnyValue lhs, AnyValue rhs) {
        assert (lhs != Values.NO_VALUE && rhs != Values.NO_VALUE) : "NO_VALUE checks need to happen outside this call";
        if (lhs instanceof NumberValue && rhs instanceof NumberValue) {
            return ((NumberValue)lhs).divideBy((NumberValue)rhs);
        }
        if (lhs instanceof DurationValue && rhs instanceof NumberValue) {
            return ((DurationValue)lhs).div((NumberValue)rhs);
        }
        throw new CypherTypeException(String.format("Cannot divide `%s` by `%s`", lhs.getTypeName(), rhs.getTypeName()));
    }

    public static AnyValue modulo(AnyValue lhs, AnyValue rhs) {
        assert (lhs != Values.NO_VALUE && rhs != Values.NO_VALUE) : "NO_VALUE checks need to happen outside this call";
        if (lhs instanceof NumberValue && rhs instanceof NumberValue) {
            try {
                if (lhs instanceof FloatingPointValue || rhs instanceof FloatingPointValue) {
                    return Values.doubleValue((double)(((NumberValue)lhs).doubleValue() % ((NumberValue)rhs).doubleValue()));
                }
                return Values.longValue((long)(((NumberValue)lhs).longValue() % ((NumberValue)rhs).longValue()));
            }
            catch (ArithmeticException e) {
                throw new org.neo4j.exceptions.ArithmeticException(e.getMessage(), (Throwable)e);
            }
        }
        throw new CypherTypeException(String.format("Cannot calculate modulus of `%s` and `%s`", lhs.getTypeName(), rhs.getTypeName()));
    }

    public static AnyValue pow(AnyValue lhs, AnyValue rhs) {
        assert (lhs != Values.NO_VALUE && rhs != Values.NO_VALUE) : "NO_VALUE checks need to happen outside this call";
        if (lhs instanceof NumberValue && rhs instanceof NumberValue) {
            return Values.doubleValue((double)Math.pow(((NumberValue)lhs).doubleValue(), ((NumberValue)rhs).doubleValue()));
        }
        throw new CypherTypeException(String.format("Cannot raise `%s` to the power of `%s`", lhs.getTypeName(), rhs.getTypeName()));
    }
}

