/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.result;

import org.neo4j.graphdb.QueryStatistics;
import org.neo4j.kernel.impl.query.QuerySubscriber;
import org.neo4j.kernel.impl.query.QuerySubscription;

public abstract class EagerQuerySubscription
implements QuerySubscription {
    private long requestedRecords;
    private int servedRecords;
    protected final QuerySubscriber subscriber;
    protected boolean cancelled;
    protected Throwable error;

    protected EagerQuerySubscription(QuerySubscriber subscriber) {
        this.subscriber = subscriber;
    }

    protected abstract void streamRecordToSubscriber(int var1) throws Exception;

    protected abstract QueryStatistics queryStatistics();

    protected abstract int resultSize();

    protected abstract void materializeIfNecessary() throws Exception;

    public void request(long numberOfRecords) throws Exception {
        this.requestedRecords = EagerQuerySubscription.checkForOverflow(this.requestedRecords + numberOfRecords);
        this.materializeIfNecessary();
        this.streamToSubscriber();
    }

    public void cancel() {
        this.cancelled = true;
    }

    public boolean await() throws Exception {
        boolean hasMore;
        boolean bl = hasMore = this.servedRecords < this.resultSize();
        if (!hasMore) {
            if (this.error != null) {
                this.subscriber.onError(this.error);
            } else {
                this.subscriber.onResultCompleted(this.queryStatistics());
            }
        }
        return hasMore && !this.cancelled;
    }

    private void streamToSubscriber() {
        try {
            while ((long)this.servedRecords < this.requestedRecords && this.servedRecords < this.resultSize()) {
                this.subscriber.onRecord();
                this.streamRecordToSubscriber(this.servedRecords);
                this.subscriber.onRecordCompleted();
                ++this.servedRecords;
            }
        }
        catch (Throwable t) {
            this.error = t;
            this.servedRecords = this.resultSize();
        }
    }

    private static long checkForOverflow(long value) {
        if (value < 0L) {
            return Long.MAX_VALUE;
        }
        return value;
    }
}

