/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.result;

import java.util.ArrayList;
import java.util.List;
import org.neo4j.cypher.result.EagerQuerySubscription;
import org.neo4j.cypher.result.QueryResult;
import org.neo4j.cypher.result.VisitableRuntimeResult;
import org.neo4j.kernel.impl.query.QuerySubscriber;
import org.neo4j.values.AnyValue;

public abstract class NaiveQuerySubscription
extends EagerQuerySubscription
implements VisitableRuntimeResult,
QueryResult.QueryResultVisitor<Exception> {
    private List<AnyValue[]> materializedResult;

    protected NaiveQuerySubscription(QuerySubscriber subscriber) {
        super(subscriber);
    }

    @Override
    protected void streamRecordToSubscriber(int servedRecords) throws Exception {
        AnyValue[] current;
        for (AnyValue anyValue : current = this.materializedResult.get(servedRecords)) {
            this.subscriber.onField(anyValue);
        }
    }

    @Override
    public void request(long numberOfRecords) throws Exception {
        if (numberOfRecords == Long.MAX_VALUE) {
            this.streamResultsDirectly();
        } else {
            super.request(numberOfRecords);
        }
    }

    @Override
    protected int resultSize() {
        return this.materializedResult != null ? this.materializedResult.size() : -1;
    }

    @Override
    protected void materializeIfNecessary() throws Exception {
        if (this.materializedResult == null) {
            this.materializedResult = new ArrayList<AnyValue[]>();
            try {
                this.accept(record -> {
                    this.materializedResult.add((AnyValue[])record.fields().clone());
                    record.release();
                    return true;
                });
            }
            catch (Exception t) {
                this.error = t;
            }
            this.subscriber.onResult(this.fieldNames().length);
        }
    }

    private void streamResultsDirectly() throws Exception {
        int length = this.fieldNames().length;
        this.subscriber.onResult(length);
        try {
            this.accept(this);
        }
        catch (Exception t) {
            this.error = t;
        }
    }

    @Override
    public boolean visit(QueryResult.Record record) throws Exception {
        this.subscriber.onRecord();
        for (AnyValue field : record.fields()) {
            this.subscriber.onField(field);
        }
        this.subscriber.onRecordCompleted();
        record.release();
        return true;
    }
}

