/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.operations;

import org.neo4j.cypher.internal.runtime.DbAccess;
import org.neo4j.exceptions.CypherTypeException;
import org.neo4j.exceptions.EntityNotFoundException;
import org.neo4j.graphdb.Direction;
import org.neo4j.internal.kernel.api.CursorFactory;
import org.neo4j.internal.kernel.api.NodeCursor;
import org.neo4j.internal.kernel.api.PropertyCursor;
import org.neo4j.internal.kernel.api.Read;
import org.neo4j.internal.kernel.api.RelationshipScanCursor;
import org.neo4j.internal.kernel.api.helpers.RelationshipSelectionCursor;
import org.neo4j.internal.kernel.api.helpers.RelationshipSelections;
import org.neo4j.values.AnyValue;
import org.neo4j.values.storable.DurationValue;
import org.neo4j.values.storable.PointValue;
import org.neo4j.values.storable.TemporalValue;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;
import org.neo4j.values.virtual.MapValue;
import org.neo4j.values.virtual.VirtualNodeValue;
import org.neo4j.values.virtual.VirtualRelationshipValue;

public final class CursorUtils {
    private CursorUtils() {
        throw new UnsupportedOperationException();
    }

    public static Value nodeGetProperty(Read read, NodeCursor nodeCursor, long node, PropertyCursor propertyCursor, int prop) throws EntityNotFoundException {
        return CursorUtils.nodeGetProperty(read, nodeCursor, node, propertyCursor, prop, true);
    }

    public static Value nodeGetProperty(Read read, NodeCursor nodeCursor, long node, PropertyCursor propertyCursor, int prop, boolean throwOnDeleted) throws EntityNotFoundException {
        if (prop == -1) {
            return Values.NO_VALUE;
        }
        read.singleNode(node, nodeCursor);
        if (!nodeCursor.next()) {
            if (throwOnDeleted && read.nodeDeletedInTransaction(node)) {
                throw new EntityNotFoundException(String.format("Node with id %d has been deleted in this transaction", node));
            }
            return Values.NO_VALUE;
        }
        nodeCursor.properties(propertyCursor);
        while (propertyCursor.next()) {
            if (propertyCursor.propertyKey() != prop) continue;
            return propertyCursor.propertyValue();
        }
        return Values.NO_VALUE;
    }

    public static boolean nodeHasLabel(Read read, NodeCursor nodeCursor, long node, int label) {
        read.singleNode(node, nodeCursor);
        if (!nodeCursor.next()) {
            return false;
        }
        return nodeCursor.hasLabel(label);
    }

    public static RelationshipSelectionCursor nodeGetRelationships(Read read, CursorFactory cursors, NodeCursor node, long nodeId, Direction direction, int[] types) {
        read.singleNode(nodeId, node);
        if (!node.next()) {
            return RelationshipSelectionCursor.EMPTY;
        }
        switch (direction) {
            case OUTGOING: {
                return RelationshipSelections.outgoingCursor((CursorFactory)cursors, (NodeCursor)node, (int[])types);
            }
            case INCOMING: {
                return RelationshipSelections.incomingCursor((CursorFactory)cursors, (NodeCursor)node, (int[])types);
            }
            case BOTH: {
                return RelationshipSelections.allCursor((CursorFactory)cursors, (NodeCursor)node, (int[])types);
            }
        }
        throw new IllegalStateException("Unknown direction " + direction);
    }

    public static Value relationshipGetProperty(Read read, RelationshipScanCursor relationshipCursor, long relationship, PropertyCursor propertyCursor, int prop) throws EntityNotFoundException {
        return CursorUtils.relationshipGetProperty(read, relationshipCursor, relationship, propertyCursor, prop, true);
    }

    public static Value relationshipGetProperty(Read read, RelationshipScanCursor relationshipCursor, long relationship, PropertyCursor propertyCursor, int prop, boolean throwOnDeleted) throws EntityNotFoundException {
        if (prop == -1) {
            return Values.NO_VALUE;
        }
        read.singleRelationship(relationship, relationshipCursor);
        if (!relationshipCursor.next()) {
            if (throwOnDeleted && read.relationshipDeletedInTransaction(relationship)) {
                throw new EntityNotFoundException(String.format("Relationship with id %d has been deleted in this transaction", relationship));
            }
            return Values.NO_VALUE;
        }
        relationshipCursor.properties(propertyCursor);
        while (propertyCursor.next()) {
            if (propertyCursor.propertyKey() != prop) continue;
            return propertyCursor.propertyValue();
        }
        return Values.NO_VALUE;
    }

    public static RelationshipSelectionCursor nodeGetRelationships(Read read, CursorFactory cursors, NodeCursor node, long nodeId, Direction direction) {
        return CursorUtils.nodeGetRelationships(read, cursors, node, nodeId, direction, null);
    }

    public static AnyValue propertyGet(String key, AnyValue container, Read read, DbAccess dbAccess, NodeCursor nodeCursor, RelationshipScanCursor relationshipScanCursor, PropertyCursor propertyCursor) {
        assert (container != Values.NO_VALUE) : "NO_VALUE checks need to happen outside this call";
        if (container instanceof VirtualNodeValue) {
            return CursorUtils.nodeGetProperty(read, nodeCursor, ((VirtualNodeValue)container).id(), propertyCursor, dbAccess.propertyKey(key));
        }
        if (container instanceof VirtualRelationshipValue) {
            return CursorUtils.relationshipGetProperty(read, relationshipScanCursor, ((VirtualRelationshipValue)container).id(), propertyCursor, dbAccess.propertyKey(key));
        }
        if (container instanceof MapValue) {
            return ((MapValue)container).get(key);
        }
        if (container instanceof TemporalValue) {
            return ((TemporalValue)container).get(key);
        }
        if (container instanceof DurationValue) {
            return ((DurationValue)container).get(key);
        }
        if (container instanceof PointValue) {
            return ((PointValue)container).get(key);
        }
        throw new CypherTypeException(String.format("Type mismatch: expected a map but was %s", container.toString()), null);
    }
}

