/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.runtime.interpreted.commands.expressions;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import org.neo4j.cypher.internal.runtime.CypherRow;
import org.neo4j.cypher.internal.runtime.Expander;
import org.neo4j.cypher.internal.runtime.KernelPredicate;
import org.neo4j.cypher.internal.runtime.ReadableRow;
import org.neo4j.cypher.internal.runtime.interpreted.commands.AllInList;
import org.neo4j.cypher.internal.runtime.interpreted.commands.AstNode;
import org.neo4j.cypher.internal.runtime.interpreted.commands.NoneInList;
import org.neo4j.cypher.internal.runtime.interpreted.commands.ShortestPath;
import org.neo4j.cypher.internal.runtime.interpreted.commands.SingleNode;
import org.neo4j.cypher.internal.runtime.interpreted.commands.expressions.Expanders$;
import org.neo4j.cypher.internal.runtime.interpreted.commands.expressions.Expression;
import org.neo4j.cypher.internal.runtime.interpreted.commands.expressions.ExtendedExpression;
import org.neo4j.cypher.internal.runtime.interpreted.commands.expressions.LegacyShortestPathExpression$;
import org.neo4j.cypher.internal.runtime.interpreted.commands.expressions.NodesFunction;
import org.neo4j.cypher.internal.runtime.interpreted.commands.expressions.RelationshipFunction;
import org.neo4j.cypher.internal.runtime.interpreted.commands.expressions.TypeAndDirectionExpander;
import org.neo4j.cypher.internal.runtime.interpreted.commands.predicates.Ands;
import org.neo4j.cypher.internal.runtime.interpreted.commands.predicates.CoercedPredicate;
import org.neo4j.cypher.internal.runtime.interpreted.commands.predicates.Predicate;
import org.neo4j.cypher.internal.runtime.interpreted.pipes.QueryState;
import org.neo4j.cypher.internal.util.NonEmptyList;
import org.neo4j.cypher.internal.util.NonEmptyList$;
import org.neo4j.cypher.internal.util.attribution.Id;
import org.neo4j.exceptions.CypherTypeException;
import org.neo4j.exceptions.ShortestPathCommonEndNodesForbiddenException;
import org.neo4j.exceptions.SyntaxException;
import org.neo4j.graphdb.Entity;
import org.neo4j.graphdb.NotFoundException;
import org.neo4j.graphdb.Path;
import org.neo4j.graphdb.Relationship;
import org.neo4j.kernel.impl.util.ValueUtils;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.values.AnyValue;
import org.neo4j.values.VirtualValue;
import org.neo4j.values.storable.Values;
import org.neo4j.values.virtual.VirtualNodeValue;
import org.neo4j.values.virtual.VirtualPathValue;
import org.neo4j.values.virtual.VirtualValues;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.Tuple6;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Iterator;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\r}e\u0001\u0002\"D\u0001RC\u0001b\u001b\u0001\u0003\u0016\u0004%\t\u0001\u001c\u0005\tc\u0002\u0011\t\u0012)A\u0005[\"A!\u000f\u0001BK\u0002\u0013\u00051\u000f\u0003\u0005~\u0001\tE\t\u0015!\u0003u\u0011!q\bA!f\u0001\n\u0003\u0019\b\u0002C@\u0001\u0005#\u0005\u000b\u0011\u0002;\t\u0015\u0005\u0005\u0001A!f\u0001\n\u0003\t\u0019\u0001\u0003\u0006\u0002\f\u0001\u0011\t\u0012)A\u0005\u0003\u000bA!\"!\u0004\u0001\u0005+\u0007I\u0011AA\u0002\u0011)\ty\u0001\u0001B\tB\u0003%\u0011Q\u0001\u0005\u000b\u0003#\u0001!Q3A\u0005\u0002\u0005M\u0001BCA\u0013\u0001\tE\t\u0015!\u0003\u0002\u0016!9\u0011q\u0005\u0001\u0005\u0002\u0005%\u0002b\u0002>\u0001\u0005\u0004%\ta\u001d\u0005\b\u0003s\u0001\u0001\u0015!\u0003u\u0011\u001d\tY\u0004\u0001C\u0001\u0003{Aq!a\u000f\u0001\t\u0003\t9\u0007C\u0004\u0002~\u0001!I!a \t\u000f\u0005u\u0005\u0001\"\u0003\u0002 \"9\u0011\u0011\u001a\u0001\u0005\n\u0005-\u0007bBAm\u0001\u0011%\u00111\u001c\u0005\b\u0003?\u0004A\u0011IAq\u0011\u001d\u0011\u0019\u0001\u0001C!\u0005\u000bAqA!\u0003\u0001\t\u0003\u0012Y\u0001C\u0004\u0003\u0018\u0001!IA!\u0007\t\u000f\t\u0005\u0003\u0001\"\u0003\u0003D!9!\u0011\u000b\u0001\u0005\n\tM\u0003b\u0002B,\u0001\u0011%!\u0011\f\u0005\b\u0005g\u0002A\u0011\u0002B;\u0011\u001d\u0011y\t\u0001C\u0005\u0005#CqAa%\u0001\t\u0013\u0011)\nC\u0004\u0003 \u0002!IA!)\t\u000f\tU\u0006\u0001\"\u0003\u00038\"I!Q\u0018\u0001\u0002\u0002\u0013\u0005!q\u0018\u0005\n\u0005\u001b\u0004\u0011\u0013!C\u0001\u0005\u001fD\u0011B!9\u0001#\u0003%\tAa9\t\u0013\t\u001d\b!%A\u0005\u0002\t\r\b\"\u0003Bu\u0001E\u0005I\u0011\u0001Bv\u0011%\u0011y\u000fAI\u0001\n\u0003\u0011Y\u000fC\u0005\u0003r\u0002\t\n\u0011\"\u0001\u0003t\"I!q\u001f\u0001\u0002\u0002\u0013\u0005#\u0011 \u0005\n\u0007\u0017\u0001\u0011\u0011!C\u0001\u0007\u001bA\u0011ba\u0004\u0001\u0003\u0003%\ta!\u0005\t\u0013\r]\u0001!!A\u0005B\re\u0001\"CB\u0014\u0001\u0005\u0005I\u0011AB\u0015\u0011%\u0019i\u0003AA\u0001\n\u0003\u001ay\u0003C\u0005\u00044\u0001\t\t\u0011\"\u0011\u00046!I1q\u0007\u0001\u0002\u0002\u0013\u00053\u0011H\u0004\b\u0007{\u0019\u0005\u0012AB \r\u0019\u00115\t#\u0001\u0004B!9\u0011q\u0005\u001a\u0005\u0002\r5\u0003bBB(e\u0011\u00051\u0011\u000b\u0005\n\u0003w\u0011\u0014\u0011!CA\u0007GB\u0011b!\u001d3#\u0003%\tAa9\t\u0013\rM$'%A\u0005\u0002\t\r\b\"CB;eE\u0005I\u0011\u0001Bv\u0011%\u00199HMI\u0001\n\u0003\u0011Y\u000fC\u0005\u0004zI\n\n\u0011\"\u0001\u0003t\"I11\u0010\u001a\u0002\u0002\u0013\u00055Q\u0010\u0005\n\u0007\u0017\u0013\u0014\u0013!C\u0001\u0005GD\u0011b!$3#\u0003%\tAa9\t\u0013\r=%'%A\u0005\u0002\t-\b\"CBIeE\u0005I\u0011\u0001Bv\u0011%\u0019\u0019JMI\u0001\n\u0003\u0011\u0019\u0010C\u0005\u0004\u0016J\n\t\u0011\"\u0003\u0004\u0018\naB*Z4bGf\u001c\u0006n\u001c:uKN$\b+\u0019;i\u000bb\u0004(/Z:tS>t'B\u0001#F\u0003-)\u0007\u0010\u001d:fgNLwN\\:\u000b\u0005\u0019;\u0015\u0001C2p[6\fg\u000eZ:\u000b\u0005!K\u0015aC5oi\u0016\u0014\bO]3uK\u0012T!AS&\u0002\u000fI,h\u000e^5nK*\u0011A*T\u0001\tS:$XM\u001d8bY*\u0011ajT\u0001\u0007Gf\u0004\b.\u001a:\u000b\u0005A\u000b\u0016!\u00028f_RR'\"\u0001*\u0002\u0007=\u0014xm\u0001\u0001\u0014\t\u0001)\u0016l\u0018\t\u0003-^k\u0011aQ\u0005\u00031\u000e\u0013!\"\u0012=qe\u0016\u001c8/[8o!\tQV,D\u0001\\\u0015\u0005a\u0016!B:dC2\f\u0017B\u00010\\\u0005\u001d\u0001&o\u001c3vGR\u0004\"\u0001\u00195\u000f\u0005\u00054gB\u00012f\u001b\u0005\u0019'B\u00013T\u0003\u0019a$o\\8u}%\tA,\u0003\u0002h7\u00069\u0001/Y2lC\u001e,\u0017BA5k\u00051\u0019VM]5bY&T\u0018M\u00197f\u0015\t97,A\ntQ>\u0014H/Z:u!\u0006$\b\u000eU1ui\u0016\u0014h.F\u0001n!\tqw.D\u0001F\u0013\t\u0001XI\u0001\u0007TQ>\u0014H/Z:u!\u0006$\b.\u0001\u000btQ>\u0014H/Z:u!\u0006$\b\u000eU1ui\u0016\u0014h\u000eI\u0001\u0012a\u0016\u00148\u000b^3q!J,G-[2bi\u0016\u001cX#\u0001;\u0011\u0007\u0001,x/\u0003\u0002wU\n\u00191+Z9\u0011\u0005a\\X\"A=\u000b\u0005i,\u0015A\u00039sK\u0012L7-\u0019;fg&\u0011A0\u001f\u0002\n!J,G-[2bi\u0016\f!\u0003]3s'R,\u0007\u000f\u0015:fI&\u001c\u0017\r^3tA\u0005\u0011b-\u001e7m!\u0006$\b\u000e\u0015:fI&\u001c\u0017\r^3t\u0003M1W\u000f\u001c7QCRD\u0007K]3eS\u000e\fG/Z:!\u000319\u0018\u000e\u001e5GC2d')Y2l+\t\t)\u0001E\u0002[\u0003\u000fI1!!\u0003\\\u0005\u001d\u0011un\u001c7fC:\fQb^5uQ\u001a\u000bG\u000e\u001c\"bG.\u0004\u0013\u0001\u00053jg\u0006dGn\\<TC6,gj\u001c3f\u0003E!\u0017n]1mY><8+Y7f\u001d>$W\rI\u0001\u000b_B,'/\u0019;pe&#WCAA\u000b!\u0011\t9\"!\t\u000e\u0005\u0005e!\u0002BA\u000e\u0003;\t1\"\u0019;ue&\u0014W\u000f^5p]*\u0019\u0011qD&\u0002\tU$\u0018\u000e\\\u0005\u0005\u0003G\tIB\u0001\u0002JI\u0006Yq\u000e]3sCR|'/\u00133!\u0003\u0019a\u0014N\\5u}Qq\u00111FA\u0017\u0003_\t\t$a\r\u00026\u0005]\u0002C\u0001,\u0001\u0011\u0015YW\u00021\u0001n\u0011\u001d\u0011X\u0002%AA\u0002QDqA`\u0007\u0011\u0002\u0003\u0007A\u000fC\u0005\u0002\u00025\u0001\n\u00111\u0001\u0002\u0006!I\u0011QB\u0007\u0011\u0002\u0003\u0007\u0011Q\u0001\u0005\n\u0003#i\u0001\u0013!a\u0001\u0003+\t1\u0002\u001d:fI&\u001c\u0017\r^3tA\u0005)\u0011\r\u001d9msR1\u0011qHA&\u0003/\u0002B!!\u0011\u0002H5\u0011\u00111\t\u0006\u0004\u0003\u000bz\u0015A\u0002<bYV,7/\u0003\u0003\u0002J\u0005\r#\u0001C!osZ\u000bG.^3\t\u000f\u00055\u0003\u00031\u0001\u0002P\u0005\u0019!o\\<\u0011\t\u0005E\u00131K\u0007\u0002\u0013&\u0019\u0011QK%\u0003\u0017I+\u0017\rZ1cY\u0016\u0014vn\u001e\u0005\b\u00033\u0002\u0002\u0019AA.\u0003\u0015\u0019H/\u0019;f!\u0011\ti&a\u0019\u000e\u0005\u0005}#bAA1\u000f\u0006)\u0001/\u001b9fg&!\u0011QMA0\u0005)\tV/\u001a:z'R\fG/\u001a\u000b\t\u0003\u007f\tI'a\u001b\u0002n!9\u0011QJ\tA\u0002\u0005=\u0003bBA-#\u0001\u0007\u00111\f\u0005\b\u0003_\n\u0002\u0019AA9\u00035iW-\\8ssR\u0013\u0018mY6feB!\u00111OA=\u001b\t\t)HC\u0002\u0002x=\u000ba!\\3n_JL\u0018\u0002BA>\u0003k\u0012Q\"T3n_JLHK]1dW\u0016\u0014\u0018AC4fi6\u000bGo\u00195fgRa\u0011qHAA\u0003\u000b\u000b)*!'\u0002\u001c\"9\u00111\u0011\nA\u0002\u0005=\u0013aA2uq\"9\u0011q\u0011\nA\u0002\u0005%\u0015!B:uCJ$\b\u0003BAF\u0003#k!!!$\u000b\t\u0005=\u00151I\u0001\bm&\u0014H/^1m\u0013\u0011\t\u0019*!$\u0003!YK'\u000f^;bY:{G-\u001a,bYV,\u0007bBAL%\u0001\u0007\u0011\u0011R\u0001\u0004K:$\u0007bBA-%\u0001\u0007\u00111\f\u0005\b\u0003_\u0012\u0002\u0019AA9\u0003m\u0019'/Z1uKNCwN\u001d;fgR\u0004\u0016\r\u001e5Qe\u0016$\u0017nY1uKRA\u0011\u0011UAZ\u0003{\u000b9\r\u0005\u0004\u0002R\u0005\r\u0016qU\u0005\u0004\u0003KK%aD&fe:,G\u000e\u0015:fI&\u001c\u0017\r^3\u0011\t\u0005%\u0016qV\u0007\u0003\u0003WS1!!,P\u0003\u001d9'/\u00199iI\nLA!!-\u0002,\n!\u0001+\u0019;i\u0011\u001d\t)l\u0005a\u0001\u0003o\u000b1\"\u001b8d_6LgnZ\"uqB!\u0011\u0011KA]\u0013\r\tY,\u0013\u0002\n\u0007f\u0004\b.\u001a:S_^Dq!a0\u0014\u0001\u0004\t\t-\u0001\bnCf\u0014W\r\u0015:fI&\u001c\u0017\r^3\u0011\ti\u000b\u0019m^\u0005\u0004\u0003\u000b\\&AB(qi&|g\u000eC\u0004\u0002ZM\u0001\r!a\u0017\u0002\u0017\u001d,G/\u00128e!>Lg\u000e\u001e\u000b\t\u0003\u0013\u000bi-a4\u0002R\"9\u00111\u0011\u000bA\u0002\u0005=\u0003bBA-)\u0001\u0007\u00111\f\u0005\b\u0003\u000f#\u0002\u0019AAj!\rq\u0017Q[\u0005\u0004\u0003/,%AC*j]\u001edWMT8eK\u0006I\u0012M\\=Ti\u0006\u0014H\u000f]8j]R\u001c8i\u001c8uC&tg*\u001e7m)\u0011\t)!!8\t\u000f\u0005\rU\u00031\u0001\u0002P\u0005A1\r[5mIJ,g.\u0006\u0002\u0002dB!\u0001-^Asa\u0011\t9/!=\u0011\u000b9\fI/!<\n\u0007\u0005-XIA\u0004BgRtu\u000eZ3\u0011\t\u0005=\u0018\u0011\u001f\u0007\u0001\t-\t\u0019PFA\u0001\u0002\u0003\u0015\t!!>\u0003\u0007}#\u0013'\u0005\u0003\u0002x\u0006u\bc\u0001.\u0002z&\u0019\u00111`.\u0003\u000f9{G\u000f[5oOB\u0019!,a@\n\u0007\t\u00051LA\u0002B]f\f\u0011\"\u0019:hk6,g\u000e^:\u0016\u0005\t\u001d\u0001c\u00011v+\u00069!/Z<sSR,GcA+\u0003\u000e!9!q\u0002\rA\u0002\tE\u0011!\u00014\u0011\u000bi\u0013\u0019\"V+\n\u0007\tU1LA\u0005Gk:\u001cG/[8oc\u0005\u00113-\u001f9iKJ\u0004vn]5uSZ,\u0007K]3eS\u000e\fG/Z:Bg\u0016C\b/\u00198eKJ$\"Ba\u0007\u00030\tE\"1\bB %\u0019\u0011iB!\t\u0003(\u00191!qD\r\u0001\u00057\u0011A\u0002\u0010:fM&tW-\\3oiz\u00022A\u0017B\u0012\u0013\r\u0011)c\u0017\u0002\u0007\u0003:L(+\u001a4\u0011\r\u0005E\u00131\u0015B\u0015!\u0011\tIKa\u000b\n\t\t5\u00121\u0016\u0002\u0007\u000b:$\u0018\u000e^=\t\u000f\u0005U\u0016\u00041\u0001\u0002P!9!1G\rA\u0002\tU\u0012A\u0004<be&\f'\r\\3PM\u001a\u001cX\r\u001e\t\u00045\n]\u0012b\u0001B\u001d7\n\u0019\u0011J\u001c;\t\r\tu\u0012\u00041\u0001x\u0003%\u0001(/\u001a3jG\u0006$X\rC\u0004\u0002Ze\u0001\r!a\u0017\u0002E\rL\b\u000f[3s\u001d\u0016<\u0017\r^5wKB\u0013X\rZ5dCR,7/Q:FqB\fg\u000eZ3s))\u0011)E!\u0013\u0003L\t5#q\n\n\u0007\u0005\u000f\u0012\tCa\n\u0007\r\t}!\u0004\u0001B#\u0011\u001d\t)L\u0007a\u0001\u0003\u001fBqAa\r\u001b\u0001\u0004\u0011)\u0004\u0003\u0004\u0003>i\u0001\ra\u001e\u0005\b\u00033R\u0002\u0019AA.\u000351\u0017N\u001c3Qe\u0016$\u0017nY1uKR\u0019QK!\u0016\t\r\tu2\u00041\u0001x\u0003\u0001\nG\rZ!mY>\u0013hj\u001c8f%\u0016d\u0017\r^5p]ND\u0017\u000e]#ya\u0006tG-\u001a:\u0015\u001d\tm#\u0011\rB2\u0005O\u0012YG!\u001c\u0003rA!\u0011\u0011\u000bB/\u0013\r\u0011y&\u0013\u0002\t\u000bb\u0004\u0018M\u001c3fe\"9\u00111\u0011\u000fA\u0002\u0005=\u0003b\u0002B39\u0001\u0007!1L\u0001\u0010GV\u0014(/\u001a8u\u000bb\u0004\u0018M\u001c3fe\"9!\u0011\u000e\u000fA\u0002\u0005\u0015\u0011aA1mY\"1!Q\b\u000fA\u0002]DqAa\u001c\u001d\u0001\u0004\u0011)$A\tsK24\u0016M]5bE2,wJ\u001a4tKRDq!!\u0017\u001d\u0001\u0004\tY&\u0001\rbI\u0012\fE\u000e\\(s\u001d>tWMT8eK\u0016C\b/\u00198eKJ$\u0002Ca\u001e\u0003\u0000\t\u0005%1\u0011BC\u0005\u000f\u0013II!$\u0011\u000fi\u0013IHa\u0017\u0003~%\u0019!1P.\u0003\rQ+\b\u000f\\33!\u0011\u0001WOa\n\t\u000f\u0005\rU\u00041\u0001\u0002P!9!QM\u000fA\u0002\tm\u0003b\u0002B5;\u0001\u0007\u0011Q\u0001\u0005\u0007\u0005{i\u0002\u0019A<\t\u000f\t=T\u00041\u0001\u00036!9!1R\u000fA\u0002\tu\u0014!F2veJ,g\u000e\u001e(pI\u0016\u0004&/\u001a3jG\u0006$Xm\u001d\u0005\b\u00033j\u0002\u0019AA.\u0003qi\u0017m[3SK2\fG/[8og\"L\u0007\u000fV=qK\u0016C\b/\u00198eKJ$\"Aa\u0017\u0002\u001b\u0005$G\r\u0015:fI&\u001c\u0017\r^3t)!\u00119Ha&\u0003\u001a\nu\u0005bBAB?\u0001\u0007\u0011q\n\u0005\b\u00057{\u0002\u0019\u0001B.\u0003U\u0011X\r\u001c+za\u0016\fe\u000e\u001a#je\u0016C\b/\u00198eKJDq!!\u0017 \u0001\u0004\tY&A\bjg:{G-Z:Gk:\u001cG/[8o)\u0011\t)Aa)\t\r\t\u0015\u0006\u00051\u0001V\u0003))\u0007\u0010\u001d:fgNLwN\u001c\u0015\u0004A\t%\u0006\u0003\u0002BV\u0005ck!A!,\u000b\u0007\t=6,\u0001\u0006b]:|G/\u0019;j_:LAAa-\u0003.\n9A/Y5me\u0016\u001c\u0017aF5t%\u0016d\u0017\r^5p]ND\u0017\u000e]:Gk:\u001cG/[8o)\u0011\t)A!/\t\r\t\u0015\u0016\u00051\u0001VQ\r\t#\u0011V\u0001\u0005G>\u0004\u0018\u0010\u0006\b\u0002,\t\u0005'1\u0019Bc\u0005\u000f\u0014IMa3\t\u000f-\u0014\u0003\u0013!a\u0001[\"9!O\tI\u0001\u0002\u0004!\bb\u0002@#!\u0003\u0005\r\u0001\u001e\u0005\n\u0003\u0003\u0011\u0003\u0013!a\u0001\u0003\u000bA\u0011\"!\u0004#!\u0003\u0005\r!!\u0002\t\u0013\u0005E!\u0005%AA\u0002\u0005U\u0011AD2paf$C-\u001a4bk2$H%M\u000b\u0003\u0005#T3!\u001cBjW\t\u0011)\u000e\u0005\u0003\u0003X\nuWB\u0001Bm\u0015\u0011\u0011YN!,\u0002\u0013Ut7\r[3dW\u0016$\u0017\u0002\u0002Bp\u00053\u0014\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uII*\"A!:+\u0007Q\u0014\u0019.\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u001a\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%iU\u0011!Q\u001e\u0016\u0005\u0003\u000b\u0011\u0019.\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u001b\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%mU\u0011!Q\u001f\u0016\u0005\u0003+\u0011\u0019.A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u000b\u0003\u0005w\u0004BA!@\u0004\b5\u0011!q \u0006\u0005\u0007\u0003\u0019\u0019!\u0001\u0003mC:<'BAB\u0003\u0003\u0011Q\u0017M^1\n\t\r%!q \u0002\u0007'R\u0014\u0018N\\4\u0002\u0019A\u0014x\u000eZ;di\u0006\u0013\u0018\u000e^=\u0016\u0005\tU\u0012A\u00049s_\u0012,8\r^#mK6,g\u000e\u001e\u000b\u0005\u0003{\u001c\u0019\u0002C\u0005\u0004\u0016-\n\t\u00111\u0001\u00036\u0005\u0019\u0001\u0010J\u0019\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"aa\u0007\u0011\r\ru11EA\u007f\u001b\t\u0019yBC\u0002\u0004\"m\u000b!bY8mY\u0016\u001cG/[8o\u0013\u0011\u0019)ca\b\u0003\u0011%#XM]1u_J\f\u0001bY1o\u000bF,\u0018\r\u001c\u000b\u0005\u0003\u000b\u0019Y\u0003C\u0005\u0004\u00165\n\t\u00111\u0001\u0002~\u0006\u0011\u0002O]8ek\u000e$X\t\\3nK:$h*Y7f)\u0011\u0011Yp!\r\t\u0013\rUa&!AA\u0002\tU\u0012\u0001\u00035bg\"\u001cu\u000eZ3\u0015\u0005\tU\u0012AB3rk\u0006d7\u000f\u0006\u0003\u0002\u0006\rm\u0002\"CB\u000ba\u0005\u0005\t\u0019AA\u007f\u0003qaUmZ1dsNCwN\u001d;fgR\u0004\u0016\r\u001e5FqB\u0014Xm]:j_:\u0004\"A\u0016\u001a\u0014\u000bI\u0012\tca\u0011\u0011\t\r\u001531J\u0007\u0003\u0007\u000fRAa!\u0013\u0004\u0004\u0005\u0011\u0011n\\\u0005\u0004S\u000e\u001dCCAB \u00031qw\u000eR;qY&\u001c\u0017\r^3t)\u0011\t)aa\u0015\t\u000f\rUC\u00071\u0001\u0004X\u0005i!/\u001a7bi&|gn\u001d5jaN\u0004R\u0001YB-\u0007;J1aa\u0017k\u0005!IE/\u001a:bE2,\u0007\u0003BAU\u0007?JAa!\u0019\u0002,\na!+\u001a7bi&|gn\u001d5jaRq\u00111FB3\u0007O\u001aIga\u001b\u0004n\r=\u0004\"B66\u0001\u0004i\u0007b\u0002:6!\u0003\u0005\r\u0001\u001e\u0005\b}V\u0002\n\u00111\u0001u\u0011%\t\t!\u000eI\u0001\u0002\u0004\t)\u0001C\u0005\u0002\u000eU\u0002\n\u00111\u0001\u0002\u0006!I\u0011\u0011C\u001b\u0011\u0002\u0003\u0007\u0011QC\u0001\u0010CB\u0004H.\u001f\u0013eK\u001a\fW\u000f\u001c;%e\u0005y\u0011\r\u001d9ms\u0012\"WMZ1vYR$3'A\bbaBd\u0017\u0010\n3fM\u0006,H\u000e\u001e\u00135\u0003=\t\u0007\u000f\u001d7zI\u0011,g-Y;mi\u0012*\u0014aD1qa2LH\u0005Z3gCVdG\u000f\n\u001c\u0002\u000fUt\u0017\r\u001d9msR!1qPBD!\u0015Q\u00161YBA!1Q61Q7ui\u0006\u0015\u0011QAA\u000b\u0013\r\u0019)i\u0017\u0002\u0007)V\u0004H.\u001a\u001c\t\u0013\r%5(!AA\u0002\u0005-\u0012a\u0001=%a\u0005YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uII\n1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012\u001a\u0014a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$C'A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$H%N\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000f\n\u001c\u0002\u0019]\u0014\u0018\u000e^3SKBd\u0017mY3\u0015\u0005\re\u0005\u0003\u0002B\u007f\u00077KAa!(\u0003\u0000\n1qJ\u00196fGR\u0004")
public class LegacyShortestPathExpression
extends Expression
implements Product,
Serializable {
    private final ShortestPath shortestPathPattern;
    private final Seq<Predicate> perStepPredicates;
    private final Seq<Predicate> fullPathPredicates;
    private final boolean withFallBack;
    private final boolean disallowSameNode;
    private final int operatorId;
    private final Seq<Predicate> predicates;

    public static int $lessinit$greater$default$6() {
        return LegacyShortestPathExpression$.MODULE$.$lessinit$greater$default$6();
    }

    public static boolean $lessinit$greater$default$5() {
        return LegacyShortestPathExpression$.MODULE$.$lessinit$greater$default$5();
    }

    public static boolean $lessinit$greater$default$4() {
        return LegacyShortestPathExpression$.MODULE$.$lessinit$greater$default$4();
    }

    public static Seq<Predicate> $lessinit$greater$default$3() {
        return LegacyShortestPathExpression$.MODULE$.$lessinit$greater$default$3();
    }

    public static Seq<Predicate> $lessinit$greater$default$2() {
        return LegacyShortestPathExpression$.MODULE$.$lessinit$greater$default$2();
    }

    public static Option<Tuple6<ShortestPath, Seq<Predicate>, Seq<Predicate>, Object, Object, Id>> unapply(LegacyShortestPathExpression x$0) {
        return LegacyShortestPathExpression$.MODULE$.unapply(x$0);
    }

    public static int apply$default$6() {
        return LegacyShortestPathExpression$.MODULE$.apply$default$6();
    }

    public static boolean apply$default$5() {
        return LegacyShortestPathExpression$.MODULE$.apply$default$5();
    }

    public static boolean apply$default$4() {
        return LegacyShortestPathExpression$.MODULE$.apply$default$4();
    }

    public static Seq<Predicate> apply$default$3() {
        return LegacyShortestPathExpression$.MODULE$.apply$default$3();
    }

    public static Seq<Predicate> apply$default$2() {
        return LegacyShortestPathExpression$.MODULE$.apply$default$2();
    }

    public static boolean noDuplicates(Iterable<Relationship> relationships) {
        return LegacyShortestPathExpression$.MODULE$.noDuplicates(relationships);
    }

    public Iterator<String> productElementNames() {
        return Product.productElementNames$((Product)this);
    }

    public ShortestPath shortestPathPattern() {
        return this.shortestPathPattern;
    }

    public Seq<Predicate> perStepPredicates() {
        return this.perStepPredicates;
    }

    public Seq<Predicate> fullPathPredicates() {
        return this.fullPathPredicates;
    }

    public boolean withFallBack() {
        return this.withFallBack;
    }

    public boolean disallowSameNode() {
        return this.disallowSameNode;
    }

    public int operatorId() {
        return this.operatorId;
    }

    public Seq<Predicate> predicates() {
        return this.predicates;
    }

    @Override
    public AnyValue apply(ReadableRow row, QueryState state) {
        return this.apply(row, state, state.memoryTrackerForOperatorProvider().memoryTrackerForOperator(this.operatorId()));
    }

    public AnyValue apply(ReadableRow row, QueryState state, MemoryTracker memoryTracker) {
        if (this.anyStartpointsContainNull(row)) {
            return Values.NO_VALUE;
        }
        VirtualNodeValue start = this.getEndPoint(row, state, this.shortestPathPattern().left());
        VirtualNodeValue end = this.getEndPoint(row, state, this.shortestPathPattern().right());
        if (!this.shortestPathPattern().allowZeroLength() && this.disallowSameNode() && start.equals((VirtualValue)end)) {
            throw new ShortestPathCommonEndNodesForbiddenException();
        }
        return this.getMatches(row, start, end, state, memoryTracker);
    }

    private AnyValue getMatches(ReadableRow ctx, VirtualNodeValue start, VirtualNodeValue end, QueryState state, MemoryTracker memoryTracker) {
        Tuple2<Expander, Seq<KernelPredicate<Entity>>> tuple2 = this.addPredicates(ctx, this.makeRelationshipTypeExpander(), state);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Expander expander = (Expander)tuple2._1();
        Seq nodePredicates = (Seq)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)expander, (Object)nodePredicates);
        Expander expander2 = (Expander)tuple22._1();
        Seq nodePredicates2 = (Seq)tuple22._2();
        None$ maybePredicate = this.predicates().isEmpty() ? None$.MODULE$ : new Some((Object)new Ands((NonEmptyList<Predicate>)NonEmptyList$.MODULE$.from(this.predicates())));
        CypherRow cypherRow = (CypherRow)ctx;
        KernelPredicate<Path> shortestPathPredicate = this.createShortestPathPredicate(cypherRow, (Option<Predicate>)maybePredicate, state);
        if (this.shortestPathPattern().single()) {
            Option result = state.query().singleShortestPath(start.id(), end.id(), BoxesRunTime.unboxToInt((Object)this.shortestPathPattern().maxDepth().getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> Integer.MAX_VALUE)), expander2, shortestPathPredicate, nodePredicates2, memoryTracker);
            if (!this.shortestPathPattern().allowZeroLength() && result.forall((Function1 & Serializable)p -> BoxesRunTime.boxToBoolean((boolean)LegacyShortestPathExpression.$anonfun$getMatches$2(p)))) {
                return Values.NO_VALUE;
            }
            return (AnyValue)result.map((Function1 & Serializable)x$1 -> ValueUtils.fromPath((Path)x$1)).getOrElse((Function0 & Serializable)() -> Values.NO_VALUE);
        }
        VirtualPathValue[] result = (VirtualPathValue[])state.query().allShortestPath(start.id(), end.id(), BoxesRunTime.unboxToInt((Object)this.shortestPathPattern().maxDepth().getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> Integer.MAX_VALUE)), expander2, shortestPathPredicate, nodePredicates2, memoryTracker).filter((Function1 & Serializable)p -> BoxesRunTime.boxToBoolean((boolean)LegacyShortestPathExpression.$anonfun$getMatches$6(this, p))).map((Function1 & Serializable)x$1 -> ValueUtils.fromPath((Path)x$1)).toArray(ClassTag$.MODULE$.apply(VirtualPathValue.class));
        return VirtualValues.list((AnyValue[])((AnyValue[])result));
    }

    private KernelPredicate<Path> createShortestPathPredicate(CypherRow incomingCtx, Option<Predicate> maybePredicate, QueryState state) {
        return new KernelPredicate<Path>(this, maybePredicate, incomingCtx, state){
            private final /* synthetic */ LegacyShortestPathExpression $outer;
            private final Option maybePredicate$1;
            private final CypherRow incomingCtx$1;
            private final QueryState state$1;

            public boolean test(Path path) {
                return this.maybePredicate$1.forall((Function1 & Serializable)predicate -> BoxesRunTime.boxToBoolean((boolean)$anon$1.$anonfun$test$1(this, path, predicate))) && (!this.$outer.withFallBack() || LegacyShortestPathExpression$.MODULE$.noDuplicates((Iterable<Relationship>)CollectionConverters$.MODULE$.IterableHasAsScala(path.relationships()).asScala()));
            }

            public static final /* synthetic */ boolean $anonfun$test$1($anon$1 $this, Path path$1, Predicate predicate) {
                $this.incomingCtx$1.set($this.$outer.shortestPathPattern().pathName(), (AnyValue)ValueUtils.fromPath((Path)path$1));
                $this.incomingCtx$1.set((String)$this.$outer.shortestPathPattern().relIterator().get(), (AnyValue)ValueUtils.asListOfEdges((java.lang.Iterable)path$1.relationships()));
                return predicate.isTrue((ReadableRow)$this.incomingCtx$1, $this.state$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.maybePredicate$1 = maybePredicate$1;
                this.incomingCtx$1 = incomingCtx$1;
                this.state$1 = state$1;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$test$1$adapted(org.neo4j.cypher.internal.runtime.interpreted.commands.expressions.LegacyShortestPathExpression$$anon$1 org.neo4j.graphdb.Path org.neo4j.cypher.internal.runtime.interpreted.commands.predicates.Predicate )}, serializedLambda);
            }
        };
    }

    private VirtualNodeValue getEndPoint(ReadableRow ctx, QueryState state, SingleNode start) {
        VirtualNodeValue virtualNodeValue;
        try {
            VirtualNodeValue virtualNodeValue2;
            AnyValue anyValue = ctx.getByName(start.name());
            if (!(anyValue instanceof VirtualNodeValue)) {
                throw new CypherTypeException(start.name() + " is not a node");
            }
            virtualNodeValue = virtualNodeValue2 = (VirtualNodeValue)anyValue;
        }
        catch (NotFoundException notFoundException) {
            throw new SyntaxException("To find a shortest path, both ends of the path need to be provided. Couldn't find `" + start + "`");
        }
        return virtualNodeValue;
    }

    private boolean anyStartpointsContainNull(ReadableRow ctx) {
        return ctx.getByName(this.shortestPathPattern().left().name()) == Values.NO_VALUE || ctx.getByName(this.shortestPathPattern().right().name()) == Values.NO_VALUE;
    }

    @Override
    public Seq<AstNode<?>> children() {
        return (Seq)((IterableOps)new .colon.colon((Object)this.shortestPathPattern(), (List)Nil$.MODULE$).$plus$plus(this.perStepPredicates())).$plus$plus(this.fullPathPredicates());
    }

    public Seq<Expression> arguments() {
        return (Seq)package$.MODULE$.Seq().empty();
    }

    @Override
    public Expression rewrite(Function1<Expression, Expression> f) {
        Object x$1 = this.shortestPathPattern().rewrite((Function1)f);
        int x$2 = this.operatorId();
        Seq<Predicate> x$3 = LegacyShortestPathExpression$.MODULE$.apply$default$2();
        Seq<Predicate> x$4 = LegacyShortestPathExpression$.MODULE$.apply$default$3();
        boolean x$5 = LegacyShortestPathExpression$.MODULE$.apply$default$4();
        boolean x$6 = LegacyShortestPathExpression$.MODULE$.apply$default$5();
        return (Expression)f.apply((Object)new LegacyShortestPathExpression((ShortestPath)x$1, x$3, x$4, x$5, x$6, x$2));
    }

    private KernelPredicate<Entity> cypherPositivePredicatesAsExpander(ReadableRow incomingCtx, int variableOffset, Predicate predicate, QueryState state) {
        return new KernelPredicate<Entity>(null, state, variableOffset, predicate, incomingCtx){
            private final QueryState state$2;
            private final int variableOffset$1;
            private final Predicate predicate$1;
            private final ReadableRow incomingCtx$2;

            public boolean test(Entity t) {
                this.state$2.expressionVariables()[this.variableOffset$1] = ValueUtils.asNodeOrEdgeValue((Entity)t);
                return this.predicate$1.isTrue(this.incomingCtx$2, this.state$2);
            }
            {
                this.state$2 = state$2;
                this.variableOffset$1 = variableOffset$1;
                this.predicate$1 = predicate$1;
                this.incomingCtx$2 = incomingCtx$2;
            }
        };
    }

    private KernelPredicate<Entity> cypherNegativePredicatesAsExpander(ReadableRow incomingCtx, int variableOffset, Predicate predicate, QueryState state) {
        return new KernelPredicate<Entity>(null, state, variableOffset, predicate, incomingCtx){
            private final QueryState state$3;
            private final int variableOffset$2;
            private final Predicate predicate$2;
            private final ReadableRow incomingCtx$3;

            public boolean test(Entity t) {
                this.state$3.expressionVariables()[this.variableOffset$2] = ValueUtils.asNodeOrEdgeValue((Entity)t);
                return !this.predicate$2.isTrue(this.incomingCtx$3, this.state$3);
            }
            {
                this.state$3 = state$3;
                this.variableOffset$2 = variableOffset$2;
                this.predicate$2 = predicate$2;
                this.incomingCtx$3 = incomingCtx$3;
            }
        };
    }

    private Expression findPredicate(Predicate predicate) {
        CoercedPredicate coercedPredicate;
        Expression inner;
        Predicate predicate2 = predicate;
        if (predicate2 instanceof CoercedPredicate && (inner = (coercedPredicate = (CoercedPredicate)predicate2).inner()) instanceof ExtendedExpression) {
            ExtendedExpression extendedExpression = (ExtendedExpression)((Object)inner);
            return extendedExpression.legacy();
        }
        return predicate;
    }

    private Expander addAllOrNoneRelationshipExpander(ReadableRow ctx, Expander currentExpander, boolean all, Predicate predicate, int relVariableOffset, QueryState state) {
        return currentExpander.addRelationshipFilter(all ? this.cypherPositivePredicatesAsExpander(ctx, relVariableOffset, predicate, state) : this.cypherNegativePredicatesAsExpander(ctx, relVariableOffset, predicate, state));
    }

    private Tuple2<Expander, Seq<KernelPredicate<Entity>>> addAllOrNoneNodeExpander(ReadableRow ctx, Expander currentExpander, boolean all, Predicate predicate, int relVariableOffset, Seq<KernelPredicate<Entity>> currentNodePredicates, QueryState state) {
        KernelPredicate<Entity> filter = all ? this.cypherPositivePredicatesAsExpander(ctx, relVariableOffset, predicate, state) : this.cypherNegativePredicatesAsExpander(ctx, relVariableOffset, predicate, state);
        return new Tuple2((Object)currentExpander.addNodeFilter(filter), currentNodePredicates.$colon$plus(filter));
    }

    private Expander makeRelationshipTypeExpander() {
        if (this.shortestPathPattern().relTypes().isEmpty()) {
            return Expanders$.MODULE$.allTypes(this.shortestPathPattern().dir());
        }
        return (Expander)this.shortestPathPattern().relTypes().foldLeft((Object)Expanders$.MODULE$.typeDir(), (Function2 & Serializable)(x0$1, x1$1) -> {
            Tuple2 tuple2 = new Tuple2(x0$1, x1$1);
            if (tuple2 != null) {
                TypeAndDirectionExpander e = (TypeAndDirectionExpander)tuple2._1();
                String t = (String)tuple2._2();
                return e.add(t, this.shortestPathPattern().dir());
            }
            throw new MatchError((Object)tuple2);
        });
    }

    private Tuple2<Expander, Seq<KernelPredicate<Entity>>> addPredicates(ReadableRow ctx, Expander relTypeAndDirExpander, QueryState state) {
        if (this.perStepPredicates().isEmpty()) {
            return new Tuple2((Object)relTypeAndDirExpander, (Object)Nil$.MODULE$);
        }
        return (Tuple2)((IterableOnceOps)this.perStepPredicates().map((Function1 & Serializable)predicate -> this.findPredicate((Predicate)predicate))).foldLeft((Object)new Tuple2((Object)relTypeAndDirExpander, (Object)Nil$.MODULE$), (Function2 & Serializable)(x0$1, x1$1) -> {
            Tuple2 tuple2 = new Tuple2(x0$1, x1$1);
            if (tuple2 != null) {
                Tuple2 tuple22 = (Tuple2)tuple2._1();
                Expression predicate = (Expression)tuple2._2();
                if (tuple22 != null) {
                    Expander currentExpander = (Expander)tuple22._1();
                    Seq currentNodePredicates = (Seq)tuple22._2();
                    if (currentNodePredicates != null) {
                        Seq seq = currentNodePredicates;
                        boolean bl = false;
                        NoneInList noneInList = null;
                        boolean bl2 = false;
                        AllInList allInList = null;
                        Expression expression = predicate;
                        if (expression instanceof NoneInList) {
                            bl = true;
                            noneInList = (NoneInList)expression;
                            Expression relFunction = noneInList.collection();
                            int variableOffset = noneInList.innerVariableOffset();
                            Predicate innerPredicate = noneInList.inner();
                            if (this.isRelationshipsFunction(relFunction)) {
                                Expander expander = this.addAllOrNoneRelationshipExpander(ctx, currentExpander, false, innerPredicate, variableOffset, state);
                                return new Tuple2((Object)expander, (Object)seq);
                            }
                        }
                        if (expression instanceof AllInList) {
                            bl2 = true;
                            allInList = (AllInList)expression;
                            Expression relFunction = allInList.collection();
                            int variableOffset = allInList.innerVariableOffset();
                            Predicate innerPredicate = allInList.inner();
                            if (this.isRelationshipsFunction(relFunction)) {
                                Expander expander = this.addAllOrNoneRelationshipExpander(ctx, currentExpander, true, innerPredicate, variableOffset, state);
                                return new Tuple2((Object)expander, (Object)seq);
                            }
                        }
                        if (bl) {
                            Expression nodeFunction = noneInList.collection();
                            int variableOffset = noneInList.innerVariableOffset();
                            Predicate innerPredicate = noneInList.inner();
                            if (this.isNodesFunction(nodeFunction)) {
                                return this.addAllOrNoneNodeExpander(ctx, currentExpander, false, innerPredicate, variableOffset, (Seq<KernelPredicate<Entity>>)seq, state);
                            }
                        }
                        if (bl2) {
                            Expression nodeFunction = allInList.collection();
                            int variableOffset = allInList.innerVariableOffset();
                            Predicate innerPredicate = allInList.inner();
                            if (this.isNodesFunction(nodeFunction)) {
                                return this.addAllOrNoneNodeExpander(ctx, currentExpander, true, innerPredicate, variableOffset, (Seq<KernelPredicate<Entity>>)seq, state);
                            }
                        }
                        return new Tuple2((Object)currentExpander, (Object)seq);
                    }
                }
            }
            throw new MatchError((Object)tuple2);
        });
    }

    private boolean isNodesFunction(Expression expression) {
        while (true) {
            Expression expression2;
            if ((expression2 = expression) instanceof NodesFunction) {
                return true;
            }
            if (!(expression2 instanceof ExtendedExpression)) break;
            ExtendedExpression extendedExpression = (ExtendedExpression)((Object)expression2);
            expression = extendedExpression.legacy();
        }
        return false;
    }

    private boolean isRelationshipsFunction(Expression expression) {
        while (true) {
            Expression expression2;
            if ((expression2 = expression) instanceof RelationshipFunction) {
                return true;
            }
            if (!(expression2 instanceof ExtendedExpression)) break;
            ExtendedExpression extendedExpression = (ExtendedExpression)((Object)expression2);
            expression = extendedExpression.legacy();
        }
        return false;
    }

    public LegacyShortestPathExpression copy(ShortestPath shortestPathPattern, Seq<Predicate> perStepPredicates, Seq<Predicate> fullPathPredicates, boolean withFallBack, boolean disallowSameNode, int operatorId) {
        return new LegacyShortestPathExpression(shortestPathPattern, perStepPredicates, fullPathPredicates, withFallBack, disallowSameNode, operatorId);
    }

    public ShortestPath copy$default$1() {
        return this.shortestPathPattern();
    }

    public Seq<Predicate> copy$default$2() {
        return this.perStepPredicates();
    }

    public Seq<Predicate> copy$default$3() {
        return this.fullPathPredicates();
    }

    public boolean copy$default$4() {
        return this.withFallBack();
    }

    public boolean copy$default$5() {
        return this.disallowSameNode();
    }

    public int copy$default$6() {
        return this.operatorId();
    }

    public String productPrefix() {
        return "LegacyShortestPathExpression";
    }

    public int productArity() {
        return 6;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.shortestPathPattern();
            }
            case 1: {
                return this.perStepPredicates();
            }
            case 2: {
                return this.fullPathPredicates();
            }
            case 3: {
                return BoxesRunTime.boxToBoolean((boolean)this.withFallBack());
            }
            case 4: {
                return BoxesRunTime.boxToBoolean((boolean)this.disallowSameNode());
            }
            case 5: {
                return new Id(this.operatorId());
            }
        }
        return Statics.ioobe((int)x$1);
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof LegacyShortestPathExpression;
    }

    public String productElementName(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return "shortestPathPattern";
            }
            case 1: {
                return "perStepPredicates";
            }
            case 2: {
                return "fullPathPredicates";
            }
            case 3: {
                return "withFallBack";
            }
            case 4: {
                return "disallowSameNode";
            }
            case 5: {
                return "operatorId";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    public int hashCode() {
        int n = -889275714;
        n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
        n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.shortestPathPattern()));
        n = Statics.mix((int)n, (int)Statics.anyHash(this.perStepPredicates()));
        n = Statics.mix((int)n, (int)Statics.anyHash(this.fullPathPredicates()));
        n = Statics.mix((int)n, (int)(this.withFallBack() ? 1231 : 1237));
        n = Statics.mix((int)n, (int)(this.disallowSameNode() ? 1231 : 1237));
        n = Statics.mix((int)n, (int)Statics.anyHash((Object)new Id(this.operatorId())));
        return Statics.finalizeHash((int)n, (int)6);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof LegacyShortestPathExpression)) return false;
        boolean bl = true;
        if (!bl) return false;
        LegacyShortestPathExpression legacyShortestPathExpression = (LegacyShortestPathExpression)x$1;
        if (this.withFallBack() != legacyShortestPathExpression.withFallBack()) return false;
        if (this.disallowSameNode() != legacyShortestPathExpression.disallowSameNode()) return false;
        ShortestPath shortestPath = this.shortestPathPattern();
        ShortestPath shortestPath2 = legacyShortestPathExpression.shortestPathPattern();
        if (shortestPath == null) {
            if (shortestPath2 != null) {
                return false;
            }
        } else if (!((Object)shortestPath).equals(shortestPath2)) return false;
        Seq<Predicate> seq = this.perStepPredicates();
        Seq<Predicate> seq2 = legacyShortestPathExpression.perStepPredicates();
        if (seq == null) {
            if (seq2 != null) {
                return false;
            }
        } else if (!seq.equals(seq2)) return false;
        Seq<Predicate> seq3 = this.fullPathPredicates();
        Seq<Predicate> seq4 = legacyShortestPathExpression.fullPathPredicates();
        if (seq3 == null) {
            if (seq4 != null) {
                return false;
            }
        } else if (!seq3.equals(seq4)) return false;
        if (this.operatorId() != legacyShortestPathExpression.operatorId()) return false;
        if (!legacyShortestPathExpression.canEqual(this)) return false;
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$getMatches$2(Path p) {
        return p.length() == 0;
    }

    public static final /* synthetic */ boolean $anonfun$getMatches$6(LegacyShortestPathExpression $this, Path p) {
        return $this.shortestPathPattern().allowZeroLength() || p.length() > 0;
    }

    public LegacyShortestPathExpression(ShortestPath shortestPathPattern, Seq<Predicate> perStepPredicates, Seq<Predicate> fullPathPredicates, boolean withFallBack, boolean disallowSameNode, int operatorId) {
        this.shortestPathPattern = shortestPathPattern;
        this.perStepPredicates = perStepPredicates;
        this.fullPathPredicates = fullPathPredicates;
        this.withFallBack = withFallBack;
        this.disallowSameNode = disallowSameNode;
        this.operatorId = operatorId;
        Product.$init$((Product)this);
        this.predicates = (Seq)perStepPredicates.$plus$plus(fullPathPredicates);
    }
}

