/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.runtime.interpreted.commands.showcommands;

import java.io.Serializable;
import java.util.Arrays;
import java.util.StringJoiner;
import org.neo4j.internal.schema.IndexConfig;
import org.neo4j.values.AnyValue;
import org.neo4j.values.storable.DoubleArray;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;
import org.neo4j.values.virtual.MapValue;
import org.neo4j.values.virtual.VirtualValues;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.immutable.List;
import scala.collection.immutable.ListMap;
import scala.collection.immutable.ListMap$;
import scala.collection.immutable.Seq;
import scala.jdk.CollectionConverters$;
import scala.math.Ordering;
import scala.reflect.ClassTag$;

public final class ShowSchemaCommandHelper$ {
    public static final ShowSchemaCommandHelper$ MODULE$ = new ShowSchemaCommandHelper$();

    public String escapeBackticks(String str) {
        return str.replace("`", "``");
    }

    public String createNodeIndexCommand(String indexType, String name, List<String> labelsOrTypes, List<String> properties, Option<String> maybeOptionsMapString) {
        String labelsOrTypesWithColons = this.asEscapedString(labelsOrTypes, this.colonStringJoiner());
        String escapedNodeProperties = this.asEscapedString(properties, this.propStringJoiner());
        return this.createIndexCommand(indexType, name, "(n" + labelsOrTypesWithColons + ")", "(" + escapedNodeProperties + ")", maybeOptionsMapString);
    }

    public Option<String> createNodeIndexCommand$default$5() {
        return None$.MODULE$;
    }

    public String createRelIndexCommand(String indexType, String name, List<String> labelsOrTypes, List<String> properties, Option<String> maybeOptionsMapString) {
        String labelsOrTypesWithColons = this.asEscapedString(labelsOrTypes, this.colonStringJoiner());
        String escapedRelProperties = this.asEscapedString(properties, this.relPropStringJoiner());
        return this.createIndexCommand(indexType, name, "()-[r" + labelsOrTypesWithColons + "]-()", "(" + escapedRelProperties + ")", maybeOptionsMapString);
    }

    public Option<String> createRelIndexCommand$default$5() {
        return None$.MODULE$;
    }

    public String createIndexCommand(String indexType, String name, String nodeOrRelPattern, String onDefinition, Option<String> maybeOptionsMapString) {
        String escapedName = "`" + this.escapeBackticks(name) + "`";
        String optionsString = (String)maybeOptionsMapString.map((Function1 & Serializable)o -> " OPTIONS " + o).getOrElse((Function0 & Serializable)() -> "");
        return "CREATE " + indexType + " INDEX " + escapedName + " FOR " + nodeOrRelPattern + " ON " + onDefinition + optionsString;
    }

    public Option<String> createIndexCommand$default$5() {
        return None$.MODULE$;
    }

    public String createNodeConstraintCommand(String name, List<String> labelsOrTypes, List<String> properties, String predicate) {
        String labelsOrTypesWithColons = this.asEscapedString(labelsOrTypes, this.colonStringJoiner());
        return this.createConstraintCommand(name, "(n" + labelsOrTypesWithColons + ")", properties, this.propStringJoiner(), predicate);
    }

    public String createRelConstraintCommand(String name, List<String> labelsOrTypes, List<String> properties, String predicate) {
        String labelsOrTypesWithColons = this.asEscapedString(labelsOrTypes, this.colonStringJoiner());
        return this.createConstraintCommand(name, "()-[r" + labelsOrTypesWithColons + "]-()", properties, this.relPropStringJoiner(), predicate);
    }

    private String createConstraintCommand(String name, String nodeOrRelPattern, List<String> properties, StringJoiner propJoiner, String predicate) {
        String escapedName = "`" + this.escapeBackticks(name) + "`";
        String escapedProperties = this.asEscapedString(properties, propJoiner);
        return "CREATE CONSTRAINT " + escapedName + " FOR " + nodeOrRelPattern + " REQUIRE (" + escapedProperties + ") " + predicate;
    }

    public MapValue extractOptionsMap(String providerName, IndexConfig indexConfig) {
        Tuple2 tuple2 = CollectionConverters$.MODULE$.MapHasAsScala(indexConfig.asMap()).asScala().toSeq().unzip(Predef$.MODULE$.$conforms());
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Seq configKeys = (Seq)tuple2._1();
        Seq configValues = (Seq)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)configKeys, (Object)configValues);
        Seq configKeys2 = (Seq)tuple22._1();
        Seq configValues2 = (Seq)tuple22._2();
        String[] optionKeys = (String[])((Object[])new String[]{"indexConfig", "indexProvider"});
        AnyValue[] optionValues = (AnyValue[])((Object[])new AnyValue[]{VirtualValues.map((String[])((String[])configKeys2.toArray(ClassTag$.MODULE$.apply(String.class))), (AnyValue[])((AnyValue[])configValues2.toArray(ClassTag$.MODULE$.apply(AnyValue.class)))), Values.stringValue((String)providerName)});
        return VirtualValues.map((String[])optionKeys, (AnyValue[])optionValues);
    }

    public String optionsAsString(String providerString, String configString) {
        return "{indexConfig: " + configString + ", indexProvider: '" + providerString + "'}";
    }

    public String asEscapedString(List<String> list, StringJoiner stringJoiner) {
        list.foreach((Function1 & Serializable)elem -> stringJoiner.add("`" + MODULE$.escapeBackticks((String)elem) + "`"));
        return stringJoiner.toString();
    }

    public String configAsString(IndexConfig indexConfig, Function1<Value, String> configValueAsString) {
        StringJoiner configString = this.configStringJoiner();
        ListMap sortedIndexConfig = (ListMap)ListMap$.MODULE$.apply((Seq)CollectionConverters$.MODULE$.MapHasAsScala(indexConfig.asMap()).asScala().toSeq().sortBy((Function1 & Serializable)x$2 -> (String)x$2._1(), (Ordering)Ordering.String$.MODULE$));
        sortedIndexConfig.foldLeft((Object)configString, (Function2 & Serializable)(acc, entry) -> {
            String singleConfig = "`" + entry._1() + "`: " + configValueAsString.apply(entry._2());
            return acc.add(singleConfig);
        });
        return configString.toString();
    }

    public String pointConfigValueAsString(Value configValue) {
        Value value = configValue;
        if (value instanceof DoubleArray) {
            DoubleArray doubleArray = (DoubleArray)value;
            return Arrays.toString(doubleArray.asObjectCopy());
        }
        throw new IllegalArgumentException("Could not convert config value '" + configValue + "' to config string.");
    }

    private StringJoiner colonStringJoiner() {
        return new StringJoiner(":", ":", "");
    }

    public StringJoiner barStringJoiner() {
        return new StringJoiner("|", ":", "");
    }

    public StringJoiner propStringJoiner() {
        return new StringJoiner(", n.", "n.", "");
    }

    public StringJoiner relPropStringJoiner() {
        return new StringJoiner(", r.", "r.", "");
    }

    private StringJoiner configStringJoiner() {
        return new StringJoiner(",", "{", "}");
    }

    private ShowSchemaCommandHelper$() {
    }
}

