/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.runtime.interpreted.pipes;

import java.io.Serializable;
import java.util.Comparator;
import org.neo4j.cypher.internal.frontend.helpers.SeqCombiner$;
import org.neo4j.cypher.internal.logical.plans.Bound;
import org.neo4j.cypher.internal.logical.plans.CompositeQueryExpression;
import org.neo4j.cypher.internal.logical.plans.ExistenceQueryExpression;
import org.neo4j.cypher.internal.logical.plans.IndexOrder;
import org.neo4j.cypher.internal.logical.plans.IndexOrderAscending$;
import org.neo4j.cypher.internal.logical.plans.IndexOrderDescending$;
import org.neo4j.cypher.internal.logical.plans.IndexOrderNone$;
import org.neo4j.cypher.internal.logical.plans.InequalitySeekRange;
import org.neo4j.cypher.internal.logical.plans.ManyQueryExpression;
import org.neo4j.cypher.internal.logical.plans.MinMaxOrdering;
import org.neo4j.cypher.internal.logical.plans.PointBoundingBoxRange;
import org.neo4j.cypher.internal.logical.plans.PointDistanceRange;
import org.neo4j.cypher.internal.logical.plans.PrefixRange;
import org.neo4j.cypher.internal.logical.plans.QueryExpression;
import org.neo4j.cypher.internal.logical.plans.RangeBetween;
import org.neo4j.cypher.internal.logical.plans.RangeGreaterThan;
import org.neo4j.cypher.internal.logical.plans.RangeLessThan;
import org.neo4j.cypher.internal.logical.plans.RangeQueryExpression;
import org.neo4j.cypher.internal.logical.plans.SingleQueryExpression;
import org.neo4j.cypher.internal.runtime.CompositeValueIndexCursor$;
import org.neo4j.cypher.internal.runtime.CypherRow;
import org.neo4j.cypher.internal.runtime.IsList$;
import org.neo4j.cypher.internal.runtime.QueryContext;
import org.neo4j.cypher.internal.runtime.ReadableRow;
import org.neo4j.cypher.internal.runtime.interpreted.commands.expressions.Expression;
import org.neo4j.cypher.internal.runtime.interpreted.commands.expressions.InequalitySeekRangeExpression;
import org.neo4j.cypher.internal.runtime.interpreted.commands.expressions.PointBoundingBoxSeekRangeExpression;
import org.neo4j.cypher.internal.runtime.interpreted.commands.expressions.PointDistanceSeekRangeExpression;
import org.neo4j.cypher.internal.runtime.interpreted.commands.expressions.PrefixSeekRangeExpression;
import org.neo4j.cypher.internal.runtime.interpreted.pipes.ExactSeek;
import org.neo4j.cypher.internal.runtime.interpreted.pipes.IndexSeekMode;
import org.neo4j.cypher.internal.runtime.interpreted.pipes.LockingUniqueIndexSeek$;
import org.neo4j.cypher.internal.runtime.interpreted.pipes.QueryState;
import org.neo4j.cypher.internal.runtime.interpreted.pipes.SeekByRange;
import org.neo4j.cypher.internal.runtime.makeValueNeoSafe$;
import org.neo4j.cypher.internal.util.AssertionRunner;
import org.neo4j.exceptions.CypherTypeException;
import org.neo4j.exceptions.InternalException;
import org.neo4j.internal.kernel.api.IndexReadSession;
import org.neo4j.internal.kernel.api.NodeValueIndexCursor;
import org.neo4j.internal.kernel.api.PropertyIndexQuery;
import org.neo4j.internal.kernel.api.RelationshipValueIndexCursor;
import org.neo4j.values.AnyValue;
import org.neo4j.values.storable.CRSCalculator;
import org.neo4j.values.storable.NumberValue;
import org.neo4j.values.storable.PointValue;
import org.neo4j.values.storable.TextValue;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.ValueGroup;
import org.neo4j.values.storable.Values;
import org.neo4j.values.virtual.ListValue;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\u0005\rfa\u0002\b\u0010!\u0003\r\tA\b\u0005\u0006K\u0001!\tA\n\u0005\u0006U\u00011\ta\u000b\u0005\u0006a\u00011\t!\r\u0005\u0006\u0005\u00021\ta\u0011\u0005\u0006\u0015\u0002!\tb\u0013\u0005\u0006m\u0002!\tb\u001e\u0005\b\u0003\u0003\u0001A\u0011BA\u0002\u0011\u001d\t\t\u0001\u0001C\u0005\u0003\u001bA\u0011\"!\u0006\u0001\u0005\u0004%I!a\u0006\t\u000f\u0005=\u0002\u0001\"\u0001\u00022!9\u0011q\r\u0001\u0005\u0002\u0005%\u0004bBA=\u0001\u0011E\u00111\u0010\u0005\b\u0003'\u0003A\u0011BAK\u0005E)e\u000e^5us&sG-\u001a=TK\u0016\\WM\u001d\u0006\u0003!E\tQ\u0001]5qKNT!AE\n\u0002\u0017%tG/\u001a:qe\u0016$X\r\u001a\u0006\u0003)U\tqA];oi&lWM\u0003\u0002\u0017/\u0005A\u0011N\u001c;fe:\fGN\u0003\u0002\u00193\u000511-\u001f9iKJT!AG\u000e\u0002\u000b9,w\u000e\u000e6\u000b\u0003q\t1a\u001c:h\u0007\u0001\u0019\"\u0001A\u0010\u0011\u0005\u0001\u001aS\"A\u0011\u000b\u0003\t\nQa]2bY\u0006L!\u0001J\u0011\u0003\r\u0005s\u0017PU3g\u0003\u0019!\u0013N\\5uIQ\tq\u0005\u0005\u0002!Q%\u0011\u0011&\t\u0002\u0005+:LG/A\u0005j]\u0012,\u00070T8eKV\tA\u0006\u0005\u0002.]5\tq\"\u0003\u00020\u001f\ti\u0011J\u001c3fqN+Wm['pI\u0016\f\u0011B^1mk\u0016,\u0005\u0010\u001d:\u0016\u0003I\u00022a\r\u001d;\u001b\u0005!$BA\u001b7\u0003\u0015\u0001H.\u00198t\u0015\t9T#A\u0004m_\u001eL7-\u00197\n\u0005e\"$aD)vKJLX\t\u001f9sKN\u001c\u0018n\u001c8\u0011\u0005m\u0002U\"\u0001\u001f\u000b\u0005ur\u0014aC3yaJ,7o]5p]NT!aP\t\u0002\u0011\r|W.\\1oINL!!\u0011\u001f\u0003\u0015\u0015C\bO]3tg&|g.A\u0006qe>\u0004XM\u001d;z\u0013\u0012\u001cX#\u0001#\u0011\u0007\u0001*u)\u0003\u0002GC\t)\u0011I\u001d:bsB\u0011\u0001\u0005S\u0005\u0003\u0013\u0006\u00121!\u00138u\u0003%Ig\u000eZ3y'\u0016,7.\u0006\u0002MaR1QJV.aK*\u0004\"A\u0014+\u000e\u0003=S!\u0001U)\u0002\u0007\u0005\u0004\u0018N\u0003\u0002S'\u000611.\u001a:oK2T!AF\r\n\u0005U{%\u0001\u0006(pI\u00164\u0016\r\\;f\u0013:$W\r_\"veN|'\u000fC\u0003X\u000b\u0001\u0007\u0001,A\u0003ti\u0006$X\r\u0005\u0002.3&\u0011!l\u0004\u0002\u000b#V,'/_*uCR,\u0007\"\u0002/\u0006\u0001\u0004i\u0016!B5oI\u0016D\bC\u0001(_\u0013\tyvJ\u0001\tJ]\u0012,\u0007PU3bIN+7o]5p]\")\u0011-\u0002a\u0001E\u0006Ya.Z3egZ\u000bG.^3t!\t\u00013-\u0003\u0002eC\t9!i\\8mK\u0006t\u0007\"\u00024\u0006\u0001\u00049\u0017AC5oI\u0016DxJ\u001d3feB\u00111\u0007[\u0005\u0003SR\u0012!\"\u00138eKb|%\u000fZ3s\u0011\u0015YW\u00011\u0001m\u0003-\u0011\u0017m]3D_:$X\r\u001f;\u0011\u00055tW\"A\n\n\u0005=\u001c\"!C\"za\",'OU8x\t\u0015\tXA1\u0001s\u0005\u0019\u0011ViU+M)F\u00111o\b\t\u0003AQL!!^\u0011\u0003\u000f9{G\u000f[5oO\u0006)\"/\u001a7bi&|gn\u001d5ja&sG-\u001a=TK\u0016\\GC\u0002=|yvtx\u0010\u0005\u0002Os&\u0011!p\u0014\u0002\u001d%\u0016d\u0017\r^5p]ND\u0017\u000e\u001d,bYV,\u0017J\u001c3fq\u000e+(o]8s\u0011\u00159f\u00011\u0001Y\u0011\u0015af\u00011\u0001^\u0011\u0015\tg\u00011\u0001c\u0011\u00151g\u00011\u0001h\u0011\u0015Yg\u00011\u0001m\u00035y'\u000fZ3sK\u0012\u001cUO]:peR)Q*!\u0002\u0002\b!)am\u0002a\u0001O\"9\u0011\u0011B\u0004A\u0002\u0005-\u0011aB2veN|'o\u001d\t\u0004A\u0015kE#\u0002=\u0002\u0010\u0005E\u0001\"\u00024\t\u0001\u00049\u0007bBA\u0005\u0011\u0001\u0007\u00111\u0003\t\u0004A\u0015C\u0018\u0001\u0003\"Z?Z\u000bE*V#\u0016\u0005\u0005e\u0001#B\u001a\u0002\u001c\u0005}\u0011bAA\u000fi\tqQ*\u001b8NCb|%\u000fZ3sS:<\u0007\u0003BA\u0011\u0003Wi!!a\t\u000b\t\u0005\u0015\u0012qE\u0001\tgR|'/\u00192mK*\u0019\u0011\u0011F\r\u0002\rY\fG.^3t\u0013\u0011\ti#a\t\u0003\u000bY\u000bG.^3\u0002'\r|W\u000e];uK&sG-\u001a=Rk\u0016\u0014\u0018.Z:\u0015\r\u0005M\u00121LA/!\u0019\t)$a\u000f\u0002@5\u0011\u0011q\u0007\u0006\u0004\u0003s\t\u0013AC2pY2,7\r^5p]&!\u0011QHA\u001c\u0005\r\u0019V-\u001d\t\u0007\u0003\u0003\n\t&!\u0016\u000f\t\u0005\r\u0013Q\n\b\u0005\u0003\u000b\nY%\u0004\u0002\u0002H)\u0019\u0011\u0011J\u000f\u0002\rq\u0012xn\u001c;?\u0013\u0005\u0011\u0013bAA(C\u00059\u0001/Y2lC\u001e,\u0017\u0002BA\u001f\u0003'R1!a\u0014\"!\rq\u0015qK\u0005\u0004\u00033z%A\u0005)s_B,'\u000f^=J]\u0012,\u00070U;fefDQa\u0016\u0006A\u0002aCq!a\u0018\u000b\u0001\u0004\t\t'A\u0002s_^\u00042!\\A2\u0013\r\t)g\u0005\u0002\f%\u0016\fG-\u00192mKJ{w/A\nd_6\u0004X\u000f^3SC:<W-U;fe&,7\u000f\u0006\u0006\u0002l\u00055\u0014qNA9\u0003k\u0002b!!\u000e\u0002<\u0005U\u0003\"B,\f\u0001\u0004A\u0006bBA0\u0017\u0001\u0007\u0011\u0011\r\u0005\u0007\u0003gZ\u0001\u0019\u0001\u001e\u0002\u0019I\fgnZ3Xe\u0006\u0004\b/\u001a:\t\r\u0005]4\u00021\u0001H\u0003)\u0001(o\u001c9feRL\u0018\nZ\u0001\u0014G>l\u0007/\u001e;f\u000bb\f7\r^)vKJLWm\u001d\u000b\u0007\u0003{\ny)!%\u0011\r\u0005U\u00121HA@!\u0019\t\t%!\u0015\u0002\u0002B!\u00111QAE\u001d\rq\u0015QQ\u0005\u0004\u0003\u000f{\u0015A\u0005)s_B,'\u000f^=J]\u0012,\u00070U;fefLA!a#\u0002\u000e\nqQ\t_1diB\u0013X\rZ5dCR,'bAAD\u001f\")q\u000b\u0004a\u00011\"9\u0011q\f\u0007A\u0002\u0005\u0005\u0014aF2p[B,H/Z\"p[B|7/\u001b;f#V,'/[3t)\u0019\t9*a(\u0002\"R1\u00111NAM\u0003;Ca!a'\u000e\u0001\u0004\u0011\u0014aD9vKJLX\t\u001f9sKN\u001c\u0018n\u001c8\t\r\u0005]T\u00021\u0001H\u0011\u00159V\u00021\u0001Y\u0011\u001d\ty&\u0004a\u0001\u0003C\u0002")
public interface EntityIndexSeeker {
    public void org$neo4j$cypher$internal$runtime$interpreted$pipes$EntityIndexSeeker$_setter_$org$neo4j$cypher$internal$runtime$interpreted$pipes$EntityIndexSeeker$$BY_VALUE_$eq(MinMaxOrdering<Value> var1);

    public IndexSeekMode indexMode();

    public QueryExpression<Expression> valueExpr();

    public int[] propertyIds();

    public static /* synthetic */ NodeValueIndexCursor indexSeek$(EntityIndexSeeker $this, QueryState state, IndexReadSession index, boolean needsValues, IndexOrder indexOrder, CypherRow baseContext) {
        return $this.indexSeek(state, index, needsValues, indexOrder, baseContext);
    }

    default public <RESULT> NodeValueIndexCursor indexSeek(QueryState state, IndexReadSession index, boolean needsValues, IndexOrder indexOrder, CypherRow baseContext) {
        IndexSeekMode indexSeekMode = this.indexMode();
        if (indexSeekMode instanceof ExactSeek ? true : indexSeekMode instanceof SeekByRange) {
            Seq<scala.collection.immutable.Seq<PropertyIndexQuery>> indexQueries = this.computeIndexQueries(state, (ReadableRow)baseContext);
            if (indexQueries.size() == 1) {
                return state.query().nodeIndexSeek(index, needsValues, indexOrder, (scala.collection.immutable.Seq)indexQueries.head());
            }
            return this.orderedCursor(indexOrder, (NodeValueIndexCursor[])((IterableOnceOps)indexQueries.map((Function1 & Serializable)query -> {
                boolean bl;
                QueryContext queryContext;
                block3: {
                    block2: {
                        queryContext = state.query();
                        if (needsValues) break block2;
                        IndexOrder indexOrder = indexOrder;
                        IndexOrderNone$ indexOrderNone$ = IndexOrderNone$.MODULE$;
                        if (!(indexOrder == null ? indexOrderNone$ != null : !indexOrder.equals(indexOrderNone$))) break block3;
                    }
                    bl = true;
                    return queryContext.nodeIndexSeek(index, bl, indexOrder, query);
                }
                bl = false;
                return queryContext.nodeIndexSeek(index, bl, indexOrder, query);
            })).toArray(ClassTag$.MODULE$.apply(NodeValueIndexCursor.class)));
        }
        if (LockingUniqueIndexSeek$.MODULE$.equals(indexSeekMode)) {
            Seq<scala.collection.immutable.Seq<PropertyIndexQuery.ExactPredicate>> indexQueries = this.computeExactQueries(state, (ReadableRow)baseContext);
            if (indexQueries.size() == 1) {
                return state.query().nodeLockingUniqueIndexSeek(index.reference(), (scala.collection.immutable.Seq)indexQueries.head());
            }
            return this.orderedCursor(indexOrder, (NodeValueIndexCursor[])((IterableOnceOps)indexQueries.map((Function1 & Serializable)query -> state.query().nodeLockingUniqueIndexSeek(index.reference(), query))).toArray(ClassTag$.MODULE$.apply(NodeValueIndexCursor.class)));
        }
        throw new MatchError((Object)indexSeekMode);
    }

    public static /* synthetic */ RelationshipValueIndexCursor relationshipIndexSeek$(EntityIndexSeeker $this, QueryState state, IndexReadSession index, boolean needsValues, IndexOrder indexOrder, CypherRow baseContext) {
        return $this.relationshipIndexSeek(state, index, needsValues, indexOrder, baseContext);
    }

    default public RelationshipValueIndexCursor relationshipIndexSeek(QueryState state, IndexReadSession index, boolean needsValues, IndexOrder indexOrder, CypherRow baseContext) {
        Seq<scala.collection.immutable.Seq<PropertyIndexQuery>> indexQueries = this.computeIndexQueries(state, (ReadableRow)baseContext);
        if (indexQueries.size() == 1) {
            return state.query().relationshipIndexSeek(index, needsValues, indexOrder, (scala.collection.immutable.Seq)indexQueries.head());
        }
        return this.orderedCursor(indexOrder, (RelationshipValueIndexCursor[])((IterableOnceOps)indexQueries.map((Function1 & Serializable)query -> {
            boolean bl;
            QueryContext queryContext;
            block3: {
                block2: {
                    queryContext = state.query();
                    if (needsValues) break block2;
                    IndexOrder indexOrder = indexOrder;
                    IndexOrderNone$ indexOrderNone$ = IndexOrderNone$.MODULE$;
                    if (!(indexOrder == null ? indexOrderNone$ != null : !indexOrder.equals(indexOrderNone$))) break block3;
                }
                bl = true;
                return queryContext.relationshipIndexSeek(index, bl, indexOrder, query);
            }
            bl = false;
            return queryContext.relationshipIndexSeek(index, bl, indexOrder, query);
        })).toArray(ClassTag$.MODULE$.apply(RelationshipValueIndexCursor.class)));
    }

    private NodeValueIndexCursor orderedCursor(IndexOrder indexOrder, NodeValueIndexCursor[] cursors) {
        IndexOrder indexOrder2 = indexOrder;
        if (IndexOrderNone$.MODULE$.equals(indexOrder2)) {
            return CompositeValueIndexCursor$.MODULE$.unordered(cursors);
        }
        if (IndexOrderAscending$.MODULE$.equals(indexOrder2)) {
            return CompositeValueIndexCursor$.MODULE$.ascending(cursors);
        }
        if (IndexOrderDescending$.MODULE$.equals(indexOrder2)) {
            return CompositeValueIndexCursor$.MODULE$.descending(cursors);
        }
        throw new MatchError((Object)indexOrder2);
    }

    private RelationshipValueIndexCursor orderedCursor(IndexOrder indexOrder, RelationshipValueIndexCursor[] cursors) {
        IndexOrder indexOrder2 = indexOrder;
        if (IndexOrderNone$.MODULE$.equals(indexOrder2)) {
            return CompositeValueIndexCursor$.MODULE$.unordered(cursors);
        }
        if (IndexOrderAscending$.MODULE$.equals(indexOrder2)) {
            return CompositeValueIndexCursor$.MODULE$.ascending(cursors);
        }
        if (IndexOrderDescending$.MODULE$.equals(indexOrder2)) {
            return CompositeValueIndexCursor$.MODULE$.descending(cursors);
        }
        throw new MatchError((Object)indexOrder2);
    }

    public MinMaxOrdering<Value> org$neo4j$cypher$internal$runtime$interpreted$pipes$EntityIndexSeeker$$BY_VALUE();

    public static /* synthetic */ Seq computeIndexQueries$(EntityIndexSeeker $this, QueryState state, ReadableRow row) {
        return $this.computeIndexQueries(state, row);
    }

    default public Seq<scala.collection.immutable.Seq<PropertyIndexQuery>> computeIndexQueries(QueryState state, ReadableRow row) {
        QueryExpression<Expression> queryExpression = this.valueExpr();
        if (queryExpression instanceof RangeQueryExpression) {
            RangeQueryExpression rangeQueryExpression = (RangeQueryExpression)queryExpression;
            Expression rangeWrapper = (Expression)rangeQueryExpression.expression();
            if (AssertionRunner.ASSERTIONS_ENABLED && this.propertyIds().length != 1) {
                throw new AssertionError((Object)"assertion failed");
            }
            return (Seq)this.computeRangeQueries(state, row, rangeWrapper, BoxesRunTime.unboxToInt((Object)ArrayOps$.MODULE$.head$extension(Predef$.MODULE$.intArrayOps(this.propertyIds())))).map((Function1 & Serializable)x$1 -> new .colon.colon(x$1, (List)Nil$.MODULE$));
        }
        if (queryExpression instanceof CompositeQueryExpression) {
            CompositeQueryExpression compositeQueryExpression = (CompositeQueryExpression)queryExpression;
            scala.collection.immutable.Seq exprs = compositeQueryExpression.inner();
            if (AssertionRunner.ASSERTIONS_ENABLED && exprs.lengthCompare(this.propertyIds().length) != 0) {
                throw new AssertionError((Object)"assertion failed");
            }
            scala.collection.immutable.Seq indexQueries = (scala.collection.immutable.Seq)((IterableOps)exprs.zip((IterableOnce)Predef$.MODULE$.wrapIntArray(this.propertyIds()))).map((Function1 & Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 != null) {
                    QueryExpression expr = (QueryExpression)tuple2._1();
                    int propId = tuple2._2$mcI$sp();
                    return this.computeCompositeQueries(state, row, (QueryExpression<Expression>)expr, propId);
                }
                throw new MatchError((Object)tuple2);
            });
            return SeqCombiner$.MODULE$.combine((Iterable)indexQueries);
        }
        if (queryExpression instanceof ExistenceQueryExpression) {
            throw new InternalException("An ExistenceQueryExpression shouldn't be found outside of a CompositeQueryExpression");
        }
        return this.computeExactQueries(state, row);
    }

    public static /* synthetic */ Seq computeRangeQueries$(EntityIndexSeeker $this, QueryState state, ReadableRow row, Expression rangeWrapper, int propertyId) {
        return $this.computeRangeQueries(state, row, rangeWrapper, propertyId);
    }

    default public Seq<PropertyIndexQuery> computeRangeQueries(QueryState state, ReadableRow row, Expression rangeWrapper, int propertyId) {
        Expression expression = rangeWrapper;
        if (expression instanceof PrefixSeekRangeExpression) {
            PrefixSeekRangeExpression prefixSeekRangeExpression = (PrefixSeekRangeExpression)expression;
            PrefixRange<Expression> range = prefixSeekRangeExpression.range();
            Expression expr2 = (Expression)range.prefix();
            AnyValue anyValue = expr2.apply(row, state);
            if (anyValue instanceof TextValue) {
                TextValue textValue = (TextValue)anyValue;
                return Predef$.MODULE$.wrapRefArray((Object[])new PropertyIndexQuery.StringPrefixPredicate[]{PropertyIndexQuery.stringPrefix((int)propertyId, (TextValue)textValue)});
            }
            return Nil$.MODULE$;
        }
        if (expression instanceof InequalitySeekRangeExpression) {
            InequalitySeekRangeExpression inequalitySeekRangeExpression = (InequalitySeekRangeExpression)expression;
            InequalitySeekRange<Expression> innerRange = inequalitySeekRangeExpression.range();
            Option option = innerRange.flatMapBounds((Function1 & Serializable)expr -> makeValueNeoSafe$.MODULE$.safeOrEmpty(expr.apply(row, state)));
            if (None$.MODULE$.equals(option)) {
                return Nil$.MODULE$;
            }
            if (option instanceof Some) {
                InequalitySeekRange range;
                Some some = (Some)option;
                InequalitySeekRange valueRange = (InequalitySeekRange)some.value();
                Map groupedRanges = valueRange.groupBy((Function1 & Serializable)bound -> ((Value)bound.endPoint()).valueGroup());
                if (groupedRanges.size() > 1) {
                    return Nil$.MODULE$;
                }
                Tuple2 tuple2 = (Tuple2)groupedRanges.head();
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                ValueGroup valueGroup = (ValueGroup)tuple2._1();
                InequalitySeekRange range2 = (InequalitySeekRange)tuple2._2();
                Tuple2 tuple22 = new Tuple2((Object)valueGroup, (Object)range2);
                ValueGroup valueGroup2 = (ValueGroup)tuple22._1();
                InequalitySeekRange inequalitySeekRange = range = (InequalitySeekRange)tuple22._2();
                if (inequalitySeekRange instanceof RangeLessThan) {
                    RangeLessThan rangeLessThan = (RangeLessThan)inequalitySeekRange;
                    return Option$.MODULE$.option2Iterable(rangeLessThan.limit(this.org$neo4j$cypher$internal$runtime$interpreted$pipes$EntityIndexSeeker$$BY_VALUE()).map((Function1 & Serializable)limit -> PropertyIndexQuery.range((int)propertyId, null, (boolean)false, (Value)((Value)limit.endPoint()), (boolean)limit.isInclusive()))).toSeq();
                }
                if (inequalitySeekRange instanceof RangeGreaterThan) {
                    RangeGreaterThan rangeGreaterThan = (RangeGreaterThan)inequalitySeekRange;
                    return Option$.MODULE$.option2Iterable(rangeGreaterThan.limit(this.org$neo4j$cypher$internal$runtime$interpreted$pipes$EntityIndexSeeker$$BY_VALUE()).map((Function1 & Serializable)limit -> PropertyIndexQuery.range((int)propertyId, (Value)((Value)limit.endPoint()), (boolean)limit.isInclusive(), null, (boolean)false))).toSeq();
                }
                if (inequalitySeekRange instanceof RangeBetween) {
                    RangeBetween rangeBetween = (RangeBetween)inequalitySeekRange;
                    RangeGreaterThan rangeGreaterThan = rangeBetween.greaterThan();
                    RangeLessThan rangeLessThan = rangeBetween.lessThan();
                    Bound greaterThanLimit = (Bound)rangeGreaterThan.limit(this.org$neo4j$cypher$internal$runtime$interpreted$pipes$EntityIndexSeeker$$BY_VALUE()).get();
                    Bound lessThanLimit = (Bound)rangeLessThan.limit(this.org$neo4j$cypher$internal$runtime$interpreted$pipes$EntityIndexSeeker$$BY_VALUE()).get();
                    int compare = Values.COMPARATOR.compare((Value)greaterThanLimit.endPoint(), (Value)lessThanLimit.endPoint());
                    if (compare < 0) {
                        return new .colon.colon((Object)PropertyIndexQuery.range((int)propertyId, (Value)((Value)greaterThanLimit.endPoint()), (boolean)greaterThanLimit.isInclusive(), (Value)((Value)lessThanLimit.endPoint()), (boolean)lessThanLimit.isInclusive()), (List)Nil$.MODULE$);
                    }
                    if (compare == 0 && greaterThanLimit.isInclusive() && lessThanLimit.isInclusive()) {
                        return new .colon.colon((Object)PropertyIndexQuery.exact((int)propertyId, (Object)lessThanLimit.endPoint()), (List)Nil$.MODULE$);
                    }
                    return Nil$.MODULE$;
                }
                throw new MatchError((Object)inequalitySeekRange);
            }
            throw new MatchError((Object)option);
        }
        if (expression instanceof PointDistanceSeekRangeExpression) {
            PointDistanceSeekRangeExpression pointDistanceSeekRangeExpression = (PointDistanceSeekRangeExpression)expression;
            PointDistanceRange<Expression> range = pointDistanceSeekRangeExpression.range();
            Tuple2 tuple2 = new Tuple2((Object)makeValueNeoSafe$.MODULE$.safeOrEmpty(((Expression)range.distance()).apply(row, state)), (Object)makeValueNeoSafe$.MODULE$.safeOrEmpty(((Expression)range.point()).apply(row, state)));
            if (tuple2 != null) {
                Some some;
                Value distance;
                Option option = (Option)tuple2._1();
                Option option2 = (Option)tuple2._2();
                if (option instanceof Some && (distance = (Value)(some = (Some)option).value()) instanceof NumberValue) {
                    Some some2;
                    Value point;
                    NumberValue numberValue = (NumberValue)distance;
                    if (option2 instanceof Some && (point = (Value)(some2 = (Some)option2).value()) instanceof PointValue) {
                        PointValue pointValue = (PointValue)point;
                        Buffer bboxes = CollectionConverters$.MODULE$.ListHasAsScala(pointValue.getCoordinateReferenceSystem().getCalculator().boundingBox(pointValue, numberValue.doubleValue())).asScala();
                        boolean inclusive = bboxes.length() > 1 ? true : range.inclusive();
                        return (Seq)bboxes.map((Function1 & Serializable)bbox -> PropertyIndexQuery.boundingBox((int)propertyId, (PointValue)((PointValue)bbox.first()), (PointValue)((PointValue)bbox.other()), (boolean)inclusive));
                    }
                }
            }
            return Nil$.MODULE$;
        }
        if (expression instanceof PointBoundingBoxSeekRangeExpression) {
            PointBoundingBoxSeekRangeExpression pointBoundingBoxSeekRangeExpression = (PointBoundingBoxSeekRangeExpression)expression;
            PointBoundingBoxRange<Expression> range = pointBoundingBoxSeekRangeExpression.range();
            Tuple2 tuple2 = new Tuple2((Object)makeValueNeoSafe$.MODULE$.safeOrEmpty(((Expression)range.lowerLeft()).apply(row, state)), (Object)makeValueNeoSafe$.MODULE$.safeOrEmpty(((Expression)range.upperRight()).apply(row, state)));
            if (tuple2 != null) {
                Some some;
                Value lowerLeft;
                Option option = (Option)tuple2._1();
                Option option3 = (Option)tuple2._2();
                if (option instanceof Some && (lowerLeft = (Value)(some = (Some)option).value()) instanceof PointValue) {
                    Some some3;
                    Value upperRight;
                    PointValue pointValue = (PointValue)lowerLeft;
                    if (option3 instanceof Some && (upperRight = (Value)(some3 = (Some)option3).value()) instanceof PointValue) {
                        PointValue pointValue2 = (PointValue)upperRight;
                        if (pointValue.getCoordinateReferenceSystem().equals((Object)pointValue2.getCoordinateReferenceSystem())) {
                            CRSCalculator calculator = pointValue.getCoordinateReferenceSystem().getCalculator();
                            Buffer bboxes = CollectionConverters$.MODULE$.ListHasAsScala(calculator.computeBBoxes(pointValue, pointValue2)).asScala();
                            return (Seq)bboxes.map((Function1 & Serializable)bbox -> PropertyIndexQuery.boundingBox((int)propertyId, (PointValue)((PointValue)bbox.first()), (PointValue)((PointValue)bbox.other())));
                        }
                    }
                }
            }
            return Nil$.MODULE$;
        }
        throw new MatchError((Object)expression);
    }

    public static /* synthetic */ Seq computeExactQueries$(EntityIndexSeeker $this, QueryState state, ReadableRow row) {
        return $this.computeExactQueries(state, row);
    }

    default public Seq<scala.collection.immutable.Seq<PropertyIndexQuery.ExactPredicate>> computeExactQueries(QueryState state, ReadableRow row) {
        QueryExpression<Expression> queryExpression = this.valueExpr();
        if (queryExpression instanceof SingleQueryExpression) {
            SingleQueryExpression singleQueryExpression = (SingleQueryExpression)queryExpression;
            Expression expr = (Expression)singleQueryExpression.expression();
            Option option = makeValueNeoSafe$.MODULE$.safeOrEmpty(expr.apply(row, state));
            if (option instanceof Some) {
                Some some = (Some)option;
                Value seekValue = (Value)some.value();
                return Predef$.MODULE$.wrapRefArray((Object[])new List[]{new .colon.colon((Object)PropertyIndexQuery.exact((int)BoxesRunTime.unboxToInt((Object)ArrayOps$.MODULE$.head$extension(Predef$.MODULE$.intArrayOps(this.propertyIds()))), (Object)seekValue), (List)Nil$.MODULE$)});
            }
            if (None$.MODULE$.equals(option)) {
                return (Seq)package$.MODULE$.Seq().empty();
            }
            throw new MatchError((Object)option);
        }
        if (queryExpression instanceof ManyQueryExpression) {
            Option option;
            ManyQueryExpression manyQueryExpression = (ManyQueryExpression)queryExpression;
            Expression expr = (Expression)manyQueryExpression.expression();
            AnyValue anyValue = expr.apply(row, state);
            if (anyValue != null && !(option = IsList$.MODULE$.unapply(anyValue)).isEmpty()) {
                ListValue coll = (ListValue)option.get();
                return ((IterableOnceOps)Predef$.MODULE$.wrapRefArray((Object[])coll.asArray()).toSet().flatMap((Function1 & Serializable)seekAnyValue -> makeValueNeoSafe$.MODULE$.safeOrEmpty(seekAnyValue).map((Function1 & Serializable)value -> new .colon.colon((Object)PropertyIndexQuery.exact((int)BoxesRunTime.unboxToInt((Object)ArrayOps$.MODULE$.head$extension(Predef$.MODULE$.intArrayOps(this.propertyIds()))), (Object)value), (List)Nil$.MODULE$)))).toIndexedSeq();
            }
            if (anyValue == Values.NO_VALUE) {
                return Predef$.MODULE$.wrapRefArray((Object[])Array$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(scala.collection.immutable.Seq.class)));
            }
            throw new CypherTypeException("Expected list, got " + anyValue);
        }
        if (queryExpression instanceof CompositeQueryExpression) {
            CompositeQueryExpression compositeQueryExpression = (CompositeQueryExpression)queryExpression;
            scala.collection.immutable.Seq exprs = compositeQueryExpression.inner();
            if (AssertionRunner.ASSERTIONS_ENABLED && exprs.lengthCompare(this.propertyIds().length) != 0) {
                throw new AssertionError((Object)"assertion failed");
            }
            scala.collection.immutable.Seq indexQueries = (scala.collection.immutable.Seq)((IterableOps)exprs.zip((IterableOnce)Predef$.MODULE$.wrapIntArray(this.propertyIds()))).map((Function1 & Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 != null) {
                    QueryExpression expr = (QueryExpression)tuple2._1();
                    int propId = tuple2._2$mcI$sp();
                    return (Seq)this.computeCompositeQueries(state, row, (QueryExpression<Expression>)expr, propId).flatMap((Function1 & Serializable)x0$2 -> {
                        PropertyIndexQuery propertyIndexQuery = x0$2;
                        if (propertyIndexQuery instanceof PropertyIndexQuery.ExactPredicate) {
                            PropertyIndexQuery.ExactPredicate exactPredicate = (PropertyIndexQuery.ExactPredicate)propertyIndexQuery;
                            return new Some((Object)exactPredicate);
                        }
                        throw new InternalException("Expected only exact for LockingUniqueIndexSeek");
                    });
                }
                throw new MatchError((Object)tuple2);
            });
            return SeqCombiner$.MODULE$.combine((Iterable)indexQueries);
        }
        throw new MatchError(queryExpression);
    }

    private Seq<PropertyIndexQuery> computeCompositeQueries(QueryState state, ReadableRow row, QueryExpression<Expression> queryExpression, int propertyId) {
        QueryExpression<Expression> queryExpression2 = queryExpression;
        if (queryExpression2 instanceof SingleQueryExpression) {
            SingleQueryExpression singleQueryExpression = (SingleQueryExpression)queryExpression2;
            Expression inner = (Expression)singleQueryExpression.expression();
            Option option = makeValueNeoSafe$.MODULE$.safeOrEmpty(inner.apply(row, state));
            if (option instanceof Some) {
                Some some = (Some)option;
                Value seekValue = (Value)some.value();
                return new .colon.colon((Object)PropertyIndexQuery.exact((int)propertyId, (Object)seekValue), (List)Nil$.MODULE$);
            }
            if (None$.MODULE$.equals(option)) {
                return (Seq)package$.MODULE$.Seq().empty();
            }
            throw new MatchError((Object)option);
        }
        if (queryExpression2 instanceof ManyQueryExpression) {
            scala.collection.immutable.Seq seq;
            Option option;
            ManyQueryExpression manyQueryExpression = (ManyQueryExpression)queryExpression2;
            Expression inner = (Expression)manyQueryExpression.expression();
            AnyValue anyValue = inner.apply(row, state);
            if (anyValue != null && !(option = IsList$.MODULE$.unapply(anyValue)).isEmpty()) {
                ListValue coll = (ListValue)option.get();
                seq = Predef$.MODULE$.copyArrayToImmutableIndexedSeq((Object)coll.asArray());
            } else if (anyValue == null) {
                seq = (scala.collection.immutable.Seq)package$.MODULE$.Seq().empty();
            } else {
                throw new CypherTypeException("Expected the value for " + inner + " to be a collection but it was not.");
            }
            scala.collection.immutable.Seq expr = seq;
            return (Seq)expr.flatMap((Function1 & Serializable)e -> makeValueNeoSafe$.MODULE$.safeOrEmpty(e).map((Function1 & Serializable)value -> PropertyIndexQuery.exact((int)propertyId, (Object)value)));
        }
        if (queryExpression2 instanceof CompositeQueryExpression) {
            throw new InternalException("A CompositeQueryExpression can't be nested in a CompositeQueryExpression");
        }
        if (queryExpression2 instanceof RangeQueryExpression) {
            RangeQueryExpression rangeQueryExpression = (RangeQueryExpression)queryExpression2;
            Expression rangeWrapper = (Expression)rangeQueryExpression.expression();
            return this.computeRangeQueries(state, row, rangeWrapper, propertyId);
        }
        if (queryExpression2 instanceof ExistenceQueryExpression) {
            return new .colon.colon((Object)PropertyIndexQuery.exists((int)propertyId), (List)Nil$.MODULE$);
        }
        throw new MatchError(queryExpression2);
    }

    public static void $init$(EntityIndexSeeker $this) {
        $this.org$neo4j$cypher$internal$runtime$interpreted$pipes$EntityIndexSeeker$_setter_$org$neo4j$cypher$internal$runtime$interpreted$pipes$EntityIndexSeeker$$BY_VALUE_$eq((MinMaxOrdering<Value>)new MinMaxOrdering(package$.MODULE$.Ordering().comparatorToOrdering((Comparator)Values.COMPARATOR)));
    }
}

