/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.runtime.interpreted.commands.showcommands;

import java.io.Serializable;
import java.time.Duration;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAmount;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.concurrent.TimeUnit;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.cypher.internal.ast.CommandResultItem;
import org.neo4j.cypher.internal.ast.ShowColumn;
import org.neo4j.cypher.internal.runtime.ClosingIterator;
import org.neo4j.cypher.internal.runtime.ClosingIterator$;
import org.neo4j.cypher.internal.runtime.CypherRow;
import org.neo4j.cypher.internal.runtime.QueryContext;
import org.neo4j.cypher.internal.runtime.interpreted.commands.expressions.Expression;
import org.neo4j.cypher.internal.runtime.interpreted.commands.showcommands.QueryId;
import org.neo4j.cypher.internal.runtime.interpreted.commands.showcommands.ShowTransactionsCommand$;
import org.neo4j.cypher.internal.runtime.interpreted.commands.showcommands.TransactionCommand;
import org.neo4j.cypher.internal.runtime.interpreted.commands.showcommands.TransactionCommandHelper$;
import org.neo4j.cypher.internal.runtime.interpreted.commands.showcommands.TransactionId$;
import org.neo4j.cypher.internal.runtime.interpreted.pipes.QueryState;
import org.neo4j.dbms.database.DatabaseContext;
import org.neo4j.internal.kernel.api.helpers.TransactionDependenciesResolver;
import org.neo4j.internal.kernel.api.security.AdminActionOnResource;
import org.neo4j.internal.kernel.api.security.PrivilegeAction;
import org.neo4j.internal.kernel.api.security.SecurityContext;
import org.neo4j.internal.kernel.api.security.Segment;
import org.neo4j.internal.kernel.api.security.UserSegment;
import org.neo4j.kernel.api.KernelTransactionHandle;
import org.neo4j.kernel.api.query.QuerySnapshot;
import org.neo4j.kernel.impl.api.TransactionExecutionStatistic;
import org.neo4j.kernel.impl.util.ValueUtils;
import org.neo4j.logging.LogTimeZone;
import org.neo4j.values.AnyValue;
import org.neo4j.values.storable.DurationValue;
import org.neo4j.values.storable.LongValue;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;
import org.neo4j.values.virtual.ListValue;
import org.neo4j.values.virtual.MapValue;
import org.neo4j.values.virtual.VirtualValues;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Tuple15;
import scala.Tuple2;
import scala.Tuple3;
import scala.Tuple4;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Iterator;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.util.Either;

@ScalaSignature(bytes="\u0006\u0005\t=d\u0001\u0002\u0013&\u0001ZB\u0001\"\u0014\u0001\u0003\u0016\u0004%\tA\u0014\u0005\tG\u0002\u0011\t\u0012)A\u0005\u001f\"AA\r\u0001BK\u0002\u0013\u0005Q\r\u0003\u0005j\u0001\tE\t\u0015!\u0003g\u0011!Q\u0007A!f\u0001\n\u0003Y\u0007\u0002C:\u0001\u0005#\u0005\u000b\u0011\u00027\t\u0011Q\u0004!Q3A\u0005\u0002UD\u0001B\u001f\u0001\u0003\u0012\u0003\u0006IA\u001e\u0005\u0006w\u0002!\t\u0001 \u0005\b\u0003\u000b\u0001A\u0011IA\u0004\u0011\u001d\ti\u0004\u0001C\u0005\u0003\u007fAq!a\u0017\u0001\t\u0013\ti\u0006C\u0004\u0002x\u0001!I!!\u001f\t\u000f\u0005\u0015\u0006\u0001\"\u0003\u0002(\"I\u0011Q\u0016\u0001\u0002\u0002\u0013\u0005\u0011q\u0016\u0005\n\u0003s\u0003\u0011\u0013!C\u0001\u0003wC\u0011\"!5\u0001#\u0003%\t!a5\t\u0013\u0005]\u0007!%A\u0005\u0002\u0005e\u0007\"CAo\u0001E\u0005I\u0011AAp\u0011%\t\u0019\u000fAA\u0001\n\u0003\n)\u000fC\u0005\u0002h\u0002\t\t\u0011\"\u0001\u0002j\"I\u0011\u0011\u001f\u0001\u0002\u0002\u0013\u0005\u00111\u001f\u0005\n\u0003\u007f\u0004\u0011\u0011!C!\u0005\u0003A\u0011Ba\u0004\u0001\u0003\u0003%\tA!\u0005\t\u0013\tU\u0001!!A\u0005B\t]\u0001\"\u0003B\u000e\u0001\u0005\u0005I\u0011\tB\u000f\u0011%\u0011y\u0002AA\u0001\n\u0003\u0012\t\u0003C\u0005\u0003$\u0001\t\t\u0011\"\u0011\u0003&\u001dI!\u0011F\u0013\u0002\u0002#\u0005!1\u0006\u0004\tI\u0015\n\t\u0011#\u0001\u0003.!11P\bC\u0001\u0005\u0007B\u0011Ba\b\u001f\u0003\u0003%)E!\t\t\u0013\t\u0015c$!A\u0005\u0002\n\u001d\u0003\"\u0003B)=\u0005\u0005I\u0011\u0011B*\u0011%\u0011)GHA\u0001\n\u0013\u00119GA\fTQ><HK]1og\u0006\u001cG/[8og\u000e{W.\\1oI*\u0011aeJ\u0001\rg\"|woY8n[\u0006tGm\u001d\u0006\u0003Q%\n\u0001bY8n[\u0006tGm\u001d\u0006\u0003U-\n1\"\u001b8uKJ\u0004(/\u001a;fI*\u0011A&L\u0001\beVtG/[7f\u0015\tqs&\u0001\u0005j]R,'O\\1m\u0015\t\u0001\u0014'\u0001\u0004dsBDWM\u001d\u0006\u0003eM\nQA\\3pi)T\u0011\u0001N\u0001\u0004_J<7\u0001A\n\u0005\u0001]Z\u0014\t\u0005\u00029s5\tQ%\u0003\u0002;K\t\u0011BK]1og\u0006\u001cG/[8o\u0007>lW.\u00198e!\tat(D\u0001>\u0015\u0005q\u0014!B:dC2\f\u0017B\u0001!>\u0005\u001d\u0001&o\u001c3vGR\u0004\"A\u0011&\u000f\u0005\rCeB\u0001#H\u001b\u0005)%B\u0001$6\u0003\u0019a$o\\8u}%\ta(\u0003\u0002J{\u00059\u0001/Y2lC\u001e,\u0017BA&M\u00051\u0019VM]5bY&T\u0018M\u00197f\u0015\tIU(\u0001\u0005hSZ,g.\u00133t+\u0005y\u0005\u0003\u0002\"Q%vK!!\u0015'\u0003\r\u0015KG\u000f[3s!\r\u00115+V\u0005\u0003)2\u0013A\u0001T5tiB\u0011aK\u0017\b\u0003/b\u0003\"\u0001R\u001f\n\u0005ek\u0014A\u0002)sK\u0012,g-\u0003\u0002\\9\n11\u000b\u001e:j]\u001eT!!W\u001f\u0011\u0005y\u000bW\"A0\u000b\u0005\u0001<\u0013aC3yaJ,7o]5p]NL!AY0\u0003\u0015\u0015C\bO]3tg&|g.A\u0005hSZ,g.\u00133tA\u00059a/\u001a:c_N,W#\u00014\u0011\u0005q:\u0017B\u00015>\u0005\u001d\u0011un\u001c7fC:\f\u0001B^3sE>\u001cX\rI\u0001\u000fI\u00164\u0017-\u001e7u\u0007>dW/\u001c8t+\u0005a\u0007c\u0001\"T[B\u0011a.]\u0007\u0002_*\u0011\u0001/L\u0001\u0004CN$\u0018B\u0001:p\u0005)\u0019\u0006n\\<D_2,XN\\\u0001\u0010I\u00164\u0017-\u001e7u\u0007>dW/\u001c8tA\u0005a\u00110[3mI\u000e{G.^7ogV\ta\u000fE\u0002C'^\u0004\"A\u001c=\n\u0005e|'!E\"p[6\fg\u000e\u001a*fgVdG/\u0013;f[\u0006i\u00110[3mI\u000e{G.^7og\u0002\na\u0001P5oSRtDcB?\u007f\u007f\u0006\u0005\u00111\u0001\t\u0003q\u0001AQ!T\u0005A\u0002=CQ\u0001Z\u0005A\u0002\u0019DQA[\u0005A\u00021DQ\u0001^\u0005A\u0002Y\f\u0001c\u001c:jO&t\u0017\r\u001c(b[\u0016\u0014vn^:\u0015\r\u0005%\u00111EA\u001a!\u0019\tY!!\u0004\u0002\u00125\t1&C\u0002\u0002\u0010-\u0012qb\u00117pg&tw-\u0013;fe\u0006$xN\u001d\t\u0007-\u0006MQ+a\u0006\n\u0007\u0005UALA\u0002NCB\u0004B!!\u0007\u0002 5\u0011\u00111\u0004\u0006\u0004\u0003;\t\u0014A\u0002<bYV,7/\u0003\u0003\u0002\"\u0005m!\u0001C!osZ\u000bG.^3\t\u000f\u0005\u0015\"\u00021\u0001\u0002(\u0005)1\u000f^1uKB!\u0011\u0011FA\u0018\u001b\t\tYCC\u0002\u0002.%\nQ\u0001]5qKNLA!!\r\u0002,\tQ\u0011+^3ssN#\u0018\r^3\t\u000f\u0005U\"\u00021\u0001\u00028\u00059!-Y:f%><\b\u0003BA\u0006\u0003sI1!a\u000f,\u0005%\u0019\u0015\u0010\u001d5feJ{w/A\u000bhKR\u001cuN\u001c4jOV\u0014X\r\u001a+j[\u0016TvN\\3\u0015\t\u0005\u0005\u0013\u0011\u000b\t\u0005\u0003\u0007\ni%\u0004\u0002\u0002F)!\u0011qIA%\u0003\u0011!\u0018.\\3\u000b\u0005\u0005-\u0013\u0001\u00026bm\u0006LA!a\u0014\u0002F\t1!l\u001c8f\u0013\u0012Dq!a\u0015\f\u0001\u0004\t)&A\u0002dib\u0004B!a\u0003\u0002X%\u0019\u0011\u0011L\u0016\u0003\u0019E+XM]=D_:$X\r\u001f;\u0002\u0015\u0019|'/\\1u)&lW\r\u0006\u0004\u0002`\u0005%\u00141\u000f\t\u0005\u0003C\n9'\u0004\u0002\u0002d)!\u0011QMA%\u0003\u0011a\u0017M\\4\n\u0007m\u000b\u0019\u0007C\u0004\u0002l1\u0001\r!!\u001c\u0002\u0013M$\u0018M\u001d;US6,\u0007c\u0001\u001f\u0002p%\u0019\u0011\u0011O\u001f\u0003\t1{gn\u001a\u0005\b\u0003kb\u0001\u0019AA!\u0003\u0019QxN\\3JI\u0006Iq-\u001a;Ti\u0006$Xo\u001d\u000b\u0006+\u0006m\u0014q\u0012\u0005\b\u0003{j\u0001\u0019AA@\u0003\u0019A\u0017M\u001c3mKB!\u0011\u0011QAF\u001b\t\t\u0019I\u0003\u0003\u0002\u0006\u0006\u001d\u0015aA1qS*\u0019\u0011\u0011R\u0019\u0002\r-,'O\\3m\u0013\u0011\ti)a!\u0003/-+'O\\3m)J\fgn]1di&|g\u000eS1oI2,\u0007bBAI\u001b\u0001\u0007\u00111S\u0001 iJ\fgn]1di&|g\u000eR3qK:$WM\\2jKN\u0014Vm]8mm\u0016\u0014\b\u0003BAK\u0003Ck!!a&\u000b\t\u0005e\u00151T\u0001\bQ\u0016d\u0007/\u001a:t\u0015\u0011\t))!(\u000b\t\u0005%\u0015q\u0014\u0006\u0003]EJA!a)\u0002\u0018\nyBK]1og\u0006\u001cG/[8o\t\u0016\u0004XM\u001c3f]\u000eLWm\u001d*fg>dg/\u001a:\u0002%\u001d,G/\u0012=fGV$\u0018N\\4Ti\u0006$Xo\u001d\u000b\u0006+\u0006%\u00161\u0016\u0005\b\u0003{r\u0001\u0019AA@\u0011\u001d\t\tJ\u0004a\u0001\u0003'\u000bAaY8qsRIQ0!-\u00024\u0006U\u0016q\u0017\u0005\b\u001b>\u0001\n\u00111\u0001P\u0011\u001d!w\u0002%AA\u0002\u0019DqA[\b\u0011\u0002\u0003\u0007A\u000eC\u0004u\u001fA\u0005\t\u0019\u0001<\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%cU\u0011\u0011Q\u0018\u0016\u0004\u001f\u0006}6FAAa!\u0011\t\u0019-!4\u000e\u0005\u0005\u0015'\u0002BAd\u0003\u0013\f\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005-W(\u0001\u0006b]:|G/\u0019;j_:LA!a4\u0002F\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%eU\u0011\u0011Q\u001b\u0016\u0004M\u0006}\u0016AD2paf$C-\u001a4bk2$HeM\u000b\u0003\u00037T3\u0001\\A`\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIQ*\"!!9+\u0007Y\fy,A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u000b\u0003\u0003?\nA\u0002\u001d:pIV\u001cG/\u0011:jif,\"!a;\u0011\u0007q\ni/C\u0002\u0002pv\u00121!\u00138u\u00039\u0001(o\u001c3vGR,E.Z7f]R$B!!>\u0002|B\u0019A(a>\n\u0007\u0005eXHA\u0002B]fD\u0011\"!@\u0017\u0003\u0003\u0005\r!a;\u0002\u0007a$\u0013'A\bqe>$Wo\u0019;Ji\u0016\u0014\u0018\r^8s+\t\u0011\u0019\u0001\u0005\u0004\u0003\u0006\t-\u0011Q_\u0007\u0003\u0005\u000fQ1A!\u0003>\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0005\u001b\u00119A\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0003!\u0019\u0017M\\#rk\u0006dGc\u00014\u0003\u0014!I\u0011Q \r\u0002\u0002\u0003\u0007\u0011Q_\u0001\u0013aJ|G-^2u\u000b2,W.\u001a8u\u001d\u0006lW\r\u0006\u0003\u0002`\te\u0001\"CA\u007f3\u0005\u0005\t\u0019AAv\u0003!A\u0017m\u001d5D_\u0012,GCAAv\u0003!!xn\u0015;sS:<GCAA0\u0003\u0019)\u0017/^1mgR\u0019aMa\n\t\u0013\u0005uH$!AA\u0002\u0005U\u0018aF*i_^$&/\u00198tC\u000e$\u0018n\u001c8t\u0007>lW.\u00198e!\tAddE\u0003\u001f\u0005_\u0011I\u0004E\u0005\u00032\tUrJ\u001a7w{6\u0011!1\u0007\u0006\u0003YuJAAa\u000e\u00034\t\t\u0012IY:ue\u0006\u001cGOR;oGRLwN\u001c\u001b\u0011\t\tm\"\u0011I\u0007\u0003\u0005{QAAa\u0010\u0002J\u0005\u0011\u0011n\\\u0005\u0004\u0017\nuBC\u0001B\u0016\u0003\u0015\t\u0007\u000f\u001d7z)%i(\u0011\nB&\u0005\u001b\u0012y\u0005C\u0003NC\u0001\u0007q\nC\u0003eC\u0001\u0007a\rC\u0003kC\u0001\u0007A\u000eC\u0003uC\u0001\u0007a/A\u0004v]\u0006\u0004\b\u000f\\=\u0015\t\tU#\u0011\r\t\u0006y\t]#1L\u0005\u0004\u00053j$AB(qi&|g\u000eE\u0004=\u0005;ze\r\u001c<\n\u0007\t}SH\u0001\u0004UkBdW\r\u000e\u0005\t\u0005G\u0012\u0013\u0011!a\u0001{\u0006\u0019\u0001\u0010\n\u0019\u0002\u0019]\u0014\u0018\u000e^3SKBd\u0017mY3\u0015\u0005\t%\u0004\u0003BA1\u0005WJAA!\u001c\u0002d\t1qJ\u00196fGR\u0004")
public class ShowTransactionsCommand
extends TransactionCommand
implements Product,
Serializable {
    private final Either<List<String>, Expression> givenIds;
    private final boolean verbose;
    private final List<ShowColumn> defaultColumns;
    private final List<CommandResultItem> yieldColumns;

    public static Option<Tuple4<Either<List<String>, Expression>, Object, List<ShowColumn>, List<CommandResultItem>>> unapply(ShowTransactionsCommand x$0) {
        return ShowTransactionsCommand$.MODULE$.unapply(x$0);
    }

    public static ShowTransactionsCommand apply(Either<List<String>, Expression> givenIds, boolean verbose, List<ShowColumn> defaultColumns, List<CommandResultItem> yieldColumns) {
        return ShowTransactionsCommand$.MODULE$.apply(givenIds, verbose, defaultColumns, yieldColumns);
    }

    public static Function1<Tuple4<Either<List<String>, Expression>, Object, List<ShowColumn>, List<CommandResultItem>>, ShowTransactionsCommand> tupled() {
        return ShowTransactionsCommand$.MODULE$.tupled();
    }

    public static Function1<Either<List<String>, Expression>, Function1<Object, Function1<List<ShowColumn>, Function1<List<CommandResultItem>, ShowTransactionsCommand>>>> curried() {
        return ShowTransactionsCommand$.MODULE$.curried();
    }

    public Iterator<String> productElementNames() {
        return Product.productElementNames$((Product)this);
    }

    public Either<List<String>, Expression> givenIds() {
        return this.givenIds;
    }

    public boolean verbose() {
        return this.verbose;
    }

    public List<ShowColumn> defaultColumns() {
        return this.defaultColumns;
    }

    public List<CommandResultItem> yieldColumns() {
        return this.yieldColumns;
    }

    @Override
    public ClosingIterator<scala.collection.immutable.Map<String, AnyValue>> originalNameRows(QueryState state, CypherRow baseRow) {
        List<String> ids = TransactionCommandHelper$.MODULE$.extractIds(this.givenIds(), state, baseRow);
        QueryContext ctx = state.query();
        SecurityContext securityContext = ctx.transactionalContext().securityContext();
        List allowedTransactions = CollectionConverters$.MODULE$.CollectionHasAsScala(ctx.getDatabaseContextProvider().registeredDatabases().values()).asScala().toList().filter((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)ShowTransactionsCommand.$anonfun$originalNameRows$1(x$1))).flatMap((Function1 & Serializable)databaseContext -> {
            String dbName = databaseContext.databaseFacade().databaseName();
            AdminActionOnResource.DatabaseScope dbScope = new AdminActionOnResource.DatabaseScope(databaseContext.database().getNamedDatabaseId().name());
            Set<KernelTransactionHandle> allTransactions = TransactionCommandHelper$.MODULE$.getExecutingTransactions((DatabaseContext)databaseContext);
            return (Set)((IterableOps)allTransactions.filter((Function1 & Serializable)tx -> BoxesRunTime.boxToBoolean((boolean)ShowTransactionsCommand.$anonfun$originalNameRows$3(dbScope, securityContext, tx)))).map((Function1 & Serializable)tx -> {
                Optional<QuerySnapshot> querySnapshot = tx.executingQuery().map(x$2 -> x$2.snapshot());
                return new Tuple3(tx, querySnapshot, (Object)dbName);
            });
        });
        List askedForTransactions = ids.nonEmpty() ? allowedTransactions.filter((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)ShowTransactionsCommand.$anonfun$originalNameRows$6(ids, x0$1))) : allowedTransactions;
        HashMap handleQuerySnapshotsMap = new HashMap();
        askedForTransactions.foreach((Function1 & Serializable)x0$2 -> {
            Tuple3 tuple3 = x0$2;
            if (tuple3 != null) {
                KernelTransactionHandle transaction = (KernelTransactionHandle)tuple3._1();
                Optional querySnapshot = (Optional)tuple3._2();
                if (transaction != null) {
                    KernelTransactionHandle kernelTransactionHandle = transaction;
                    if (querySnapshot != null) {
                        Optional optional = querySnapshot;
                        return handleQuerySnapshotsMap.put(kernelTransactionHandle, optional);
                    }
                }
            }
            throw new MatchError((Object)tuple3);
        });
        TransactionDependenciesResolver transactionDependenciesResolver = new TransactionDependenciesResolver(handleQuerySnapshotsMap);
        ZoneId zoneId = this.getConfiguredTimeZone(ctx);
        List rows = askedForTransactions.map((Function1 & Serializable)x0$3 -> {
            Tuple3 tuple3 = x0$3;
            if (tuple3 != null) {
                KernelTransactionHandle transaction = (KernelTransactionHandle)tuple3._1();
                Optional querySnapshot = (Optional)tuple3._2();
                String dbName = (String)tuple3._3();
                if (transaction != null) {
                    KernelTransactionHandle kernelTransactionHandle = transaction;
                    if (querySnapshot != null) {
                        Optional optional = querySnapshot;
                        if (dbName != null) {
                            Tuple2 tuple2;
                            String string = dbName;
                            TransactionExecutionStatistic statistic = kernelTransactionHandle.transactionStatistic();
                            Optional clientInfo = kernelTransactionHandle.clientInfo();
                            String txId = TransactionId$.MODULE$.apply(string, kernelTransactionHandle.getTransactionSequenceNumber()).toString();
                            String username = kernelTransactionHandle.subject().executingUser();
                            String startTime = this.formatTime(kernelTransactionHandle.startTime(), zoneId);
                            Value elapsedTime = ShowTransactionsCommand.getDurationOrNullFromMillis$1(Predef$.MODULE$.long2Long(statistic.getElapsedTimeMillis()));
                            if (optional.isPresent()) {
                                QuerySnapshot snapshot = (QuerySnapshot)optional.get();
                                String currentQueryId = new QueryId(snapshot.internalQueryId()).toString();
                                String currentQuery = snapshot.obfuscatedQueryText().orElse("");
                                v0 = new Tuple2((Object)currentQueryId, (Object)currentQuery);
                            } else {
                                v0 = tuple2 = new Tuple2((Object)"", (Object)"");
                            }
                            if (tuple2 == null) {
                                throw new MatchError((Object)tuple2);
                            }
                            String currentQueryId = (String)tuple2._1();
                            String currentQuery = (String)tuple2._2();
                            Tuple2 tuple22 = new Tuple2((Object)currentQueryId, (Object)currentQuery);
                            String currentQueryId2 = (String)tuple22._1();
                            String currentQuery2 = (String)tuple22._2();
                            String connectionId = clientInfo.map(x$4 -> x$4.connectionId()).orElse("");
                            String clientAddress = clientInfo.map(x$5 -> x$5.clientAddress()).orElse("");
                            String status = this.getStatus(kernelTransactionHandle, transactionDependenciesResolver);
                            scala.collection.immutable.Map briefResult = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"database"), (Object)Values.stringValue((String)string)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"transactionId"), (Object)Values.stringValue((String)txId)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"currentQueryId"), (Object)Values.stringValue((String)currentQueryId2)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"connectionId"), (Object)Values.stringValue((String)connectionId)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"clientAddress"), (Object)Values.stringValue((String)clientAddress)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"username"), (Object)Values.stringValue((String)username)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"currentQuery"), (Object)Values.stringValue((String)currentQuery2)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"startTime"), (Object)Values.stringValue((String)startTime)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"status"), (Object)Values.stringValue((String)status)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"elapsedTime"), (Object)elapsedTime)}));
                            if (this.verbose()) {
                                Tuple15 tuple15;
                                if (optional.isPresent()) {
                                    String queryTransactionId;
                                    QuerySnapshot query = (QuerySnapshot)optional.get();
                                    String string2 = queryTransactionId = TransactionId$.MODULE$.apply(string, query.transactionId()).toString();
                                    String string3 = txId;
                                    String outerTransactionId = !(string2 != null ? !string2.equals(string3) : string3 != null) ? "" : queryTransactionId;
                                    MapValue parameters = query.obfuscatedQueryParameters().orElse(MapValue.EMPTY);
                                    String maybePlanner = query.planner();
                                    String planner = maybePlanner == null ? "" : maybePlanner;
                                    String maybeRuntime = query.runtime();
                                    String runtime = maybeRuntime == null ? "" : maybeRuntime;
                                    ListValue indexes = VirtualValues.list((AnyValue[])((AnyValue[])CollectionConverters$.MODULE$.CollectionHasAsScala((Collection)query.indexes()).asScala().toList().map((Function1 & Serializable)m -> {
                                        scala.collection.mutable.Map scalaMap = CollectionConverters$.MODULE$.MapHasAsScala(m).asScala();
                                        String[] keys = (String[])scalaMap.keys().toArray(ClassTag$.MODULE$.apply(String.class));
                                        AnyValue[] vals = (AnyValue[])((IterableOnceOps)scalaMap.values().map((Function1 & Serializable)x$1 -> Values.stringValue((String)x$1))).toArray(ClassTag$.MODULE$.apply(AnyValue.class));
                                        return VirtualValues.map((String[])keys, (AnyValue[])vals);
                                    }).toArray(ClassTag$.MODULE$.apply(MapValue.class))));
                                    String queryStartTime = this.formatTime(query.startTimestampMillis(), zoneId);
                                    String queryStatus = query.status();
                                    LongValue queryActiveLockCount = Values.longValue((long)query.activeLockCount());
                                    Value queryElapsedTime = ShowTransactionsCommand.getDurationOrNullFromMicro$1(Predef$.MODULE$.long2Long(query.elapsedTimeMicros()));
                                    OptionalLong optionalCpuTime = query.cpuTimeMicros();
                                    Value queryCpuTime = optionalCpuTime.isPresent() ? ShowTransactionsCommand.getDurationOrNullFromMicro$1(Predef$.MODULE$.long2Long(optionalCpuTime.getAsLong())) : Values.NO_VALUE;
                                    DurationValue queryWaitTime = Values.durationValue((TemporalAmount)Duration.ofMillis(TimeUnit.MICROSECONDS.toMillis(query.waitTimeMicros())));
                                    OptionalLong optionalIdleTime = query.idleTimeMicros();
                                    Value queryIdleTime = optionalIdleTime.isPresent() ? ShowTransactionsCommand.getDurationOrNullFromMicro$1(Predef$.MODULE$.long2Long(optionalIdleTime.getAsLong())) : Values.NO_VALUE;
                                    long queryBytes = query.allocatedBytes();
                                    Value queryAllocatedBytes = queryBytes == -1L ? Values.NO_VALUE : ShowTransactionsCommand.getLongOrNull$1(Predef$.MODULE$.long2Long(queryBytes));
                                    LongValue queryPageHits = Values.longValue((long)query.pageHits());
                                    LongValue queryPageFaults = Values.longValue((long)query.pageFaults());
                                    v2 = new Tuple15((Object)outerTransactionId, (Object)parameters, (Object)planner, (Object)runtime, (Object)indexes, (Object)queryStartTime, (Object)queryStatus, (Object)queryActiveLockCount, (Object)queryElapsedTime, (Object)queryCpuTime, (Object)queryWaitTime, (Object)queryIdleTime, (Object)queryAllocatedBytes, (Object)queryPageHits, (Object)queryPageFaults);
                                } else {
                                    v2 = tuple15 = new Tuple15((Object)"", (Object)MapValue.EMPTY, (Object)"", (Object)"", (Object)VirtualValues.EMPTY_LIST, (Object)"", (Object)"", (Object)Values.NO_VALUE, (Object)Values.NO_VALUE, (Object)Values.NO_VALUE, (Object)Values.NO_VALUE, (Object)Values.NO_VALUE, (Object)Values.NO_VALUE, (Object)Values.NO_VALUE, (Object)Values.NO_VALUE);
                                }
                                if (tuple15 == null) {
                                    throw new MatchError((Object)tuple15);
                                }
                                String outerTransactionId = (String)tuple15._1();
                                MapValue parameters = (MapValue)tuple15._2();
                                String planner = (String)tuple15._3();
                                String runtime = (String)tuple15._4();
                                ListValue indexes = (ListValue)tuple15._5();
                                String queryStartTime = (String)tuple15._6();
                                String queryStatus = (String)tuple15._7();
                                Value queryActiveLockCount = (Value)tuple15._8();
                                Value queryElapsedTime = (Value)tuple15._9();
                                Value queryCpuTime = (Value)tuple15._10();
                                Value queryWaitTime = (Value)tuple15._11();
                                Value queryIdleTime = (Value)tuple15._12();
                                Value queryAllocatedBytes = (Value)tuple15._13();
                                Value queryPageHits = (Value)tuple15._14();
                                Value queryPageFaults = (Value)tuple15._15();
                                Tuple15 tuple152 = new Tuple15((Object)outerTransactionId, (Object)parameters, (Object)planner, (Object)runtime, (Object)indexes, (Object)queryStartTime, (Object)queryStatus, (Object)queryActiveLockCount, (Object)queryElapsedTime, (Object)queryCpuTime, (Object)queryWaitTime, (Object)queryIdleTime, (Object)queryAllocatedBytes, (Object)queryPageHits, (Object)queryPageFaults);
                                String outerTransactionId2 = (String)tuple152._1();
                                MapValue parameters2 = (MapValue)tuple152._2();
                                String planner2 = (String)tuple152._3();
                                String runtime2 = (String)tuple152._4();
                                ListValue indexes2 = (ListValue)tuple152._5();
                                String queryStartTime2 = (String)tuple152._6();
                                String queryStatus2 = (String)tuple152._7();
                                Value queryActiveLockCount2 = (Value)tuple152._8();
                                Value queryElapsedTime2 = (Value)tuple152._9();
                                Value queryCpuTime2 = (Value)tuple152._10();
                                Value queryWaitTime2 = (Value)tuple152._11();
                                Value queryIdleTime2 = (Value)tuple152._12();
                                Value queryAllocatedBytes2 = (Value)tuple152._13();
                                Value queryPageHits2 = (Value)tuple152._14();
                                Value queryPageFaults2 = (Value)tuple152._15();
                                MapValue metaData = ShowTransactionsCommand.getMapValue$1(kernelTransactionHandle.getMetaData());
                                String protocol = clientInfo.map(x$7 -> x$7.protocol()).orElse("");
                                String requestUri = clientInfo.map(x$8 -> x$8.requestURI()).orElse(null);
                                String statusDetails = kernelTransactionHandle.getStatusDetails();
                                MapValue resourceInformation = ShowTransactionsCommand.getMapValue$1(optional.map(x$9 -> x$9.resourceInformation()).orElse(Collections.emptyMap()));
                                long activeLockCount = kernelTransactionHandle.activeLocks().count();
                                Value cpuTime = ShowTransactionsCommand.getDurationOrNullFromMillis$1(statistic.getCpuTimeMillis());
                                DurationValue waitTime = Values.durationValue((TemporalAmount)Duration.ofMillis(statistic.getWaitTimeMillis()));
                                Value idleTime = ShowTransactionsCommand.getDurationOrNullFromMillis$1(statistic.getIdleTimeMillis());
                                Value allocatedDirectBytes = ShowTransactionsCommand.getLongOrNull$1(statistic.getNativeAllocatedBytes());
                                Value estimatedUsedHeapMemory = ShowTransactionsCommand.getLongOrNull$1(statistic.getEstimatedUsedHeapMemory());
                                long pageHits = statistic.getPageHits();
                                long pageFaults = statistic.getPageFaults();
                                String initializationStackTrace = kernelTransactionHandle.transactionInitialisationTrace().getTrace();
                                return (scala.collection.immutable.Map)briefResult.$plus$plus((IterableOnce)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"outerTransactionId"), (Object)Values.stringValue((String)outerTransactionId2)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"metaData"), (Object)metaData), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"parameters"), (Object)parameters2), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"planner"), (Object)Values.stringValue((String)planner2)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"runtime"), (Object)Values.stringValue((String)runtime2)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"indexes"), (Object)indexes2), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"currentQueryStartTime"), (Object)Values.stringValue((String)queryStartTime2)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"protocol"), (Object)Values.stringValue((String)protocol)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"requestUri"), (Object)Values.stringOrNoValue((String)requestUri)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"currentQueryStatus"), (Object)Values.stringValue((String)queryStatus2)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"statusDetails"), (Object)Values.stringValue((String)statusDetails)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"resourceInformation"), (Object)resourceInformation), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"activeLockCount"), (Object)Values.longValue((long)activeLockCount)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"currentQueryActiveLockCount"), (Object)queryActiveLockCount2), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"cpuTime"), (Object)cpuTime), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"waitTime"), (Object)waitTime), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"idleTime"), (Object)idleTime), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"currentQueryElapsedTime"), (Object)queryElapsedTime2), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"currentQueryCpuTime"), (Object)queryCpuTime2), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"currentQueryWaitTime"), (Object)queryWaitTime2), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"currentQueryIdleTime"), (Object)queryIdleTime2), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"currentQueryAllocatedBytes"), (Object)queryAllocatedBytes2), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"allocatedDirectBytes"), (Object)allocatedDirectBytes), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"estimatedUsedHeapMemory"), (Object)estimatedUsedHeapMemory), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"pageHits"), (Object)Values.longValue((long)pageHits)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"pageFaults"), (Object)Values.longValue((long)pageFaults)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"currentQueryPageHits"), (Object)queryPageHits2), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"currentQueryPageFaults"), (Object)queryPageFaults2), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"initializationStackTrace"), (Object)Values.stringValue((String)initializationStackTrace))})));
                            }
                            return briefResult;
                        }
                    }
                }
            }
            throw new MatchError((Object)tuple3);
        });
        List<scala.collection.immutable.Map<String, AnyValue>> updatedRows = this.updateRowsWithPotentiallyRenamedColumns((List<scala.collection.immutable.Map<String, AnyValue>>)rows);
        return ClosingIterator$.MODULE$.apply(updatedRows.iterator());
    }

    private ZoneId getConfiguredTimeZone(QueryContext ctx) {
        return ((LogTimeZone)ctx.getConfig().get(GraphDatabaseSettings.db_timezone)).getZoneId();
    }

    private String formatTime(long startTime, ZoneId zoneId) {
        return OffsetDateTime.ofInstant(Instant.ofEpochMilli(startTime), zoneId).format(DateTimeFormatter.ISO_OFFSET_DATE_TIME);
    }

    private String getStatus(KernelTransactionHandle handle, TransactionDependenciesResolver transactionDependenciesResolver) {
        return handle.terminationReason().map(reason -> String.format(TransactionId$.MODULE$.TERMINATED_STATE(), reason.code())).orElseGet(() -> this.getExecutingStatus(handle, transactionDependenciesResolver));
    }

    private String getExecutingStatus(KernelTransactionHandle handle, TransactionDependenciesResolver transactionDependenciesResolver) {
        if (transactionDependenciesResolver.isBlocked(handle)) {
            return TransactionId$.MODULE$.BLOCKED_STATE() + transactionDependenciesResolver.describeBlockingTransactions(handle);
        }
        if (handle.isClosing()) {
            return TransactionId$.MODULE$.CLOSING_STATE();
        }
        return TransactionId$.MODULE$.RUNNING_STATE();
    }

    public ShowTransactionsCommand copy(Either<List<String>, Expression> givenIds, boolean verbose, List<ShowColumn> defaultColumns, List<CommandResultItem> yieldColumns) {
        return new ShowTransactionsCommand(givenIds, verbose, defaultColumns, yieldColumns);
    }

    public Either<List<String>, Expression> copy$default$1() {
        return this.givenIds();
    }

    public boolean copy$default$2() {
        return this.verbose();
    }

    public List<ShowColumn> copy$default$3() {
        return this.defaultColumns();
    }

    public List<CommandResultItem> copy$default$4() {
        return this.yieldColumns();
    }

    public String productPrefix() {
        return "ShowTransactionsCommand";
    }

    public int productArity() {
        return 4;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.givenIds();
            }
            case 1: {
                return BoxesRunTime.boxToBoolean((boolean)this.verbose());
            }
            case 2: {
                return this.defaultColumns();
            }
            case 3: {
                return this.yieldColumns();
            }
        }
        return Statics.ioobe((int)x$1);
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof ShowTransactionsCommand;
    }

    public String productElementName(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return "givenIds";
            }
            case 1: {
                return "verbose";
            }
            case 2: {
                return "defaultColumns";
            }
            case 3: {
                return "yieldColumns";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    public int hashCode() {
        int n = -889275714;
        n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
        n = Statics.mix((int)n, (int)Statics.anyHash(this.givenIds()));
        n = Statics.mix((int)n, (int)(this.verbose() ? 1231 : 1237));
        n = Statics.mix((int)n, (int)Statics.anyHash(this.defaultColumns()));
        n = Statics.mix((int)n, (int)Statics.anyHash(this.yieldColumns()));
        return Statics.finalizeHash((int)n, (int)4);
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof ShowTransactionsCommand)) return false;
        boolean bl = true;
        if (!bl) return false;
        ShowTransactionsCommand showTransactionsCommand = (ShowTransactionsCommand)x$1;
        if (this.verbose() != showTransactionsCommand.verbose()) return false;
        Either<List<String>, Expression> either = this.givenIds();
        Either<List<String>, Expression> either2 = showTransactionsCommand.givenIds();
        if (either == null) {
            if (either2 != null) {
                return false;
            }
        } else if (!either.equals(either2)) return false;
        List<ShowColumn> list = this.defaultColumns();
        List<ShowColumn> list2 = showTransactionsCommand.defaultColumns();
        if (list == null) {
            if (list2 != null) {
                return false;
            }
        } else if (!list.equals(list2)) return false;
        List<CommandResultItem> list3 = this.yieldColumns();
        List<CommandResultItem> list4 = showTransactionsCommand.yieldColumns();
        if (list3 == null) {
            if (list4 != null) {
                return false;
            }
        } else if (!list3.equals(list4)) return false;
        if (!showTransactionsCommand.canEqual(this)) return false;
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$originalNameRows$1(DatabaseContext x$1) {
        return x$1.database().isStarted();
    }

    public static final /* synthetic */ boolean $anonfun$originalNameRows$3(AdminActionOnResource.DatabaseScope dbScope$1, SecurityContext securityContext$1, KernelTransactionHandle tx) {
        String username = tx.subject().executingUser();
        AdminActionOnResource action = new AdminActionOnResource(PrivilegeAction.SHOW_TRANSACTION, dbScope$1, (Segment)new UserSegment(username));
        return TransactionCommandHelper$.MODULE$.isSelfOrAllows(username, action, securityContext$1);
    }

    public static final /* synthetic */ boolean $anonfun$originalNameRows$6(List ids$1, Tuple3 x0$1) {
        Tuple3 tuple3 = x0$1;
        if (tuple3 != null) {
            KernelTransactionHandle transaction = (KernelTransactionHandle)tuple3._1();
            String dbName = (String)tuple3._3();
            if (transaction != null) {
                KernelTransactionHandle kernelTransactionHandle = transaction;
                if (dbName != null) {
                    String string = dbName;
                    String txId = TransactionId$.MODULE$.apply(string, kernelTransactionHandle.getTransactionSequenceNumber()).toString();
                    return ids$1.contains((Object)txId);
                }
            }
        }
        throw new MatchError((Object)tuple3);
    }

    private static final Value getLongOrNull$1(Long l) {
        Long l2 = l;
        if (l2 != null) {
            Long l3 = l2;
            return Values.longValue((long)Predef$.MODULE$.Long2long(l3));
        }
        return Values.NO_VALUE;
    }

    private static final Value getDurationOrNullFromMillis$1(Long l) {
        Long l2 = l;
        if (l2 != null) {
            Long l3 = l2;
            return Values.durationValue((TemporalAmount)Duration.ofMillis(Predef$.MODULE$.Long2long(l3)));
        }
        return Values.NO_VALUE;
    }

    private static final Value getDurationOrNullFromMicro$1(Long l) {
        Long l2 = l;
        if (l2 != null) {
            Long l3 = l2;
            return Values.durationValue((TemporalAmount)Duration.ofMillis(TimeUnit.MICROSECONDS.toMillis(Predef$.MODULE$.Long2long(l3))));
        }
        return Values.NO_VALUE;
    }

    private static final MapValue getMapValue$1(Map m) {
        scala.collection.mutable.Map scalaMap = CollectionConverters$.MODULE$.MapHasAsScala(m).asScala();
        String[] keys = (String[])scalaMap.keys().toArray(ClassTag$.MODULE$.apply(String.class));
        AnyValue[] vals = (AnyValue[])((IterableOnceOps)scalaMap.values().map((Function1 & Serializable)x$1 -> ValueUtils.of((Object)x$1))).toArray(ClassTag$.MODULE$.apply(AnyValue.class));
        return VirtualValues.map((String[])keys, (AnyValue[])vals);
    }

    public ShowTransactionsCommand(Either<List<String>, Expression> givenIds, boolean verbose, List<ShowColumn> defaultColumns, List<CommandResultItem> yieldColumns) {
        this.givenIds = givenIds;
        this.verbose = verbose;
        this.defaultColumns = defaultColumns;
        this.yieldColumns = yieldColumns;
        super(defaultColumns, yieldColumns);
        Product.$init$((Product)this);
    }
}

