/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.runtime.interpreted.commands.showcommands;

import java.io.Serializable;
import org.neo4j.common.EntityType;
import org.neo4j.cypher.internal.ast.ShowColumn;
import org.neo4j.cypher.internal.ast.ShowIndexType;
import org.neo4j.cypher.internal.runtime.interpreted.commands.showcommands.ShowIndexesCommand;
import org.neo4j.cypher.internal.runtime.interpreted.commands.showcommands.ShowSchemaCommandHelper$;
import org.neo4j.internal.schema.ConstraintDescriptor;
import org.neo4j.internal.schema.IndexConfig;
import org.neo4j.internal.schema.IndexType;
import org.neo4j.values.storable.BooleanValue;
import org.neo4j.values.storable.StringValue;
import org.neo4j.values.storable.Value;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple3;
import scala.collection.immutable.List;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;

public final class ShowIndexesCommand$
implements Serializable {
    public static final ShowIndexesCommand$ MODULE$ = new ShowIndexesCommand$();

    public String org$neo4j$cypher$internal$runtime$interpreted$commands$showcommands$ShowIndexesCommand$$createIndexStatement(String name, IndexType indexType, EntityType entityType, List<String> labelsOrTypes, List<String> properties, String providerName, IndexConfig indexConfig, Option<ConstraintDescriptor> maybeConstraint) {
        String escapedName = "`" + ShowSchemaCommandHelper$.MODULE$.escapeBackticks(name) + "`";
        IndexType indexType2 = indexType;
        if (IndexType.RANGE.equals(indexType2)) {
            ConstraintDescriptor constraint;
            String labelsOrTypesWithColons = ShowSchemaCommandHelper$.MODULE$.asEscapedString(labelsOrTypes, ShowSchemaCommandHelper$.MODULE$.colonStringJoiner());
            boolean bl = false;
            Some some = null;
            Option<ConstraintDescriptor> option = maybeConstraint;
            if (option instanceof Some) {
                bl = true;
                some = (Some)option;
                ConstraintDescriptor constraint2 = (ConstraintDescriptor)some.value();
                if (constraint2.isUniquenessConstraint()) {
                    String escapedNodeProperties = ShowSchemaCommandHelper$.MODULE$.asEscapedString(properties, ShowSchemaCommandHelper$.MODULE$.propStringJoiner());
                    String optionsString = "{indexConfig: {}, indexProvider: '" + providerName + "'}";
                    return ShowIndexesCommand$.constraintCommand$1(labelsOrTypesWithColons, escapedNodeProperties, "IS UNIQUE", optionsString, escapedName);
                }
            }
            if (bl && (constraint = (ConstraintDescriptor)some.value()).isNodeKeyConstraint()) {
                String escapedNodeProperties = ShowSchemaCommandHelper$.MODULE$.asEscapedString(properties, ShowSchemaCommandHelper$.MODULE$.propStringJoiner());
                String optionsString = "{indexConfig: {}, indexProvider: '" + providerName + "'}";
                return ShowIndexesCommand$.constraintCommand$1(labelsOrTypesWithColons, escapedNodeProperties, "IS NODE KEY", optionsString, escapedName);
            }
            if (bl) {
                throw new IllegalArgumentException("Expected an index or index backed constraint, found another constraint.");
            }
            if (None$.MODULE$.equals(option)) {
                EntityType entityType2 = entityType;
                if (EntityType.NODE.equals(entityType2)) {
                    String escapedNodeProperties = ShowSchemaCommandHelper$.MODULE$.asEscapedString(properties, ShowSchemaCommandHelper$.MODULE$.propStringJoiner());
                    return "CREATE RANGE INDEX " + escapedName + " FOR (n" + labelsOrTypesWithColons + ") ON (" + escapedNodeProperties + ")";
                }
                if (EntityType.RELATIONSHIP.equals(entityType2)) {
                    String escapedRelProperties = ShowSchemaCommandHelper$.MODULE$.asEscapedString(properties, ShowSchemaCommandHelper$.MODULE$.relPropStringJoiner());
                    return "CREATE RANGE INDEX " + escapedName + " FOR ()-[r" + labelsOrTypesWithColons + "]-() ON (" + escapedRelProperties + ")";
                }
                throw new IllegalArgumentException("Did not recognize entity type " + entityType);
            }
            throw new MatchError(option);
        }
        if (IndexType.FULLTEXT.equals(indexType2)) {
            String labelsOrTypesWithBars = ShowSchemaCommandHelper$.MODULE$.asEscapedString(labelsOrTypes, ShowSchemaCommandHelper$.MODULE$.barStringJoiner());
            String fulltextConfig = ShowSchemaCommandHelper$.MODULE$.configAsString(indexConfig, (Function1<Value, String>)(Function1 & Serializable)value -> MODULE$.fullTextConfigValueAsString((Value)value));
            String optionsString = ShowSchemaCommandHelper$.MODULE$.optionsAsString(providerName, fulltextConfig);
            EntityType entityType3 = entityType;
            if (EntityType.NODE.equals(entityType3)) {
                String escapedNodeProperties = ShowSchemaCommandHelper$.MODULE$.asEscapedString(properties, ShowSchemaCommandHelper$.MODULE$.propStringJoiner());
                return "CREATE FULLTEXT INDEX " + escapedName + " FOR (n" + labelsOrTypesWithBars + ") ON EACH [" + escapedNodeProperties + "] OPTIONS " + optionsString;
            }
            if (EntityType.RELATIONSHIP.equals(entityType3)) {
                String escapedRelProperties = ShowSchemaCommandHelper$.MODULE$.asEscapedString(properties, ShowSchemaCommandHelper$.MODULE$.relPropStringJoiner());
                return "CREATE FULLTEXT INDEX " + escapedName + " FOR ()-[r" + labelsOrTypesWithBars + "]-() ON EACH [" + escapedRelProperties + "] OPTIONS " + optionsString;
            }
            throw new IllegalArgumentException("Did not recognize entity type " + entityType);
        }
        if (IndexType.TEXT.equals(indexType2)) {
            String labelsOrTypesWithColons = ShowSchemaCommandHelper$.MODULE$.asEscapedString(labelsOrTypes, ShowSchemaCommandHelper$.MODULE$.colonStringJoiner());
            String optionsString = "{indexConfig: {}, indexProvider: '" + providerName + "'}";
            EntityType entityType4 = entityType;
            if (EntityType.NODE.equals(entityType4)) {
                String escapedNodeProperties = ShowSchemaCommandHelper$.MODULE$.asEscapedString(properties, ShowSchemaCommandHelper$.MODULE$.propStringJoiner());
                return "CREATE TEXT INDEX " + escapedName + " FOR (n" + labelsOrTypesWithColons + ") ON (" + escapedNodeProperties + ") OPTIONS " + optionsString;
            }
            if (EntityType.RELATIONSHIP.equals(entityType4)) {
                String escapedRelProperties = ShowSchemaCommandHelper$.MODULE$.asEscapedString(properties, ShowSchemaCommandHelper$.MODULE$.relPropStringJoiner());
                return "CREATE TEXT INDEX " + escapedName + " FOR ()-[r" + labelsOrTypesWithColons + "]-() ON (" + escapedRelProperties + ") OPTIONS " + optionsString;
            }
            throw new IllegalArgumentException("Did not recognize entity type " + entityType);
        }
        if (IndexType.POINT.equals(indexType2)) {
            String labelsOrTypesWithColons = ShowSchemaCommandHelper$.MODULE$.asEscapedString(labelsOrTypes, ShowSchemaCommandHelper$.MODULE$.colonStringJoiner());
            String pointConfig = ShowSchemaCommandHelper$.MODULE$.configAsString(indexConfig, (Function1<Value, String>)(Function1 & Serializable)value -> ShowSchemaCommandHelper$.MODULE$.pointConfigValueAsString((Value)value));
            String optionsString = ShowSchemaCommandHelper$.MODULE$.optionsAsString(providerName, pointConfig);
            EntityType entityType5 = entityType;
            if (EntityType.NODE.equals(entityType5)) {
                String escapedNodeProperties = ShowSchemaCommandHelper$.MODULE$.asEscapedString(properties, ShowSchemaCommandHelper$.MODULE$.propStringJoiner());
                return "CREATE POINT INDEX " + escapedName + " FOR (n" + labelsOrTypesWithColons + ") ON (" + escapedNodeProperties + ") OPTIONS " + optionsString;
            }
            if (EntityType.RELATIONSHIP.equals(entityType5)) {
                String escapedRelProperties = ShowSchemaCommandHelper$.MODULE$.asEscapedString(properties, ShowSchemaCommandHelper$.MODULE$.relPropStringJoiner());
                return "CREATE POINT INDEX " + escapedName + " FOR ()-[r" + labelsOrTypesWithColons + "]-() ON (" + escapedRelProperties + ") OPTIONS " + optionsString;
            }
            throw new IllegalArgumentException("Did not recognize entity type " + entityType);
        }
        if (IndexType.LOOKUP.equals(indexType2)) {
            EntityType entityType6 = entityType;
            if (EntityType.NODE.equals(entityType6)) {
                return "CREATE LOOKUP INDEX " + escapedName + " FOR (n) ON EACH labels(n)";
            }
            if (EntityType.RELATIONSHIP.equals(entityType6)) {
                return "CREATE LOOKUP INDEX " + escapedName + " FOR ()-[r]-() ON EACH type(r)";
            }
            throw new IllegalArgumentException("Did not recognize entity type " + entityType);
        }
        throw new IllegalArgumentException("Did not recognize index type " + indexType);
    }

    private String fullTextConfigValueAsString(Value configValue) {
        Value value = configValue;
        if (value instanceof BooleanValue) {
            BooleanValue booleanValue = (BooleanValue)value;
            return Boolean.toString(booleanValue.booleanValue());
        }
        if (value instanceof StringValue) {
            StringValue stringValue = (StringValue)value;
            return "'" + stringValue.stringValue() + "'";
        }
        throw new IllegalArgumentException("Could not convert config value '" + configValue + "' to config string.");
    }

    public ShowIndexesCommand apply(ShowIndexType indexType, boolean verbose, List<ShowColumn> columns) {
        return new ShowIndexesCommand(indexType, verbose, columns);
    }

    public Option<Tuple3<ShowIndexType, Object, List<ShowColumn>>> unapply(ShowIndexesCommand x$0) {
        if (x$0 == null) {
            return None$.MODULE$;
        }
        return new Some((Object)new Tuple3((Object)x$0.indexType(), (Object)BoxesRunTime.boxToBoolean((boolean)x$0.verbose()), x$0.columns()));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(ShowIndexesCommand$.class);
    }

    private static final String constraintCommand$1(String labelsOrTypesWithColons, String escapedNodeProperties, String predicate, String options, String escapedName$1) {
        return "CREATE CONSTRAINT " + escapedName$1 + " FOR (n" + labelsOrTypesWithColons + ") REQUIRE (" + escapedNodeProperties + ") " + predicate + " OPTIONS " + options;
    }

    private ShowIndexesCommand$() {
    }
}

