/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.runtime.interpreted.commands.expressions;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import org.neo4j.cypher.internal.runtime.CypherRow;
import org.neo4j.cypher.internal.runtime.Expander;
import org.neo4j.cypher.internal.runtime.KernelPredicate;
import org.neo4j.cypher.internal.runtime.ReadableRow;
import org.neo4j.cypher.internal.runtime.interpreted.commands.AllInList;
import org.neo4j.cypher.internal.runtime.interpreted.commands.AstNode;
import org.neo4j.cypher.internal.runtime.interpreted.commands.NoneInList;
import org.neo4j.cypher.internal.runtime.interpreted.commands.ShortestPath;
import org.neo4j.cypher.internal.runtime.interpreted.commands.SingleNode;
import org.neo4j.cypher.internal.runtime.interpreted.commands.expressions.Expanders$;
import org.neo4j.cypher.internal.runtime.interpreted.commands.expressions.Expression;
import org.neo4j.cypher.internal.runtime.interpreted.commands.expressions.ExtendedExpression;
import org.neo4j.cypher.internal.runtime.interpreted.commands.expressions.NodesFunction;
import org.neo4j.cypher.internal.runtime.interpreted.commands.expressions.RelationshipFunction;
import org.neo4j.cypher.internal.runtime.interpreted.commands.expressions.ShortestPathExpression$;
import org.neo4j.cypher.internal.runtime.interpreted.commands.expressions.TypeAndDirectionExpander;
import org.neo4j.cypher.internal.runtime.interpreted.commands.predicates.Ands;
import org.neo4j.cypher.internal.runtime.interpreted.commands.predicates.CoercedPredicate;
import org.neo4j.cypher.internal.runtime.interpreted.commands.predicates.Predicate;
import org.neo4j.cypher.internal.runtime.interpreted.pipes.QueryState;
import org.neo4j.cypher.internal.util.NonEmptyList;
import org.neo4j.cypher.internal.util.NonEmptyList$;
import org.neo4j.cypher.internal.util.attribution.Id;
import org.neo4j.exceptions.CypherTypeException;
import org.neo4j.exceptions.ShortestPathCommonEndNodesForbiddenException;
import org.neo4j.exceptions.SyntaxException;
import org.neo4j.graphdb.Entity;
import org.neo4j.graphdb.NotFoundException;
import org.neo4j.graphdb.Path;
import org.neo4j.graphdb.Relationship;
import org.neo4j.kernel.impl.util.ValueUtils;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.values.AnyValue;
import org.neo4j.values.VirtualValue;
import org.neo4j.values.storable.Values;
import org.neo4j.values.virtual.VirtualNodeValue;
import org.neo4j.values.virtual.VirtualPathValue;
import org.neo4j.values.virtual.VirtualValues;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.Tuple6;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Iterator;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\r}e\u0001\u0002\"D\u0001RC\u0001b\u001b\u0001\u0003\u0016\u0004%\t\u0001\u001c\u0005\tc\u0002\u0011\t\u0012)A\u0005[\"A!\u000f\u0001BK\u0002\u0013\u00051\u000f\u0003\u0005~\u0001\tE\t\u0015!\u0003u\u0011!q\bA!f\u0001\n\u0003\u0019\b\u0002C@\u0001\u0005#\u0005\u000b\u0011\u0002;\t\u0015\u0005\u0005\u0001A!f\u0001\n\u0003\t\u0019\u0001\u0003\u0006\u0002\f\u0001\u0011\t\u0012)A\u0005\u0003\u000bA!\"!\u0004\u0001\u0005+\u0007I\u0011AA\u0002\u0011)\ty\u0001\u0001B\tB\u0003%\u0011Q\u0001\u0005\u000b\u0003#\u0001!Q3A\u0005\u0002\u0005M\u0001BCA\u0013\u0001\tE\t\u0015!\u0003\u0002\u0016!9\u0011q\u0005\u0001\u0005\u0002\u0005%\u0002b\u0002>\u0001\u0005\u0004%\ta\u001d\u0005\b\u0003s\u0001\u0001\u0015!\u0003u\u0011\u001d\tY\u0004\u0001C\u0001\u0003{Aq!a\u000f\u0001\t\u0003\t9\u0007C\u0004\u0002~\u0001!I!a \t\u000f\u0005u\u0005\u0001\"\u0003\u0002 \"9\u0011\u0011\u001a\u0001\u0005\n\u0005-\u0007bBAm\u0001\u0011%\u00111\u001c\u0005\b\u0003?\u0004A\u0011IAq\u0011\u001d\u0011\u0019\u0001\u0001C!\u0005\u000bAqA!\u0003\u0001\t\u0003\u0012Y\u0001C\u0004\u0003\u0018\u0001!IA!\u0007\t\u000f\t\u0005\u0003\u0001\"\u0003\u0003D!9!\u0011\u000b\u0001\u0005\n\tM\u0003b\u0002B,\u0001\u0011%!\u0011\f\u0005\b\u0005g\u0002A\u0011\u0002B;\u0011\u001d\u0011y\t\u0001C\u0005\u0005#CqAa%\u0001\t\u0013\u0011)\nC\u0004\u0003 \u0002!IA!)\t\u000f\tU\u0006\u0001\"\u0003\u00038\"I!Q\u0018\u0001\u0002\u0002\u0013\u0005!q\u0018\u0005\n\u0005\u001b\u0004\u0011\u0013!C\u0001\u0005\u001fD\u0011B!9\u0001#\u0003%\tAa9\t\u0013\t\u001d\b!%A\u0005\u0002\t\r\b\"\u0003Bu\u0001E\u0005I\u0011\u0001Bv\u0011%\u0011y\u000fAI\u0001\n\u0003\u0011Y\u000fC\u0005\u0003r\u0002\t\n\u0011\"\u0001\u0003t\"I!q\u001f\u0001\u0002\u0002\u0013\u0005#\u0011 \u0005\n\u0007\u0017\u0001\u0011\u0011!C\u0001\u0007\u001bA\u0011ba\u0004\u0001\u0003\u0003%\ta!\u0005\t\u0013\r]\u0001!!A\u0005B\re\u0001\"CB\u0014\u0001\u0005\u0005I\u0011AB\u0015\u0011%\u0019i\u0003AA\u0001\n\u0003\u001ay\u0003C\u0005\u00044\u0001\t\t\u0011\"\u0011\u00046!I1q\u0007\u0001\u0002\u0002\u0013\u00053\u0011H\u0004\b\u0007{\u0019\u0005\u0012AB \r\u0019\u00115\t#\u0001\u0004B!9\u0011q\u0005\u001a\u0005\u0002\r5\u0003bBB(e\u0011\u00051\u0011\u000b\u0005\n\u0003w\u0011\u0014\u0011!CA\u0007GB\u0011b!\u001d3#\u0003%\tAa9\t\u0013\rM$'%A\u0005\u0002\t\r\b\"CB;eE\u0005I\u0011\u0001Bv\u0011%\u00199HMI\u0001\n\u0003\u0011Y\u000fC\u0005\u0004zI\n\n\u0011\"\u0001\u0003t\"I11\u0010\u001a\u0002\u0002\u0013\u00055Q\u0010\u0005\n\u0007\u0017\u0013\u0014\u0013!C\u0001\u0005GD\u0011b!$3#\u0003%\tAa9\t\u0013\r=%'%A\u0005\u0002\t-\b\"CBIeE\u0005I\u0011\u0001Bv\u0011%\u0019\u0019JMI\u0001\n\u0003\u0011\u0019\u0010C\u0005\u0004\u0016J\n\t\u0011\"\u0003\u0004\u0018\n12\u000b[8si\u0016\u001cH\u000fU1uQ\u0016C\bO]3tg&|gN\u0003\u0002E\u000b\u0006YQ\r\u001f9sKN\u001c\u0018n\u001c8t\u0015\t1u)\u0001\u0005d_6l\u0017M\u001c3t\u0015\tA\u0015*A\u0006j]R,'\u000f\u001d:fi\u0016$'B\u0001&L\u0003\u001d\u0011XO\u001c;j[\u0016T!\u0001T'\u0002\u0011%tG/\u001a:oC2T!AT(\u0002\r\rL\b\u000f[3s\u0015\t\u0001\u0016+A\u0003oK>$$NC\u0001S\u0003\ry'oZ\u0002\u0001'\u0011\u0001Q+W0\u0011\u0005Y;V\"A\"\n\u0005a\u001b%AC#yaJ,7o]5p]B\u0011!,X\u0007\u00027*\tA,A\u0003tG\u0006d\u0017-\u0003\u0002_7\n9\u0001K]8ek\u000e$\bC\u00011i\u001d\t\tgM\u0004\u0002cK6\t1M\u0003\u0002e'\u00061AH]8pizJ\u0011\u0001X\u0005\u0003On\u000bq\u0001]1dW\u0006<W-\u0003\u0002jU\na1+\u001a:jC2L'0\u00192mK*\u0011qmW\u0001\u0014g\"|'\u000f^3tiB\u000bG\u000f\u001b)biR,'O\\\u000b\u0002[B\u0011an\\\u0007\u0002\u000b&\u0011\u0001/\u0012\u0002\r'\"|'\u000f^3tiB\u000bG\u000f[\u0001\u0015g\"|'\u000f^3tiB\u000bG\u000f\u001b)biR,'O\u001c\u0011\u0002#A,'o\u0015;faB\u0013X\rZ5dCR,7/F\u0001u!\r\u0001Wo^\u0005\u0003m*\u00141aU3r!\tA80D\u0001z\u0015\tQX)\u0001\u0006qe\u0016$\u0017nY1uKNL!\u0001`=\u0003\u0013A\u0013X\rZ5dCR,\u0017A\u00059feN#X\r\u001d)sK\u0012L7-\u0019;fg\u0002\n!CZ;mYB\u000bG\u000f\u001b)sK\u0012L7-\u0019;fg\u0006\u0019b-\u001e7m!\u0006$\b\u000e\u0015:fI&\u001c\u0017\r^3tA\u0005aq/\u001b;i\r\u0006dGNQ1dWV\u0011\u0011Q\u0001\t\u00045\u0006\u001d\u0011bAA\u00057\n9!i\\8mK\u0006t\u0017!D<ji\"4\u0015\r\u001c7CC\u000e\\\u0007%\u0001\teSN\fG\u000e\\8x'\u0006lWMT8eK\u0006\tB-[:bY2|woU1nK:{G-\u001a\u0011\u0002\u0015=\u0004XM]1u_JLE-\u0006\u0002\u0002\u0016A!\u0011qCA\u0011\u001b\t\tIB\u0003\u0003\u0002\u001c\u0005u\u0011aC1uiJL'-\u001e;j_:T1!a\bL\u0003\u0011)H/\u001b7\n\t\u0005\r\u0012\u0011\u0004\u0002\u0003\u0013\u0012\f1b\u001c9fe\u0006$xN]%eA\u00051A(\u001b8jiz\"b\"a\u000b\u0002.\u0005=\u0012\u0011GA\u001a\u0003k\t9\u0004\u0005\u0002W\u0001!)1.\u0004a\u0001[\"9!/\u0004I\u0001\u0002\u0004!\bb\u0002@\u000e!\u0003\u0005\r\u0001\u001e\u0005\n\u0003\u0003i\u0001\u0013!a\u0001\u0003\u000bA\u0011\"!\u0004\u000e!\u0003\u0005\r!!\u0002\t\u0013\u0005EQ\u0002%AA\u0002\u0005U\u0011a\u00039sK\u0012L7-\u0019;fg\u0002\nQ!\u00199qYf$b!a\u0010\u0002L\u0005]\u0003\u0003BA!\u0003\u000fj!!a\u0011\u000b\u0007\u0005\u0015s*\u0001\u0004wC2,Xm]\u0005\u0005\u0003\u0013\n\u0019E\u0001\u0005B]f4\u0016\r\\;f\u0011\u001d\ti\u0005\u0005a\u0001\u0003\u001f\n1A]8x!\u0011\t\t&a\u0015\u000e\u0003%K1!!\u0016J\u0005-\u0011V-\u00193bE2,'k\\<\t\u000f\u0005e\u0003\u00031\u0001\u0002\\\u0005)1\u000f^1uKB!\u0011QLA2\u001b\t\tyFC\u0002\u0002b\u001d\u000bQ\u0001]5qKNLA!!\u001a\u0002`\tQ\u0011+^3ssN#\u0018\r^3\u0015\u0011\u0005}\u0012\u0011NA6\u0003[Bq!!\u0014\u0012\u0001\u0004\ty\u0005C\u0004\u0002ZE\u0001\r!a\u0017\t\u000f\u0005=\u0014\u00031\u0001\u0002r\u0005iQ.Z7pef$&/Y2lKJ\u0004B!a\u001d\u0002z5\u0011\u0011Q\u000f\u0006\u0004\u0003oz\u0015AB7f[>\u0014\u00180\u0003\u0003\u0002|\u0005U$!D'f[>\u0014\u0018\u0010\u0016:bG.,'/\u0001\u0006hKRl\u0015\r^2iKN$B\"a\u0010\u0002\u0002\u0006\u0015\u0015QSAM\u00037Cq!a!\u0013\u0001\u0004\ty%A\u0002dibDq!a\"\u0013\u0001\u0004\tI)A\u0003ti\u0006\u0014H\u000f\u0005\u0003\u0002\f\u0006EUBAAG\u0015\u0011\ty)a\u0011\u0002\u000fYL'\u000f^;bY&!\u00111SAG\u0005A1\u0016N\u001d;vC2tu\u000eZ3WC2,X\rC\u0004\u0002\u0018J\u0001\r!!#\u0002\u0007\u0015tG\rC\u0004\u0002ZI\u0001\r!a\u0017\t\u000f\u0005=$\u00031\u0001\u0002r\u0005Y2M]3bi\u0016\u001c\u0006n\u001c:uKN$\b+\u0019;i!J,G-[2bi\u0016$\u0002\"!)\u00024\u0006u\u0016q\u0019\t\u0007\u0003#\n\u0019+a*\n\u0007\u0005\u0015\u0016JA\bLKJtW\r\u001c)sK\u0012L7-\u0019;f!\u0011\tI+a,\u000e\u0005\u0005-&bAAW\u001f\u00069qM]1qQ\u0012\u0014\u0017\u0002BAY\u0003W\u0013A\u0001U1uQ\"9\u0011QW\nA\u0002\u0005]\u0016aC5oG>l\u0017N\\4Dib\u0004B!!\u0015\u0002:&\u0019\u00111X%\u0003\u0013\rK\b\u000f[3s%><\bbBA`'\u0001\u0007\u0011\u0011Y\u0001\u000f[\u0006L(-\u001a)sK\u0012L7-\u0019;f!\u0011Q\u00161Y<\n\u0007\u0005\u00157L\u0001\u0004PaRLwN\u001c\u0005\b\u00033\u001a\u0002\u0019AA.\u0003-9W\r^#oIB{\u0017N\u001c;\u0015\u0011\u0005%\u0015QZAh\u0003#Dq!a!\u0015\u0001\u0004\ty\u0005C\u0004\u0002ZQ\u0001\r!a\u0017\t\u000f\u0005\u001dE\u00031\u0001\u0002TB\u0019a.!6\n\u0007\u0005]WI\u0001\u0006TS:<G.\u001a(pI\u0016\f\u0011$\u00198z'R\f'\u000f\u001e9pS:$8oQ8oi\u0006LgNT;mYR!\u0011QAAo\u0011\u001d\t\u0019)\u0006a\u0001\u0003\u001f\n\u0001b\u00195jY\u0012\u0014XM\\\u000b\u0003\u0003G\u0004B\u0001Y;\u0002fB\"\u0011q]Ay!\u0015q\u0017\u0011^Aw\u0013\r\tY/\u0012\u0002\b\u0003N$hj\u001c3f!\u0011\ty/!=\r\u0001\u0011Y\u00111\u001f\f\u0002\u0002\u0003\u0005)\u0011AA{\u0005\ryF%M\t\u0005\u0003o\fi\u0010E\u0002[\u0003sL1!a?\\\u0005\u001dqu\u000e\u001e5j]\u001e\u00042AWA\u0000\u0013\r\u0011\ta\u0017\u0002\u0004\u0003:L\u0018!C1sOVlWM\u001c;t+\t\u00119\u0001E\u0002akV\u000bqA]3xe&$X\rF\u0002V\u0005\u001bAqAa\u0004\u0019\u0001\u0004\u0011\t\"A\u0001g!\u0015Q&1C+V\u0013\r\u0011)b\u0017\u0002\n\rVt7\r^5p]F\n!eY=qQ\u0016\u0014\bk\\:ji&4X\r\u0015:fI&\u001c\u0017\r^3t\u0003N,\u0005\u0010]1oI\u0016\u0014HC\u0003B\u000e\u0005_\u0011\tDa\u000f\u0003@I1!Q\u0004B\u0011\u0005O1aAa\b\u001a\u0001\tm!\u0001\u0004\u001fsK\u001aLg.Z7f]Rt\u0004c\u0001.\u0003$%\u0019!QE.\u0003\r\u0005s\u0017PU3g!\u0019\t\t&a)\u0003*A!\u0011\u0011\u0016B\u0016\u0013\u0011\u0011i#a+\u0003\r\u0015sG/\u001b;z\u0011\u001d\t),\u0007a\u0001\u0003\u001fBqAa\r\u001a\u0001\u0004\u0011)$\u0001\bwCJL\u0017M\u00197f\u001f\u001a47/\u001a;\u0011\u0007i\u00139$C\u0002\u0003:m\u00131!\u00138u\u0011\u0019\u0011i$\u0007a\u0001o\u0006I\u0001O]3eS\u000e\fG/\u001a\u0005\b\u00033J\u0002\u0019AA.\u0003\t\u001a\u0017\u0010\u001d5fe:+w-\u0019;jm\u0016\u0004&/\u001a3jG\u0006$Xm]!t\u000bb\u0004\u0018M\u001c3feRQ!Q\tB%\u0005\u0017\u0012iEa\u0014\u0013\r\t\u001d#\u0011\u0005B\u0014\r\u0019\u0011yB\u0007\u0001\u0003F!9\u0011Q\u0017\u000eA\u0002\u0005=\u0003b\u0002B\u001a5\u0001\u0007!Q\u0007\u0005\u0007\u0005{Q\u0002\u0019A<\t\u000f\u0005e#\u00041\u0001\u0002\\\u0005ia-\u001b8e!J,G-[2bi\u0016$2!\u0016B+\u0011\u0019\u0011id\u0007a\u0001o\u0006\u0001\u0013\r\u001a3BY2|%OT8oKJ+G.\u0019;j_:\u001c\b.\u001b9FqB\fg\u000eZ3s)9\u0011YF!\u0019\u0003d\t\u001d$1\u000eB7\u0005c\u0002B!!\u0015\u0003^%\u0019!qL%\u0003\u0011\u0015C\b/\u00198eKJDq!a!\u001d\u0001\u0004\ty\u0005C\u0004\u0003fq\u0001\rAa\u0017\u0002\u001f\r,(O]3oi\u0016C\b/\u00198eKJDqA!\u001b\u001d\u0001\u0004\t)!A\u0002bY2DaA!\u0010\u001d\u0001\u00049\bb\u0002B89\u0001\u0007!QG\u0001\u0012e\u0016dg+\u0019:jC\ndWm\u00144gg\u0016$\bbBA-9\u0001\u0007\u00111L\u0001\u0019C\u0012$\u0017\t\u001c7Pe:{g.\u001a(pI\u0016,\u0005\u0010]1oI\u0016\u0014H\u0003\u0005B<\u0005\u007f\u0012\tIa!\u0003\u0006\n\u001d%\u0011\u0012BG!\u001dQ&\u0011\u0010B.\u0005{J1Aa\u001f\\\u0005\u0019!V\u000f\u001d7feA!\u0001-\u001eB\u0014\u0011\u001d\t\u0019)\ba\u0001\u0003\u001fBqA!\u001a\u001e\u0001\u0004\u0011Y\u0006C\u0004\u0003ju\u0001\r!!\u0002\t\r\tuR\u00041\u0001x\u0011\u001d\u0011y'\ba\u0001\u0005kAqAa#\u001e\u0001\u0004\u0011i(A\u000bdkJ\u0014XM\u001c;O_\u0012,\u0007K]3eS\u000e\fG/Z:\t\u000f\u0005eS\u00041\u0001\u0002\\\u0005aR.Y6f%\u0016d\u0017\r^5p]ND\u0017\u000e\u001d+za\u0016,\u0005\u0010]1oI\u0016\u0014HC\u0001B.\u00035\tG\r\u001a)sK\u0012L7-\u0019;fgRA!q\u000fBL\u00053\u0013i\nC\u0004\u0002\u0004~\u0001\r!a\u0014\t\u000f\tmu\u00041\u0001\u0003\\\u0005)\"/\u001a7UsB,\u0017I\u001c3ESJ,\u0005\u0010]1oI\u0016\u0014\bbBA-?\u0001\u0007\u00111L\u0001\u0010SNtu\u000eZ3t\rVt7\r^5p]R!\u0011Q\u0001BR\u0011\u0019\u0011)\u000b\ta\u0001+\u0006QQ\r\u001f9sKN\u001c\u0018n\u001c8)\u0007\u0001\u0012I\u000b\u0005\u0003\u0003,\nEVB\u0001BW\u0015\r\u0011ykW\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002\u0002BZ\u0005[\u0013q\u0001^1jYJ,7-A\fjgJ+G.\u0019;j_:\u001c\b.\u001b9t\rVt7\r^5p]R!\u0011Q\u0001B]\u0011\u0019\u0011)+\ta\u0001+\"\u001a\u0011E!+\u0002\t\r|\u0007/\u001f\u000b\u000f\u0003W\u0011\tMa1\u0003F\n\u001d'\u0011\u001aBf\u0011\u001dY'\u0005%AA\u00025DqA\u001d\u0012\u0011\u0002\u0003\u0007A\u000fC\u0004\u007fEA\u0005\t\u0019\u0001;\t\u0013\u0005\u0005!\u0005%AA\u0002\u0005\u0015\u0001\"CA\u0007EA\u0005\t\u0019AA\u0003\u0011%\t\tB\tI\u0001\u0002\u0004\t)\"\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\tE'fA7\u0003T.\u0012!Q\u001b\t\u0005\u0005/\u0014i.\u0004\u0002\u0003Z*!!1\u001cBW\u0003%)hn\u00195fG.,G-\u0003\u0003\u0003`\ne'!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\u0012TC\u0001BsU\r!(1[\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00134\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIQ*\"A!<+\t\u0005\u0015!1[\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00136\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIY*\"A!>+\t\u0005U!1[\u0001\u000eaJ|G-^2u!J,g-\u001b=\u0016\u0005\tm\b\u0003\u0002B\u007f\u0007\u000fi!Aa@\u000b\t\r\u000511A\u0001\u0005Y\u0006twM\u0003\u0002\u0004\u0006\u0005!!.\u0019<b\u0013\u0011\u0019IAa@\u0003\rM#(/\u001b8h\u00031\u0001(o\u001c3vGR\f%/\u001b;z+\t\u0011)$\u0001\bqe>$Wo\u0019;FY\u0016lWM\u001c;\u0015\t\u0005u81\u0003\u0005\n\u0007+Y\u0013\u0011!a\u0001\u0005k\t1\u0001\u001f\u00132\u0003=\u0001(o\u001c3vGRLE/\u001a:bi>\u0014XCAB\u000e!\u0019\u0019iba\t\u0002~6\u00111q\u0004\u0006\u0004\u0007CY\u0016AC2pY2,7\r^5p]&!1QEB\u0010\u0005!IE/\u001a:bi>\u0014\u0018\u0001C2b]\u0016\u000bX/\u00197\u0015\t\u0005\u001511\u0006\u0005\n\u0007+i\u0013\u0011!a\u0001\u0003{\f!\u0003\u001d:pIV\u001cG/\u00127f[\u0016tGOT1nKR!!1`B\u0019\u0011%\u0019)BLA\u0001\u0002\u0004\u0011)$\u0001\u0005iCND7i\u001c3f)\t\u0011)$\u0001\u0004fcV\fGn\u001d\u000b\u0005\u0003\u000b\u0019Y\u0004C\u0005\u0004\u0016A\n\t\u00111\u0001\u0002~\u000612\u000b[8si\u0016\u001cH\u000fU1uQ\u0016C\bO]3tg&|g\u000e\u0005\u0002WeM)!G!\t\u0004DA!1QIB&\u001b\t\u00199E\u0003\u0003\u0004J\r\r\u0011AA5p\u0013\rI7q\t\u000b\u0003\u0007\u007f\tAB\\8EkBd\u0017nY1uKN$B!!\u0002\u0004T!91Q\u000b\u001bA\u0002\r]\u0013!\u0004:fY\u0006$\u0018n\u001c8tQ&\u00048\u000fE\u0003a\u00073\u001ai&C\u0002\u0004\\)\u0014\u0001\"\u0013;fe\u0006\u0014G.\u001a\t\u0005\u0003S\u001by&\u0003\u0003\u0004b\u0005-&\u0001\u0004*fY\u0006$\u0018n\u001c8tQ&\u0004HCDA\u0016\u0007K\u001a9g!\u001b\u0004l\r54q\u000e\u0005\u0006WV\u0002\r!\u001c\u0005\beV\u0002\n\u00111\u0001u\u0011\u001dqX\u0007%AA\u0002QD\u0011\"!\u00016!\u0003\u0005\r!!\u0002\t\u0013\u00055Q\u0007%AA\u0002\u0005\u0015\u0001\"CA\tkA\u0005\t\u0019AA\u000b\u0003=\t\u0007\u000f\u001d7zI\u0011,g-Y;mi\u0012\u0012\u0014aD1qa2LH\u0005Z3gCVdG\u000fJ\u001a\u0002\u001f\u0005\u0004\b\u000f\\=%I\u00164\u0017-\u001e7uIQ\nq\"\u00199qYf$C-\u001a4bk2$H%N\u0001\u0010CB\u0004H.\u001f\u0013eK\u001a\fW\u000f\u001c;%m\u00059QO\\1qa2LH\u0003BB@\u0007\u000f\u0003RAWAb\u0007\u0003\u0003BBWBB[R$\u0018QAA\u0003\u0003+I1a!\"\\\u0005\u0019!V\u000f\u001d7fm!I1\u0011R\u001e\u0002\u0002\u0003\u0007\u00111F\u0001\u0004q\u0012\u0002\u0014a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$#'A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$HeM\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000f\n\u001b\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00136\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%m\u0005aqO]5uKJ+\u0007\u000f\\1dKR\u00111\u0011\u0014\t\u0005\u0005{\u001cY*\u0003\u0003\u0004\u001e\n}(AB(cU\u0016\u001cG\u000f")
public class ShortestPathExpression
extends Expression
implements Product,
Serializable {
    private final ShortestPath shortestPathPattern;
    private final Seq<Predicate> perStepPredicates;
    private final Seq<Predicate> fullPathPredicates;
    private final boolean withFallBack;
    private final boolean disallowSameNode;
    private final int operatorId;
    private final Seq<Predicate> predicates;

    public static int $lessinit$greater$default$6() {
        return ShortestPathExpression$.MODULE$.$lessinit$greater$default$6();
    }

    public static boolean $lessinit$greater$default$5() {
        return ShortestPathExpression$.MODULE$.$lessinit$greater$default$5();
    }

    public static boolean $lessinit$greater$default$4() {
        return ShortestPathExpression$.MODULE$.$lessinit$greater$default$4();
    }

    public static Seq<Predicate> $lessinit$greater$default$3() {
        return ShortestPathExpression$.MODULE$.$lessinit$greater$default$3();
    }

    public static Seq<Predicate> $lessinit$greater$default$2() {
        return ShortestPathExpression$.MODULE$.$lessinit$greater$default$2();
    }

    public static Option<Tuple6<ShortestPath, Seq<Predicate>, Seq<Predicate>, Object, Object, Id>> unapply(ShortestPathExpression x$0) {
        return ShortestPathExpression$.MODULE$.unapply(x$0);
    }

    public static int apply$default$6() {
        return ShortestPathExpression$.MODULE$.apply$default$6();
    }

    public static boolean apply$default$5() {
        return ShortestPathExpression$.MODULE$.apply$default$5();
    }

    public static boolean apply$default$4() {
        return ShortestPathExpression$.MODULE$.apply$default$4();
    }

    public static Seq<Predicate> apply$default$3() {
        return ShortestPathExpression$.MODULE$.apply$default$3();
    }

    public static Seq<Predicate> apply$default$2() {
        return ShortestPathExpression$.MODULE$.apply$default$2();
    }

    public static boolean noDuplicates(Iterable<Relationship> relationships) {
        return ShortestPathExpression$.MODULE$.noDuplicates(relationships);
    }

    public Iterator<String> productElementNames() {
        return Product.productElementNames$((Product)this);
    }

    public ShortestPath shortestPathPattern() {
        return this.shortestPathPattern;
    }

    public Seq<Predicate> perStepPredicates() {
        return this.perStepPredicates;
    }

    public Seq<Predicate> fullPathPredicates() {
        return this.fullPathPredicates;
    }

    public boolean withFallBack() {
        return this.withFallBack;
    }

    public boolean disallowSameNode() {
        return this.disallowSameNode;
    }

    public int operatorId() {
        return this.operatorId;
    }

    public Seq<Predicate> predicates() {
        return this.predicates;
    }

    @Override
    public AnyValue apply(ReadableRow row, QueryState state) {
        return this.apply(row, state, state.memoryTrackerForOperatorProvider().memoryTrackerForOperator(this.operatorId()));
    }

    public AnyValue apply(ReadableRow row, QueryState state, MemoryTracker memoryTracker) {
        if (this.anyStartpointsContainNull(row)) {
            return Values.NO_VALUE;
        }
        VirtualNodeValue start = this.getEndPoint(row, state, this.shortestPathPattern().left());
        VirtualNodeValue end = this.getEndPoint(row, state, this.shortestPathPattern().right());
        if (!this.shortestPathPattern().allowZeroLength() && this.disallowSameNode() && start.equals((VirtualValue)end)) {
            throw new ShortestPathCommonEndNodesForbiddenException();
        }
        return this.getMatches(row, start, end, state, memoryTracker);
    }

    private AnyValue getMatches(ReadableRow ctx, VirtualNodeValue start, VirtualNodeValue end, QueryState state, MemoryTracker memoryTracker) {
        Tuple2<Expander, Seq<KernelPredicate<Entity>>> tuple2 = this.addPredicates(ctx, this.makeRelationshipTypeExpander(), state);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Expander expander = (Expander)tuple2._1();
        Seq nodePredicates = (Seq)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)expander, (Object)nodePredicates);
        Expander expander2 = (Expander)tuple22._1();
        Seq nodePredicates2 = (Seq)tuple22._2();
        None$ maybePredicate = this.predicates().isEmpty() ? None$.MODULE$ : new Some((Object)new Ands((NonEmptyList<Predicate>)NonEmptyList$.MODULE$.from(this.predicates())));
        CypherRow cypherRow = (CypherRow)ctx;
        KernelPredicate<Path> shortestPathPredicate = this.createShortestPathPredicate(cypherRow, (Option<Predicate>)maybePredicate, state);
        if (this.shortestPathPattern().single()) {
            Option result = state.query().singleShortestPath(start.id(), end.id(), BoxesRunTime.unboxToInt((Object)this.shortestPathPattern().maxDepth().getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> Integer.MAX_VALUE)), expander2, shortestPathPredicate, nodePredicates2, memoryTracker);
            if (!this.shortestPathPattern().allowZeroLength() && result.forall((Function1 & Serializable)p -> BoxesRunTime.boxToBoolean((boolean)ShortestPathExpression.$anonfun$getMatches$2(p)))) {
                return Values.NO_VALUE;
            }
            return (AnyValue)result.map((Function1 & Serializable)x$1 -> ValueUtils.fromPath((Path)x$1)).getOrElse((Function0 & Serializable)() -> Values.NO_VALUE);
        }
        VirtualPathValue[] result = (VirtualPathValue[])state.query().allShortestPath(start.id(), end.id(), BoxesRunTime.unboxToInt((Object)this.shortestPathPattern().maxDepth().getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> Integer.MAX_VALUE)), expander2, shortestPathPredicate, nodePredicates2, memoryTracker).filter((Function1 & Serializable)p -> BoxesRunTime.boxToBoolean((boolean)ShortestPathExpression.$anonfun$getMatches$6(this, p))).map((Function1 & Serializable)x$1 -> ValueUtils.fromPath((Path)x$1)).toArray(ClassTag$.MODULE$.apply(VirtualPathValue.class));
        return VirtualValues.list((AnyValue[])((AnyValue[])result));
    }

    private KernelPredicate<Path> createShortestPathPredicate(CypherRow incomingCtx, Option<Predicate> maybePredicate, QueryState state) {
        return new KernelPredicate<Path>(this, maybePredicate, incomingCtx, state){
            private final /* synthetic */ ShortestPathExpression $outer;
            private final Option maybePredicate$1;
            private final CypherRow incomingCtx$1;
            private final QueryState state$1;

            public boolean test(Path path) {
                return this.maybePredicate$1.forall((Function1 & Serializable)predicate -> BoxesRunTime.boxToBoolean((boolean)$anon$1.$anonfun$test$1(this, path, predicate))) && (!this.$outer.withFallBack() || ShortestPathExpression$.MODULE$.noDuplicates((Iterable<Relationship>)CollectionConverters$.MODULE$.IterableHasAsScala(path.relationships()).asScala()));
            }

            public static final /* synthetic */ boolean $anonfun$test$1($anon$1 $this, Path path$1, Predicate predicate) {
                $this.incomingCtx$1.set($this.$outer.shortestPathPattern().pathName(), (AnyValue)ValueUtils.fromPath((Path)path$1));
                $this.incomingCtx$1.set((String)$this.$outer.shortestPathPattern().relIterator().get(), (AnyValue)ValueUtils.asListOfEdges((java.lang.Iterable)path$1.relationships()));
                return predicate.isTrue((ReadableRow)$this.incomingCtx$1, $this.state$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.maybePredicate$1 = maybePredicate$1;
                this.incomingCtx$1 = incomingCtx$1;
                this.state$1 = state$1;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$test$1$adapted(org.neo4j.cypher.internal.runtime.interpreted.commands.expressions.ShortestPathExpression$$anon$1 org.neo4j.graphdb.Path org.neo4j.cypher.internal.runtime.interpreted.commands.predicates.Predicate )}, serializedLambda);
            }
        };
    }

    private VirtualNodeValue getEndPoint(ReadableRow ctx, QueryState state, SingleNode start) {
        VirtualNodeValue virtualNodeValue;
        try {
            VirtualNodeValue virtualNodeValue2;
            AnyValue anyValue = ctx.getByName(start.name());
            if (!(anyValue instanceof VirtualNodeValue)) {
                throw new CypherTypeException(start.name() + " is not a node");
            }
            virtualNodeValue = virtualNodeValue2 = (VirtualNodeValue)anyValue;
        }
        catch (NotFoundException notFoundException) {
            throw new SyntaxException("To find a shortest path, both ends of the path need to be provided. Couldn't find `" + start + "`");
        }
        return virtualNodeValue;
    }

    private boolean anyStartpointsContainNull(ReadableRow ctx) {
        return ctx.getByName(this.shortestPathPattern().left().name()) == Values.NO_VALUE || ctx.getByName(this.shortestPathPattern().right().name()) == Values.NO_VALUE;
    }

    @Override
    public Seq<AstNode<?>> children() {
        return (Seq)((IterableOps)new .colon.colon((Object)this.shortestPathPattern(), (List)Nil$.MODULE$).$plus$plus(this.perStepPredicates())).$plus$plus(this.fullPathPredicates());
    }

    public Seq<Expression> arguments() {
        return (Seq)package$.MODULE$.Seq().empty();
    }

    @Override
    public Expression rewrite(Function1<Expression, Expression> f) {
        Object x$1 = this.shortestPathPattern().rewrite((Function1)f);
        int x$2 = this.operatorId();
        Seq<Predicate> x$3 = ShortestPathExpression$.MODULE$.apply$default$2();
        Seq<Predicate> x$4 = ShortestPathExpression$.MODULE$.apply$default$3();
        boolean x$5 = ShortestPathExpression$.MODULE$.apply$default$4();
        boolean x$6 = ShortestPathExpression$.MODULE$.apply$default$5();
        return (Expression)f.apply((Object)new ShortestPathExpression((ShortestPath)x$1, x$3, x$4, x$5, x$6, x$2));
    }

    private KernelPredicate<Entity> cypherPositivePredicatesAsExpander(ReadableRow incomingCtx, int variableOffset, Predicate predicate, QueryState state) {
        return new KernelPredicate<Entity>(null, state, variableOffset, predicate, incomingCtx){
            private final QueryState state$2;
            private final int variableOffset$1;
            private final Predicate predicate$1;
            private final ReadableRow incomingCtx$2;

            public boolean test(Entity t) {
                this.state$2.expressionVariables()[this.variableOffset$1] = ValueUtils.asNodeOrEdgeValue((Entity)t);
                return this.predicate$1.isTrue(this.incomingCtx$2, this.state$2);
            }
            {
                this.state$2 = state$2;
                this.variableOffset$1 = variableOffset$1;
                this.predicate$1 = predicate$1;
                this.incomingCtx$2 = incomingCtx$2;
            }
        };
    }

    private KernelPredicate<Entity> cypherNegativePredicatesAsExpander(ReadableRow incomingCtx, int variableOffset, Predicate predicate, QueryState state) {
        return new KernelPredicate<Entity>(null, state, variableOffset, predicate, incomingCtx){
            private final QueryState state$3;
            private final int variableOffset$2;
            private final Predicate predicate$2;
            private final ReadableRow incomingCtx$3;

            public boolean test(Entity t) {
                this.state$3.expressionVariables()[this.variableOffset$2] = ValueUtils.asNodeOrEdgeValue((Entity)t);
                return !this.predicate$2.isTrue(this.incomingCtx$3, this.state$3);
            }
            {
                this.state$3 = state$3;
                this.variableOffset$2 = variableOffset$2;
                this.predicate$2 = predicate$2;
                this.incomingCtx$3 = incomingCtx$3;
            }
        };
    }

    private Expression findPredicate(Predicate predicate) {
        CoercedPredicate coercedPredicate;
        Expression inner;
        Predicate predicate2 = predicate;
        if (predicate2 instanceof CoercedPredicate && (inner = (coercedPredicate = (CoercedPredicate)predicate2).inner()) instanceof ExtendedExpression) {
            ExtendedExpression extendedExpression = (ExtendedExpression)((Object)inner);
            return extendedExpression.legacy();
        }
        return predicate;
    }

    private Expander addAllOrNoneRelationshipExpander(ReadableRow ctx, Expander currentExpander, boolean all, Predicate predicate, int relVariableOffset, QueryState state) {
        return currentExpander.addRelationshipFilter(all ? this.cypherPositivePredicatesAsExpander(ctx, relVariableOffset, predicate, state) : this.cypherNegativePredicatesAsExpander(ctx, relVariableOffset, predicate, state));
    }

    private Tuple2<Expander, Seq<KernelPredicate<Entity>>> addAllOrNoneNodeExpander(ReadableRow ctx, Expander currentExpander, boolean all, Predicate predicate, int relVariableOffset, Seq<KernelPredicate<Entity>> currentNodePredicates, QueryState state) {
        KernelPredicate<Entity> filter = all ? this.cypherPositivePredicatesAsExpander(ctx, relVariableOffset, predicate, state) : this.cypherNegativePredicatesAsExpander(ctx, relVariableOffset, predicate, state);
        return new Tuple2((Object)currentExpander.addNodeFilter(filter), currentNodePredicates.$colon$plus(filter));
    }

    private Expander makeRelationshipTypeExpander() {
        if (this.shortestPathPattern().relTypes().isEmpty()) {
            return Expanders$.MODULE$.allTypes(this.shortestPathPattern().dir());
        }
        return (Expander)this.shortestPathPattern().relTypes().foldLeft((Object)Expanders$.MODULE$.typeDir(), (Function2 & Serializable)(x0$1, x1$1) -> {
            Tuple2 tuple2 = new Tuple2(x0$1, x1$1);
            if (tuple2 != null) {
                TypeAndDirectionExpander e = (TypeAndDirectionExpander)tuple2._1();
                String t = (String)tuple2._2();
                return e.add(t, this.shortestPathPattern().dir());
            }
            throw new MatchError((Object)tuple2);
        });
    }

    private Tuple2<Expander, Seq<KernelPredicate<Entity>>> addPredicates(ReadableRow ctx, Expander relTypeAndDirExpander, QueryState state) {
        if (this.perStepPredicates().isEmpty()) {
            return new Tuple2((Object)relTypeAndDirExpander, (Object)Nil$.MODULE$);
        }
        return (Tuple2)((IterableOnceOps)this.perStepPredicates().map((Function1 & Serializable)predicate -> this.findPredicate((Predicate)predicate))).foldLeft((Object)new Tuple2((Object)relTypeAndDirExpander, (Object)Nil$.MODULE$), (Function2 & Serializable)(x0$1, x1$1) -> {
            Tuple2 tuple2 = new Tuple2(x0$1, x1$1);
            if (tuple2 != null) {
                Tuple2 tuple22 = (Tuple2)tuple2._1();
                Expression predicate = (Expression)tuple2._2();
                if (tuple22 != null) {
                    Expander currentExpander = (Expander)tuple22._1();
                    Seq currentNodePredicates = (Seq)tuple22._2();
                    if (currentNodePredicates != null) {
                        Seq seq = currentNodePredicates;
                        boolean bl = false;
                        NoneInList noneInList = null;
                        boolean bl2 = false;
                        AllInList allInList = null;
                        Expression expression = predicate;
                        if (expression instanceof NoneInList) {
                            bl = true;
                            noneInList = (NoneInList)expression;
                            Expression relFunction = noneInList.collection();
                            int variableOffset = noneInList.innerVariableOffset();
                            Predicate innerPredicate = noneInList.inner();
                            if (this.isRelationshipsFunction(relFunction)) {
                                Expander expander = this.addAllOrNoneRelationshipExpander(ctx, currentExpander, false, innerPredicate, variableOffset, state);
                                return new Tuple2((Object)expander, (Object)seq);
                            }
                        }
                        if (expression instanceof AllInList) {
                            bl2 = true;
                            allInList = (AllInList)expression;
                            Expression relFunction = allInList.collection();
                            int variableOffset = allInList.innerVariableOffset();
                            Predicate innerPredicate = allInList.inner();
                            if (this.isRelationshipsFunction(relFunction)) {
                                Expander expander = this.addAllOrNoneRelationshipExpander(ctx, currentExpander, true, innerPredicate, variableOffset, state);
                                return new Tuple2((Object)expander, (Object)seq);
                            }
                        }
                        if (bl) {
                            Expression nodeFunction = noneInList.collection();
                            int variableOffset = noneInList.innerVariableOffset();
                            Predicate innerPredicate = noneInList.inner();
                            if (this.isNodesFunction(nodeFunction)) {
                                return this.addAllOrNoneNodeExpander(ctx, currentExpander, false, innerPredicate, variableOffset, (Seq<KernelPredicate<Entity>>)seq, state);
                            }
                        }
                        if (bl2) {
                            Expression nodeFunction = allInList.collection();
                            int variableOffset = allInList.innerVariableOffset();
                            Predicate innerPredicate = allInList.inner();
                            if (this.isNodesFunction(nodeFunction)) {
                                return this.addAllOrNoneNodeExpander(ctx, currentExpander, true, innerPredicate, variableOffset, (Seq<KernelPredicate<Entity>>)seq, state);
                            }
                        }
                        return new Tuple2((Object)currentExpander, (Object)seq);
                    }
                }
            }
            throw new MatchError((Object)tuple2);
        });
    }

    private boolean isNodesFunction(Expression expression) {
        while (true) {
            Expression expression2;
            if ((expression2 = expression) instanceof NodesFunction) {
                return true;
            }
            if (!(expression2 instanceof ExtendedExpression)) break;
            ExtendedExpression extendedExpression = (ExtendedExpression)((Object)expression2);
            expression = extendedExpression.legacy();
        }
        return false;
    }

    private boolean isRelationshipsFunction(Expression expression) {
        while (true) {
            Expression expression2;
            if ((expression2 = expression) instanceof RelationshipFunction) {
                return true;
            }
            if (!(expression2 instanceof ExtendedExpression)) break;
            ExtendedExpression extendedExpression = (ExtendedExpression)((Object)expression2);
            expression = extendedExpression.legacy();
        }
        return false;
    }

    public ShortestPathExpression copy(ShortestPath shortestPathPattern, Seq<Predicate> perStepPredicates, Seq<Predicate> fullPathPredicates, boolean withFallBack, boolean disallowSameNode, int operatorId) {
        return new ShortestPathExpression(shortestPathPattern, perStepPredicates, fullPathPredicates, withFallBack, disallowSameNode, operatorId);
    }

    public ShortestPath copy$default$1() {
        return this.shortestPathPattern();
    }

    public Seq<Predicate> copy$default$2() {
        return this.perStepPredicates();
    }

    public Seq<Predicate> copy$default$3() {
        return this.fullPathPredicates();
    }

    public boolean copy$default$4() {
        return this.withFallBack();
    }

    public boolean copy$default$5() {
        return this.disallowSameNode();
    }

    public int copy$default$6() {
        return this.operatorId();
    }

    public String productPrefix() {
        return "ShortestPathExpression";
    }

    public int productArity() {
        return 6;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.shortestPathPattern();
            }
            case 1: {
                return this.perStepPredicates();
            }
            case 2: {
                return this.fullPathPredicates();
            }
            case 3: {
                return BoxesRunTime.boxToBoolean((boolean)this.withFallBack());
            }
            case 4: {
                return BoxesRunTime.boxToBoolean((boolean)this.disallowSameNode());
            }
            case 5: {
                return new Id(this.operatorId());
            }
        }
        return Statics.ioobe((int)x$1);
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof ShortestPathExpression;
    }

    public String productElementName(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return "shortestPathPattern";
            }
            case 1: {
                return "perStepPredicates";
            }
            case 2: {
                return "fullPathPredicates";
            }
            case 3: {
                return "withFallBack";
            }
            case 4: {
                return "disallowSameNode";
            }
            case 5: {
                return "operatorId";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    public int hashCode() {
        int n = -889275714;
        n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
        n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.shortestPathPattern()));
        n = Statics.mix((int)n, (int)Statics.anyHash(this.perStepPredicates()));
        n = Statics.mix((int)n, (int)Statics.anyHash(this.fullPathPredicates()));
        n = Statics.mix((int)n, (int)(this.withFallBack() ? 1231 : 1237));
        n = Statics.mix((int)n, (int)(this.disallowSameNode() ? 1231 : 1237));
        n = Statics.mix((int)n, (int)Statics.anyHash((Object)new Id(this.operatorId())));
        return Statics.finalizeHash((int)n, (int)6);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof ShortestPathExpression)) return false;
        boolean bl = true;
        if (!bl) return false;
        ShortestPathExpression shortestPathExpression = (ShortestPathExpression)x$1;
        if (this.withFallBack() != shortestPathExpression.withFallBack()) return false;
        if (this.disallowSameNode() != shortestPathExpression.disallowSameNode()) return false;
        ShortestPath shortestPath = this.shortestPathPattern();
        ShortestPath shortestPath2 = shortestPathExpression.shortestPathPattern();
        if (shortestPath == null) {
            if (shortestPath2 != null) {
                return false;
            }
        } else if (!((Object)shortestPath).equals(shortestPath2)) return false;
        Seq<Predicate> seq = this.perStepPredicates();
        Seq<Predicate> seq2 = shortestPathExpression.perStepPredicates();
        if (seq == null) {
            if (seq2 != null) {
                return false;
            }
        } else if (!seq.equals(seq2)) return false;
        Seq<Predicate> seq3 = this.fullPathPredicates();
        Seq<Predicate> seq4 = shortestPathExpression.fullPathPredicates();
        if (seq3 == null) {
            if (seq4 != null) {
                return false;
            }
        } else if (!seq3.equals(seq4)) return false;
        if (this.operatorId() != shortestPathExpression.operatorId()) return false;
        if (!shortestPathExpression.canEqual(this)) return false;
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$getMatches$2(Path p) {
        return p.length() == 0;
    }

    public static final /* synthetic */ boolean $anonfun$getMatches$6(ShortestPathExpression $this, Path p) {
        return $this.shortestPathPattern().allowZeroLength() || p.length() > 0;
    }

    public ShortestPathExpression(ShortestPath shortestPathPattern, Seq<Predicate> perStepPredicates, Seq<Predicate> fullPathPredicates, boolean withFallBack, boolean disallowSameNode, int operatorId) {
        this.shortestPathPattern = shortestPathPattern;
        this.perStepPredicates = perStepPredicates;
        this.fullPathPredicates = fullPathPredicates;
        this.withFallBack = withFallBack;
        this.disallowSameNode = disallowSameNode;
        this.operatorId = operatorId;
        Product.$init$((Product)this);
        this.predicates = (Seq)perStepPredicates.$plus$plus(fullPathPredicates);
    }
}

