/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.runtime.interpreted.pipes;

import org.eclipse.collections.api.map.primitive.IntObjectMap;
import org.eclipse.collections.api.map.primitive.MutableIntObjectMap;
import org.eclipse.collections.impl.factory.primitive.IntObjectMaps;
import org.neo4j.cypher.internal.planner.spi.ReadTokenContext;
import org.neo4j.cypher.internal.runtime.CypherRow;
import org.neo4j.cypher.internal.runtime.QueryContext;
import org.neo4j.cypher.internal.runtime.ReadableRow;
import org.neo4j.cypher.internal.runtime.WriteOperations;
import org.neo4j.cypher.internal.runtime.interpreted.commands.expressions.Expression;
import org.neo4j.cypher.internal.runtime.interpreted.pipes.LazyPropertyKey;
import org.neo4j.cypher.internal.runtime.interpreted.pipes.LazyPropertyKey$;
import org.neo4j.cypher.internal.runtime.interpreted.pipes.QueryState;
import org.neo4j.cypher.internal.runtime.interpreted.pipes.SetOperation;
import org.neo4j.cypher.internal.runtime.makeValueNeoSafe$;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;
import scala.Option;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001E4Q\u0001B\u0003\u0002\u0002QAQa\b\u0001\u0005\u0002\u0001BQA\t\u0001\u0005\u0012\rBQa\u0017\u0001\u0005\u0012q\u0013A$\u00112tiJ\f7\r^*fiB\u0013x\u000e]3sif|\u0005/\u001a:bi&|gN\u0003\u0002\u0007\u000f\u0005)\u0001/\u001b9fg*\u0011\u0001\"C\u0001\fS:$XM\u001d9sKR,GM\u0003\u0002\u000b\u0017\u00059!/\u001e8uS6,'B\u0001\u0007\u000e\u0003!Ig\u000e^3s]\u0006d'B\u0001\b\u0010\u0003\u0019\u0019\u0017\u0010\u001d5fe*\u0011\u0001#E\u0001\u0006]\u0016|GG\u001b\u0006\u0002%\u0005\u0019qN]4\u0004\u0001M\u0019\u0001!F\u000e\u0011\u0005YIR\"A\f\u000b\u0003a\tQa]2bY\u0006L!AG\f\u0003\r\u0005s\u0017PU3g!\taR$D\u0001\u0006\u0013\tqRA\u0001\u0007TKR|\u0005/\u001a:bi&|g.\u0001\u0004=S:LGO\u0010\u000b\u0002CA\u0011A\u0004A\u0001\fg\u0016$\bK]8qKJ$\u00180\u0006\u0002%wQ9Q\u0005\u000b\u00184\u000f2\u000b\u0006C\u0001\f'\u0013\t9sCA\u0004C_>dW-\u00198\t\u000b%\u0012\u0001\u0019\u0001\u0016\u0002\u000f\r|g\u000e^3yiB\u00111\u0006L\u0007\u0002\u0013%\u0011Q&\u0003\u0002\n\u0007f\u0004\b.\u001a:S_^DQa\f\u0002A\u0002A\nQa\u001d;bi\u0016\u0004\"\u0001H\u0019\n\u0005I*!AC)vKJL8\u000b^1uK\")AG\u0001a\u0001k\u0005\u0019q\u000e]:1\u0005Y*\u0005\u0003B\u00168s\u0011K!\u0001O\u0005\u0003\u001f]\u0013\u0018\u000e^3Pa\u0016\u0014\u0018\r^5p]N\u0004\"AO\u001e\r\u0001\u0011)AH\u0001b\u0001{\t\tA+\u0005\u0002?\u0003B\u0011acP\u0005\u0003\u0001^\u0011qAT8uQ&tw\r\u0005\u0002\u0017\u0005&\u00111i\u0006\u0002\u0004\u0003:L\bC\u0001\u001eF\t%15'!A\u0001\u0002\u000b\u0005QHA\u0002`IEBQ\u0001\u0013\u0002A\u0002%\u000ba!\u001b;f[&#\u0007C\u0001\fK\u0013\tYuC\u0001\u0003M_:<\u0007\"B'\u0003\u0001\u0004q\u0015a\u00039s_B,'\u000f^=LKf\u0004\"\u0001H(\n\u0005A+!a\u0004'buf\u0004&o\u001c9feRL8*Z=\t\u000bI\u0013\u0001\u0019A*\u0002\u0015\u0015D\bO]3tg&|g\u000e\u0005\u0002U36\tQK\u0003\u0002W/\u0006YQ\r\u001f9sKN\u001c\u0018n\u001c8t\u0015\tAv!\u0001\u0005d_6l\u0017M\u001c3t\u0013\tQVK\u0001\u0006FqB\u0014Xm]:j_:\fQb]3u!J|\u0007/\u001a:uS\u0016\u001cXCA/e)\u001dIel\u00181iS:DQ!K\u0002A\u0002)BQaL\u0002A\u0002ABQ\u0001N\u0002A\u0002\u0005\u0004$A\u00194\u0011\t-:4-\u001a\t\u0003u\u0011$Q\u0001P\u0002C\u0002u\u0002\"A\u000f4\u0005\u0013\u001d\u0004\u0017\u0011!A\u0001\u0006\u0003i$aA0%e!)\u0001j\u0001a\u0001\u0013\")!n\u0001a\u0001W\u0006!1.Z=t!\r1BNT\u0005\u0003[^\u0011Q!\u0011:sCfDQa\\\u0002A\u0002A\faA^1mk\u0016\u001c\bc\u0001\fm'\u0002")
public abstract class AbstractSetPropertyOperation
implements SetOperation {
    @Override
    public void execute(CypherRow row, QueryState state) {
        SetOperation.execute$(this, row, state);
    }

    public <T> boolean setProperty(CypherRow context, QueryState state, WriteOperations<T, ?> ops, long itemId, LazyPropertyKey propertyKey, Expression expression) {
        boolean bl;
        QueryContext queryContext = state.query();
        int maybePropertyKey = propertyKey.id((ReadTokenContext)queryContext);
        Value value = makeValueNeoSafe$.MODULE$.apply(expression.apply((ReadableRow)context, state));
        if (value == Values.NO_VALUE) {
            Option optPropertyKeyId = queryContext.getOptPropertyKeyId(propertyKey.name());
            bl = optPropertyKeyId.isDefined() ? ops.removeProperty(itemId, BoxesRunTime.unboxToInt((Object)optPropertyKeyId.get())) : false;
        } else {
            int propertyId = maybePropertyKey == LazyPropertyKey$.MODULE$.UNKNOWN() ? queryContext.getOrCreatePropertyKeyId(propertyKey.name()) : maybePropertyKey;
            ops.setProperty(itemId, propertyId, value);
            bl = true;
        }
        return bl;
    }

    public <T> long setProperties(CypherRow context, QueryState state, WriteOperations<T, ?> ops, long itemId, LazyPropertyKey[] keys, Expression[] values) {
        QueryContext queryContext = state.query();
        MutableIntObjectMap propValues = IntObjectMaps.mutable.empty();
        for (int i = 0; i < keys.length; ++i) {
            Object object;
            LazyPropertyKey propertyKey = keys[i];
            Expression expression = values[i];
            int maybePropertyKey = propertyKey.id((ReadTokenContext)queryContext);
            Value value = makeValueNeoSafe$.MODULE$.apply(expression.apply((ReadableRow)context, state));
            if (value == Values.NO_VALUE) {
                if (maybePropertyKey != LazyPropertyKey$.MODULE$.UNKNOWN()) {
                    object = propValues.put(maybePropertyKey, (Object)Values.NO_VALUE);
                    continue;
                }
                object = BoxedUnit.UNIT;
                continue;
            }
            int propertyId = maybePropertyKey == LazyPropertyKey$.MODULE$.UNKNOWN() ? queryContext.getOrCreatePropertyKeyId(propertyKey.name()) : maybePropertyKey;
            object = propValues.put(propertyId, (Object)value);
        }
        ops.setProperties(itemId, (IntObjectMap)propValues);
        return propValues.size();
    }

    public AbstractSetPropertyOperation() {
        SetOperation.$init$(this);
    }
}

