/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.runtime.interpreted.commands.expressions;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import org.neo4j.cypher.internal.runtime.CypherRow;
import org.neo4j.cypher.internal.runtime.Expander;
import org.neo4j.cypher.internal.runtime.KernelPredicate;
import org.neo4j.cypher.internal.runtime.ReadableRow;
import org.neo4j.cypher.internal.runtime.interpreted.commands.AllInList;
import org.neo4j.cypher.internal.runtime.interpreted.commands.AstNode;
import org.neo4j.cypher.internal.runtime.interpreted.commands.NoneInList;
import org.neo4j.cypher.internal.runtime.interpreted.commands.ShortestPath;
import org.neo4j.cypher.internal.runtime.interpreted.commands.SingleNode;
import org.neo4j.cypher.internal.runtime.interpreted.commands.expressions.Expanders$;
import org.neo4j.cypher.internal.runtime.interpreted.commands.expressions.Expression;
import org.neo4j.cypher.internal.runtime.interpreted.commands.expressions.ExtendedExpression;
import org.neo4j.cypher.internal.runtime.interpreted.commands.expressions.NodesFunction;
import org.neo4j.cypher.internal.runtime.interpreted.commands.expressions.RelationshipFunction;
import org.neo4j.cypher.internal.runtime.interpreted.commands.expressions.ShortestPathExpression$;
import org.neo4j.cypher.internal.runtime.interpreted.commands.expressions.TypeAndDirectionExpander;
import org.neo4j.cypher.internal.runtime.interpreted.commands.predicates.Ands;
import org.neo4j.cypher.internal.runtime.interpreted.commands.predicates.CoercedPredicate;
import org.neo4j.cypher.internal.runtime.interpreted.commands.predicates.Not;
import org.neo4j.cypher.internal.runtime.interpreted.commands.predicates.Predicate;
import org.neo4j.cypher.internal.runtime.interpreted.commands.predicates.PropertyExists;
import org.neo4j.cypher.internal.runtime.interpreted.commands.values.KeyToken;
import org.neo4j.cypher.internal.runtime.interpreted.pipes.QueryState;
import org.neo4j.cypher.internal.util.NonEmptyList;
import org.neo4j.cypher.internal.util.NonEmptyList$;
import org.neo4j.cypher.internal.util.attribution.Id;
import org.neo4j.exceptions.CypherTypeException;
import org.neo4j.exceptions.ShortestPathCommonEndNodesForbiddenException;
import org.neo4j.exceptions.SyntaxException;
import org.neo4j.graphdb.Entity;
import org.neo4j.graphdb.NotFoundException;
import org.neo4j.graphdb.Path;
import org.neo4j.graphdb.Relationship;
import org.neo4j.kernel.impl.util.ValueUtils;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.values.AnyValue;
import org.neo4j.values.VirtualValue;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;
import org.neo4j.values.virtual.VirtualNodeValue;
import org.neo4j.values.virtual.VirtualPathValue;
import org.neo4j.values.virtual.VirtualValues;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.Tuple6;
import scala.collection.Iterable;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\rUf\u0001B\"E\u0001VC\u0001b\u0019\u0001\u0003\u0016\u0004%\t\u0001\u001a\u0005\tS\u0002\u0011\t\u0012)A\u0005K\"A!\u000e\u0001BK\u0002\u0013\u00051\u000e\u0003\u0005\u007f\u0001\tE\t\u0015!\u0003m\u0011!y\bA!f\u0001\n\u0003Y\u0007\"CA\u0001\u0001\tE\t\u0015!\u0003m\u0011)\t\u0019\u0001\u0001BK\u0002\u0013\u0005\u0011Q\u0001\u0005\u000b\u0003\u001b\u0001!\u0011#Q\u0001\n\u0005\u001d\u0001BCA\b\u0001\tU\r\u0011\"\u0001\u0002\u0006!Q\u0011\u0011\u0003\u0001\u0003\u0012\u0003\u0006I!a\u0002\t\u0015\u0005M\u0001A!f\u0001\n\u0003\t)\u0002\u0003\u0006\u0002(\u0001\u0011\t\u0012)A\u0005\u0003/Aq!!\u000b\u0001\t\u0003\tY\u0003C\u0004|\u0001\t\u0007I\u0011A6\t\u000f\u0005m\u0002\u0001)A\u0005Y\"9\u0011Q\b\u0001\u0005\u0002\u0005}\u0002bBA\u001f\u0001\u0011\u0005\u0011\u0011\u000e\u0005\b\u0003\u007f\u0002A\u0011BAA\u0011\u001d\ty\n\u0001C\u0005\u0003CCq!a3\u0001\t\u0013\ti\rC\u0004\u0002\\\u0002!I!!8\t\u000f\u0005\u0005\b\u0001\"\u0011\u0002d\"9!Q\u0001\u0001\u0005B\t\u001d\u0001b\u0002B\u0006\u0001\u0011\u0005#Q\u0002\u0005\b\u00053\u0001A\u0011\u0002B\u000e\u0011\u001d\u0011)\u0005\u0001C\u0005\u0005\u000fBqAa\u0014\u0001\t\u0013\u0011\t\u0006C\u0004\u0003j\u0001!IAa\u001b\t\u000f\te\u0004\u0001\"\u0003\u0003|!9!q\u0010\u0001\u0005\n\t\u0005\u0005b\u0002BN\u0001\u0011%!Q\u0014\u0005\b\u0005o\u0003A\u0011\u0002B]\u0011\u001d\u0011Y\f\u0001C\u0005\u0005{CqAa2\u0001\t\u0013\u0011I\rC\u0004\u0003^\u0002!IAa8\t\u0013\t\u0015\b!!A\u0005\u0002\t\u001d\b\"\u0003B{\u0001E\u0005I\u0011\u0001B|\u0011%\u0019I\u0001AI\u0001\n\u0003\u0019Y\u0001C\u0005\u0004\u0010\u0001\t\n\u0011\"\u0001\u0004\f!I1\u0011\u0003\u0001\u0012\u0002\u0013\u000511\u0003\u0005\n\u0007/\u0001\u0011\u0013!C\u0001\u0007'A\u0011b!\u0007\u0001#\u0003%\taa\u0007\t\u0013\r}\u0001!!A\u0005B\r\u0005\u0002\"CB\u0019\u0001\u0005\u0005I\u0011AB\u001a\u0011%\u0019)\u0004AA\u0001\n\u0003\u00199\u0004C\u0005\u0004>\u0001\t\t\u0011\"\u0011\u0004@!I1Q\n\u0001\u0002\u0002\u0013\u00051q\n\u0005\n\u0007'\u0002\u0011\u0011!C!\u0007+B\u0011ba\u0016\u0001\u0003\u0003%\te!\u0017\b\u000f\ruC\t#\u0001\u0004`\u001911\t\u0012E\u0001\u0007CBq!!\u000b4\t\u0003\u0019\u0019\u0007C\u0004\u0004fM\"\taa\u001a\t\u0013\u0005u2'!A\u0005\u0002\u000ee\u0004\"CBDgE\u0005I\u0011AB\u0006\u0011%\u0019IiMI\u0001\n\u0003\u0019Y\u0001C\u0005\u0004\fN\n\n\u0011\"\u0001\u0004\u0014!I1QR\u001a\u0012\u0002\u0013\u000511\u0003\u0005\n\u0007\u001f\u001b\u0014\u0013!C\u0001\u00077A\u0011b!%4\u0003\u0003%\tia%\t\u0013\r\u00056'%A\u0005\u0002\r-\u0001\"CBRgE\u0005I\u0011AB\u0006\u0011%\u0019)kMI\u0001\n\u0003\u0019\u0019\u0002C\u0005\u0004(N\n\n\u0011\"\u0001\u0004\u0014!I1\u0011V\u001a\u0012\u0002\u0013\u000511\u0004\u0005\n\u0007W\u001b\u0014\u0011!C\u0005\u0007[\u0013ac\u00155peR,7\u000f\u001e)bi\",\u0005\u0010\u001d:fgNLwN\u001c\u0006\u0003\u000b\u001a\u000b1\"\u001a=qe\u0016\u001c8/[8og*\u0011q\tS\u0001\tG>lW.\u00198eg*\u0011\u0011JS\u0001\fS:$XM\u001d9sKR,GM\u0003\u0002L\u0019\u00069!/\u001e8uS6,'BA'O\u0003!Ig\u000e^3s]\u0006d'BA(Q\u0003\u0019\u0019\u0017\u0010\u001d5fe*\u0011\u0011KU\u0001\u0006]\u0016|GG\u001b\u0006\u0002'\u0006\u0019qN]4\u0004\u0001M!\u0001A\u0016.a!\t9\u0006,D\u0001E\u0013\tIFI\u0001\u0006FqB\u0014Xm]:j_:\u0004\"a\u00170\u000e\u0003qS\u0011!X\u0001\u0006g\u000e\fG.Y\u0005\u0003?r\u0013q\u0001\u0015:pIV\u001cG\u000f\u0005\u0002\\C&\u0011!\r\u0018\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.Z\u0001\u0014g\"|'\u000f^3tiB\u000bG\u000f\u001b)biR,'O\\\u000b\u0002KB\u0011amZ\u0007\u0002\r&\u0011\u0001N\u0012\u0002\r'\"|'\u000f^3tiB\u000bG\u000f[\u0001\u0015g\"|'\u000f^3tiB\u000bG\u000f\u001b)biR,'O\u001c\u0011\u0002#A,'o\u0015;faB\u0013X\rZ5dCR,7/F\u0001m!\riW\u000f\u001f\b\u0003]Nt!a\u001c:\u000e\u0003AT!!\u001d+\u0002\rq\u0012xn\u001c;?\u0013\u0005i\u0016B\u0001;]\u0003\u001d\u0001\u0018mY6bO\u0016L!A^<\u0003\u0007M+\u0017O\u0003\u0002u9B\u0011\u0011\u0010`\u0007\u0002u*\u00111PR\u0001\u000baJ,G-[2bi\u0016\u001c\u0018BA?{\u0005%\u0001&/\u001a3jG\u0006$X-\u0001\nqKJ\u001cF/\u001a9Qe\u0016$\u0017nY1uKN\u0004\u0013A\u00054vY2\u0004\u0016\r\u001e5Qe\u0016$\u0017nY1uKN\f1CZ;mYB\u000bG\u000f\u001b)sK\u0012L7-\u0019;fg\u0002\nAb^5uQ\u001a\u000bG\u000e\u001c\"bG.,\"!a\u0002\u0011\u0007m\u000bI!C\u0002\u0002\fq\u0013qAQ8pY\u0016\fg.A\u0007xSRDg)\u00197m\u0005\u0006\u001c7\u000eI\u0001\u0011I&\u001c\u0018\r\u001c7poN\u000bW.\u001a(pI\u0016\f\u0011\u0003Z5tC2dwn^*b[\u0016tu\u000eZ3!\u0003)y\u0007/\u001a:bi>\u0014\u0018\nZ\u000b\u0003\u0003/\u0001B!!\u0007\u0002$5\u0011\u00111\u0004\u0006\u0005\u0003;\ty\"A\u0006biR\u0014\u0018NY;uS>t'bAA\u0011\u0019\u0006!Q\u000f^5m\u0013\u0011\t)#a\u0007\u0003\u0005%#\u0017aC8qKJ\fGo\u001c:JI\u0002\na\u0001P5oSRtDCDA\u0017\u0003_\t\t$a\r\u00026\u0005]\u0012\u0011\b\t\u0003/\u0002AQaY\u0007A\u0002\u0015DqA[\u0007\u0011\u0002\u0003\u0007A\u000eC\u0004\u0000\u001bA\u0005\t\u0019\u00017\t\u0013\u0005\rQ\u0002%AA\u0002\u0005\u001d\u0001\"CA\b\u001bA\u0005\t\u0019AA\u0004\u0011%\t\u0019\"\u0004I\u0001\u0002\u0004\t9\"A\u0006qe\u0016$\u0017nY1uKN\u0004\u0013!B1qa2LHCBA!\u0003\u001b\nI\u0006\u0005\u0003\u0002D\u0005%SBAA#\u0015\r\t9\u0005U\u0001\u0007m\u0006dW/Z:\n\t\u0005-\u0013Q\t\u0002\t\u0003:Lh+\u00197vK\"9\u0011q\n\tA\u0002\u0005E\u0013a\u0001:poB!\u00111KA+\u001b\u0005Q\u0015bAA,\u0015\nY!+Z1eC\ndWMU8x\u0011\u001d\tY\u0006\u0005a\u0001\u0003;\nQa\u001d;bi\u0016\u0004B!a\u0018\u0002f5\u0011\u0011\u0011\r\u0006\u0004\u0003GB\u0015!\u00029ja\u0016\u001c\u0018\u0002BA4\u0003C\u0012!\"U;fef\u001cF/\u0019;f)!\t\t%a\u001b\u0002n\u0005=\u0004bBA(#\u0001\u0007\u0011\u0011\u000b\u0005\b\u00037\n\u0002\u0019AA/\u0011\u001d\t\t(\u0005a\u0001\u0003g\nQ\"\\3n_JLHK]1dW\u0016\u0014\b\u0003BA;\u0003wj!!a\u001e\u000b\u0007\u0005e\u0004+\u0001\u0004nK6|'/_\u0005\u0005\u0003{\n9HA\u0007NK6|'/\u001f+sC\u000e\\WM]\u0001\u000bO\u0016$X*\u0019;dQ\u0016\u001cH\u0003DA!\u0003\u0007\u000b9)a&\u0002\u001c\u0006u\u0005bBAC%\u0001\u0007\u0011\u0011K\u0001\u0004GRD\bbBAE%\u0001\u0007\u00111R\u0001\u0006gR\f'\u000f\u001e\t\u0005\u0003\u001b\u000b\u0019*\u0004\u0002\u0002\u0010*!\u0011\u0011SA#\u0003\u001d1\u0018N\u001d;vC2LA!!&\u0002\u0010\n\u0001b+\u001b:uk\u0006dgj\u001c3f-\u0006dW/\u001a\u0005\b\u00033\u0013\u0002\u0019AAF\u0003\r)g\u000e\u001a\u0005\b\u00037\u0012\u0002\u0019AA/\u0011\u001d\t\tH\u0005a\u0001\u0003g\n1d\u0019:fCR,7\u000b[8si\u0016\u001cH\u000fU1uQB\u0013X\rZ5dCR,G\u0003CAR\u0003k\u000by,!3\u0011\r\u0005M\u0013QUAU\u0013\r\t9K\u0013\u0002\u0010\u0017\u0016\u0014h.\u001a7Qe\u0016$\u0017nY1uKB!\u00111VAY\u001b\t\tiKC\u0002\u00020B\u000bqa\u001a:ba\"$'-\u0003\u0003\u00024\u00065&\u0001\u0002)bi\"Dq!a.\u0014\u0001\u0004\tI,A\u0006j]\u000e|W.\u001b8h\u0007RD\b\u0003BA*\u0003wK1!!0K\u0005%\u0019\u0015\u0010\u001d5feJ{w\u000fC\u0004\u0002BN\u0001\r!a1\u0002\u001d5\f\u0017PY3Qe\u0016$\u0017nY1uKB!1,!2y\u0013\r\t9\r\u0018\u0002\u0007\u001fB$\u0018n\u001c8\t\u000f\u0005m3\u00031\u0001\u0002^\u0005Yq-\u001a;F]\u0012\u0004v.\u001b8u)!\tY)a4\u0002R\u0006M\u0007bBAC)\u0001\u0007\u0011\u0011\u000b\u0005\b\u00037\"\u0002\u0019AA/\u0011\u001d\tI\t\u0006a\u0001\u0003+\u00042AZAl\u0013\r\tIN\u0012\u0002\u000b'&tw\r\\3O_\u0012,\u0017!G1osN#\u0018M\u001d;q_&tGo]\"p]R\f\u0017N\u001c(vY2$B!a\u0002\u0002`\"9\u0011QQ\u000bA\u0002\u0005E\u0013\u0001C2iS2$'/\u001a8\u0016\u0005\u0005\u0015\b\u0003B7v\u0003O\u0004D!!;\u0002tB)a-a;\u0002p&\u0019\u0011Q\u001e$\u0003\u000f\u0005\u001bHOT8eKB!\u0011\u0011_Az\u0019\u0001!1\"!>\u0017\u0003\u0003\u0005\tQ!\u0001\u0002x\n\u0019q\fJ\u0019\u0012\t\u0005e\u0018q \t\u00047\u0006m\u0018bAA\u007f9\n9aj\u001c;iS:<\u0007cA.\u0003\u0002%\u0019!1\u0001/\u0003\u0007\u0005s\u00170A\u0005be\u001e,X.\u001a8ugV\u0011!\u0011\u0002\t\u0004[V4\u0016a\u0002:foJLG/\u001a\u000b\u0004-\n=\u0001b\u0002B\t1\u0001\u0007!1C\u0001\u0002MB)1L!\u0006W-&\u0019!q\u0003/\u0003\u0013\u0019+hn\u0019;j_:\f\u0014A\u00069s_B,'\u000f^=Fq&\u001cHo]#ya\u0006tG-\u001a:\u0015\t\tu!\u0011\u0007\n\u0007\u0005?\u0011\u0019C!\u000b\u0007\r\t\u0005\u0012\u0004\u0001B\u000f\u00051a$/\u001a4j]\u0016lWM\u001c;?!\rY&QE\u0005\u0004\u0005Oa&AB!osJ+g\r\u0005\u0004\u0002T\u0005\u0015&1\u0006\t\u0005\u0003W\u0013i#\u0003\u0003\u00030\u00055&AB#oi&$\u0018\u0010C\u0004\u00034e\u0001\rA!\u000e\u0002\t9\fW.\u001a\t\u0005\u0005o\u0011yD\u0004\u0003\u0003:\tm\u0002CA8]\u0013\r\u0011i\u0004X\u0001\u0007!J,G-\u001a4\n\t\t\u0005#1\t\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\tuB,A\rqe>\u0004XM\u001d;z\u001d>$X\t_5tiN,\u0005\u0010]1oI\u0016\u0014H\u0003\u0002B%\u0005\u001b\u0012bAa\u0013\u0003$\t%bA\u0002B\u00115\u0001\u0011I\u0005C\u0004\u00034i\u0001\rA!\u000e\u0002E\rL\b\u000f[3s!>\u001c\u0018\u000e^5wKB\u0013X\rZ5dCR,7/Q:FqB\fg\u000eZ3s))\u0011\u0019Fa\u0016\u0003Z\t\r$q\r\n\u0007\u0005+\u0012\u0019C!\u000b\u0007\r\t\u00052\u0004\u0001B*\u0011\u001d\t9l\u0007a\u0001\u0003#BqAa\u0017\u001c\u0001\u0004\u0011i&\u0001\bwCJL\u0017M\u00197f\u001f\u001a47/\u001a;\u0011\u0007m\u0013y&C\u0002\u0003bq\u00131!\u00138u\u0011\u0019\u0011)g\u0007a\u0001q\u0006I\u0001O]3eS\u000e\fG/\u001a\u0005\b\u00037Z\u0002\u0019AA/\u0003\t\u001a\u0017\u0010\u001d5fe:+w-\u0019;jm\u0016\u0004&/\u001a3jG\u0006$Xm]!t\u000bb\u0004\u0018M\u001c3feRQ!Q\u000eB9\u0005g\u0012)Ha\u001e\u0013\r\t=$1\u0005B\u0015\r\u0019\u0011\t\u0003\b\u0001\u0003n!9\u0011q\u0017\u000fA\u0002\u0005E\u0003b\u0002B.9\u0001\u0007!Q\f\u0005\u0007\u0005Kb\u0002\u0019\u0001=\t\u000f\u0005mC\u00041\u0001\u0002^\u0005ia-\u001b8e!J,G-[2bi\u0016$2A\u0016B?\u0011\u0019\u0011)'\ba\u0001q\u0006\u0001\u0013\r\u001a3BY2|%OT8oKJ+G.\u0019;j_:\u001c\b.\u001b9FqB\fg\u000eZ3s)9\u0011\u0019I!#\u0003\f\n=%1\u0013BK\u00053\u0003B!a\u0015\u0003\u0006&\u0019!q\u0011&\u0003\u0011\u0015C\b/\u00198eKJDq!!\"\u001f\u0001\u0004\t\t\u0006C\u0004\u0003\u000ez\u0001\rAa!\u0002\u001f\r,(O]3oi\u0016C\b/\u00198eKJDqA!%\u001f\u0001\u0004\t9!A\u0002bY2DaA!\u001a\u001f\u0001\u0004A\bb\u0002BL=\u0001\u0007!QL\u0001\u0012e\u0016dg+\u0019:jC\ndWm\u00144gg\u0016$\bbBA.=\u0001\u0007\u0011QL\u0001\u0019C\u0012$\u0017\t\u001c7Pe:{g.\u001a(pI\u0016,\u0005\u0010]1oI\u0016\u0014H\u0003\u0005BP\u0005O\u0013IKa+\u0003.\n=&\u0011\u0017B[!\u001dY&\u0011\u0015BB\u0005KK1Aa)]\u0005\u0019!V\u000f\u001d7feA!Q.\u001eB\u0015\u0011\u001d\t)i\ba\u0001\u0003#BqA!$ \u0001\u0004\u0011\u0019\tC\u0004\u0003\u0012~\u0001\r!a\u0002\t\r\t\u0015t\u00041\u0001y\u0011\u001d\u00119j\ba\u0001\u0005;BqAa- \u0001\u0004\u0011)+A\u000bdkJ\u0014XM\u001c;O_\u0012,\u0007K]3eS\u000e\fG/Z:\t\u000f\u0005ms\u00041\u0001\u0002^\u0005aR.Y6f%\u0016d\u0017\r^5p]ND\u0017\u000e\u001d+za\u0016,\u0005\u0010]1oI\u0016\u0014HC\u0001BB\u00035\tG\r\u001a)sK\u0012L7-\u0019;fgRA!q\u0014B`\u0005\u0003\u0014)\rC\u0004\u0002\u0006\u0006\u0002\r!!\u0015\t\u000f\t\r\u0017\u00051\u0001\u0003\u0004\u0006)\"/\u001a7UsB,\u0017I\u001c3ESJ,\u0005\u0010]1oI\u0016\u0014\bbBA.C\u0001\u0007\u0011QL\u0001\u0010SNtu\u000eZ3t\rVt7\r^5p]R!\u0011q\u0001Bf\u0011\u0019\u0011iM\ta\u0001-\u0006QQ\r\u001f9sKN\u001c\u0018n\u001c8)\u0007\t\u0012\t\u000e\u0005\u0003\u0003T\neWB\u0001Bk\u0015\r\u00119\u000eX\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002\u0002Bn\u0005+\u0014q\u0001^1jYJ,7-A\fjgJ+G.\u0019;j_:\u001c\b.\u001b9t\rVt7\r^5p]R!\u0011q\u0001Bq\u0011\u0019\u0011im\ta\u0001-\"\u001a1E!5\u0002\t\r|\u0007/\u001f\u000b\u000f\u0003[\u0011IOa;\u0003n\n=(\u0011\u001fBz\u0011\u001d\u0019G\u0005%AA\u0002\u0015DqA\u001b\u0013\u0011\u0002\u0003\u0007A\u000eC\u0004\u0000IA\u0005\t\u0019\u00017\t\u0013\u0005\rA\u0005%AA\u0002\u0005\u001d\u0001\"CA\bIA\u0005\t\u0019AA\u0004\u0011%\t\u0019\u0002\nI\u0001\u0002\u0004\t9\"\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\te(fA3\u0003|.\u0012!Q \t\u0005\u0005\u007f\u001c)!\u0004\u0002\u0004\u0002)!11\u0001Bk\u0003%)hn\u00195fG.,G-\u0003\u0003\u0004\b\r\u0005!!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\u0012TCAB\u0007U\ra'1`\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00134\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIQ*\"a!\u0006+\t\u0005\u001d!1`\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00136\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIY*\"a!\b+\t\u0005]!1`\u0001\u000eaJ|G-^2u!J,g-\u001b=\u0016\u0005\r\r\u0002\u0003BB\u0013\u0007_i!aa\n\u000b\t\r%21F\u0001\u0005Y\u0006twM\u0003\u0002\u0004.\u0005!!.\u0019<b\u0013\u0011\u0011\tea\n\u0002\u0019A\u0014x\u000eZ;di\u0006\u0013\u0018\u000e^=\u0016\u0005\tu\u0013A\u00049s_\u0012,8\r^#mK6,g\u000e\u001e\u000b\u0005\u0003\u007f\u001cI\u0004C\u0005\u0004<5\n\t\u00111\u0001\u0003^\u0005\u0019\u0001\u0010J\u0019\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"a!\u0011\u0011\r\r\r3\u0011JA\u0000\u001b\t\u0019)EC\u0002\u0004Hq\u000b!bY8mY\u0016\u001cG/[8o\u0013\u0011\u0019Ye!\u0012\u0003\u0011%#XM]1u_J\f\u0001bY1o\u000bF,\u0018\r\u001c\u000b\u0005\u0003\u000f\u0019\t\u0006C\u0005\u0004<=\n\t\u00111\u0001\u0002\u0000\u0006A\u0001.Y:i\u0007>$W\r\u0006\u0002\u0003^\u00051Q-];bYN$B!a\u0002\u0004\\!I11H\u0019\u0002\u0002\u0003\u0007\u0011q`\u0001\u0017'\"|'\u000f^3tiB\u000bG\u000f[#yaJ,7o]5p]B\u0011qkM\n\u0005g\t\r\u0002\r\u0006\u0002\u0004`\u0005aan\u001c#va2L7-\u0019;fgR!\u0011qAB5\u0011\u001d\u0019Y'\u000ea\u0001\u0007[\nQB]3mCRLwN\\:iSB\u001c\b#B7\u0004p\rM\u0014bAB9o\nA\u0011\n^3sC\ndW\r\u0005\u0003\u0002,\u000eU\u0014\u0002BB<\u0003[\u0013ABU3mCRLwN\\:iSB$b\"!\f\u0004|\ru4qPBA\u0007\u0007\u001b)\tC\u0003dm\u0001\u0007Q\rC\u0004kmA\u0005\t\u0019\u00017\t\u000f}4\u0004\u0013!a\u0001Y\"I\u00111\u0001\u001c\u0011\u0002\u0003\u0007\u0011q\u0001\u0005\n\u0003\u001f1\u0004\u0013!a\u0001\u0003\u000fA\u0011\"a\u00057!\u0003\u0005\r!a\u0006\u0002\u001f\u0005\u0004\b\u000f\\=%I\u00164\u0017-\u001e7uII\nq\"\u00199qYf$C-\u001a4bk2$HeM\u0001\u0010CB\u0004H.\u001f\u0013eK\u001a\fW\u000f\u001c;%i\u0005y\u0011\r\u001d9ms\u0012\"WMZ1vYR$S'A\bbaBd\u0017\u0010\n3fM\u0006,H\u000e\u001e\u00137\u0003\u001d)h.\u00199qYf$Ba!&\u0004\u001eB)1,!2\u0004\u0018Ba1l!'fY2\f9!a\u0002\u0002\u0018%\u001911\u0014/\u0003\rQ+\b\u000f\\37\u0011%\u0019y\nPA\u0001\u0002\u0004\ti#A\u0002yIA\n1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012\u0012\u0014a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$3'A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$H\u0005N\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000fJ\u001b\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00137\u0003-\u0011X-\u00193SKN|GN^3\u0015\u0005\r=\u0006\u0003BB\u0013\u0007cKAaa-\u0004(\t1qJ\u00196fGR\u0004")
public class ShortestPathExpression
extends Expression
implements Product,
scala.Serializable {
    private final ShortestPath shortestPathPattern;
    private final Seq<Predicate> perStepPredicates;
    private final Seq<Predicate> fullPathPredicates;
    private final boolean withFallBack;
    private final boolean disallowSameNode;
    private final int operatorId;
    private final Seq<Predicate> predicates;

    public static int $lessinit$greater$default$6() {
        return ShortestPathExpression$.MODULE$.$lessinit$greater$default$6();
    }

    public static boolean $lessinit$greater$default$5() {
        return ShortestPathExpression$.MODULE$.$lessinit$greater$default$5();
    }

    public static boolean $lessinit$greater$default$4() {
        return ShortestPathExpression$.MODULE$.$lessinit$greater$default$4();
    }

    public static Seq<Predicate> $lessinit$greater$default$3() {
        return ShortestPathExpression$.MODULE$.$lessinit$greater$default$3();
    }

    public static Seq<Predicate> $lessinit$greater$default$2() {
        return ShortestPathExpression$.MODULE$.$lessinit$greater$default$2();
    }

    public static Option<Tuple6<ShortestPath, Seq<Predicate>, Seq<Predicate>, Object, Object, Id>> unapply(ShortestPathExpression shortestPathExpression) {
        return ShortestPathExpression$.MODULE$.unapply(shortestPathExpression);
    }

    public static int apply$default$6() {
        return ShortestPathExpression$.MODULE$.apply$default$6();
    }

    public static boolean apply$default$5() {
        return ShortestPathExpression$.MODULE$.apply$default$5();
    }

    public static boolean apply$default$4() {
        return ShortestPathExpression$.MODULE$.apply$default$4();
    }

    public static Seq<Predicate> apply$default$3() {
        return ShortestPathExpression$.MODULE$.apply$default$3();
    }

    public static Seq<Predicate> apply$default$2() {
        return ShortestPathExpression$.MODULE$.apply$default$2();
    }

    public static boolean noDuplicates(Iterable<Relationship> iterable) {
        return ShortestPathExpression$.MODULE$.noDuplicates(iterable);
    }

    public ShortestPath shortestPathPattern() {
        return this.shortestPathPattern;
    }

    public Seq<Predicate> perStepPredicates() {
        return this.perStepPredicates;
    }

    public Seq<Predicate> fullPathPredicates() {
        return this.fullPathPredicates;
    }

    public boolean withFallBack() {
        return this.withFallBack;
    }

    public boolean disallowSameNode() {
        return this.disallowSameNode;
    }

    public int operatorId() {
        return this.operatorId;
    }

    public Seq<Predicate> predicates() {
        return this.predicates;
    }

    @Override
    public AnyValue apply(ReadableRow row, QueryState state) {
        return this.apply(row, state, state.memoryTrackerForOperatorProvider().memoryTrackerForOperator(this.operatorId()));
    }

    public AnyValue apply(ReadableRow row, QueryState state, MemoryTracker memoryTracker) {
        Value value;
        if (this.anyStartpointsContainNull(row)) {
            value = Values.NO_VALUE;
        } else {
            VirtualNodeValue start = this.getEndPoint(row, state, this.shortestPathPattern().left());
            VirtualNodeValue end = this.getEndPoint(row, state, this.shortestPathPattern().right());
            if (!this.shortestPathPattern().allowZeroLength() && this.disallowSameNode() && start.equals((VirtualValue)end)) {
                throw new ShortestPathCommonEndNodesForbiddenException();
            }
            value = this.getMatches(row, start, end, state, memoryTracker);
        }
        return value;
    }

    private AnyValue getMatches(ReadableRow ctx, VirtualNodeValue start, VirtualNodeValue end, QueryState state, MemoryTracker memoryTracker) {
        Object object;
        Tuple2<Expander, Seq<KernelPredicate<Entity>>> tuple2 = this.addPredicates(ctx, this.makeRelationshipTypeExpander(), state);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Expander expander = (Expander)tuple2._1();
        Seq nodePredicates = (Seq)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)expander, (Object)nodePredicates);
        Tuple2 tuple23 = tuple22;
        Expander expander2 = (Expander)tuple23._1();
        Seq nodePredicates2 = (Seq)tuple23._2();
        None$ maybePredicate = this.predicates().isEmpty() ? None$.MODULE$ : new Some((Object)new Ands((NonEmptyList<Predicate>)NonEmptyList$.MODULE$.from(this.predicates())));
        CypherRow cypherRow = (CypherRow)ctx;
        KernelPredicate<Path> shortestPathPredicate = this.createShortestPathPredicate(cypherRow, (Option<Predicate>)maybePredicate, state);
        if (this.shortestPathPattern().single()) {
            Option result = state.query().singleShortestPath(start.id(), end.id(), BoxesRunTime.unboxToInt((Object)this.shortestPathPattern().maxDepth().getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> Integer.MAX_VALUE)), expander2, shortestPathPredicate, nodePredicates2, memoryTracker);
            object = !this.shortestPathPattern().allowZeroLength() && result.forall((Function1 & Serializable & scala.Serializable)p -> BoxesRunTime.boxToBoolean((boolean)ShortestPathExpression.$anonfun$getMatches$2(p))) ? Values.NO_VALUE : (AnyValue)result.map((Function1 & Serializable & scala.Serializable)x$1 -> ValueUtils.fromPath((Path)x$1)).getOrElse((Function0 & Serializable & scala.Serializable)() -> Values.NO_VALUE);
        } else {
            VirtualPathValue[] result = (VirtualPathValue[])state.query().allShortestPath(start.id(), end.id(), BoxesRunTime.unboxToInt((Object)this.shortestPathPattern().maxDepth().getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> Integer.MAX_VALUE)), expander2, shortestPathPredicate, nodePredicates2, memoryTracker).filter((Function1 & Serializable & scala.Serializable)p -> BoxesRunTime.boxToBoolean((boolean)ShortestPathExpression.$anonfun$getMatches$6(this, p))).map((Function1 & Serializable & scala.Serializable)x$1 -> ValueUtils.fromPath((Path)x$1)).toArray(ClassTag$.MODULE$.apply(VirtualPathValue.class));
            object = VirtualValues.list((AnyValue[])((AnyValue[])result));
        }
        return object;
    }

    private KernelPredicate<Path> createShortestPathPredicate(CypherRow incomingCtx, Option<Predicate> maybePredicate, QueryState state) {
        return new KernelPredicate<Path>(this, maybePredicate, incomingCtx, state){
            private final /* synthetic */ ShortestPathExpression $outer;
            private final Option maybePredicate$1;
            private final CypherRow incomingCtx$1;
            private final QueryState state$1;

            public boolean test(Path path) {
                return this.maybePredicate$1.forall((Function1 & Serializable & scala.Serializable)predicate -> BoxesRunTime.boxToBoolean((boolean)$anon$1.$anonfun$test$1(this, path, predicate))) && (!this.$outer.withFallBack() || ShortestPathExpression$.MODULE$.noDuplicates((Iterable<Relationship>)((Iterable)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(path.relationships()).asScala())));
            }

            public static final /* synthetic */ boolean $anonfun$test$1($anon$1 $this, Path path$1, Predicate predicate) {
                $this.incomingCtx$1.set($this.$outer.shortestPathPattern().pathName(), (AnyValue)ValueUtils.fromPath((Path)path$1));
                $this.incomingCtx$1.set((String)$this.$outer.shortestPathPattern().relIterator().get(), (AnyValue)ValueUtils.asListOfEdges((java.lang.Iterable)path$1.relationships()));
                return predicate.isTrue((ReadableRow)$this.incomingCtx$1, $this.state$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.maybePredicate$1 = maybePredicate$1;
                this.incomingCtx$1 = incomingCtx$1;
                this.state$1 = state$1;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$test$1$adapted(org.neo4j.cypher.internal.runtime.interpreted.commands.expressions.ShortestPathExpression$$anon$1 org.neo4j.graphdb.Path org.neo4j.cypher.internal.runtime.interpreted.commands.predicates.Predicate )}, serializedLambda);
            }
        };
    }

    private VirtualNodeValue getEndPoint(ReadableRow ctx, QueryState state, SingleNode start) {
        VirtualNodeValue virtualNodeValue;
        try {
            VirtualNodeValue virtualNodeValue2;
            AnyValue anyValue = ctx.getByName(start.name());
            if (!(anyValue instanceof VirtualNodeValue)) {
                throw new CypherTypeException(new StringBuilder(14).append(start.name()).append(" is not a node").toString());
            }
            VirtualNodeValue virtualNodeValue3 = virtualNodeValue2 = (VirtualNodeValue)anyValue;
            virtualNodeValue = virtualNodeValue3;
        }
        catch (NotFoundException notFoundException) {
            throw new SyntaxException(new StringBuilder(84).append("To find a shortest path, both ends of the path need to be provided. Couldn't find `").append(start).append("`").toString());
        }
        return virtualNodeValue;
    }

    private boolean anyStartpointsContainNull(ReadableRow ctx) {
        return ctx.getByName(this.shortestPathPattern().left().name()) == Values.NO_VALUE || ctx.getByName(this.shortestPathPattern().right().name()) == Values.NO_VALUE;
    }

    @Override
    public Seq<AstNode<?>> children() {
        return (Seq)((TraversableLike)((TraversableLike)new .colon.colon((Object)this.shortestPathPattern(), (List)Nil$.MODULE$)).$plus$plus(this.perStepPredicates(), Seq$.MODULE$.canBuildFrom())).$plus$plus(this.fullPathPredicates(), Seq$.MODULE$.canBuildFrom());
    }

    @Override
    public Seq<Expression> arguments() {
        return (Seq)Nil$.MODULE$;
    }

    @Override
    public Expression rewrite(Function1<Expression, Expression> f) {
        Object x$1 = this.shortestPathPattern().rewrite((Function1)f);
        int x$2 = this.operatorId();
        Seq<Predicate> x$3 = ShortestPathExpression$.MODULE$.apply$default$2();
        Seq<Predicate> x$4 = ShortestPathExpression$.MODULE$.apply$default$3();
        boolean x$5 = ShortestPathExpression$.MODULE$.apply$default$4();
        boolean x$6 = ShortestPathExpression$.MODULE$.apply$default$5();
        return (Expression)f.apply((Object)new ShortestPathExpression((ShortestPath)x$1, x$3, x$4, x$5, x$6, x$2));
    }

    private KernelPredicate<Entity> propertyExistsExpander(String name) {
        return new KernelPredicate<Entity>(null, name){
            private final String name$1;

            public boolean test(Entity t) {
                return t.hasProperty(this.name$1);
            }
            {
                this.name$1 = name$1;
            }
        };
    }

    private KernelPredicate<Entity> propertyNotExistsExpander(String name) {
        return new KernelPredicate<Entity>(null, name){
            private final String name$2;

            public boolean test(Entity t) {
                return !t.hasProperty(this.name$2);
            }
            {
                this.name$2 = name$2;
            }
        };
    }

    private KernelPredicate<Entity> cypherPositivePredicatesAsExpander(ReadableRow incomingCtx, int variableOffset, Predicate predicate, QueryState state) {
        return new KernelPredicate<Entity>(null, state, variableOffset, predicate, incomingCtx){
            private final QueryState state$2;
            private final int variableOffset$1;
            private final Predicate predicate$1;
            private final ReadableRow incomingCtx$2;

            public boolean test(Entity t) {
                this.state$2.expressionVariables()[this.variableOffset$1] = ValueUtils.asNodeOrEdgeValue((Entity)t);
                return this.predicate$1.isTrue(this.incomingCtx$2, this.state$2);
            }
            {
                this.state$2 = state$2;
                this.variableOffset$1 = variableOffset$1;
                this.predicate$1 = predicate$1;
                this.incomingCtx$2 = incomingCtx$2;
            }
        };
    }

    private KernelPredicate<Entity> cypherNegativePredicatesAsExpander(ReadableRow incomingCtx, int variableOffset, Predicate predicate, QueryState state) {
        return new KernelPredicate<Entity>(null, state, variableOffset, predicate, incomingCtx){
            private final QueryState state$3;
            private final int variableOffset$2;
            private final Predicate predicate$2;
            private final ReadableRow incomingCtx$3;

            public boolean test(Entity t) {
                this.state$3.expressionVariables()[this.variableOffset$2] = ValueUtils.asNodeOrEdgeValue((Entity)t);
                return !this.predicate$2.isTrue(this.incomingCtx$3, this.state$3);
            }
            {
                this.state$3 = state$3;
                this.variableOffset$2 = variableOffset$2;
                this.predicate$2 = predicate$2;
                this.incomingCtx$3 = incomingCtx$3;
            }
        };
    }

    private Expression findPredicate(Predicate predicate) {
        Expression expression;
        CoercedPredicate coercedPredicate;
        Expression inner;
        Predicate predicate2 = predicate;
        if (predicate2 instanceof CoercedPredicate && (inner = (coercedPredicate = (CoercedPredicate)predicate2).inner()) instanceof ExtendedExpression) {
            ExtendedExpression extendedExpression = (ExtendedExpression)((Object)inner);
            expression = extendedExpression.legacy();
        } else {
            expression = predicate;
        }
        return expression;
    }

    private Expander addAllOrNoneRelationshipExpander(ReadableRow ctx, Expander currentExpander, boolean all, Predicate predicate, int relVariableOffset, QueryState state) {
        Not not;
        Predicate predicate2;
        Expander expander;
        Expression expression = this.findPredicate(predicate);
        if (expression instanceof PropertyExists) {
            PropertyExists propertyExists = (PropertyExists)expression;
            KeyToken propertyKey = propertyExists.propertyKey();
            expander = currentExpander.addRelationshipFilter(all ? this.propertyExistsExpander(propertyKey.name()) : this.propertyNotExistsExpander(propertyKey.name()));
        } else if (expression instanceof Not && (predicate2 = (not = (Not)expression).a()) instanceof PropertyExists) {
            PropertyExists propertyExists = (PropertyExists)predicate2;
            KeyToken propertyKey = propertyExists.propertyKey();
            expander = currentExpander.addRelationshipFilter(all ? this.propertyNotExistsExpander(propertyKey.name()) : this.propertyExistsExpander(propertyKey.name()));
        } else {
            expander = currentExpander.addRelationshipFilter(all ? this.cypherPositivePredicatesAsExpander(ctx, relVariableOffset, predicate, state) : this.cypherNegativePredicatesAsExpander(ctx, relVariableOffset, predicate, state));
        }
        return expander;
    }

    private Tuple2<Expander, Seq<KernelPredicate<Entity>>> addAllOrNoneNodeExpander(ReadableRow ctx, Expander currentExpander, boolean all, Predicate predicate, int relVariableOffset, Seq<KernelPredicate<Entity>> currentNodePredicates, QueryState state) {
        Not not;
        Predicate predicate2;
        KernelPredicate<Entity> kernelPredicate;
        Expression expression = this.findPredicate(predicate);
        if (expression instanceof PropertyExists) {
            PropertyExists propertyExists = (PropertyExists)expression;
            KeyToken propertyKey = propertyExists.propertyKey();
            kernelPredicate = all ? this.propertyExistsExpander(propertyKey.name()) : this.propertyNotExistsExpander(propertyKey.name());
        } else if (expression instanceof Not && (predicate2 = (not = (Not)expression).a()) instanceof PropertyExists) {
            PropertyExists propertyExists = (PropertyExists)predicate2;
            KeyToken propertyKey = propertyExists.propertyKey();
            kernelPredicate = all ? this.propertyNotExistsExpander(propertyKey.name()) : this.propertyExistsExpander(propertyKey.name());
        } else {
            kernelPredicate = all ? this.cypherPositivePredicatesAsExpander(ctx, relVariableOffset, predicate, state) : this.cypherNegativePredicatesAsExpander(ctx, relVariableOffset, predicate, state);
        }
        KernelPredicate<Entity> filter = kernelPredicate;
        return new Tuple2((Object)currentExpander.addNodeFilter(filter), currentNodePredicates.$colon$plus(filter, Seq$.MODULE$.canBuildFrom()));
    }

    private Expander makeRelationshipTypeExpander() {
        return this.shortestPathPattern().relTypes().isEmpty() ? Expanders$.MODULE$.allTypes(this.shortestPathPattern().dir()) : (Expander)this.shortestPathPattern().relTypes().foldLeft((Object)Expanders$.MODULE$.typeDir(), (Function2 & Serializable & scala.Serializable)(x0$1, x1$1) -> {
            Tuple2 tuple2 = new Tuple2(x0$1, x1$1);
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            TypeAndDirectionExpander e = (TypeAndDirectionExpander)tuple2._1();
            String t = (String)tuple2._2();
            TypeAndDirectionExpander typeAndDirectionExpander = e.add(t, this.shortestPathPattern().dir());
            return typeAndDirectionExpander;
        });
    }

    private Tuple2<Expander, Seq<KernelPredicate<Entity>>> addPredicates(ReadableRow ctx, Expander relTypeAndDirExpander, QueryState state) {
        return this.perStepPredicates().isEmpty() ? new Tuple2((Object)relTypeAndDirExpander, (Object)Nil$.MODULE$) : (Tuple2)((TraversableOnce)this.perStepPredicates().map((Function1 & Serializable & scala.Serializable)predicate -> this.findPredicate((Predicate)predicate), Seq$.MODULE$.canBuildFrom())).foldLeft((Object)new Tuple2((Object)relTypeAndDirExpander, (Object)Nil$.MODULE$), (arg_0, arg_1) -> ShortestPathExpression.$anonfun$addPredicates$2(this, ctx, state, arg_0, arg_1));
    }

    private boolean isNodesFunction(Expression expression) {
        boolean bl;
        block2: {
            while (true) {
                Expression expression2;
                if ((expression2 = expression) instanceof NodesFunction) {
                    bl = true;
                    break block2;
                }
                if (!(expression2 instanceof ExtendedExpression)) break;
                ExtendedExpression extendedExpression = (ExtendedExpression)((Object)expression2);
                expression = extendedExpression.legacy();
            }
            bl = false;
        }
        return bl;
    }

    private boolean isRelationshipsFunction(Expression expression) {
        boolean bl;
        block2: {
            while (true) {
                Expression expression2;
                if ((expression2 = expression) instanceof RelationshipFunction) {
                    bl = true;
                    break block2;
                }
                if (!(expression2 instanceof ExtendedExpression)) break;
                ExtendedExpression extendedExpression = (ExtendedExpression)((Object)expression2);
                expression = extendedExpression.legacy();
            }
            bl = false;
        }
        return bl;
    }

    public ShortestPathExpression copy(ShortestPath shortestPathPattern, Seq<Predicate> perStepPredicates, Seq<Predicate> fullPathPredicates, boolean withFallBack, boolean disallowSameNode, int operatorId) {
        return new ShortestPathExpression(shortestPathPattern, perStepPredicates, fullPathPredicates, withFallBack, disallowSameNode, operatorId);
    }

    public ShortestPath copy$default$1() {
        return this.shortestPathPattern();
    }

    public Seq<Predicate> copy$default$2() {
        return this.perStepPredicates();
    }

    public Seq<Predicate> copy$default$3() {
        return this.fullPathPredicates();
    }

    public boolean copy$default$4() {
        return this.withFallBack();
    }

    public boolean copy$default$5() {
        return this.disallowSameNode();
    }

    public int copy$default$6() {
        return this.operatorId();
    }

    public String productPrefix() {
        return "ShortestPathExpression";
    }

    public int productArity() {
        return 6;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.shortestPathPattern();
                break;
            }
            case 1: {
                object = this.perStepPredicates();
                break;
            }
            case 2: {
                object = this.fullPathPredicates();
                break;
            }
            case 3: {
                object = BoxesRunTime.boxToBoolean((boolean)this.withFallBack());
                break;
            }
            case 4: {
                object = BoxesRunTime.boxToBoolean((boolean)this.disallowSameNode());
                break;
            }
            case 5: {
                object = new Id(this.operatorId());
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(Integer.toString(x$1));
            }
        }
        return object;
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof ShortestPathExpression;
    }

    public int hashCode() {
        int n = -889275714;
        n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.shortestPathPattern()));
        n = Statics.mix((int)n, (int)Statics.anyHash(this.perStepPredicates()));
        n = Statics.mix((int)n, (int)Statics.anyHash(this.fullPathPredicates()));
        n = Statics.mix((int)n, (int)(this.withFallBack() ? 1231 : 1237));
        n = Statics.mix((int)n, (int)(this.disallowSameNode() ? 1231 : 1237));
        n = Statics.mix((int)n, (int)Statics.anyHash((Object)new Id(this.operatorId())));
        return Statics.finalizeHash((int)n, (int)6);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof ShortestPathExpression)) return false;
        boolean bl = true;
        if (!bl) return false;
        ShortestPathExpression shortestPathExpression = (ShortestPathExpression)x$1;
        ShortestPath shortestPath = this.shortestPathPattern();
        ShortestPath shortestPath2 = shortestPathExpression.shortestPathPattern();
        if (shortestPath == null) {
            if (shortestPath2 != null) {
                return false;
            }
        } else if (!((Object)shortestPath).equals(shortestPath2)) return false;
        Seq<Predicate> seq = this.perStepPredicates();
        Seq<Predicate> seq2 = shortestPathExpression.perStepPredicates();
        if (seq == null) {
            if (seq2 != null) {
                return false;
            }
        } else if (!seq.equals(seq2)) return false;
        Seq<Predicate> seq3 = this.fullPathPredicates();
        Seq<Predicate> seq4 = shortestPathExpression.fullPathPredicates();
        if (seq3 == null) {
            if (seq4 != null) {
                return false;
            }
        } else if (!seq3.equals(seq4)) return false;
        if (this.withFallBack() != shortestPathExpression.withFallBack()) return false;
        if (this.disallowSameNode() != shortestPathExpression.disallowSameNode()) return false;
        if (this.operatorId() != shortestPathExpression.operatorId()) return false;
        if (!shortestPathExpression.canEqual(this)) return false;
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$getMatches$2(Path p) {
        return p.length() == 0;
    }

    public static final /* synthetic */ boolean $anonfun$getMatches$6(ShortestPathExpression $this, Path p) {
        return $this.shortestPathPattern().allowZeroLength() || p.length() > 0;
    }

    /*
     * Unable to fully structure code
     */
    public static final /* synthetic */ Tuple2 $anonfun$addPredicates$2(ShortestPathExpression $this, ReadableRow ctx$1, QueryState state$4, Tuple2 x0$1, Expression x1$1) {
        block4: {
            block2: {
                block6: {
                    block5: {
                        block3: {
                            var7_5 = new Tuple2((Object)x0$1, (Object)x1$1);
                            if (var7_5 == null) break block2;
                            var8_6 = (Tuple2)var7_5._1();
                            predicate = (Expression)var7_5._2();
                            if (var8_6 == null) break block2;
                            currentExpander = (Expander)var8_6._1();
                            currentNodePredicates = (Seq)var8_6._2();
                            if (currentNodePredicates == null) break block2;
                            var12_10 = currentNodePredicates;
                            var13_11 = false;
                            var14_12 = null;
                            var15_13 = false;
                            var16_14 = null;
                            var17_15 = predicate;
                            if (!(var17_15 instanceof NoneInList)) break block3;
                            var13_11 = true;
                            var14_12 = (NoneInList)var17_15;
                            relFunction = var14_12.collection();
                            variableOffset = var14_12.innerVariableOffset();
                            innerPredicate = var14_12.inner();
                            if (!$this.isRelationshipsFunction(relFunction)) break block3;
                            expander = $this.addAllOrNoneRelationshipExpander(ctx$1, currentExpander, false, innerPredicate, variableOffset, state$4);
                            var6_20 = new Tuple2((Object)expander, (Object)var12_10);
                            break block4;
                        }
                        if (!(var17_15 instanceof AllInList)) break block5;
                        var15_13 = true;
                        var16_14 = (AllInList)var17_15;
                        relFunction = var16_14.collection();
                        variableOffset = var16_14.innerVariableOffset();
                        innerPredicate = var16_14.inner();
                        if (!$this.isRelationshipsFunction(relFunction)) break block5;
                        expander = $this.addAllOrNoneRelationshipExpander(ctx$1, currentExpander, true, innerPredicate, variableOffset, state$4);
                        var6_20 = new Tuple2((Object)expander, (Object)var12_10);
                        break block4;
                    }
                    if (!var13_11) break block6;
                    nodeFunction = var14_12.collection();
                    variableOffset = var14_12.innerVariableOffset();
                    innerPredicate = var14_12.inner();
                    if (!$this.isNodesFunction(nodeFunction)) break block6;
                    var6_20 = $this.addAllOrNoneNodeExpander(ctx$1, currentExpander, false, innerPredicate, variableOffset, (Seq<KernelPredicate<Entity>>)var12_10, state$4);
                    break block4;
                }
                if (!var15_13) ** GOTO lbl-1000
                nodeFunction = var16_14.collection();
                variableOffset = var16_14.innerVariableOffset();
                innerPredicate = var16_14.inner();
                if ($this.isNodesFunction(nodeFunction)) {
                    var6_20 = $this.addAllOrNoneNodeExpander(ctx$1, currentExpander, true, innerPredicate, variableOffset, (Seq<KernelPredicate<Entity>>)var12_10, state$4);
                } else lbl-1000:
                // 2 sources

                {
                    var6_20 = new Tuple2((Object)currentExpander, (Object)var12_10);
                }
                break block4;
            }
            throw new MatchError((Object)var7_5);
        }
        var5_31 = var6_20;
        return var5_31;
    }

    public ShortestPathExpression(ShortestPath shortestPathPattern, Seq<Predicate> perStepPredicates, Seq<Predicate> fullPathPredicates, boolean withFallBack, boolean disallowSameNode, int operatorId) {
        this.shortestPathPattern = shortestPathPattern;
        this.perStepPredicates = perStepPredicates;
        this.fullPathPredicates = fullPathPredicates;
        this.withFallBack = withFallBack;
        this.disallowSameNode = disallowSameNode;
        this.operatorId = operatorId;
        Product.$init$((Product)this);
        this.predicates = (Seq)perStepPredicates.$plus$plus(fullPathPredicates, Seq$.MODULE$.canBuildFrom());
    }
}

