/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.runtime.interpreted.commands.showcommands;

import java.io.Serializable;
import java.util.Optional;
import org.neo4j.cypher.internal.ast.ShowColumn;
import org.neo4j.cypher.internal.expressions.Expression;
import org.neo4j.cypher.internal.runtime.ClosingIterator;
import org.neo4j.cypher.internal.runtime.ClosingIterator$;
import org.neo4j.cypher.internal.runtime.QueryContext;
import org.neo4j.cypher.internal.runtime.interpreted.commands.showcommands.Command;
import org.neo4j.cypher.internal.runtime.interpreted.commands.showcommands.TerminateTransactionsCommand$;
import org.neo4j.cypher.internal.runtime.interpreted.commands.showcommands.TransactionCommandHelper$;
import org.neo4j.cypher.internal.runtime.interpreted.commands.showcommands.TransactionId;
import org.neo4j.cypher.internal.runtime.interpreted.commands.showcommands.TransactionId$;
import org.neo4j.cypher.internal.runtime.interpreted.pipes.QueryState;
import org.neo4j.dbms.database.DatabaseContext;
import org.neo4j.dbms.database.DatabaseManager;
import org.neo4j.exceptions.InvalidSemanticsException;
import org.neo4j.internal.kernel.api.security.AdminActionOnResource;
import org.neo4j.internal.kernel.api.security.PrivilegeAction;
import org.neo4j.internal.kernel.api.security.SecurityContext;
import org.neo4j.internal.kernel.api.security.Segment;
import org.neo4j.internal.kernel.api.security.UserSegment;
import org.neo4j.kernel.api.KernelTransactionHandle;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.database.DatabaseIdRepository;
import org.neo4j.kernel.database.NamedDatabaseId;
import org.neo4j.logging.Log;
import org.neo4j.values.AnyValue;
import org.neo4j.values.storable.Values;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Iterable;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;

@ScalaSignature(bytes="\u0006\u0001\u0005Ef\u0001B\r\u001b\u0001.B\u0001\"\u000f\u0001\u0003\u0016\u0004%\tA\u000f\u0005\t1\u0002\u0011\t\u0012)A\u0005w!A\u0011\f\u0001BK\u0002\u0013\u0005!\f\u0003\u0005c\u0001\tE\t\u0015!\u0003\\\u0011\u0015\u0019\u0007\u0001\"\u0001e\u0011\u0015A\u0007\u0001\"\u0011j\u0011!y\b!!A\u0005\u0002\u0005\u0005\u0001\"CA\u0004\u0001E\u0005I\u0011AA\u0005\u0011%\ty\u0002AI\u0001\n\u0003\t\t\u0003C\u0005\u0002&\u0001\t\t\u0011\"\u0011\u0002(!I\u0011q\u0007\u0001\u0002\u0002\u0013\u0005\u0011\u0011\b\u0005\n\u0003\u0003\u0002\u0011\u0011!C\u0001\u0003\u0007B\u0011\"a\u0014\u0001\u0003\u0003%\t%!\u0015\t\u0013\u0005}\u0003!!A\u0005\u0002\u0005\u0005\u0004\"CA6\u0001\u0005\u0005I\u0011IA7\u0011%\ty\u0007AA\u0001\n\u0003\n\t\bC\u0005\u0002t\u0001\t\t\u0011\"\u0011\u0002v\u001dI\u0011\u0011\u0010\u000e\u0002\u0002#\u0005\u00111\u0010\u0004\t3i\t\t\u0011#\u0001\u0002~!11m\u0005C\u0001\u0003\u0013C\u0011\"a\u001c\u0014\u0003\u0003%)%!\u001d\t\u0013\u0005-5#!A\u0005\u0002\u00065\u0005\"CAJ'\u0005\u0005I\u0011QAK\u0011%\t9kEA\u0001\n\u0013\tIK\u0001\u000fUKJl\u0017N\\1uKR\u0013\u0018M\\:bGRLwN\\:D_6l\u0017M\u001c3\u000b\u0005ma\u0012\u0001D:i_^\u001cw.\\7b]\u0012\u001c(BA\u000f\u001f\u0003!\u0019w.\\7b]\u0012\u001c(BA\u0010!\u0003-Ig\u000e^3saJ,G/\u001a3\u000b\u0005\u0005\u0012\u0013a\u0002:v]RLW.\u001a\u0006\u0003G\u0011\n\u0001\"\u001b8uKJt\u0017\r\u001c\u0006\u0003K\u0019\naaY=qQ\u0016\u0014(BA\u0014)\u0003\u0015qWm\u001c\u001bk\u0015\u0005I\u0013aA8sO\u000e\u00011\u0003\u0002\u0001-aY\u0002\"!\f\u0018\u000e\u0003iI!a\f\u000e\u0003\u000f\r{W.\\1oIB\u0011\u0011\u0007N\u0007\u0002e)\t1'A\u0003tG\u0006d\u0017-\u0003\u00026e\t9\u0001K]8ek\u000e$\bCA\u00198\u0013\tA$G\u0001\u0007TKJL\u0017\r\\5{C\ndW-\u0001\u0005hSZ,g.\u00133t+\u0005Y\u0004\u0003\u0002\u001fE\u000fJs!!\u0010\"\u000f\u0005y\nU\"A \u000b\u0005\u0001S\u0013A\u0002\u001fs_>$h(C\u00014\u0013\t\u0019%'A\u0004qC\u000e\\\u0017mZ3\n\u0005\u00153%AB#ji\",'O\u0003\u0002DeA\u0019A\b\u0013&\n\u0005%3%\u0001\u0002'jgR\u0004\"aS(\u000f\u00051k\u0005C\u0001 3\u0013\tq%'\u0001\u0004Qe\u0016$WMZ\u0005\u0003!F\u0013aa\u0015;sS:<'B\u0001(3!\t\u0019f+D\u0001U\u0015\t)&%A\u0006fqB\u0014Xm]:j_:\u001c\u0018BA,U\u0005))\u0005\u0010\u001d:fgNLwN\\\u0001\nO&4XM\\%eg\u0002\nqaY8mk6t7/F\u0001\\!\ra\u0004\n\u0018\t\u0003;\u0002l\u0011A\u0018\u0006\u0003?\n\n1!Y:u\u0013\t\tgL\u0001\u0006TQ><8i\u001c7v[:\f\u0001bY8mk6t7\u000fI\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0007\u00154w\r\u0005\u0002.\u0001!)\u0011(\u0002a\u0001w!)\u0011,\u0002a\u00017\u0006\u0001rN]5hS:\fGNT1nKJ{wo\u001d\u000b\u0003U^\u00042a\u001b7o\u001b\u0005\u0001\u0013BA7!\u0005=\u0019En\\:j]\u001eLE/\u001a:bi>\u0014\b\u0003B&p\u0015FL!\u0001])\u0003\u00075\u000b\u0007\u000f\u0005\u0002sk6\t1O\u0003\u0002uM\u00051a/\u00197vKNL!A^:\u0003\u0011\u0005s\u0017PV1mk\u0016DQ\u0001\u001f\u0004A\u0002e\fQa\u001d;bi\u0016\u0004\"A_?\u000e\u0003mT!\u0001 \u0010\u0002\u000bAL\u0007/Z:\n\u0005y\\(AC)vKJL8\u000b^1uK\u0006!1m\u001c9z)\u0015)\u00171AA\u0003\u0011\u001dIt\u0001%AA\u0002mBq!W\u0004\u0011\u0002\u0003\u00071,\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\u0005-!fA\u001e\u0002\u000e-\u0012\u0011q\u0002\t\u0005\u0003#\tY\"\u0004\u0002\u0002\u0014)!\u0011QCA\f\u0003%)hn\u00195fG.,GMC\u0002\u0002\u001aI\n!\"\u00198o_R\fG/[8o\u0013\u0011\ti\"a\u0005\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001a\u0016\u0005\u0005\r\"fA.\u0002\u000e\u0005i\u0001O]8ek\u000e$\bK]3gSb,\"!!\u000b\u0011\t\u0005-\u0012QG\u0007\u0003\u0003[QA!a\f\u00022\u0005!A.\u00198h\u0015\t\t\u0019$\u0001\u0003kCZ\f\u0017b\u0001)\u0002.\u0005a\u0001O]8ek\u000e$\u0018I]5usV\u0011\u00111\b\t\u0004c\u0005u\u0012bAA e\t\u0019\u0011J\u001c;\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR!\u0011QIA&!\r\t\u0014qI\u0005\u0004\u0003\u0013\u0012$aA!os\"I\u0011Q\n\u0007\u0002\u0002\u0003\u0007\u00111H\u0001\u0004q\u0012\n\u0014a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0005\u0005M\u0003CBA+\u00037\n)%\u0004\u0002\u0002X)\u0019\u0011\u0011\f\u001a\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002^\u0005]#\u0001C%uKJ\fGo\u001c:\u0002\u0011\r\fg.R9vC2$B!a\u0019\u0002jA\u0019\u0011'!\u001a\n\u0007\u0005\u001d$GA\u0004C_>dW-\u00198\t\u0013\u00055c\"!AA\u0002\u0005\u0015\u0013\u0001\u00035bg\"\u001cu\u000eZ3\u0015\u0005\u0005m\u0012\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0005\u0005%\u0012AB3rk\u0006d7\u000f\u0006\u0003\u0002d\u0005]\u0004\"CA'#\u0005\u0005\t\u0019AA#\u0003q!VM]7j]\u0006$X\r\u0016:b]N\f7\r^5p]N\u001cu.\\7b]\u0012\u0004\"!L\n\u0014\tM\tyH\u000e\t\b\u0003\u0003\u000b)iO.f\u001b\t\t\u0019I\u0003\u0002\"e%!\u0011qQAB\u0005E\t%m\u001d;sC\u000e$h)\u001e8di&|gN\r\u000b\u0003\u0003w\nQ!\u00199qYf$R!ZAH\u0003#CQ!\u000f\fA\u0002mBQ!\u0017\fA\u0002m\u000bq!\u001e8baBd\u0017\u0010\u0006\u0003\u0002\u0018\u0006\r\u0006#B\u0019\u0002\u001a\u0006u\u0015bAANe\t1q\n\u001d;j_:\u0004R!MAPwmK1!!)3\u0005\u0019!V\u000f\u001d7fe!A\u0011QU\f\u0002\u0002\u0003\u0007Q-A\u0002yIA\n1B]3bIJ+7o\u001c7wKR\u0011\u00111\u0016\t\u0005\u0003W\ti+\u0003\u0003\u00020\u00065\"AB(cU\u0016\u001cG\u000f")
public class TerminateTransactionsCommand
extends Command
implements Product,
scala.Serializable {
    private final Either<List<String>, Expression> givenIds;
    private final List<ShowColumn> columns;

    public static Option<Tuple2<Either<List<String>, Expression>, List<ShowColumn>>> unapply(TerminateTransactionsCommand terminateTransactionsCommand) {
        return TerminateTransactionsCommand$.MODULE$.unapply(terminateTransactionsCommand);
    }

    public static TerminateTransactionsCommand apply(Either<List<String>, Expression> either, List<ShowColumn> list) {
        return TerminateTransactionsCommand$.MODULE$.apply(either, list);
    }

    public static Function1<Tuple2<Either<List<String>, Expression>, List<ShowColumn>>, TerminateTransactionsCommand> tupled() {
        return TerminateTransactionsCommand$.MODULE$.tupled();
    }

    public static Function1<Either<List<String>, Expression>, Function1<List<ShowColumn>, TerminateTransactionsCommand>> curried() {
        return TerminateTransactionsCommand$.MODULE$.curried();
    }

    public Either<List<String>, Expression> givenIds() {
        return this.givenIds;
    }

    public List<ShowColumn> columns() {
        return this.columns;
    }

    @Override
    public ClosingIterator<Map<String, AnyValue>> originalNameRows(QueryState state) {
        List<String> ids = TransactionCommandHelper$.MODULE$.extractIds(this.givenIds(), state.params());
        if (ids.isEmpty()) {
            throw new InvalidSemanticsException("Missing transaction id to terminate, the transaction id can be found using `SHOW TRANSACTIONS`.");
        }
        QueryContext ctx = state.query();
        SecurityContext securityContext = ctx.transactionalContext().securityContext();
        String executingUser = securityContext.subject().executingUser();
        String authenticatedUser = securityContext.subject().authenticatedUser();
        String loggingUser = securityContext.impersonating() ? new StringBuilder(1).append(authenticatedUser).append(":").append(executingUser).toString() : executingUser;
        Log log = state.query().logProvider().getLog(this.getClass());
        log.info("User %s trying to terminate transactions: %s.", new Object[]{loggingUser, ids.mkString("[", ", ", "]")});
        DatabaseManager databaseManager = ctx.getDatabaseManager();
        DatabaseIdRepository.Caching databaseIdRepository = databaseManager.databaseIdRepository();
        Tuple2 tuple2 = (Tuple2)ids.foldLeft((Object)new Tuple2((Object)Predef$.MODULE$.Map().empty(), (Object)Predef$.MODULE$.Set().empty()), (Function2 & Serializable & scala.Serializable)(x0$1, x1$1) -> {
            Tuple2 tuple2;
            Tuple2 tuple22 = new Tuple2(x0$1, x1$1);
            if (tuple22 == null) throw new MatchError((Object)tuple22);
            Tuple2 tuple23 = (Tuple2)tuple22._1();
            String idText = (String)tuple22._2();
            if (tuple23 == null) throw new MatchError((Object)tuple22);
            Map accMap = (Map)tuple23._1();
            Set accSet = (Set)tuple23._2();
            TransactionId id = TransactionId$.MODULE$.parse(idText);
            Optional namedDatabaseId = databaseIdRepository.getByName(id.database());
            if (namedDatabaseId.isPresent()) {
                NamedDatabaseId databaseId = (NamedDatabaseId)namedDatabaseId.get();
                Set transactions = (Set)accMap.getOrElse((Object)databaseId, (Function0 & Serializable & scala.Serializable)() -> Predef$.MODULE$.Set().empty());
                tuple2 = new Tuple2((Object)accMap.$plus$plus((GenTraversableOnce)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)databaseId), (Object)transactions.$plus((Object)id))}))), (Object)accSet);
                return tuple2;
            } else {
                tuple2 = new Tuple2((Object)accMap, (Object)accSet.$plus((Object)id));
            }
            return tuple2;
        });
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Map transactionsByDatabase = (Map)tuple2._1();
        Set otherTxIds = (Set)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)transactionsByDatabase, (Object)otherTxIds);
        Tuple2 tuple23 = tuple22;
        Map transactionsByDatabase2 = (Map)tuple23._1();
        Set otherTxIds2 = (Set)tuple23._2();
        Iterable rows = (Iterable)transactionsByDatabase2.flatMap((Function1 & Serializable & scala.Serializable)x0$2 -> {
            Map map;
            Tuple2 tuple2 = x0$2;
            if (tuple2 == null) throw new MatchError((Object)tuple2);
            NamedDatabaseId databaseId = (NamedDatabaseId)tuple2._1();
            Set txIds = (Set)tuple2._2();
            if (databaseId == null) throw new MatchError((Object)tuple2);
            NamedDatabaseId namedDatabaseId = databaseId;
            if (txIds == null) throw new MatchError((Object)tuple2);
            Set set = txIds;
            Optional maybeDatabaseContext = databaseManager.getDatabaseContext(namedDatabaseId);
            String dbName = namedDatabaseId.name();
            if (maybeDatabaseContext.isPresent()) {
                DatabaseContext databaseContext = (DatabaseContext)maybeDatabaseContext.get();
                AdminActionOnResource.DatabaseScope dbScope = new AdminActionOnResource.DatabaseScope(dbName);
                map = ((TraversableOnce)((TraversableLike)TransactionCommandHelper$.MODULE$.getExecutingTransactions(databaseContext).map((Function1 & Serializable & scala.Serializable)tx -> {
                    TransactionId txIdRepresentation = TransactionId$.MODULE$.apply(dbName, tx.getUserTransactionId());
                    return new Tuple2((Object)txIdRepresentation, tx);
                }, Set$.MODULE$.canBuildFrom())).filter((Function1 & Serializable & scala.Serializable)x0$3 -> BoxesRunTime.boxToBoolean((boolean)TerminateTransactionsCommand.$anonfun$originalNameRows$5(dbScope, securityContext, set, x0$3)))).toMap(Predef$.MODULE$.$conforms());
            } else {
                map = Predef$.MODULE$.Map().empty();
            }
            Map allowedTransactions = map;
            return (Set)set.map((Function1 & Serializable & scala.Serializable)txId -> {
                Option txHandle = allowedTransactions.get(txId);
                Tuple2 tuple2 = (Tuple2)txHandle.map((Function1 & Serializable & scala.Serializable)x0$4 -> {
                    Tuple2 tuple2;
                    KernelTransactionHandle kernelTransactionHandle = x0$4;
                    if (kernelTransactionHandle.isClosing()) {
                        tuple2 = new Tuple2((Object)kernelTransactionHandle.subject().executingUser(), (Object)"Unable to terminate closing transactions.");
                    } else {
                        kernelTransactionHandle.markForTermination((Status)Status.Transaction.Terminated);
                        log.info("User %s terminated transaction %s.", new Object[]{loggingUser, txId.toString()});
                        tuple2 = new Tuple2((Object)kernelTransactionHandle.subject().executingUser(), (Object)"Transaction terminated.");
                    }
                    return tuple2;
                }).getOrElse((Function0 & Serializable & scala.Serializable)() -> new Tuple2(null, (Object)"Transaction not found."));
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                String username = (String)tuple2._1();
                String message = (String)tuple2._2();
                Tuple2 tuple22 = new Tuple2((Object)username, (Object)message);
                Tuple2 tuple23 = tuple22;
                String username2 = (String)tuple23._1();
                String message2 = (String)tuple23._2();
                return (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"transactionId"), (Object)Values.stringValue((String)txId.toString())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"username"), (Object)Values.stringOrNoValue((String)username2)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"message"), (Object)Values.stringValue((String)message2))}));
            }, Set$.MODULE$.canBuildFrom());
        }, Iterable$.MODULE$.canBuildFrom());
        Iterable updatedRows = (Iterable)rows.$plus$plus((GenTraversableOnce)otherTxIds2.map((Function1 & Serializable & scala.Serializable)txId -> (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"transactionId"), (Object)Values.stringValue((String)txId.toString())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"username"), (Object)Values.NO_VALUE), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"message"), (Object)Values.stringValue((String)"Transaction not found."))})), Set$.MODULE$.canBuildFrom()), Iterable$.MODULE$.canBuildFrom());
        return ClosingIterator$.MODULE$.apply(updatedRows.iterator());
    }

    public TerminateTransactionsCommand copy(Either<List<String>, Expression> givenIds, List<ShowColumn> columns) {
        return new TerminateTransactionsCommand(givenIds, columns);
    }

    public Either<List<String>, Expression> copy$default$1() {
        return this.givenIds();
    }

    public List<ShowColumn> copy$default$2() {
        return this.columns();
    }

    public String productPrefix() {
        return "TerminateTransactionsCommand";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        Either<List<String>, Expression> either;
        int n = x$1;
        switch (n) {
            case 0: {
                either = this.givenIds();
                break;
            }
            case 1: {
                either = this.columns();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(Integer.toString(x$1));
            }
        }
        return either;
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof TerminateTransactionsCommand;
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof TerminateTransactionsCommand)) return false;
        boolean bl = true;
        if (!bl) return false;
        TerminateTransactionsCommand terminateTransactionsCommand = (TerminateTransactionsCommand)x$1;
        Either<List<String>, Expression> either = this.givenIds();
        Either<List<String>, Expression> either2 = terminateTransactionsCommand.givenIds();
        if (either == null) {
            if (either2 != null) {
                return false;
            }
        } else if (!either.equals(either2)) return false;
        List<ShowColumn> list = this.columns();
        List<ShowColumn> list2 = terminateTransactionsCommand.columns();
        if (list == null) {
            if (list2 != null) {
                return false;
            }
        } else if (!list.equals(list2)) return false;
        if (!terminateTransactionsCommand.canEqual(this)) return false;
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$originalNameRows$5(AdminActionOnResource.DatabaseScope dbScope$1, SecurityContext securityContext$1, Set x3$1, Tuple2 x0$3) {
        AdminActionOnResource action;
        Tuple2 tuple2 = x0$3;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        TransactionId txIdRepresentation = (TransactionId)tuple2._1();
        KernelTransactionHandle tx = (KernelTransactionHandle)tuple2._2();
        String username = tx.subject().executingUser();
        boolean bl = TransactionCommandHelper$.MODULE$.isSelfOrAllows(username, action = new AdminActionOnResource(PrivilegeAction.TERMINATE_TRANSACTION, dbScope$1, (Segment)new UserSegment(username)), securityContext$1) && x3$1.contains((Object)txIdRepresentation);
        return bl;
    }

    public TerminateTransactionsCommand(Either<List<String>, Expression> givenIds, List<ShowColumn> columns) {
        this.givenIds = givenIds;
        this.columns = columns;
        super(columns);
        Product.$init$((Product)this);
    }
}

