/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.runtime.interpreted.pipes;

import java.io.Serializable;
import org.neo4j.cypher.internal.runtime.ClosingIterator;
import org.neo4j.cypher.internal.runtime.ClosingIterator$;
import org.neo4j.cypher.internal.runtime.CypherRow;
import org.neo4j.cypher.internal.runtime.EntityTransformer;
import org.neo4j.cypher.internal.runtime.QueryStatistics;
import org.neo4j.cypher.internal.runtime.QueryStatistics$;
import org.neo4j.cypher.internal.runtime.QueryTransactionalContext;
import org.neo4j.cypher.internal.runtime.interpreted.commands.expressions.Expression;
import org.neo4j.cypher.internal.runtime.interpreted.pipes.Pipe;
import org.neo4j.cypher.internal.runtime.interpreted.pipes.PipeHelper$;
import org.neo4j.cypher.internal.runtime.interpreted.pipes.QueryState;
import org.neo4j.exceptions.InternalException;
import scala.Function1;
import scala.Option;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.java8.JFunction1;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\u0005Ua\u0001C\b\u0011!\u0003\r\ta\b9\t\u000b\u0019\u0002A\u0011A\u0014\t\u000f-\u0002!\u0019!D\u0001Y!)\u0011\u0007\u0001C\u0001e!)!\n\u0001C\u0001\u0017\")a\n\u0001C\u0005\u001f\")q\u000b\u0001C\u00011\")\u0001\r\u0001C\u0001C\u001e)q\u000f\u0005E\u0001q\u001a)q\u0002\u0005E\u0001s\")!0\u0003C\u0001w\u001a!A0\u0003\u0001~\u0011!q8B!A!\u0002\u0013y\bB\u0002>\f\t\u0003\t)\u0001C\u0004\u0002\u000e-!\t!a\u0004\u0003\u001fQ\u0013\u0018M\\:bGRLwN\u001c)ja\u0016T!!\u0005\n\u0002\u000bAL\u0007/Z:\u000b\u0005M!\u0012aC5oi\u0016\u0014\bO]3uK\u0012T!!\u0006\f\u0002\u000fI,h\u000e^5nK*\u0011q\u0003G\u0001\tS:$XM\u001d8bY*\u0011\u0011DG\u0001\u0007Gf\u0004\b.\u001a:\u000b\u0005ma\u0012!\u00028f_RR'\"A\u000f\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0005\u0001\u0001\u0003CA\u0011%\u001b\u0005\u0011#\"A\u0012\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0015\u0012#AB!osJ+g-\u0001\u0004%S:LG\u000f\n\u000b\u0002QA\u0011\u0011%K\u0005\u0003U\t\u0012A!\u00168ji\u0006)\u0011N\u001c8feV\tQ\u0006\u0005\u0002/_5\t\u0001#\u0003\u00021!\t!\u0001+\u001b9f\u0003U\u0011XO\\%o]\u0016\u0014\u0018J\u001c+sC:\u001c\u0018m\u0019;j_:$2\u0001K\u001a9\u0011\u0015!4\u00011\u00016\u0003\u0015\u0019H/\u0019;f!\tqc'\u0003\u00028!\tQ\u0011+^3ssN#\u0018\r^3\t\u000be\u001a\u0001\u0019\u0001\u001e\u0002\u000b\t\fGo\u00195\u0011\u0007m\u001aeI\u0004\u0002=\u0003:\u0011Q\bQ\u0007\u0002})\u0011qHH\u0001\u0007yI|w\u000e\u001e \n\u0003\rJ!A\u0011\u0012\u0002\u000fA\f7m[1hK&\u0011A)\u0012\u0002\u0004'\u0016\f(B\u0001\"#!\t9\u0005*D\u0001\u0015\u0013\tIECA\u0005DsBDWM\u001d*po\u0006y\"/\u001e8J]:,'/\u00138Ue\u0006t7/Y2uS>t7*Z3q%\u0016\u001cX\u000f\u001c;\u0015\u0007ibU\nC\u00035\t\u0001\u0007Q\u0007C\u0003:\t\u0001\u0007!(\u0001\u0011j]R,'O\\1m\u0007J,\u0017\r^3SKN,H\u000e^:G_J|e.\u001a\"bi\u000eDG\u0003\u0002\u001eQ#JCQ\u0001N\u0003A\u0002UBQ!O\u0003A\u0002iBQaU\u0003A\u0002Q\u000b1b[3faJ+7/\u001e7ugB\u0011\u0011%V\u0005\u0003-\n\u0012qAQ8pY\u0016\fg.\u0001\tj]:+w\u000f\u0016:b]N\f7\r^5p]R\u0011\u0011l\u0018\u000b\u0003uiCQa\u0017\u0004A\u0002q\u000b\u0011A\u001a\t\u0005Cu+$(\u0003\u0002_E\tIa)\u001e8di&|g.\r\u0005\u0006i\u0019\u0001\r!N\u0001\u0012KZ\fG.^1uK\n\u000bGo\u00195TSj,Gc\u00012f_B\u0011\u0011eY\u0005\u0003I\n\u0012A\u0001T8oO\")am\u0002a\u0001O\u0006I!-\u0019;dQNK'0\u001a\t\u0003Q6l\u0011!\u001b\u0006\u0003U.\f1\"\u001a=qe\u0016\u001c8/[8og*\u0011ANE\u0001\tG>lW.\u00198eg&\u0011a.\u001b\u0002\u000b\u000bb\u0004(/Z:tS>t\u0007\"\u0002\u001b\b\u0001\u0004)$cA9ti\u001a!!\u000f\u0001\u0001q\u00051a$/\u001a4j]\u0016lWM\u001c;?!\tq\u0003\u0001\u0005\u0002/k&\u0011a\u000f\u0005\u0002\u000f!&\u0004XmV5uQN{WO]2f\u0003=!&/\u00198tC\u000e$\u0018n\u001c8QSB,\u0007C\u0001\u0018\n'\tI\u0001%\u0001\u0004=S:LGO\u0010\u000b\u0002q\nQ2)\u001f9iKJ\u0014vn^#oi&$\u0018\u0010\u0016:b]N4wN]7feN\u00111\u0002I\u0001\u0012K:$\u0018\u000e^=Ue\u0006t7OZ8s[\u0016\u0014\bcA$\u0002\u0002%\u0019\u00111\u0001\u000b\u0003#\u0015sG/\u001b;z)J\fgn\u001d4pe6,'\u000f\u0006\u0003\u0002\b\u0005-\u0001cAA\u0005\u00175\t\u0011\u0002C\u0003\u007f\u001b\u0001\u0007q0A\u0012d_BLx+\u001b;i\u000b:$\u0018\u000e^=Xe\u0006\u0004\b/\u001b8h-\u0006dW/Z:SK\n|WO\u001c3\u0015\u0007\u0019\u000b\t\u0002\u0003\u0004\u0002\u00149\u0001\rAR\u0001\u0004e><\b")
public interface TransactionPipe {
    public Pipe inner();

    public static /* synthetic */ void runInnerInTransaction$(TransactionPipe $this, QueryState state, Seq batch) {
        $this.runInnerInTransaction(state, (Seq<CypherRow>)batch);
    }

    default public void runInnerInTransaction(QueryState state, Seq<CypherRow> batch) {
        this.internalCreateResultsForOneBatch(state, batch, false);
    }

    public static /* synthetic */ Seq runInnerInTransactionKeepResult$(TransactionPipe $this, QueryState state, Seq batch) {
        return $this.runInnerInTransactionKeepResult(state, (Seq<CypherRow>)batch);
    }

    default public Seq<CypherRow> runInnerInTransactionKeepResult(QueryState state, Seq<CypherRow> batch) {
        return this.internalCreateResultsForOneBatch(state, batch, true);
    }

    private Seq<CypherRow> internalCreateResultsForOneBatch(QueryState state, Seq<CypherRow> batch, boolean keepResults) {
        return this.inNewTransaction(state, (Function1<QueryState, Seq<CypherRow>>)(Function1 & Serializable & scala.Serializable)stateWithNewTransaction -> {
            CypherRowEntityTransformer entityTransformer = new CypherRowEntityTransformer(stateWithNewTransaction.query().entityTransformer());
            Seq result = (Seq)batch.flatMap((Function1 & Serializable & scala.Serializable)outerRow -> {
                ClosingIterator closingIterator;
                outerRow.invalidateCachedProperties();
                CypherRow reboundRow = entityTransformer.copyWithEntityWrappingValuesRebound((CypherRow)outerRow);
                QueryState innerState = stateWithNewTransaction.withInitialContext(reboundRow);
                ClosingIterator result = this.inner().createResults(innerState);
                if (!keepResults) {
                    while (result.hasNext()) {
                        result.next();
                    }
                    closingIterator = ClosingIterator$.MODULE$.empty();
                } else {
                    closingIterator = result;
                }
                return closingIterator;
            }, Seq$.MODULE$.canBuildFrom());
            QueryStatistics subqueryStatistics = stateWithNewTransaction.getStatistics();
            state.query().addStatistics(subqueryStatistics);
            return result;
        });
    }

    public static /* synthetic */ Seq inNewTransaction$(TransactionPipe $this, QueryState state, Function1 f) {
        return $this.inNewTransaction(state, (Function1<QueryState, Seq<CypherRow>>)f);
    }

    default public Seq<CypherRow> inNewTransaction(QueryState state, Function1<QueryState, Seq<CypherRow>> f) {
        Seq seq;
        if (state.query().transactionalContext().dataRead().transactionStateHasChanges()) {
            throw new InternalException("Expected transaction state to be empty when calling transactional subquery.");
        }
        QueryState stateWithNewTransaction = state.withNewTransaction();
        QueryTransactionalContext innerTxContext = stateWithNewTransaction.query().transactionalContext();
        try {
            try {
                Seq result = (Seq)f.apply((Object)stateWithNewTransaction);
                innerTxContext.close();
                innerTxContext.commitTransaction();
                int x$1 = 1;
                int x$2 = QueryStatistics$.MODULE$.apply$default$1();
                int x$3 = QueryStatistics$.MODULE$.apply$default$2();
                int x$4 = QueryStatistics$.MODULE$.apply$default$3();
                int x$5 = QueryStatistics$.MODULE$.apply$default$4();
                int x$6 = QueryStatistics$.MODULE$.apply$default$5();
                int x$7 = QueryStatistics$.MODULE$.apply$default$6();
                int x$8 = QueryStatistics$.MODULE$.apply$default$7();
                int x$9 = QueryStatistics$.MODULE$.apply$default$8();
                int x$10 = QueryStatistics$.MODULE$.apply$default$9();
                int x$11 = QueryStatistics$.MODULE$.apply$default$10();
                int x$12 = QueryStatistics$.MODULE$.apply$default$11();
                int x$13 = QueryStatistics$.MODULE$.apply$default$12();
                int x$14 = QueryStatistics$.MODULE$.apply$default$13();
                int x$15 = QueryStatistics$.MODULE$.apply$default$14();
                int x$16 = QueryStatistics$.MODULE$.apply$default$15();
                int x$17 = QueryStatistics$.MODULE$.apply$default$16();
                int x$18 = QueryStatistics$.MODULE$.apply$default$18();
                QueryStatistics executionStatistics = new QueryStatistics(x$2, x$3, x$4, x$5, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, x$16, x$17, x$1, x$18);
                state.query().addStatistics(executionStatistics);
                seq = result;
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                Option option = NonFatal$.MODULE$.unapply(throwable2);
                if (!option.isEmpty()) {
                    Throwable e;
                    block11: {
                        e = (Throwable)option.get();
                        try {
                            innerTxContext.rollback();
                        }
                        catch (Throwable throwable3) {
                            Throwable throwable4 = throwable3;
                            Option option2 = NonFatal$.MODULE$.unapply(throwable4);
                            if (!option2.isEmpty()) {
                                Throwable rollbackException = (Throwable)option2.get();
                                e.addSuppressed(rollbackException);
                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                break block11;
                            }
                            throw throwable3;
                        }
                    }
                    throw e;
                }
                throw throwable;
            }
        }
        finally {
            innerTxContext.close();
            stateWithNewTransaction.close();
        }
        return seq;
    }

    public static /* synthetic */ long evaluateBatchSize$(TransactionPipe $this, Expression batchSize, QueryState state) {
        return $this.evaluateBatchSize(batchSize, state);
    }

    default public long evaluateBatchSize(Expression batchSize, QueryState state) {
        return PipeHelper$.MODULE$.evaluateStaticLongOrThrow(batchSize, (Function1<Object, Object>)(JFunction1.mcZJ.sp & Serializable & scala.Serializable)x$1 -> x$1 > 0L, state, "OF ... ROWS", " Must be a positive integer.");
    }

    public static void $init$(TransactionPipe $this) {
    }

    public static class CypherRowEntityTransformer {
        private final EntityTransformer entityTransformer;

        public CypherRow copyWithEntityWrappingValuesRebound(CypherRow row) {
            return row.copyMapped((Function1 & Serializable & scala.Serializable)value -> $this.entityTransformer.rebindEntityWrappingValue(value));
        }

        public CypherRowEntityTransformer(EntityTransformer entityTransformer) {
            this.entityTransformer = entityTransformer;
        }
    }
}

