/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.runtime.interpreted.pipes;

import java.lang.constant.Constable;
import org.neo4j.cypher.internal.runtime.IsNoValue$;
import org.neo4j.cypher.internal.runtime.interpreted.commands.expressions.Expression;
import org.neo4j.cypher.internal.runtime.interpreted.pipes.DeletePipe;
import org.neo4j.cypher.internal.runtime.interpreted.pipes.Pipe;
import org.neo4j.cypher.internal.runtime.interpreted.pipes.QueryState;
import org.neo4j.cypher.internal.util.attribution.Id$;
import org.neo4j.exceptions.CypherTypeException;
import org.neo4j.values.AnyValue;
import org.neo4j.values.virtual.NodeValue;
import org.neo4j.values.virtual.PathValue;
import org.neo4j.values.virtual.RelationshipValue;
import scala.None$;
import scala.Option;
import scala.Serializable;
import scala.Some;
import scala.Tuple3;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class DeletePipe$
implements Serializable {
    public static DeletePipe$ MODULE$;

    static {
        new DeletePipe$();
    }

    public int $lessinit$greater$default$4(Pipe src, Expression expression, boolean forced) {
        return Id$.MODULE$.INVALID_ID();
    }

    public void delete(AnyValue toDelete, QueryState state, boolean forced) {
        AnyValue anyValue = toDelete;
        if (IsNoValue$.MODULE$.unapply(anyValue)) {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (anyValue instanceof RelationshipValue) {
            RelationshipValue relationshipValue = (RelationshipValue)anyValue;
            this.deleteRelationship(relationshipValue, state);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (anyValue instanceof NodeValue) {
            NodeValue nodeValue = (NodeValue)anyValue;
            this.deleteNode(nodeValue, state, forced);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (anyValue instanceof PathValue) {
            PathValue pathValue = (PathValue)anyValue;
            this.deletePath(pathValue, state, forced);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new CypherTypeException(new StringBuilder(49).append("Expected a Node, Relationship or Path, but got a ").append(anyValue.getClass().getSimpleName()).toString());
        }
    }

    private Object deleteNode(NodeValue n, QueryState state, boolean forced) {
        return !state.query().nodeOps().isDeletedInThisTx(n.id()) ? (forced ? (Constable)BoxesRunTime.boxToInteger((int)state.query().detachDeleteNode(n.id())) : (Constable)BoxesRunTime.boxToBoolean((boolean)state.query().nodeOps().delete(n.id()))) : BoxedUnit.UNIT;
    }

    private void deleteRelationship(RelationshipValue r, QueryState state) {
        block0: {
            if (state.query().relationshipOps().isDeletedInThisTx(r.id())) break block0;
            state.query().relationshipOps().delete(r.id());
        }
    }

    private void deletePath(PathValue p, QueryState state, boolean forced) {
        for (AnyValue anyValue : p.asList()) {
            Object object;
            if (anyValue instanceof NodeValue) {
                NodeValue nodeValue = (NodeValue)anyValue;
                object = this.deleteNode(nodeValue, state, forced);
                continue;
            }
            if (anyValue instanceof RelationshipValue) {
                RelationshipValue relationshipValue = (RelationshipValue)anyValue;
                this.deleteRelationship(relationshipValue, state);
                object = BoxedUnit.UNIT;
                continue;
            }
            throw new CypherTypeException(new StringBuilder(43).append("Expected a Node or Relationship, but got a ").append(anyValue.getClass().getSimpleName()).toString());
        }
    }

    public DeletePipe apply(Pipe src, Expression expression, boolean forced, int id) {
        return new DeletePipe(src, expression, forced, id);
    }

    public int apply$default$4(Pipe src, Expression expression, boolean forced) {
        return Id$.MODULE$.INVALID_ID();
    }

    public Option<Tuple3<Pipe, Expression, Object>> unapply(DeletePipe x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple3((Object)x$0.src(), (Object)x$0.expression(), (Object)BoxesRunTime.boxToBoolean((boolean)x$0.forced())));
    }

    private Object readResolve() {
        return MODULE$;
    }

    private DeletePipe$() {
        MODULE$ = this;
    }
}

