/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.runtime.interpreted.pipes.aggregation;

import java.io.Serializable;
import org.neo4j.cypher.internal.runtime.ReadableRow;
import org.neo4j.cypher.internal.runtime.interpreted.commands.expressions.Expression;
import org.neo4j.cypher.internal.runtime.interpreted.pipes.QueryState;
import org.neo4j.cypher.internal.runtime.interpreted.pipes.aggregation.AggregationFunction;
import org.neo4j.cypher.internal.runtime.interpreted.pipes.aggregation.NumericOrDurationAggregationExpression;
import org.neo4j.cypher.internal.runtime.interpreted.pipes.aggregation.NumericOrDurationAggregationExpression$AggregatingDurations$;
import org.neo4j.cypher.internal.runtime.interpreted.pipes.aggregation.NumericOrDurationAggregationExpression$AggregatingNumbers$;
import org.neo4j.exceptions.InternalException;
import org.neo4j.values.AnyValue;
import org.neo4j.values.storable.DurationValue;
import org.neo4j.values.storable.NumberValue;
import org.neo4j.values.utils.ValueMath;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001]3Aa\u0002\u0005\u00013!A\u0011\u0005\u0001BC\u0002\u0013\u0005!\u0005\u0003\u0005,\u0001\t\u0005\t\u0015!\u0003$\u0011\u0015a\u0003\u0001\"\u0001.\u0011\u0015\u0001\u0004\u0001\"\u00012\u0011\u0015Q\u0004\u0001\"\u0011<\u0011\u0015A\u0005\u0001\"\u0011J\u0005-\u0019V/\u001c$v]\u000e$\u0018n\u001c8\u000b\u0005%Q\u0011aC1hOJ,w-\u0019;j_:T!a\u0003\u0007\u0002\u000bAL\u0007/Z:\u000b\u00055q\u0011aC5oi\u0016\u0014\bO]3uK\u0012T!a\u0004\t\u0002\u000fI,h\u000e^5nK*\u0011\u0011CE\u0001\tS:$XM\u001d8bY*\u00111\u0003F\u0001\u0007Gf\u0004\b.\u001a:\u000b\u0005U1\u0012!\u00028f_RR'\"A\f\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0007\u0001Qb\u0004\u0005\u0002\u001c95\t\u0001\"\u0003\u0002\u001e\u0011\t\u0019\u0012iZ4sK\u001e\fG/[8o\rVt7\r^5p]B\u00111dH\u0005\u0003A!\u0011aET;nKJL7m\u0014:EkJ\fG/[8o\u0003\u001e<'/Z4bi&|g.\u0012=qe\u0016\u001c8/[8o\u0003\u00151\u0018\r\\;f+\u0005\u0019\u0003C\u0001\u0013*\u001b\u0005)#B\u0001\u0014(\u0003-)\u0007\u0010\u001d:fgNLwN\\:\u000b\u0005!b\u0011\u0001C2p[6\fg\u000eZ:\n\u0005)*#AC#yaJ,7o]5p]\u00061a/\u00197vK\u0002\na\u0001P5oSRtDC\u0001\u00180!\tY\u0002\u0001C\u0003\"\u0007\u0001\u00071%\u0001\u0003oC6,W#\u0001\u001a\u0011\u0005MBT\"\u0001\u001b\u000b\u0005U2\u0014\u0001\u00027b]\u001eT\u0011aN\u0001\u0005U\u00064\u0018-\u0003\u0002:i\t11\u000b\u001e:j]\u001e\faA]3tk2$HC\u0001\u001fC!\ti\u0004)D\u0001?\u0015\tyD#\u0001\u0004wC2,Xm]\u0005\u0003\u0003z\u0012\u0001\"\u00118z-\u0006dW/\u001a\u0005\u0006\u0007\u0016\u0001\r\u0001R\u0001\u0006gR\fG/\u001a\t\u0003\u000b\u001ak\u0011AC\u0005\u0003\u000f*\u0011!\"U;fef\u001cF/\u0019;f\u0003\u0015\t\u0007\u000f\u001d7z)\rQ\u0005K\u0016\t\u0003\u0017:k\u0011\u0001\u0014\u0006\u0002\u001b\u0006)1oY1mC&\u0011q\n\u0014\u0002\u0005+:LG\u000fC\u0003R\r\u0001\u0007!+\u0001\u0003eCR\f\u0007CA*U\u001b\u0005q\u0011BA+\u000f\u0005-\u0011V-\u00193bE2,'k\\<\t\u000b\r3\u0001\u0019\u0001#")
public class SumFunction
extends AggregationFunction
implements NumericOrDurationAggregationExpression {
    private final Expression value;
    private volatile NumericOrDurationAggregationExpression$AggregatingNumbers$ AggregatingNumbers$module;
    private volatile NumericOrDurationAggregationExpression$AggregatingDurations$ AggregatingDurations$module;
    private NumberValue sumNumber;
    private DurationValue sumDuration;
    private Option<NumericOrDurationAggregationExpression.AggregatingType> aggregatingType;

    @Override
    public void actOnNumberOrDuration(AnyValue vl, Function1<NumberValue, BoxedUnit> aggNumber, Function1<DurationValue, BoxedUnit> aggDuration) {
        NumericOrDurationAggregationExpression.actOnNumberOrDuration$(this, vl, aggNumber, aggDuration);
    }

    @Override
    public NumericOrDurationAggregationExpression$AggregatingNumbers$ AggregatingNumbers() {
        if (this.AggregatingNumbers$module == null) {
            this.AggregatingNumbers$lzycompute$1();
        }
        return this.AggregatingNumbers$module;
    }

    @Override
    public NumericOrDurationAggregationExpression$AggregatingDurations$ AggregatingDurations() {
        if (this.AggregatingDurations$module == null) {
            this.AggregatingDurations$lzycompute$1();
        }
        return this.AggregatingDurations$module;
    }

    @Override
    public NumberValue sumNumber() {
        return this.sumNumber;
    }

    @Override
    public void sumNumber_$eq(NumberValue x$1) {
        this.sumNumber = x$1;
    }

    @Override
    public DurationValue sumDuration() {
        return this.sumDuration;
    }

    @Override
    public void sumDuration_$eq(DurationValue x$1) {
        this.sumDuration = x$1;
    }

    @Override
    public Option<NumericOrDurationAggregationExpression.AggregatingType> aggregatingType() {
        return this.aggregatingType;
    }

    @Override
    public void aggregatingType_$eq(Option<NumericOrDurationAggregationExpression.AggregatingType> x$1) {
        this.aggregatingType = x$1;
    }

    @Override
    public Expression value() {
        return this.value;
    }

    @Override
    public String name() {
        return "SUM";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public AnyValue result(QueryState state) {
        boolean bl = false;
        Some some = null;
        Option<NumericOrDurationAggregationExpression.AggregatingType> option = this.aggregatingType();
        if (None$.MODULE$.equals(option)) {
            return this.sumNumber();
        }
        if (option instanceof Some) {
            bl = true;
            some = (Some)option;
            NumericOrDurationAggregationExpression.AggregatingType aggregatingType = (NumericOrDurationAggregationExpression.AggregatingType)some.value();
            if (this.AggregatingNumbers().equals(aggregatingType)) {
                return this.sumNumber();
            }
        }
        if (!bl) throw new InternalException(new StringBuilder(25).append("invalid aggregation type ").append(this.aggregatingType()).toString());
        NumericOrDurationAggregationExpression.AggregatingType aggregatingType = (NumericOrDurationAggregationExpression.AggregatingType)some.value();
        if (!this.AggregatingDurations().equals(aggregatingType)) throw new InternalException(new StringBuilder(25).append("invalid aggregation type ").append(this.aggregatingType()).toString());
        return this.sumDuration();
    }

    @Override
    public void apply(ReadableRow data, QueryState state) {
        AnyValue vl = this.value().apply(data, state);
        this.actOnNumberOrDuration(vl, (Function1<NumberValue, BoxedUnit>)(Function1 & Serializable & scala.Serializable)number -> {
            this.sumNumber_$eq(ValueMath.overflowSafeAdd((NumberValue)this.sumNumber(), (NumberValue)number));
            return BoxedUnit.UNIT;
        }, (Function1<DurationValue, BoxedUnit>)(Function1 & Serializable & scala.Serializable)duration -> {
            this.sumDuration_$eq(this.sumDuration().add(duration));
            return BoxedUnit.UNIT;
        });
    }

    private final void AggregatingNumbers$lzycompute$1() {
        SumFunction sumFunction = this;
        synchronized (sumFunction) {
            if (this.AggregatingNumbers$module == null) {
                this.AggregatingNumbers$module = new NumericOrDurationAggregationExpression$AggregatingNumbers$(this);
            }
        }
    }

    private final void AggregatingDurations$lzycompute$1() {
        SumFunction sumFunction = this;
        synchronized (sumFunction) {
            if (this.AggregatingDurations$module == null) {
                this.AggregatingDurations$module = new NumericOrDurationAggregationExpression$AggregatingDurations$(this);
            }
        }
    }

    public SumFunction(Expression value) {
        this.value = value;
        NumericOrDurationAggregationExpression.$init$(this);
    }
}

