/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.runtime.interpreted;

import java.io.Serializable;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetTime;
import java.time.ZonedDateTime;
import java.time.temporal.TemporalAmount;
import java.util.Collection;
import java.util.Map;
import org.neo4j.cypher.internal.util.symbols.AnyType;
import org.neo4j.cypher.internal.util.symbols.BooleanType;
import org.neo4j.cypher.internal.util.symbols.CypherType;
import org.neo4j.cypher.internal.util.symbols.DateTimeType;
import org.neo4j.cypher.internal.util.symbols.DateType;
import org.neo4j.cypher.internal.util.symbols.DurationType;
import org.neo4j.cypher.internal.util.symbols.FloatType;
import org.neo4j.cypher.internal.util.symbols.GeometryType;
import org.neo4j.cypher.internal.util.symbols.IntegerType;
import org.neo4j.cypher.internal.util.symbols.ListType$;
import org.neo4j.cypher.internal.util.symbols.LocalDateTimeType;
import org.neo4j.cypher.internal.util.symbols.LocalTimeType;
import org.neo4j.cypher.internal.util.symbols.MapType;
import org.neo4j.cypher.internal.util.symbols.NodeType;
import org.neo4j.cypher.internal.util.symbols.NumberType;
import org.neo4j.cypher.internal.util.symbols.PathType;
import org.neo4j.cypher.internal.util.symbols.PointType;
import org.neo4j.cypher.internal.util.symbols.RelationshipType;
import org.neo4j.cypher.internal.util.symbols.StringType;
import org.neo4j.cypher.internal.util.symbols.TimeType;
import org.neo4j.cypher.internal.util.symbols.package$;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Path;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.spatial.Geometry;
import org.neo4j.graphdb.spatial.Point;
import org.neo4j.kernel.impl.util.ValueUtils;
import org.neo4j.values.AnyValue;
import org.neo4j.values.storable.ArrayValue;
import org.neo4j.values.storable.DateTimeValue;
import org.neo4j.values.storable.DateValue;
import org.neo4j.values.storable.LocalDateTimeValue;
import org.neo4j.values.storable.LocalTimeValue;
import org.neo4j.values.storable.TimeValue;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;
import org.neo4j.values.virtual.ListValue;
import org.neo4j.values.virtual.MapValue;
import org.neo4j.values.virtual.MapValueBuilder;
import org.neo4j.values.virtual.VirtualValues;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.TraversableOnce;
import scala.collection.TraversableOnce$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public final class ValueConversion$ {
    public static ValueConversion$ MODULE$;

    static {
        new ValueConversion$();
    }

    public Function1<Object, AnyValue> getValueConverter(CypherType cType) {
        Function1 & Serializable & scala.Serializable intersect;
        CypherType cypherType = cType;
        NodeType nodeType = package$.MODULE$.CTNode();
        CypherType cypherType2 = cypherType;
        if (!(nodeType != null ? !nodeType.equals(cypherType2) : cypherType2 != null)) {
            intersect = (Function1 & Serializable & scala.Serializable)n -> ValueUtils.fromNodeEntity((Node)((Node)n));
        } else {
            RelationshipType relationshipType = package$.MODULE$.CTRelationship();
            CypherType cypherType3 = cypherType;
            if (!(relationshipType != null ? !relationshipType.equals(cypherType3) : cypherType3 != null)) {
                intersect = (Function1 & Serializable & scala.Serializable)r -> ValueUtils.fromRelationshipEntity((Relationship)((Relationship)r));
            } else {
                BooleanType booleanType = package$.MODULE$.CTBoolean();
                CypherType cypherType4 = cypherType;
                if (!(booleanType != null ? !booleanType.equals(cypherType4) : cypherType4 != null)) {
                    intersect = (Function1 & Serializable & scala.Serializable)b -> Values.booleanValue((boolean)BoxesRunTime.unboxToBoolean((Object)b));
                } else {
                    FloatType floatType = package$.MODULE$.CTFloat();
                    CypherType cypherType5 = cypherType;
                    if (!(floatType != null ? !floatType.equals(cypherType5) : cypherType5 != null)) {
                        intersect = (Function1 & Serializable & scala.Serializable)d -> Values.doubleValue((double)BoxesRunTime.unboxToDouble((Object)d));
                    } else {
                        IntegerType integerType = package$.MODULE$.CTInteger();
                        CypherType cypherType6 = cypherType;
                        if (!(integerType != null ? !integerType.equals(cypherType6) : cypherType6 != null)) {
                            intersect = (Function1 & Serializable & scala.Serializable)l -> Values.longValue((long)BoxesRunTime.unboxToLong((Object)l));
                        } else {
                            NumberType numberType = package$.MODULE$.CTNumber();
                            CypherType cypherType7 = cypherType;
                            if (!(numberType != null ? !numberType.equals(cypherType7) : cypherType7 != null)) {
                                intersect = (Function1 & Serializable & scala.Serializable)l -> Values.numberValue((Number)((Number)l));
                            } else {
                                StringType stringType = package$.MODULE$.CTString();
                                CypherType cypherType8 = cypherType;
                                if (!(stringType != null ? !stringType.equals(cypherType8) : cypherType8 != null)) {
                                    intersect = (Function1 & Serializable & scala.Serializable)l -> Values.utf8Value((String)((String)l));
                                } else {
                                    PathType pathType = package$.MODULE$.CTPath();
                                    CypherType cypherType9 = cypherType;
                                    if (!(pathType != null ? !pathType.equals(cypherType9) : cypherType9 != null)) {
                                        intersect = (Function1 & Serializable & scala.Serializable)p -> ValueUtils.fromPath((Path)((Path)p));
                                    } else {
                                        MapType mapType = package$.MODULE$.CTMap();
                                        CypherType cypherType10 = cypherType;
                                        if (!(mapType != null ? !mapType.equals(cypherType10) : cypherType10 != null)) {
                                            intersect = (Function1 & Serializable & scala.Serializable)m -> ValueUtils.asMapValue((Map)((Map)m));
                                        } else {
                                            Option option = ListType$.MODULE$.unapply(cypherType);
                                            if (!option.isEmpty()) {
                                                intersect = (Function1 & Serializable & scala.Serializable)x0$1 -> {
                                                    ListValue listValue;
                                                    Object object = x0$1;
                                                    if (object instanceof byte[]) {
                                                        byte[] byArray = (byte[])object;
                                                        listValue = Values.byteArray((byte[])byArray);
                                                    } else {
                                                        listValue = ValueUtils.asListValue((Iterable)((Collection)object));
                                                    }
                                                    return listValue;
                                                };
                                            } else {
                                                AnyType anyType = package$.MODULE$.CTAny();
                                                CypherType cypherType11 = cypherType;
                                                if (!(anyType != null ? !anyType.equals(cypherType11) : cypherType11 != null)) {
                                                    intersect = (Function1 & Serializable & scala.Serializable)o -> ValueUtils.of((Object)o);
                                                } else {
                                                    PointType pointType = package$.MODULE$.CTPoint();
                                                    CypherType cypherType12 = cypherType;
                                                    if (!(pointType != null ? !pointType.equals(cypherType12) : cypherType12 != null)) {
                                                        intersect = (Function1 & Serializable & scala.Serializable)o -> ValueUtils.asPointValue((Point)((Point)o));
                                                    } else {
                                                        GeometryType geometryType = package$.MODULE$.CTGeometry();
                                                        CypherType cypherType13 = cypherType;
                                                        if (!(geometryType != null ? !geometryType.equals(cypherType13) : cypherType13 != null)) {
                                                            intersect = (Function1 & Serializable & scala.Serializable)o -> ValueUtils.asGeometryValue((Geometry)((Geometry)o));
                                                        } else {
                                                            DateTimeType dateTimeType = package$.MODULE$.CTDateTime();
                                                            CypherType cypherType14 = cypherType;
                                                            if (!(dateTimeType != null ? !dateTimeType.equals(cypherType14) : cypherType14 != null)) {
                                                                intersect = (Function1 & Serializable & scala.Serializable)o -> DateTimeValue.datetime((ZonedDateTime)((ZonedDateTime)o));
                                                            } else {
                                                                LocalDateTimeType localDateTimeType = package$.MODULE$.CTLocalDateTime();
                                                                CypherType cypherType15 = cypherType;
                                                                if (!(localDateTimeType != null ? !localDateTimeType.equals(cypherType15) : cypherType15 != null)) {
                                                                    intersect = (Function1 & Serializable & scala.Serializable)o -> LocalDateTimeValue.localDateTime((LocalDateTime)((LocalDateTime)o));
                                                                } else {
                                                                    DateType dateType = package$.MODULE$.CTDate();
                                                                    CypherType cypherType16 = cypherType;
                                                                    if (!(dateType != null ? !dateType.equals(cypherType16) : cypherType16 != null)) {
                                                                        intersect = (Function1 & Serializable & scala.Serializable)o -> DateValue.date((LocalDate)((LocalDate)o));
                                                                    } else {
                                                                        TimeType timeType = package$.MODULE$.CTTime();
                                                                        CypherType cypherType17 = cypherType;
                                                                        if (!(timeType != null ? !timeType.equals(cypherType17) : cypherType17 != null)) {
                                                                            intersect = (Function1 & Serializable & scala.Serializable)o -> TimeValue.time((OffsetTime)((OffsetTime)o));
                                                                        } else {
                                                                            LocalTimeType localTimeType = package$.MODULE$.CTLocalTime();
                                                                            CypherType cypherType18 = cypherType;
                                                                            if (!(localTimeType != null ? !localTimeType.equals(cypherType18) : cypherType18 != null)) {
                                                                                intersect = (Function1 & Serializable & scala.Serializable)o -> LocalTimeValue.localTime((LocalTime)((LocalTime)o));
                                                                            } else {
                                                                                DurationType durationType = package$.MODULE$.CTDuration();
                                                                                CypherType cypherType19 = cypherType;
                                                                                if (!(durationType != null ? !durationType.equals(cypherType19) : cypherType19 != null)) {
                                                                                    intersect = (Function1 & Serializable & scala.Serializable)o -> Values.durationValue((TemporalAmount)((TemporalAmount)o));
                                                                                } else {
                                                                                    throw new MatchError((Object)cypherType);
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        Function1 & Serializable & scala.Serializable converter = intersect;
        return (Function1 & Serializable & scala.Serializable)v -> v == null ? Values.NO_VALUE : (AnyValue)converter.apply(v);
    }

    public MapValue asValues(scala.collection.immutable.Map<String, Object> params) {
        if (params.isEmpty()) {
            return VirtualValues.EMPTY_MAP;
        }
        MapValueBuilder builder = new MapValueBuilder(params.size());
        params.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String key = (String)tuple2._1();
            Object value = tuple2._2();
            AnyValue anyValue = builder.add(key, MODULE$.asValue(value));
            return anyValue;
        });
        return builder.build();
    }

    public AnyValue asValue(Object value2) {
        Value value3;
        Object object = value2;
        if (object == null) {
            value3 = Values.NO_VALUE;
        } else if (object instanceof String) {
            String string = (String)object;
            value3 = Values.utf8Value((String)string);
        } else if (object instanceof Character) {
            char c = BoxesRunTime.unboxToChar((Object)object);
            value3 = Values.charValue((char)c);
        } else if (object instanceof Double) {
            double d = BoxesRunTime.unboxToDouble((Object)object);
            value3 = Values.doubleValue((double)d);
        } else if (object instanceof Float) {
            float f = BoxesRunTime.unboxToFloat((Object)object);
            value3 = Values.floatValue((float)f);
        } else if (object instanceof Number) {
            Number number = (Number)object;
            value3 = Values.longValue((long)number.longValue());
        } else if (object instanceof Boolean) {
            boolean bl = BoxesRunTime.unboxToBoolean((Object)object);
            value3 = Values.booleanValue((boolean)bl);
        } else if (object instanceof Node) {
            Node node = (Node)object;
            value3 = ValueUtils.fromNodeEntity((Node)node);
        } else if (object instanceof Relationship) {
            Relationship relationship = (Relationship)object;
            value3 = ValueUtils.fromRelationshipEntity((Relationship)relationship);
        } else if (object instanceof Path) {
            Path path = (Path)object;
            value3 = ValueUtils.fromPath((Path)path);
        } else if (object instanceof Point) {
            Point point = (Point)object;
            value3 = ValueUtils.asPointValue((Point)point);
        } else if (object instanceof Geometry) {
            Geometry geometry = (Geometry)object;
            value3 = ValueUtils.asGeometryValue((Geometry)geometry);
        } else if (object instanceof ZonedDateTime) {
            ZonedDateTime zonedDateTime = (ZonedDateTime)object;
            value3 = DateTimeValue.datetime((ZonedDateTime)zonedDateTime);
        } else if (object instanceof LocalDateTime) {
            LocalDateTime localDateTime = (LocalDateTime)object;
            value3 = LocalDateTimeValue.localDateTime((LocalDateTime)localDateTime);
        } else if (object instanceof LocalDate) {
            LocalDate localDate = (LocalDate)object;
            value3 = DateValue.date((LocalDate)localDate);
        } else if (object instanceof OffsetTime) {
            OffsetTime offsetTime = (OffsetTime)object;
            value3 = TimeValue.time((OffsetTime)offsetTime);
        } else if (object instanceof LocalTime) {
            LocalTime localTime = (LocalTime)object;
            value3 = LocalTimeValue.localTime((LocalTime)localTime);
        } else if (object instanceof TemporalAmount) {
            TemporalAmount temporalAmount = (TemporalAmount)object;
            value3 = Values.durationValue((TemporalAmount)temporalAmount);
        } else if (object instanceof scala.collection.immutable.Map) {
            scala.collection.immutable.Map map = (scala.collection.immutable.Map)object;
            MapValueBuilder builder = new MapValueBuilder();
            map.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                Object k = tuple2._1();
                Object v = tuple2._2();
                AnyValue anyValue = builder.add((String)k, MODULE$.asValue(v));
                return anyValue;
            });
            value3 = builder.build();
        } else if (object instanceof Map) {
            Map map = (Map)object;
            value3 = ValueUtils.asMapValue((Map)map);
        } else if (object instanceof TraversableOnce) {
            TraversableOnce traversableOnce = (TraversableOnce)object;
            value3 = VirtualValues.list((AnyValue[])((AnyValue[])TraversableOnce$.MODULE$.MonadOps(traversableOnce).map((Function1 & Serializable & scala.Serializable)value -> MODULE$.asValue(value)).toArray(ClassTag$.MODULE$.apply(AnyValue.class))));
        } else if (object instanceof Collection) {
            Collection collection = (Collection)object;
            value3 = ValueUtils.asListValue((Iterable)collection);
        } else if (ScalaRunTime$.MODULE$.isArray(object, 1)) {
            Object object2 = object;
            String string = object2.getClass().getComponentType().getName();
            Object object3 = "byte".equals(string) ? Values.byteArray((byte[])((byte[])object2)) : ("short".equals(string) ? VirtualValues.fromArray((ArrayValue)Values.shortArray((short[])((short[])object2))) : ("char".equals(string) ? VirtualValues.fromArray((ArrayValue)Values.charArray((char[])((char[])object2))) : ("int".equals(string) ? VirtualValues.fromArray((ArrayValue)Values.intArray((int[])((int[])object2))) : ("long".equals(string) ? VirtualValues.fromArray((ArrayValue)Values.longArray((long[])((long[])object2))) : ("float".equals(string) ? VirtualValues.fromArray((ArrayValue)Values.floatArray((float[])((float[])object2))) : ("double".equals(string) ? VirtualValues.fromArray((ArrayValue)Values.doubleArray((double[])((double[])object2))) : ("boolean".equals(string) ? VirtualValues.fromArray((ArrayValue)Values.booleanArray((boolean[])((boolean[])object2))) : ("java.lang.String".equals(string) ? VirtualValues.fromArray((ArrayValue)Values.stringArray((String[])((String[])object2))) : VirtualValues.list((AnyValue[])((AnyValue[])Predef$.MODULE$.genericArrayOps(object2).map((Function1 & Serializable & scala.Serializable)value -> MODULE$.asValue(value), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(AnyValue.class)))))))))))));
            value3 = object3;
        } else {
            throw new MatchError(object);
        }
        return value3;
    }

    private ValueConversion$() {
        MODULE$ = this;
    }
}

