/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.runtime.interpreted.commands.predicates;

import java.util.Iterator;
import org.neo4j.cypher.internal.runtime.interpreted.commands.predicates.Checker;
import org.neo4j.cypher.internal.runtime.interpreted.commands.predicates.NullListChecker$;
import org.neo4j.cypher.internal.runtime.interpreted.commands.predicates.SetChecker;
import org.neo4j.cypher.internal.util.AssertionRunner;
import org.neo4j.values.AnyValue;
import org.neo4j.values.Equality;
import org.neo4j.values.storable.Values;
import org.neo4j.values.virtual.ListValue;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.collection.mutable.HashSet;
import scala.collection.mutable.Set;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001u3A!\u0003\u0006\u00017!Aa\u0005\u0001B\u0001B\u0003%q\u0005C\u00030\u0001\u0011\u0005\u0001\u0007C\u00044\u0001\t\u0007I\u0011\u0001\u001b\t\r\u0005\u0003\u0001\u0015!\u00036\u0011\u001d\u0011\u0005A1A\u0005\n\rCa\u0001\u0014\u0001!\u0002\u0013!\u0005\"B'\u0001\t\u0003r\u0005\"\u0002.\u0001\t\u0013Y&a\u0002\"vS2$W\u000b\u001d\u0006\u0003\u00171\t!\u0002\u001d:fI&\u001c\u0017\r^3t\u0015\tia\"\u0001\u0005d_6l\u0017M\u001c3t\u0015\ty\u0001#A\u0006j]R,'\u000f\u001d:fi\u0016$'BA\t\u0013\u0003\u001d\u0011XO\u001c;j[\u0016T!a\u0005\u000b\u0002\u0011%tG/\u001a:oC2T!!\u0006\f\u0002\r\rL\b\u000f[3s\u0015\t9\u0002$A\u0003oK>$$NC\u0001\u001a\u0003\ry'oZ\u0002\u0001'\r\u0001AD\t\t\u0003;\u0001j\u0011A\b\u0006\u0002?\u0005)1oY1mC&\u0011\u0011E\b\u0002\u0007\u0003:L(+\u001a4\u0011\u0005\r\"S\"\u0001\u0006\n\u0005\u0015R!aB\"iK\u000e\\WM]\u0001\u0005Y&\u001cH\u000f\u0005\u0002)[5\t\u0011F\u0003\u0002+W\u00059a/\u001b:uk\u0006d'B\u0001\u0017\u0017\u0003\u00191\u0018\r\\;fg&\u0011a&\u000b\u0002\n\u0019&\u001cHOV1mk\u0016\fa\u0001P5oSRtDCA\u00193!\t\u0019\u0003\u0001C\u0003'\u0005\u0001\u0007q%\u0001\u0005ji\u0016\u0014\u0018\r^8s+\u0005)\u0004c\u0001\u001c<{5\tqG\u0003\u00029s\u0005!Q\u000f^5m\u0015\u0005Q\u0014\u0001\u00026bm\u0006L!\u0001P\u001c\u0003\u0011%#XM]1u_J\u0004\"AP \u000e\u0003-J!\u0001Q\u0016\u0003\u0011\u0005s\u0017PV1mk\u0016\f\u0011\"\u001b;fe\u0006$xN\u001d\u0011\u0002\u0013\r\f7\r[3e'\u0016$X#\u0001#\u0011\u0007\u0015SU(D\u0001G\u0015\t9\u0005*A\u0004nkR\f'\r\\3\u000b\u0005%s\u0012AC2pY2,7\r^5p]&\u00111J\u0012\u0002\u0004'\u0016$\u0018AC2bG\",GmU3uA\u0005A1m\u001c8uC&t7\u000f\u0006\u0002P1B!Q\u0004\u0015*#\u0013\t\tfD\u0001\u0004UkBdWM\r\t\u0004;M+\u0016B\u0001+\u001f\u0005\u0019y\u0005\u000f^5p]B\u0011QDV\u0005\u0003/z\u0011qAQ8pY\u0016\fg\u000eC\u0003Z\u000f\u0001\u0007Q(A\u0003wC2,X-\u0001\u000bdQ\u0016\u001c7.\u00118e\u0005VLG\u000eZ+q\u0007\u0006\u001c\u0007.\u001a\u000b\u0003\u001frCQ!\u0017\u0005A\u0002u\u0002")
public class BuildUp
implements Checker {
    private final Iterator<AnyValue> iterator;
    private final Set<AnyValue> cachedSet;

    public Iterator<AnyValue> iterator() {
        return this.iterator;
    }

    private Set<AnyValue> cachedSet() {
        return this.cachedSet;
    }

    @Override
    public Tuple2<Option<Object>, Checker> contains(AnyValue value) {
        return value == Values.NO_VALUE ? new Tuple2<Option<Object>, Checker>((Object)None$.MODULE$, (Object)this) : (this.cachedSet().contains((Object)value) ? new Tuple2((Object)new Some((Object)BoxesRunTime.boxToBoolean((boolean)true)), (Object)this) : this.checkAndBuildUpCache(value));
    }

    private Tuple2<Option<Object>, Checker> checkAndBuildUpCache(AnyValue value) {
        Tuple2 tuple2;
        Equality foundMatch = Equality.FALSE;
        while (this.iterator().hasNext()) {
            Equality equality = foundMatch;
            Equality equality2 = Equality.TRUE;
            if (!(equality == null ? equality2 != null : !equality.equals(equality2))) break;
            AnyValue nextValue = this.iterator().next();
            if (nextValue == Values.NO_VALUE) {
                foundMatch = Equality.UNDEFINED;
                continue;
            }
            this.cachedSet().add((Object)nextValue);
            Equality areEqual = nextValue.ternaryEquals(value);
            if (areEqual != Equality.UNDEFINED && areEqual != Equality.TRUE) continue;
            foundMatch = areEqual;
        }
        if (this.cachedSet().isEmpty()) {
            tuple2 = new Tuple2((Object)None$.MODULE$, (Object)NullListChecker$.MODULE$);
        } else {
            Equality equality = foundMatch;
            Equality equality3 = Equality.UNDEFINED;
            None$ falseResult = !(equality != null ? !equality.equals(equality3) : equality3 != null) ? None$.MODULE$ : new Some((Object)BoxesRunTime.boxToBoolean((boolean)false));
            Checker nextState = this.iterator().hasNext() ? this : new SetChecker(this.cachedSet(), (Option<Object>)falseResult);
            Equality equality4 = foundMatch;
            Equality equality5 = Equality.TRUE;
            None$ result = !(equality4 != null ? !equality4.equals(equality5) : equality5 != null) ? new Some((Object)BoxesRunTime.boxToBoolean((boolean)true)) : falseResult;
            tuple2 = new Tuple2((Object)result, (Object)nextState);
        }
        return tuple2;
    }

    public BuildUp(ListValue list) {
        this.iterator = list.iterator();
        if (AssertionRunner.ASSERTIONS_ENABLED && !this.iterator().hasNext()) {
            throw new AssertionError((Object)"assertion failed");
        }
        this.cachedSet = new HashSet();
    }
}

