/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.runtime.interpreted.profiler;

import java.io.Serializable;
import org.neo4j.common.Edition;
import org.neo4j.cypher.internal.profiling.KernelStatisticProvider;
import org.neo4j.cypher.internal.runtime.CypherRow;
import org.neo4j.cypher.internal.runtime.QueryContext;
import org.neo4j.cypher.internal.runtime.interpreted.pipes.PipeDecorator;
import org.neo4j.cypher.internal.runtime.interpreted.pipes.QueryState;
import org.neo4j.cypher.internal.runtime.interpreted.profiler.InterpretedProfileInformation;
import org.neo4j.cypher.internal.runtime.interpreted.profiler.PageCacheStats;
import org.neo4j.cypher.internal.runtime.interpreted.profiler.ProfilingIterator;
import org.neo4j.cypher.internal.runtime.interpreted.profiler.ProfilingPipeQueryContext;
import org.neo4j.cypher.internal.util.attribution.Id;
import org.neo4j.kernel.impl.factory.DbmsInfo;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005-c\u0001\u0002\n\u0014\u0001\tB\u0001b\f\u0001\u0003\u0002\u0003\u0006I\u0001\r\u0005\tu\u0001\u0011\t\u0011)A\u0005w!)q\b\u0001C\u0001\u0001\"9A\t\u0001a\u0001\n\u0013)\u0005b\u0002.\u0001\u0001\u0004%Ia\u0017\u0005\u0007C\u0002\u0001\u000b\u0015\u0002$\t\u000f\t\u0004\u0001\u0019!C\u0005G\"9q\r\u0001a\u0001\n\u0013A\u0007B\u00026\u0001A\u0003&A\rC\u0003l\u0001\u0011%A\u000eC\u0003x\u0001\u0011%\u0001\u0010C\u0003|\u0001\u0011%A\u0010C\u0004\u0002\n\u0001!\t!a\u0003\t\u000f\u0005%\u0001\u0001\"\u0001\u0002$!9\u0011\u0011\u0007\u0001\u0005B\u0005M\u0002bBA\u001d\u0001\u0011%\u00111\b\u0005\b\u0003\u0007\u0002A\u0011AA#\u0005!\u0001&o\u001c4jY\u0016\u0014(B\u0001\u000b\u0016\u0003!\u0001(o\u001c4jY\u0016\u0014(B\u0001\f\u0018\u0003-Ig\u000e^3saJ,G/\u001a3\u000b\u0005aI\u0012a\u0002:v]RLW.\u001a\u0006\u00035m\t\u0001\"\u001b8uKJt\u0017\r\u001c\u0006\u00039u\taaY=qQ\u0016\u0014(B\u0001\u0010 \u0003\u0015qWm\u001c\u001bk\u0015\u0005\u0001\u0013aA8sO\u000e\u00011c\u0001\u0001$SA\u0011AeJ\u0007\u0002K)\ta%A\u0003tG\u0006d\u0017-\u0003\u0002)K\t1\u0011I\\=SK\u001a\u0004\"AK\u0017\u000e\u0003-R!\u0001L\u000b\u0002\u000bAL\u0007/Z:\n\u00059Z#!\u0004)ja\u0016$UmY8sCR|'/\u0001\u0005eE6\u001c\u0018J\u001c4p!\t\t\u0004(D\u00013\u0015\t\u0019D'A\u0004gC\u000e$xN]=\u000b\u0005U2\u0014\u0001B5na2T!aN\u000f\u0002\r-,'O\\3m\u0013\tI$G\u0001\u0005EE6\u001c\u0018J\u001c4p\u0003\u0015\u0019H/\u0019;t!\taT(D\u0001\u0014\u0013\tq4CA\u000fJ]R,'\u000f\u001d:fi\u0016$\u0007K]8gS2,\u0017J\u001c4pe6\fG/[8o\u0003\u0019a\u0014N\\5u}Q\u0019\u0011IQ\"\u0011\u0005q\u0002\u0001\"B\u0018\u0004\u0001\u0004\u0001\u0004\"\u0002\u001e\u0004\u0001\u0004Y\u0014a\u00039mC:LEm\u0015;bG.,\u0012A\u0012\t\u0004\u000f>\u0013fB\u0001%N\u001d\tIE*D\u0001K\u0015\tY\u0015%\u0001\u0004=e>|GOP\u0005\u0002M%\u0011a*J\u0001\ba\u0006\u001c7.Y4f\u0013\t\u0001\u0016K\u0001\u0003MSN$(B\u0001(&!\t\u0019\u0006,D\u0001U\u0015\t)f+A\u0006biR\u0014\u0018NY;uS>t'BA,\u001a\u0003\u0011)H/\u001b7\n\u0005e#&AA%e\u0003=\u0001H.\u00198JIN#\u0018mY6`I\u0015\fHC\u0001/`!\t!S,\u0003\u0002_K\t!QK\\5u\u0011\u001d\u0001W!!AA\u0002\u0019\u000b1\u0001\u001f\u00132\u00031\u0001H.\u00198JIN#\u0018mY6!\u0003Ea\u0017m\u001d;PEN,'O^3e'R\fGo]\u000b\u0002IB\u0011A(Z\u0005\u0003MN\u0011a\u0002U1hK\u000e\u000b7\r[3Ti\u0006$8/A\u000bmCN$xJY:feZ,Gm\u0015;biN|F%Z9\u0015\u0005qK\u0007b\u00021\t\u0003\u0003\u0005\r\u0001Z\u0001\u0013Y\u0006\u001cHo\u00142tKJ4X\rZ*uCR\u001c\b%\u0001\u0011ti\u0006\u0014H/Q2d_VtG/\u001b8h!\u0006<WmQ1dQ\u0016\u001cF/\u0019;t\r>\u0014Hc\u0001/nk\")aN\u0003a\u0001_\u0006\t2\u000f^1uSN$\u0018n\u0019)s_ZLG-\u001a:\u0011\u0005A\u001cX\"A9\u000b\u0005IL\u0012!\u00039s_\u001aLG.\u001b8h\u0013\t!\u0018OA\fLKJtW\r\\*uCRL7\u000f^5d!J|g/\u001b3fe\")aO\u0003a\u0001%\u0006\u0011\u0011\u000eZ\u0001 gR|\u0007/Q2d_VtG/\u001b8h!\u0006<WmQ1dQ\u0016\u001cF/\u0019;t\r>\u0014Hc\u0001/zu\")an\u0003a\u0001_\")ao\u0003a\u0001%\u0006IR\u000f\u001d3bi\u0016\u0004\u0016mZ3DC\u000eDWm\u0015;bi&\u001cH/[2t)\raVp \u0005\u0006}2\u0001\rAU\u0001\u0007a&\u0004X-\u00133\t\u000f\u0005\u0005A\u00021\u0001\u0002\u0004\u0005\ta\r\u0005\u0004%\u0003\u000by'\u000bX\u0005\u0004\u0003\u000f)#!\u0003$v]\u000e$\u0018n\u001c83\u0003!!WmY8sCR,GCBA\u0007\u00037\ty\u0002E\u0003H\u0003\u001f\t\u0019\"C\u0002\u0002\u0012E\u0013\u0001\"\u0013;fe\u0006$xN\u001d\t\u0005\u0003+\t9\"D\u0001\u0018\u0013\r\tIb\u0006\u0002\n\u0007f\u0004\b.\u001a:S_^Da!!\b\u000e\u0001\u0004\u0011\u0016A\u00029mC:LE\rC\u0004\u0002\"5\u0001\r!!\u0004\u0002\t%$XM\u001d\u000b\u0007\u0003K\tY#!\f\u0011\u0007)\n9#C\u0002\u0002*-\u0012!\"U;fef\u001cF/\u0019;f\u0011\u0019\tiB\u0004a\u0001%\"9\u0011q\u0006\bA\u0002\u0005\u0015\u0012!B:uCR,\u0017AE1gi\u0016\u00148I]3bi\u0016\u0014Vm];miN$R\u0001XA\u001b\u0003oAa!!\b\u0010\u0001\u0004\u0011\u0006bBA\u0018\u001f\u0001\u0007\u0011QE\u0001\u0014iJ\f7m\u001b)bO\u0016\u001c\u0015m\u00195f'R\fGo]\u000b\u0003\u0003{\u00012\u0001JA \u0013\r\t\t%\n\u0002\b\u0005>|G.Z1o\u00039IgN\\3s\t\u0016\u001cwN]1u_J$2!KA$\u0011\u0019\tI%\u0005a\u0001%\u0006Yq.\u001e;feBc\u0017M\\%e\u0001")
public class Profiler
implements PipeDecorator {
    private final DbmsInfo dbmsInfo;
    private final InterpretedProfileInformation stats;
    private List<Id> planIdStack;
    private PageCacheStats lastObservedStats;

    @Override
    public Iterator<CypherRow> decorate(int planId, Iterator<CypherRow> iter, Iterator<CypherRow> sourceIter) {
        return PipeDecorator.decorate$((PipeDecorator)this, planId, iter, sourceIter);
    }

    @Override
    public Iterator<CypherRow> decorate(int planId, Iterator<CypherRow> iter, Function0<Option<CypherRow>> previousContextSupplier) {
        return PipeDecorator.decorate$((PipeDecorator)this, planId, iter, previousContextSupplier);
    }

    private List<Id> planIdStack() {
        return this.planIdStack;
    }

    private void planIdStack_$eq(List<Id> x$1) {
        this.planIdStack = x$1;
    }

    private PageCacheStats lastObservedStats() {
        return this.lastObservedStats;
    }

    private void lastObservedStats_$eq(PageCacheStats x$1) {
        this.lastObservedStats = x$1;
    }

    private void startAccountingPageCacheStatsFor(KernelStatisticProvider statisticProvider, int id) {
        PageCacheStats currentStats = new PageCacheStats(statisticProvider.getPageCacheHits(), statisticProvider.getPageCacheMisses());
        this.planIdStack().headOption().foreach((Function1 & Serializable & scala.Serializable)previousId -> {
            Profiler.$anonfun$startAccountingPageCacheStatsFor$1(this, currentStats, ((Id)previousId).x());
            return BoxedUnit.UNIT;
        });
        this.planIdStack_$eq((List<Id>)this.planIdStack().$colon$colon((Object)new Id(id)));
        this.lastObservedStats_$eq(currentStats);
    }

    private void stopAccountingPageCacheStatsFor(KernelStatisticProvider statisticProvider, int id) {
        List<Id> list = this.planIdStack();
        if (!(list instanceof .colon.colon)) {
            throw new MatchError(list);
        }
        .colon.colon colon2 = (.colon.colon)list;
        int head = ((Id)colon2.head()).x();
        List rest = colon2.tl$access$1();
        Tuple2 tuple2 = new Tuple2((Object)new Id(head), (Object)rest);
        Tuple2 tuple22 = tuple2;
        int head2 = ((Id)tuple22._1()).x();
        List rest2 = (List)tuple22._2();
        Predef$.MODULE$.require(head2 == id, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(98).append("We messed up accounting the page cache statistics. Expected to pop ").append(new Id(id)).append(" but popped ").append(new Id(head2)).append(". Remaining stack: ").append(this.planIdStack()).toString());
        PageCacheStats currentStats = new PageCacheStats(statisticProvider.getPageCacheHits(), statisticProvider.getPageCacheMisses());
        this.stats.pageCacheMap().update((Object)new Id(id), (Object)((PageCacheStats)this.stats.pageCacheMap().apply((Object)new Id(id))).$plus(currentStats.$minus(this.lastObservedStats())));
        this.planIdStack_$eq((List<Id>)rest2);
        this.lastObservedStats_$eq(currentStats);
    }

    private void updatePageCacheStatistics(int pipeId, Function2<KernelStatisticProvider, Id, BoxedUnit> f) {
        ProfilingPipeQueryContext context = (ProfilingPipeQueryContext)this.stats.dbHitsMap().apply((Object)new Id(pipeId));
        KernelStatisticProvider statisticProvider = context.transactionalContext().kernelStatisticProvider();
        f.apply((Object)statisticProvider, (Object)new Id(pipeId));
    }

    @Override
    public Iterator<CypherRow> decorate(int planId, Iterator<CypherRow> iter) {
        long oldCount = BoxesRunTime.unboxToLong((Object)this.stats.rowMap().get((Object)new Id(planId)).map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToLong((long)x$2.count())).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L));
        ProfilingIterator resultIter = new ProfilingIterator(iter, oldCount, planId, (Function1<Id, BoxedUnit>)(this.trackPageCacheStats() ? (Function1 & Serializable & scala.Serializable)x$3 -> {
            this.updatePageCacheStatistics(((Id)x$3).x(), (Function2<KernelStatisticProvider, Id, BoxedUnit>)(Function2 & Serializable & scala.Serializable)(statisticProvider, id) -> {
                $this.startAccountingPageCacheStatsFor(statisticProvider, ((Id)id).x());
                return BoxedUnit.UNIT;
            });
            return BoxedUnit.UNIT;
        } : (Function1 & Serializable & scala.Serializable)x$4 -> {
            Profiler.$anonfun$decorate$5(((Id)x$4).x());
            return BoxedUnit.UNIT;
        }), (Function1<Id, BoxedUnit>)(this.trackPageCacheStats() ? (Function1 & Serializable & scala.Serializable)x$5 -> {
            this.updatePageCacheStatistics(((Id)x$5).x(), (Function2<KernelStatisticProvider, Id, BoxedUnit>)(Function2 & Serializable & scala.Serializable)(statisticProvider, id) -> {
                $this.stopAccountingPageCacheStatsFor(statisticProvider, ((Id)id).x());
                return BoxedUnit.UNIT;
            });
            return BoxedUnit.UNIT;
        } : (Function1 & Serializable & scala.Serializable)x$6 -> {
            Profiler.$anonfun$decorate$8(((Id)x$6).x());
            return BoxedUnit.UNIT;
        }));
        this.stats.rowMap().update((Object)new Id(planId), (Object)resultIter);
        return resultIter;
    }

    @Override
    public QueryState decorate(int planId, QueryState state) {
        ProfilingPipeQueryContext decoratedContext;
        block0: {
            this.stats.setMemoryTracker(state.memoryTracker());
            decoratedContext = (ProfilingPipeQueryContext)this.stats.dbHitsMap().getOrElseUpdate((Object)new Id(planId), (Function0 & Serializable & scala.Serializable)() -> {
                ProfilingPipeQueryContext profilingPipeQueryContext;
                QueryContext queryContext = state.query();
                if (queryContext instanceof ProfilingPipeQueryContext) {
                    ProfilingPipeQueryContext profilingPipeQueryContext2 = (ProfilingPipeQueryContext)queryContext;
                    profilingPipeQueryContext = new ProfilingPipeQueryContext(profilingPipeQueryContext2.inner());
                } else {
                    profilingPipeQueryContext = new ProfilingPipeQueryContext(state.query());
                }
                return profilingPipeQueryContext;
            });
            if (!this.trackPageCacheStats()) break block0;
            this.startAccountingPageCacheStatsFor(decoratedContext.transactionalContext().kernelStatisticProvider(), planId);
        }
        return state.withQueryContext(decoratedContext);
    }

    @Override
    public void afterCreateResults(int planId, QueryState state) {
        block0: {
            if (!this.trackPageCacheStats()) break block0;
            this.stopAccountingPageCacheStatsFor(state.query().transactionalContext().kernelStatisticProvider(), planId);
        }
    }

    private boolean trackPageCacheStats() {
        Edition edition = this.dbmsInfo.edition;
        Edition edition2 = Edition.COMMUNITY;
        return edition == null ? edition2 != null : !edition.equals(edition2);
    }

    @Override
    public PipeDecorator innerDecorator(int outerPlanId) {
        return new PipeDecorator(this, outerPlanId){
            private final /* synthetic */ Profiler $outer;
            private final int outerPlanId$1;

            public Iterator<CypherRow> decorate(int planId, Iterator<CypherRow> iter, Iterator<CypherRow> sourceIter) {
                return PipeDecorator.decorate$((PipeDecorator)this, planId, iter, sourceIter);
            }

            public Iterator<CypherRow> decorate(int planId, Iterator<CypherRow> iter, Function0<Option<CypherRow>> previousContextSupplier) {
                return PipeDecorator.decorate$((PipeDecorator)this, planId, iter, previousContextSupplier);
            }

            public PipeDecorator innerDecorator(int planId) {
                return this;
            }

            public QueryState decorate(int planId, QueryState state) {
                return this.$outer.decorate(this.outerPlanId$1, state);
            }

            public Iterator<CypherRow> decorate(int planId, Iterator<CypherRow> iter) {
                return iter;
            }

            public void afterCreateResults(int planId, QueryState state) {
                this.$outer.afterCreateResults(this.outerPlanId$1, state);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.outerPlanId$1 = outerPlanId$1;
                PipeDecorator.$init$(this);
            }
        };
    }

    public static final /* synthetic */ void $anonfun$startAccountingPageCacheStatsFor$1(Profiler $this, PageCacheStats currentStats$1, int previousId) {
        $this.stats.pageCacheMap().update((Object)new Id(previousId), (Object)((PageCacheStats)$this.stats.pageCacheMap().apply((Object)new Id(previousId))).$plus(currentStats$1.$minus($this.lastObservedStats())));
    }

    public static final /* synthetic */ void $anonfun$decorate$5(int x$4) {
    }

    public static final /* synthetic */ void $anonfun$decorate$8(int x$6) {
    }

    public Profiler(DbmsInfo dbmsInfo, InterpretedProfileInformation stats) {
        this.dbmsInfo = dbmsInfo;
        this.stats = stats;
        PipeDecorator.$init$(this);
        this.planIdStack = Nil$.MODULE$;
        this.lastObservedStats = new PageCacheStats(0L, 0L);
    }
}

