/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.runtime.interpreted.pipes;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Comparator;
import org.neo4j.cypher.internal.DefaultComparatorTopTable;
import org.neo4j.cypher.internal.runtime.ExecutionContext;
import org.neo4j.cypher.internal.runtime.WithHeapUsageEstimation;
import org.neo4j.cypher.internal.runtime.interpreted.commands.expressions.Expression;
import org.neo4j.cypher.internal.runtime.interpreted.commands.expressions.NumericHelper$;
import org.neo4j.cypher.internal.runtime.interpreted.pipes.Pipe;
import org.neo4j.cypher.internal.runtime.interpreted.pipes.PipeWithSource;
import org.neo4j.cypher.internal.runtime.interpreted.pipes.QueryState;
import org.neo4j.cypher.internal.runtime.interpreted.pipes.TopNPipe$;
import org.neo4j.exceptions.InvalidArgumentException;
import org.neo4j.values.storable.FloatingPointValue;
import org.neo4j.values.storable.NumberValue;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.Iterator$;
import scala.collection.JavaConverters$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0001\u0005%h\u0001B\u0001\u0003\u0001F\u0011\u0001\u0002V8q\u001dBK\u0007/\u001a\u0006\u0003\u0007\u0011\tQ\u0001]5qKNT!!\u0002\u0004\u0002\u0017%tG/\u001a:qe\u0016$X\r\u001a\u0006\u0003\u000f!\tqA];oi&lWM\u0003\u0002\n\u0015\u0005A\u0011N\u001c;fe:\fGN\u0003\u0002\f\u0019\u000511-\u001f9iKJT!!\u0004\b\u0002\u000b9,w\u000e\u000e6\u000b\u0003=\t1a\u001c:h\u0007\u0001\u0019B\u0001\u0001\n\u00179A\u00111\u0003F\u0007\u0002\u0005%\u0011QC\u0001\u0002\u000f!&\u0004XmV5uQN{WO]2f!\t9\"$D\u0001\u0019\u0015\u0005I\u0012!B:dC2\f\u0017BA\u000e\u0019\u0005\u001d\u0001&o\u001c3vGR\u0004\"aF\u000f\n\u0005yA\"\u0001D*fe&\fG.\u001b>bE2,\u0007\u0002\u0003\u0011\u0001\u0005+\u0007I\u0011A\u0011\u0002\rM|WO]2f+\u0005\u0011\u0003CA\n$\u0013\t!#A\u0001\u0003QSB,\u0007\u0002\u0003\u0014\u0001\u0005#\u0005\u000b\u0011\u0002\u0012\u0002\u000fM|WO]2fA!A\u0001\u0006\u0001BK\u0002\u0013\u0005\u0011&A\bd_VtG/\u0012=qe\u0016\u001c8/[8o+\u0005Q\u0003CA\u00161\u001b\u0005a#BA\u0017/\u0003-)\u0007\u0010\u001d:fgNLwN\\:\u000b\u0005=\"\u0011\u0001C2p[6\fg\u000eZ:\n\u0005Eb#AC#yaJ,7o]5p]\"A1\u0007\u0001B\tB\u0003%!&\u0001\td_VtG/\u0012=qe\u0016\u001c8/[8oA!AQ\u0007\u0001BK\u0002\u0013\u0005a'\u0001\u0006d_6\u0004\u0018M]1u_J,\u0012a\u000e\t\u0004quzT\"A\u001d\u000b\u0005iZ\u0014\u0001B;uS2T\u0011\u0001P\u0001\u0005U\u00064\u0018-\u0003\u0002?s\tQ1i\\7qCJ\fGo\u001c:\u0011\u0005\u0001\u000bU\"\u0001\u0004\n\u0005\t3!\u0001E#yK\u000e,H/[8o\u0007>tG/\u001a=u\u0011!!\u0005A!E!\u0002\u00139\u0014aC2p[B\f'/\u0019;pe\u0002B\u0001B\u0012\u0001\u0003\u0006\u0004%\taR\u0001\u0003S\u0012,\u0012\u0001\u0013\t\u0003\u0013>k\u0011A\u0013\u0006\u0003\u00172\u000b1\"\u0019;ue&\u0014W\u000f^5p]*\u0011!(\u0014\u0006\u0003\u001d\"\tAA\u001e\u001b`a%\u0011\u0001K\u0013\u0002\u0003\u0013\u0012D\u0001B\u0015\u0001\u0003\u0002\u0003\u0006I\u0001S\u0001\u0004S\u0012\u0004\u0003\"\u0002+\u0001\t\u0003)\u0016A\u0002\u001fj]&$h\b\u0006\u0003W3j[FCA,Y!\t\u0019\u0002\u0001C\u0004G'B\u0005\t\u0019\u0001%\t\u000b\u0001\u001a\u0006\u0019\u0001\u0012\t\u000b!\u001a\u0006\u0019\u0001\u0016\t\u000bU\u001a\u0006\u0019A\u001c\t\u000fu\u0003!\u0019!C\u0005=\u0006a\u0012N\\5uS\u0006dg)\u00197mE\u0006\u001c7nU8si\u0006\u0013(/Y=TSj,W#A0\u0011\u0005]\u0001\u0017BA1\u0019\u0005\rIe\u000e\u001e\u0005\u0007G\u0002\u0001\u000b\u0011B0\u0002;%t\u0017\u000e^5bY\u001a\u000bG\u000e\u001c2bG.\u001cvN\u001d;BeJ\f\u0017pU5{K\u0002BQ!\u001a\u0001\u0005R\u0019\fQ#\u001b8uKJt\u0017\r\\\"sK\u0006$XMU3tk2$8\u000fF\u0002hgV\u00042\u0001\u001b9@\u001d\tIgN\u0004\u0002k[6\t1N\u0003\u0002m!\u00051AH]8pizJ\u0011!G\u0005\u0003_b\tq\u0001]1dW\u0006<W-\u0003\u0002re\nA\u0011\n^3sCR|'O\u0003\u0002p1!)A\u000f\u001aa\u0001O\u0006)\u0011N\u001c9vi\")a\u000f\u001aa\u0001o\u0006)1\u000f^1uKB\u00111\u0003_\u0005\u0003s\n\u0011!\"U;fef\u001cF/\u0019;f\u0011\u001dY\b!!A\u0005\u0002q\fAaY8qsR1Qp`A\u0001\u0003\u0007!\"a\u0016@\t\u000b\u0019S\b\u0019\u0001%\t\u000f\u0001R\b\u0013!a\u0001E!9\u0001F\u001fI\u0001\u0002\u0004Q\u0003bB\u001b{!\u0003\u0005\ra\u000e\u0005\n\u0003\u000f\u0001\u0011\u0013!C\u0001\u0003\u0013\tabY8qs\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0002\f)\u001a!%!\u0004,\u0005\u0005=\u0001\u0003BA\t\u00037i!!a\u0005\u000b\t\u0005U\u0011qC\u0001\nk:\u001c\u0007.Z2lK\u0012T1!!\u0007\u0019\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003;\t\u0019BA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016D\u0011\"!\t\u0001#\u0003%\t!a\t\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%eU\u0011\u0011Q\u0005\u0016\u0004U\u00055\u0001\"CA\u0015\u0001E\u0005I\u0011AA\u0016\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIM*\"!!\f+\u0007]\ni\u0001C\u0005\u00022\u0001\t\t\u0011\"\u0011\u00024\u0005i\u0001O]8ek\u000e$\bK]3gSb,\"!!\u000e\u0011\t\u0005]\u0012QH\u0007\u0003\u0003sQ1!a\u000f<\u0003\u0011a\u0017M\\4\n\t\u0005}\u0012\u0011\b\u0002\u0007'R\u0014\u0018N\\4\t\u0011\u0005\r\u0003!!A\u0005\u0002y\u000bA\u0002\u001d:pIV\u001cG/\u0011:jifD\u0011\"a\u0012\u0001\u0003\u0003%\t!!\u0013\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR!\u00111JA)!\r9\u0012QJ\u0005\u0004\u0003\u001fB\"aA!os\"I\u00111KA#\u0003\u0003\u0005\raX\u0001\u0004q\u0012\n\u0004\"CA,\u0001\u0005\u0005I\u0011IA-\u0003=\u0001(o\u001c3vGRLE/\u001a:bi>\u0014XCAA.!\u0019\ti&a\u0019\u0002L5\u0011\u0011q\f\u0006\u0004\u0003CB\u0012AC2pY2,7\r^5p]&\u0019\u0011/a\u0018\t\u0013\u0005\u001d\u0004!!A\u0005\u0002\u0005%\u0014\u0001C2b]\u0016\u000bX/\u00197\u0015\t\u0005-\u0014\u0011\u000f\t\u0004/\u00055\u0014bAA81\t9!i\\8mK\u0006t\u0007BCA*\u0003K\n\t\u00111\u0001\u0002L!I\u0011Q\u000f\u0001\u0002\u0002\u0013\u0005\u0013qO\u0001\tQ\u0006\u001c\bnQ8eKR\tq\fC\u0005\u0002|\u0001\t\t\u0011\"\u0011\u0002~\u0005AAo\\*ue&tw\r\u0006\u0002\u00026!I\u0011\u0011\u0011\u0001\u0002\u0002\u0013\u0005\u00131Q\u0001\u0007KF,\u0018\r\\:\u0015\t\u0005-\u0014Q\u0011\u0005\u000b\u0003'\ny(!AA\u0002\u0005-s!CAE\u0005\u0005\u0005\t\u0012AAF\u0003!!v\u000e\u001d(QSB,\u0007cA\n\u0002\u000e\u001aA\u0011AAA\u0001\u0012\u0003\tyiE\u0003\u0002\u000e\u0006EE\u0004E\u0002\u0018\u0003'K1!!&\u0019\u0005\u0019\te.\u001f*fM\"9A+!$\u0005\u0002\u0005eECAAF\u0011)\tY(!$\u0002\u0002\u0013\u0015\u0013Q\u0010\u0005\u000b\u0003?\u000bi)!A\u0005\u0002\u0006\u0005\u0016!B1qa2LH\u0003CAR\u0003O\u000bI+a+\u0015\u0007]\u000b)\u000b\u0003\u0005G\u0003;\u0003\n\u00111\u0001I\u0011\u0019\u0001\u0013Q\u0014a\u0001E!1\u0001&!(A\u0002)Ba!NAO\u0001\u00049\u0004BCAX\u0003\u001b\u000b\t\u0011\"!\u00022\u00069QO\\1qa2LH\u0003BAZ\u0003\u007f\u0003RaFA[\u0003sK1!a.\u0019\u0005\u0019y\u0005\u000f^5p]B1q#a/#U]J1!!0\u0019\u0005\u0019!V\u000f\u001d7fg!I\u0011\u0011YAW\u0003\u0003\u0005\raV\u0001\u0004q\u0012\u0002\u0004BCAc\u0003\u001b\u000b\n\u0011\"\u0001\u0002H\u0006y\u0011\r\u001d9ms\u0012\"WMZ1vYR$C\u0007\u0006\u0005\u0002J\u0006-\u0017QZAhU\rA\u0015Q\u0002\u0005\u0007A\u0005\r\u0007\u0019\u0001\u0012\t\r!\n\u0019\r1\u0001+\u0011\u0019)\u00141\u0019a\u0001o!Q\u00111[AG#\u0003%\t!!6\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00135)!\tI-a6\u0002Z\u0006m\u0007B\u0002\u0011\u0002R\u0002\u0007!\u0005\u0003\u0004)\u0003#\u0004\rA\u000b\u0005\u0007k\u0005E\u0007\u0019A\u001c\t\u0015\u0005}\u0017QRA\u0001\n\u0013\t\t/A\u0006sK\u0006$'+Z:pYZ,GCAAr!\u0011\t9$!:\n\t\u0005\u001d\u0018\u0011\b\u0002\u0007\u001f\nTWm\u0019;")
public class TopNPipe
extends PipeWithSource
implements Product,
scala.Serializable {
    private final Pipe source;
    private final Expression countExpression;
    private final Comparator<ExecutionContext> comparator;
    private final int id;
    private final int initialFallbackSortArraySize;

    public static int $lessinit$greater$default$4(Pipe pipe, Expression expression, Comparator comparator) {
        return TopNPipe$.MODULE$.$lessinit$greater$default$4(pipe, expression, comparator);
    }

    public static int apply$default$4(Pipe pipe, Expression expression, Comparator comparator) {
        return TopNPipe$.MODULE$.apply$default$4(pipe, expression, comparator);
    }

    public static Option<Tuple3<Pipe, Expression, Comparator<ExecutionContext>>> unapply(TopNPipe topNPipe) {
        return TopNPipe$.MODULE$.unapply(topNPipe);
    }

    public static TopNPipe apply(Pipe pipe, Expression expression, Comparator<ExecutionContext> comparator, int n) {
        return TopNPipe$.MODULE$.apply(pipe, expression, comparator, n);
    }

    public Pipe source() {
        return this.source;
    }

    public Expression countExpression() {
        return this.countExpression;
    }

    public Comparator<ExecutionContext> comparator() {
        return this.comparator;
    }

    @Override
    public int id() {
        return this.id;
    }

    private int initialFallbackSortArraySize() {
        return this.initialFallbackSortArraySize;
    }

    @Override
    public Iterator<ExecutionContext> internalCreateResults(Iterator<ExecutionContext> input, QueryState state) {
        Iterator iterator;
        NumberValue limitNumber = NumericHelper$.MODULE$.asNumber(this.countExpression().apply(state.newExecutionContext(this.executionContextFactory()), state));
        if (limitNumber instanceof FloatingPointValue) {
            double limit = limitNumber.doubleValue();
            throw new InvalidArgumentException(new StringBuilder(78).append("LIMIT: Invalid input. '").append(limit).append("' is not a valid value. Must be a non-negative integer.").toString());
        }
        long limit = limitNumber.longValue();
        if (limit < 0L) {
            throw new InvalidArgumentException(new StringBuilder(78).append("LIMIT: Invalid input. '").append(limit).append("' is not a valid value. Must be a non-negative integer.").toString());
        }
        if (limit == 0L || input.isEmpty()) {
            return Iterator$.MODULE$.empty();
        }
        if (limit > Integer.MAX_VALUE) {
            ArrayBuffer buffer = new ArrayBuffer(this.initialFallbackSortArraySize());
            while (input.hasNext()) {
                ExecutionContext row = (ExecutionContext)input.next();
                buffer.$plus$eq((Object)row);
                state.memoryTracker().allocated((WithHeapUsageEstimation)row);
            }
            ExecutionContext[] array = (ExecutionContext[])buffer.toArray(ClassTag$.MODULE$.apply(ExecutionContext.class));
            Arrays.sort((Object[])array, this.comparator());
            LongRef c = LongRef.create((long)0L);
            iterator = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])array)).toStream().takeWhile((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)TopNPipe.$anonfun$internalCreateResults$1(limit, c, x$1))).iterator();
        } else {
            int count = (int)limit;
            DefaultComparatorTopTable topTable = new DefaultComparatorTopTable(this.comparator(), count);
            int i = 1;
            while (input.hasNext()) {
                ExecutionContext row = (ExecutionContext)input.next();
                topTable.add((Object)row);
                if (i < count) {
                    state.memoryTracker().allocated((WithHeapUsageEstimation)row);
                }
                ++i;
            }
            topTable.sort();
            iterator = (Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter(topTable.iterator()).asScala();
        }
        return iterator;
    }

    public TopNPipe copy(Pipe source, Expression countExpression, Comparator<ExecutionContext> comparator, int id) {
        return new TopNPipe(source, countExpression, comparator, id);
    }

    public Pipe copy$default$1() {
        return this.source();
    }

    public Expression copy$default$2() {
        return this.countExpression();
    }

    public Comparator<ExecutionContext> copy$default$3() {
        return this.comparator();
    }

    public String productPrefix() {
        return "TopNPipe";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        Comparator<ExecutionContext> comparator;
        int n = x$1;
        switch (n) {
            case 0: {
                comparator = this.source();
                break;
            }
            case 1: {
                comparator = this.countExpression();
                break;
            }
            case 2: {
                comparator = this.comparator();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return comparator;
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof TopNPipe;
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof TopNPipe)) return false;
        boolean bl = true;
        if (!bl) return false;
        TopNPipe topNPipe = (TopNPipe)x$1;
        Pipe pipe = this.source();
        Pipe pipe2 = topNPipe.source();
        if (pipe == null) {
            if (pipe2 != null) {
                return false;
            }
        } else if (!pipe.equals(pipe2)) return false;
        Expression expression = this.countExpression();
        Expression expression2 = topNPipe.countExpression();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Comparator<ExecutionContext> comparator = this.comparator();
        Comparator<ExecutionContext> comparator2 = topNPipe.comparator();
        if (comparator == null) {
            if (comparator2 != null) {
                return false;
            }
        } else if (!((Object)comparator).equals(comparator2)) return false;
        if (!topNPipe.canEqual(this)) return false;
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$internalCreateResults$1(long limit$1, LongRef c$1, ExecutionContext x$1) {
        ++c$1.elem;
        return c$1.elem <= limit$1;
    }

    public TopNPipe(Pipe source, Expression countExpression, Comparator<ExecutionContext> comparator, int id) {
        this.source = source;
        this.countExpression = countExpression;
        this.comparator = comparator;
        this.id = id;
        super(source);
        Product.$init$((Product)this);
        countExpression.registerOwningPipe(this);
        this.initialFallbackSortArraySize = 0xFFFFFFF;
    }
}

