/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.runtime.interpreted.pipes;

import org.neo4j.cypher.internal.runtime.ExecutionContext;
import org.neo4j.cypher.internal.runtime.interpreted.commands.expressions.Expression;
import org.neo4j.cypher.internal.runtime.interpreted.commands.expressions.NumericHelper$;
import org.neo4j.cypher.internal.runtime.interpreted.pipes.LimitPipe$;
import org.neo4j.cypher.internal.runtime.interpreted.pipes.Pipe;
import org.neo4j.cypher.internal.runtime.interpreted.pipes.PipeWithSource;
import org.neo4j.cypher.internal.runtime.interpreted.pipes.QueryState;
import org.neo4j.exceptions.InvalidArgumentException;
import org.neo4j.values.storable.FloatingPointValue;
import org.neo4j.values.storable.NumberValue;
import scala.Option;
import scala.Product;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.AbstractIterator;
import scala.collection.Iterator;
import scala.collection.Iterator$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0001\u0005mf\u0001B\u0001\u0003\u0001F\u0011\u0011\u0002T5nSR\u0004\u0016\u000e]3\u000b\u0005\r!\u0011!\u00029ja\u0016\u001c(BA\u0003\u0007\u0003-Ig\u000e^3saJ,G/\u001a3\u000b\u0005\u001dA\u0011a\u0002:v]RLW.\u001a\u0006\u0003\u0013)\t\u0001\"\u001b8uKJt\u0017\r\u001c\u0006\u0003\u00171\taaY=qQ\u0016\u0014(BA\u0007\u000f\u0003\u0015qWm\u001c\u001bk\u0015\u0005y\u0011aA8sO\u000e\u00011\u0003\u0002\u0001\u0013-q\u0001\"a\u0005\u000b\u000e\u0003\tI!!\u0006\u0002\u0003\u001dAK\u0007/Z,ji\"\u001cv.\u001e:dKB\u0011qCG\u0007\u00021)\t\u0011$A\u0003tG\u0006d\u0017-\u0003\u0002\u001c1\t9\u0001K]8ek\u000e$\bCA\f\u001e\u0013\tq\u0002D\u0001\u0007TKJL\u0017\r\\5{C\ndW\r\u0003\u0005!\u0001\tU\r\u0011\"\u0001\"\u0003\u0019\u0019x.\u001e:dKV\t!\u0005\u0005\u0002\u0014G%\u0011AE\u0001\u0002\u0005!&\u0004X\r\u0003\u0005'\u0001\tE\t\u0015!\u0003#\u0003\u001d\u0019x.\u001e:dK\u0002B\u0001\u0002\u000b\u0001\u0003\u0016\u0004%\t!K\u0001\u0004Kb\u0004X#\u0001\u0016\u0011\u0005-\u0002T\"\u0001\u0017\u000b\u00055r\u0013aC3yaJ,7o]5p]NT!a\f\u0003\u0002\u0011\r|W.\\1oINL!!\r\u0017\u0003\u0015\u0015C\bO]3tg&|g\u000e\u0003\u00054\u0001\tE\t\u0015!\u0003+\u0003\u0011)\u0007\u0010\u001d\u0011\t\u0011U\u0002!Q1A\u0005\u0002Y\n!!\u001b3\u0016\u0003]\u0002\"\u0001O \u000e\u0003eR!AO\u001e\u0002\u0017\u0005$HO]5ckRLwN\u001c\u0006\u0003yu\nA!\u001e;jY*\u0011a\bC\u0001\u0005mRz\u0006'\u0003\u0002As\t\u0011\u0011\n\u001a\u0005\t\u0005\u0002\u0011\t\u0011)A\u0005o\u0005\u0019\u0011\u000e\u001a\u0011\t\u000b\u0011\u0003A\u0011A#\u0002\rqJg.\u001b;?)\r1\u0015J\u0013\u000b\u0003\u000f\"\u0003\"a\u0005\u0001\t\u000fU\u001a\u0005\u0013!a\u0001o!)\u0001e\u0011a\u0001E!)\u0001f\u0011a\u0001U!)A\n\u0001C\t\u001b\u0006)\u0012N\u001c;fe:\fGn\u0011:fCR,'+Z:vYR\u001cHc\u0001(_AB\u0019qj\u0016.\u000f\u0005A+fBA)U\u001b\u0005\u0011&BA*\u0011\u0003\u0019a$o\\8u}%\t\u0011$\u0003\u0002W1\u00059\u0001/Y2lC\u001e,\u0017B\u0001-Z\u0005!IE/\u001a:bi>\u0014(B\u0001,\u0019!\tYF,D\u0001\u0007\u0013\tifA\u0001\tFq\u0016\u001cW\u000f^5p]\u000e{g\u000e^3yi\")ql\u0013a\u0001\u001d\u0006)\u0011N\u001c9vi\")\u0011m\u0013a\u0001E\u0006)1\u000f^1uKB\u00111cY\u0005\u0003I\n\u0011!\"U;fef\u001cF/\u0019;f\u0011\u001d1\u0007!!A\u0005\u0002\u001d\fAaY8qsR\u0019\u0001N[6\u0015\u0005\u001dK\u0007\"B\u001bf\u0001\u00049\u0004b\u0002\u0011f!\u0003\u0005\rA\t\u0005\bQ\u0015\u0004\n\u00111\u0001+\u0011\u001di\u0007!%A\u0005\u00029\fabY8qs\u0012\"WMZ1vYR$\u0013'F\u0001pU\t\u0011\u0003oK\u0001r!\t\u0011x/D\u0001t\u0015\t!X/A\u0005v]\u000eDWmY6fI*\u0011a\u000fG\u0001\u000bC:tw\u000e^1uS>t\u0017B\u0001=t\u0005E)hn\u00195fG.,GMV1sS\u0006t7-\u001a\u0005\bu\u0002\t\n\u0011\"\u0001|\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uII*\u0012\u0001 \u0016\u0003UADqA \u0001\u0002\u0002\u0013\u0005s0A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u000b\u0003\u0003\u0003\u0001B!a\u0001\u0002\u000e5\u0011\u0011Q\u0001\u0006\u0005\u0003\u000f\tI!\u0001\u0003mC:<'BAA\u0006\u0003\u0011Q\u0017M^1\n\t\u0005=\u0011Q\u0001\u0002\u0007'R\u0014\u0018N\\4\t\u0013\u0005M\u0001!!A\u0005\u0002\u0005U\u0011\u0001\u00049s_\u0012,8\r^!sSRLXCAA\f!\r9\u0012\u0011D\u0005\u0004\u00037A\"aA%oi\"I\u0011q\u0004\u0001\u0002\u0002\u0013\u0005\u0011\u0011E\u0001\u000faJ|G-^2u\u000b2,W.\u001a8u)\u0011\t\u0019#!\u000b\u0011\u0007]\t)#C\u0002\u0002(a\u00111!\u00118z\u0011)\tY#!\b\u0002\u0002\u0003\u0007\u0011qC\u0001\u0004q\u0012\n\u0004\"CA\u0018\u0001\u0005\u0005I\u0011IA\u0019\u0003=\u0001(o\u001c3vGRLE/\u001a:bi>\u0014XCAA\u001a!\u0019\t)$a\u000f\u0002$5\u0011\u0011q\u0007\u0006\u0004\u0003sA\u0012AC2pY2,7\r^5p]&\u0019\u0001,a\u000e\t\u0013\u0005}\u0002!!A\u0005\u0002\u0005\u0005\u0013\u0001C2b]\u0016\u000bX/\u00197\u0015\t\u0005\r\u0013\u0011\n\t\u0004/\u0005\u0015\u0013bAA$1\t9!i\\8mK\u0006t\u0007BCA\u0016\u0003{\t\t\u00111\u0001\u0002$!I\u0011Q\n\u0001\u0002\u0002\u0013\u0005\u0013qJ\u0001\tQ\u0006\u001c\bnQ8eKR\u0011\u0011q\u0003\u0005\n\u0003'\u0002\u0011\u0011!C!\u0003+\n\u0001\u0002^8TiJLgn\u001a\u000b\u0003\u0003\u0003A\u0011\"!\u0017\u0001\u0003\u0003%\t%a\u0017\u0002\r\u0015\fX/\u00197t)\u0011\t\u0019%!\u0018\t\u0015\u0005-\u0012qKA\u0001\u0002\u0004\t\u0019cB\u0005\u0002b\t\t\t\u0011#\u0001\u0002d\u0005IA*[7jiBK\u0007/\u001a\t\u0004'\u0005\u0015d\u0001C\u0001\u0003\u0003\u0003E\t!a\u001a\u0014\u000b\u0005\u0015\u0014\u0011\u000e\u000f\u0011\u0007]\tY'C\u0002\u0002na\u0011a!\u00118z%\u00164\u0007b\u0002#\u0002f\u0011\u0005\u0011\u0011\u000f\u000b\u0003\u0003GB!\"a\u0015\u0002f\u0005\u0005IQIA+\u0011)\t9(!\u001a\u0002\u0002\u0013\u0005\u0015\u0011P\u0001\u0006CB\u0004H.\u001f\u000b\u0007\u0003w\ny(!!\u0015\u0007\u001d\u000bi\b\u0003\u00056\u0003k\u0002\n\u00111\u00018\u0011\u0019\u0001\u0013Q\u000fa\u0001E!1\u0001&!\u001eA\u0002)B!\"!\"\u0002f\u0005\u0005I\u0011QAD\u0003\u001d)h.\u00199qYf$B!!#\u0002\u0016B)q#a#\u0002\u0010&\u0019\u0011Q\u0012\r\u0003\r=\u0003H/[8o!\u00159\u0012\u0011\u0013\u0012+\u0013\r\t\u0019\n\u0007\u0002\u0007)V\u0004H.\u001a\u001a\t\u0013\u0005]\u00151QA\u0001\u0002\u00049\u0015a\u0001=%a!Q\u00111TA3#\u0003%\t!!(\u0002\u001f\u0005\u0004\b\u000f\\=%I\u00164\u0017-\u001e7uIM\"b!a(\u0002\"\u0006\r&FA\u001cq\u0011\u0019\u0001\u0013\u0011\u0014a\u0001E!1\u0001&!'A\u0002)B!\"a*\u0002fE\u0005I\u0011AAU\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%gQ1\u0011qTAV\u0003[Ca\u0001IAS\u0001\u0004\u0011\u0003B\u0002\u0015\u0002&\u0002\u0007!\u0006\u0003\u0006\u00022\u0006\u0015\u0014\u0011!C\u0005\u0003g\u000b1B]3bIJ+7o\u001c7wKR\u0011\u0011Q\u0017\t\u0005\u0003\u0007\t9,\u0003\u0003\u0002:\u0006\u0015!AB(cU\u0016\u001cG\u000f")
public class LimitPipe
extends PipeWithSource
implements Product,
Serializable {
    private final Pipe source;
    private final Expression exp;
    private final int id;

    public static int $lessinit$greater$default$3(Pipe pipe, Expression expression) {
        return LimitPipe$.MODULE$.$lessinit$greater$default$3(pipe, expression);
    }

    public static int apply$default$3(Pipe pipe, Expression expression) {
        return LimitPipe$.MODULE$.apply$default$3(pipe, expression);
    }

    public static Option<Tuple2<Pipe, Expression>> unapply(LimitPipe limitPipe) {
        return LimitPipe$.MODULE$.unapply(limitPipe);
    }

    public static LimitPipe apply(Pipe pipe, Expression expression, int n) {
        return LimitPipe$.MODULE$.apply(pipe, expression, n);
    }

    public Pipe source() {
        return this.source;
    }

    public Expression exp() {
        return this.exp;
    }

    @Override
    public int id() {
        return this.id;
    }

    @Override
    public Iterator<ExecutionContext> internalCreateResults(Iterator<ExecutionContext> input, QueryState state) {
        NumberValue limitNumber = NumericHelper$.MODULE$.asNumber(this.exp().apply(state.newExecutionContext(this.executionContextFactory()), state));
        if (limitNumber instanceof FloatingPointValue) {
            double limit = limitNumber.doubleValue();
            throw new InvalidArgumentException(new StringBuilder(78).append("LIMIT: Invalid input. '").append(limit).append("' is not a valid value. Must be a non-negative integer.").toString());
        }
        long limit = limitNumber.longValue();
        if (limit < 0L) {
            throw new InvalidArgumentException(new StringBuilder(78).append("LIMIT: Invalid input. '").append(limit).append("' is not a valid value. Must be a non-negative integer.").toString());
        }
        if (limit == 0L || input.isEmpty()) {
            return Iterator$.MODULE$.empty();
        }
        return new AbstractIterator<ExecutionContext>(null, input, limit){
            private long remaining;
            private final Iterator input$1;

            private long remaining() {
                return this.remaining;
            }

            private void remaining_$eq(long x$1) {
                this.remaining = x$1;
            }

            public boolean hasNext() {
                return this.remaining() > 0L && this.input$1.hasNext();
            }

            public ExecutionContext next() {
                ExecutionContext executionContext;
                if (this.remaining() > 0L) {
                    this.remaining_$eq(this.remaining() - 1L);
                    executionContext = (ExecutionContext)this.input$1.next();
                } else {
                    executionContext = (ExecutionContext)Iterator$.MODULE$.empty().next();
                }
                return executionContext;
            }
            {
                this.input$1 = input$1;
                this.remaining = limit$1;
            }
        };
    }

    public LimitPipe copy(Pipe source, Expression exp, int id) {
        return new LimitPipe(source, exp, id);
    }

    public Pipe copy$default$1() {
        return this.source();
    }

    public Expression copy$default$2() {
        return this.exp();
    }

    public String productPrefix() {
        return "LimitPipe";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.source();
                break;
            }
            case 1: {
                object = this.exp();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return object;
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof LimitPipe;
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof LimitPipe)) return false;
        boolean bl = true;
        if (!bl) return false;
        LimitPipe limitPipe = (LimitPipe)x$1;
        Pipe pipe = this.source();
        Pipe pipe2 = limitPipe.source();
        if (pipe == null) {
            if (pipe2 != null) {
                return false;
            }
        } else if (!pipe.equals(pipe2)) return false;
        Expression expression = this.exp();
        Expression expression2 = limitPipe.exp();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        if (!limitPipe.canEqual(this)) return false;
        return true;
    }

    public LimitPipe(Pipe source, Expression exp, int id) {
        this.source = source;
        this.exp = exp;
        this.id = id;
        super(source);
        Product.$init$((Product)this);
        exp.registerOwningPipe(this);
    }
}

