/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.runtime.interpreted.pipes;

import java.io.Serializable;
import org.neo4j.cypher.internal.runtime.ExecutionContext;
import org.neo4j.cypher.internal.runtime.IsNoValue$;
import org.neo4j.cypher.internal.runtime.LenientCreateRelationship$;
import org.neo4j.cypher.internal.runtime.Operations;
import org.neo4j.cypher.internal.runtime.interpreted.pipes.BaseCreatePipe;
import org.neo4j.cypher.internal.runtime.interpreted.pipes.CreateNodeCommand;
import org.neo4j.cypher.internal.runtime.interpreted.pipes.CreateRelationshipCommand;
import org.neo4j.cypher.internal.runtime.interpreted.pipes.Pipe;
import org.neo4j.cypher.internal.runtime.interpreted.pipes.QueryState;
import org.neo4j.exceptions.InternalException;
import org.neo4j.values.AnyValue;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;
import org.neo4j.values.virtual.NodeValue;
import org.neo4j.values.virtual.RelationshipValue;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001!4Q!\u0001\u0002\u0002\u0002E\u0011\u0001#\u00128uSRL8I]3bi\u0016\u0004\u0016\u000e]3\u000b\u0005\r!\u0011!\u00029ja\u0016\u001c(BA\u0003\u0007\u0003-Ig\u000e^3saJ,G/\u001a3\u000b\u0005\u001dA\u0011a\u0002:v]RLW.\u001a\u0006\u0003\u0013)\t\u0001\"\u001b8uKJt\u0017\r\u001c\u0006\u0003\u00171\taaY=qQ\u0016\u0014(BA\u0007\u000f\u0003\u0015qWm\u001c\u001bk\u0015\u0005y\u0011aA8sO\u000e\u00011C\u0001\u0001\u0013!\t\u0019B#D\u0001\u0003\u0013\t)\"A\u0001\bCCN,7I]3bi\u0016\u0004\u0016\u000e]3\t\u0011]\u0001!\u0011!Q\u0001\na\t1a\u001d:d!\t\u0019\u0012$\u0003\u0002\u001b\u0005\t!\u0001+\u001b9f\u0011\u0015a\u0002\u0001\"\u0001\u001e\u0003\u0019a\u0014N\\5u}Q\u0011ad\b\t\u0003'\u0001AQaF\u000eA\u0002aAQ!\t\u0001\u0005\u0012\t\n!b\u0019:fCR,gj\u001c3f)\u0011\u0019CHQ$\u0011\t\u0011:\u0013\u0006N\u0007\u0002K)\ta%A\u0003tG\u0006d\u0017-\u0003\u0002)K\t1A+\u001e9mKJ\u0002\"AK\u0019\u000f\u0005-z\u0003C\u0001\u0017&\u001b\u0005i#B\u0001\u0018\u0011\u0003\u0019a$o\\8u}%\u0011\u0001'J\u0001\u0007!J,G-\u001a4\n\u0005I\u001a$AB*ue&twM\u0003\u00021KA\u0011QGO\u0007\u0002m)\u0011q\u0007O\u0001\bm&\u0014H/^1m\u0015\tID\"\u0001\u0004wC2,Xm]\u0005\u0003wY\u0012\u0011BT8eKZ\u000bG.^3\t\u000bu\u0002\u0003\u0019\u0001 \u0002\u000f\r|g\u000e^3yiB\u0011q\bQ\u0007\u0002\r%\u0011\u0011I\u0002\u0002\u0011\u000bb,7-\u001e;j_:\u001cuN\u001c;fqRDQa\u0011\u0011A\u0002\u0011\u000bQa\u001d;bi\u0016\u0004\"aE#\n\u0005\u0019\u0013!AC)vKJL8\u000b^1uK\")\u0001\n\ta\u0001\u0013\u0006!A-\u0019;b!\t\u0019\"*\u0003\u0002L\u0005\t\t2I]3bi\u0016tu\u000eZ3D_6l\u0017M\u001c3\t\u000b5\u0003A\u0011\u0003(\u0002%\r\u0014X-\u0019;f%\u0016d\u0017\r^5p]ND\u0017\u000e\u001d\u000b\u0005\u001fR+f\u000b\u0005\u0003%O%\u0002\u0006CA)S\u001b\u0005A\u0014BA*9\u0005!\te.\u001f,bYV,\u0007\"B\u001fM\u0001\u0004q\u0004\"B\"M\u0001\u0004!\u0005\"\u0002%M\u0001\u00049\u0006CA\nY\u0013\tI&AA\rDe\u0016\fG/\u001a*fY\u0006$\u0018n\u001c8tQ&\u00048i\\7nC:$\u0007\"B.\u0001\t\u0013a\u0016aB4fi:{G-\u001a\u000b\u0006iu{\u0016m\u0019\u0005\u0006=j\u0003\rAP\u0001\u0004e><\b\"\u00021[\u0001\u0004I\u0013a\u0002:fY:\u000bW.\u001a\u0005\u0006Ej\u0003\r!K\u0001\u0005]\u0006lW\rC\u0003e5\u0002\u0007Q-A\u0004mK:LWM\u001c;\u0011\u0005\u00112\u0017BA4&\u0005\u001d\u0011un\u001c7fC:\u0004")
public abstract class EntityCreatePipe
extends BaseCreatePipe {
    public Tuple2<String, NodeValue> createNode(ExecutionContext context, QueryState state, CreateNodeCommand data) {
        int[] labelIds = (int[])((TraversableOnce)data.labels().map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToInteger((int)x$1.getOrCreateId(state.query())), Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.Int());
        NodeValue node = state.query().createNode(labelIds);
        data.properties().foreach((Function1 & Serializable & scala.Serializable)x$2 -> {
            this.setProperties(context, state, node.id(), x$2, (Operations<?, ?>)state.query().nodeOps());
            return BoxedUnit.UNIT;
        });
        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)data.idName()), (Object)node);
    }

    public Tuple2<String, AnyValue> createRelationship(ExecutionContext context, QueryState state, CreateRelationshipCommand data) {
        Value value;
        NodeValue start = this.getNode(context, data.idName(), data.startNode(), state.lenientCreateRelationship());
        NodeValue end = this.getNode(context, data.idName(), data.endNode(), state.lenientCreateRelationship());
        if (start == null || end == null) {
            value = Values.NO_VALUE;
        } else {
            int typeId = data.relType().typ(state.query());
            RelationshipValue relationship = state.query().createRelationship(start.id(), end.id(), typeId);
            data.properties().foreach((Function1 & Serializable & scala.Serializable)x$3 -> {
                this.setProperties(context, state, relationship.id(), x$3, (Operations<?, ?>)state.query().relationshipOps());
                return BoxedUnit.UNIT;
            });
            value = relationship;
        }
        Value relationship = value;
        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)data.idName()), (Object)relationship);
    }

    private NodeValue getNode(ExecutionContext row, String relName, String name, boolean lenient) {
        NodeValue nodeValue;
        AnyValue anyValue = row.getByName(name);
        if (anyValue instanceof NodeValue) {
            NodeValue nodeValue2;
            nodeValue = nodeValue2 = (NodeValue)anyValue;
        } else if (IsNoValue$.MODULE$.unapply(anyValue)) {
            if (!lenient) {
                throw new InternalException(LenientCreateRelationship$.MODULE$.errorMsg(relName, name));
            }
            nodeValue = null;
        } else {
            throw new InternalException(new StringBuilder(49).append("Expected to find a node at '").append(name).append("' but found instead: ").append(anyValue).toString());
        }
        return nodeValue;
    }

    public EntityCreatePipe(Pipe src) {
        super(src);
    }
}

