/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.runtime.interpreted.load_csv;

import java.net.URL;
import org.neo4j.cypher.internal.runtime.QueryContext;
import org.neo4j.cypher.internal.runtime.ResourceManager;
import org.neo4j.cypher.internal.runtime.interpreted.CSVResource;
import org.neo4j.cypher.internal.runtime.interpreted.load_csv.LoadCsvIteratorWithPeriodicCommit;
import org.neo4j.cypher.internal.runtime.interpreted.load_csv.UpdateCounter;
import org.neo4j.cypher.internal.runtime.interpreted.pipes.ExternalCSVResource;
import org.neo4j.cypher.internal.runtime.interpreted.pipes.LoadCsvIterator;
import org.neo4j.internal.kernel.api.AutoCloseablePlus;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Serializable;
import scala.Some;
import scala.collection.mutable.ArrayBuffer;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005Ua\u0001B\u0001\u0003\u0001E\u0011Q\u0004T8bI\u000e\u001bh\u000fU3sS>$\u0017nY\"p[6LGo\u00142tKJ4XM\u001d\u0006\u0003\u0007\u0011\t\u0001\u0002\\8bI~\u001b7O\u001e\u0006\u0003\u000b\u0019\t1\"\u001b8uKJ\u0004(/\u001a;fI*\u0011q\u0001C\u0001\beVtG/[7f\u0015\tI!\"\u0001\u0005j]R,'O\\1m\u0015\tYA\"\u0001\u0004dsBDWM\u001d\u0006\u0003\u001b9\tQA\\3pi)T\u0011aD\u0001\u0004_J<7\u0001A\n\u0004\u0001IA\u0002CA\n\u0017\u001b\u0005!\"\"A\u000b\u0002\u000bM\u001c\u0017\r\\1\n\u0005]!\"AB!osJ+g\r\u0005\u0002\u001a95\t!D\u0003\u0002\u001c\t\u0005)\u0001/\u001b9fg&\u0011QD\u0007\u0002\u0014\u000bb$XM\u001d8bY\u000e\u001bfKU3t_V\u00148-\u001a\u0005\t?\u0001\u0011\t\u0011)A\u0005A\u0005i!-\u0019;dQJ{woQ8v]R\u0004\"aE\u0011\n\u0005\t\"\"\u0001\u0002'p]\u001eD\u0001\u0002\n\u0001\u0003\u0002\u0003\u0006I\u0001G\u0001\ne\u0016\u001cx.\u001e:dKND\u0001B\n\u0001\u0003\u0002\u0003\u0006IaJ\u0001\rcV,'/_\"p]R,\u0007\u0010\u001e\t\u0003Q%j\u0011AB\u0005\u0003U\u0019\u0011A\"U;fef\u001cuN\u001c;fqRDQ\u0001\f\u0001\u0005\u00025\na\u0001P5oSRtD\u0003\u0002\u00181cI\u0002\"a\f\u0001\u000e\u0003\tAQaH\u0016A\u0002\u0001BQ\u0001J\u0016A\u0002aAQAJ\u0016A\u0002\u001dBq\u0001\u000e\u0001C\u0002\u0013\u0005Q'A\u0007va\u0012\fG/Z\"pk:$XM]\u000b\u0002mA\u0011qfN\u0005\u0003q\t\u0011Q\"\u00169eCR,7i\\;oi\u0016\u0014\bB\u0002\u001e\u0001A\u0003%a'\u0001\bva\u0012\fG/Z\"pk:$XM\u001d\u0011\t\u000fq\u0002\u0001\u0019!C\u0001{\u0005!r.\u001e;fe2{\u0017\rZ\"T-&#XM]1u_J,\u0012A\u0010\t\u0004'}\n\u0015B\u0001!\u0015\u0005\u0019y\u0005\u000f^5p]B\u0011qFQ\u0005\u0003\u0007\n\u0011\u0011\u0005T8bI\u000e\u001bh/\u0013;fe\u0006$xN],ji\"\u0004VM]5pI&\u001c7i\\7nSRDq!\u0012\u0001A\u0002\u0013\u0005a)\u0001\rpkR,'\u000fT8bI\u000e\u001bf+\u0013;fe\u0006$xN]0%KF$\"a\u0012&\u0011\u0005MA\u0015BA%\u0015\u0005\u0011)f.\u001b;\t\u000f-#\u0015\u0011!a\u0001}\u0005\u0019\u0001\u0010J\u0019\t\r5\u0003\u0001\u0015)\u0003?\u0003UyW\u000f^3s\u0019>\fGmQ*W\u0013R,'/\u0019;pe\u0002BQa\u0014\u0001\u0005BA\u000babZ3u\u0007N4\u0018\n^3sCR|'\u000f\u0006\u0004R)zc\u0017O\u001e\t\u00033IK!a\u0015\u000e\u0003\u001f1{\u0017\rZ\"tm&#XM]1u_JDQ!\u0016(A\u0002Y\u000b1!\u001e:m!\t9F,D\u0001Y\u0015\tI&,A\u0002oKRT\u0011aW\u0001\u0005U\u00064\u0018-\u0003\u0002^1\n\u0019QK\u0015'\t\u000b}s\u0005\u0019\u00011\u0002\u001f\u0019LW\r\u001c3UKJl\u0017N\\1u_J\u00042aE b!\t\u0011\u0017N\u0004\u0002dOB\u0011A\rF\u0007\u0002K*\u0011a\rE\u0001\u0007yI|w\u000e\u001e \n\u0005!$\u0012A\u0002)sK\u0012,g-\u0003\u0002kW\n11\u000b\u001e:j]\u001eT!\u0001\u001b\u000b\t\u000b5t\u0005\u0019\u00018\u0002-1,w-Y2z\u0007N4\u0018+^8uK\u0016\u001b8-\u00199j]\u001e\u0004\"aE8\n\u0005A$\"a\u0002\"p_2,\u0017M\u001c\u0005\u0006e:\u0003\ra]\u0001\u000bEV4g-\u001a:TSj,\u0007CA\nu\u0013\t)HCA\u0002J]RDqa\u001e(\u0011\u0002\u0003\u0007a.A\u0004iK\u0006$WM]:\t\u000be\u0004A\u0011\u0002>\u0002\r=tg*\u001a=u)\u00059\u0005\"\u0002?\u0001\t\u0013Q\u0018AE2p[6LG/\u00118e%\u0016\u001cH/\u0019:u)bDqA \u0001\u0012\u0002\u0013\u0005s0\u0001\rhKR\u001c5O^%uKJ\fGo\u001c:%I\u00164\u0017-\u001e7uIU*\"!!\u0001+\u00079\f\u0019a\u000b\u0002\u0002\u0006A!\u0011qAA\t\u001b\t\tIA\u0003\u0003\u0002\f\u00055\u0011!C;oG\",7m[3e\u0015\r\ty\u0001F\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BA\n\u0003\u0013\u0011\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0001")
public class LoadCsvPeriodicCommitObserver
implements ExternalCSVResource {
    private final long batchRowCount;
    private final ExternalCSVResource resources;
    private final QueryContext queryContext;
    private final UpdateCounter updateCounter;
    private Option<LoadCsvIteratorWithPeriodicCommit> outerLoadCSVIterator;

    public UpdateCounter updateCounter() {
        return this.updateCounter;
    }

    public Option<LoadCsvIteratorWithPeriodicCommit> outerLoadCSVIterator() {
        return this.outerLoadCSVIterator;
    }

    public void outerLoadCSVIterator_$eq(Option<LoadCsvIteratorWithPeriodicCommit> x$1) {
        this.outerLoadCSVIterator = x$1;
    }

    @Override
    public LoadCsvIterator getCsvIterator(URL url, Option<String> fieldTerminator, boolean legacyCsvQuoteEscaping, int bufferSize, boolean headers) {
        LoadCsvIterator loadCsvIterator;
        LoadCsvIterator innerIterator = this.resources.getCsvIterator(url, fieldTerminator, legacyCsvQuoteEscaping, bufferSize, headers);
        if (this.outerLoadCSVIterator().isEmpty()) {
            if (headers) {
                this.updateCounter().offsetForHeaders();
            }
            LoadCsvIteratorWithPeriodicCommit iterator = new LoadCsvIteratorWithPeriodicCommit(innerIterator, (Function0<BoxedUnit>)(JFunction0.mcV.sp & java.io.Serializable & Serializable)() -> this.onNext());
            this.outerLoadCSVIterator_$eq((Option<LoadCsvIteratorWithPeriodicCommit>)new Some((Object)iterator));
            loadCsvIterator = iterator;
        } else {
            loadCsvIterator = innerIterator;
        }
        return loadCsvIterator;
    }

    @Override
    public boolean getCsvIterator$default$5() {
        return false;
    }

    private void onNext() {
        this.updateCounter().resetIfPastLimit(this.batchRowCount, (Function0<BoxedUnit>)(JFunction0.mcV.sp & java.io.Serializable & Serializable)() -> this.commitAndRestartTx());
        this.updateCounter().$plus$eq(1L);
    }

    private void commitAndRestartTx() {
        ArrayBuffer csvResources = new ArrayBuffer();
        this.queryContext.resources().allResources().foreach((Function1 & java.io.Serializable & Serializable)x0$1 -> {
            BoxedUnit boxedUnit;
            AutoCloseablePlus autoCloseablePlus = x0$1;
            if (autoCloseablePlus instanceof CSVResource) {
                CSVResource cSVResource = (CSVResource)autoCloseablePlus;
                boxedUnit = csvResources.$plus$eq((Object)cSVResource);
            } else {
                autoCloseablePlus.closeInternal();
                boxedUnit = BoxedUnit.UNIT;
            }
            return boxedUnit;
        });
        ResourceManager resourceManager = this.queryContext.resources();
        csvResources.foreach((Function1 & java.io.Serializable & Serializable)resource -> {
            resourceManager.untrace(resource);
            return BoxedUnit.UNIT;
        });
        this.queryContext.transactionalContext().commitAndRestartTx();
        ResourceManager resourceManager2 = this.queryContext.resources();
        csvResources.foreach((Function1 & java.io.Serializable & Serializable)resource -> {
            resourceManager2.trace(resource);
            return BoxedUnit.UNIT;
        });
        this.outerLoadCSVIterator().foreach((Function1 & java.io.Serializable & Serializable)x$1 -> {
            x$1.notifyCommit();
            return BoxedUnit.UNIT;
        });
    }

    public LoadCsvPeriodicCommitObserver(long batchRowCount, ExternalCSVResource resources, QueryContext queryContext) {
        this.batchRowCount = batchRowCount;
        this.resources = resources;
        this.queryContext = queryContext;
        this.updateCounter = new UpdateCounter();
        this.outerLoadCSVIterator = None$.MODULE$;
    }
}

