/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.csv.reader;

import java.io.IOException;
import org.neo4j.csv.reader.CharReadable;
import org.neo4j.csv.reader.CharReadableChunker;
import org.neo4j.csv.reader.HeaderSkipper;
import org.neo4j.csv.reader.Source;

public class ClosestNewLineChunker
extends CharReadableChunker {
    private final HeaderSkipper headerSkip;
    private String lastSeenSourceDescription;
    private int fileIndex = -1;

    public ClosestNewLineChunker(CharReadable reader, int chunkSize, HeaderSkipper headerSkip) {
        super(reader, chunkSize);
        this.headerSkip = headerSkip;
    }

    @Override
    public synchronized boolean nextChunk(Source.Chunk chunk) throws IOException {
        int leftToRead;
        CharReadableChunker.ChunkImpl into = (CharReadableChunker.ChunkImpl)chunk;
        int offset = this.fillFromBackBuffer(into.buffer);
        int read = this.reader.read(into.buffer, offset, leftToRead = this.chunkSize - offset);
        if (read == leftToRead) {
            int newlineOffset = ClosestNewLineChunker.offsetOfLastNewline(into.buffer);
            if (newlineOffset > -1) {
                read -= this.storeInBackBuffer(into.data(), newlineOffset + 1, this.chunkSize - (newlineOffset + 1));
            } else {
                throw new IllegalStateException("Weird input data, no newline character in the whole buffer " + this.chunkSize + ", not supported a.t.m.");
            }
        }
        boolean newSource = this.crossedOverToNewSource();
        if (read > 0) {
            this.position += (long)read;
            int skipped = newSource && this.fileIndex > 0 ? this.headerSkip.skipHeader(into.buffer, 0, offset += read) : 0;
            into.initialize(skipped, offset - skipped, this.lastSeenSourceDescription);
            return true;
        }
        return false;
    }

    private boolean crossedOverToNewSource() {
        String currentSourceDescription = this.reader.sourceDescription();
        if (!currentSourceDescription.equals(this.lastSeenSourceDescription)) {
            ++this.fileIndex;
            this.lastSeenSourceDescription = currentSourceDescription;
            return true;
        }
        return false;
    }

    private static int offsetOfLastNewline(char[] buffer) {
        for (int i = buffer.length - 1; i >= 0; --i) {
            if (buffer[i] != '\n') continue;
            return i;
        }
        return -1;
    }
}

