/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.csv.reader;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.nio.CharBuffer;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.commons.lang3.exception.CloneFailedException;
import org.neo4j.collection.PrimitiveLongCollections;
import org.neo4j.csv.reader.Configuration;
import org.neo4j.csv.reader.Extractor;
import org.neo4j.graphdb.spatial.Point;
import org.neo4j.internal.helpers.Numbers;
import org.neo4j.values.AnyValue;
import org.neo4j.values.storable.CSVHeaderInformation;
import org.neo4j.values.storable.DateArray;
import org.neo4j.values.storable.DateTimeArray;
import org.neo4j.values.storable.DateTimeValue;
import org.neo4j.values.storable.DateValue;
import org.neo4j.values.storable.DurationArray;
import org.neo4j.values.storable.DurationValue;
import org.neo4j.values.storable.LocalDateTimeArray;
import org.neo4j.values.storable.LocalDateTimeValue;
import org.neo4j.values.storable.LocalTimeArray;
import org.neo4j.values.storable.LocalTimeValue;
import org.neo4j.values.storable.PointArray;
import org.neo4j.values.storable.PointValue;
import org.neo4j.values.storable.TimeArray;
import org.neo4j.values.storable.TimeValue;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

public class Extractors {
    private final Map<String, Extractor<?>> instances = new HashMap();
    private final Extractor<String> string;
    private final LongExtractor long_;
    private final IntExtractor int_;
    private final CharExtractor char_;
    private final ShortExtractor short_;
    private final ByteExtractor byte_;
    private final BooleanExtractor boolean_;
    private final FloatExtractor float_;
    private final DoubleExtractor double_;
    private final Extractor<String[]> stringArray;
    private final Extractor<boolean[]> booleanArray;
    private final Extractor<byte[]> byteArray;
    private final Extractor<short[]> shortArray;
    private final Extractor<int[]> intArray;
    private final Extractor<long[]> longArray;
    private final Extractor<float[]> floatArray;
    private final Extractor<double[]> doubleArray;
    private final PointExtractor point;
    private final PointArrayExtractor pointArray;
    private final DateExtractor date;
    private final DateArrayExtractor dateArray;
    private final TimeExtractor time;
    private final TimeArrayExtractor timeArray;
    private final DateTimeExtractor dateTime;
    private final DateTimeArrayExtractor dateTimeArray;
    private final LocalTimeExtractor localTime;
    private final LocalTimeArrayExtractor localTimeArray;
    private final LocalDateTimeExtractor localDateTime;
    private final LocalDateTimeArrayExtractor localDateTimeArray;
    private final DurationExtractor duration;
    private final TextValueExtractor textValue;
    private final DurationArrayExtractor durationArray;
    private static final char[] BOOLEAN_MATCH = new char[Boolean.TRUE.toString().length()];
    private static final Supplier<ZoneId> inUTC;
    private static final char[] BOOLEAN_TRUE_CHARACTERS;

    public Extractors(char arrayDelimiter) {
        this(arrayDelimiter, Configuration.COMMAS.emptyQuotedStringsAsNull(), Configuration.COMMAS.trimStrings(), inUTC);
    }

    public Extractors(char arrayDelimiter, boolean emptyStringsAsNull) {
        this(arrayDelimiter, emptyStringsAsNull, Configuration.COMMAS.trimStrings(), inUTC);
    }

    public Extractors(char arrayDelimiter, boolean emptyStringsAsNull, boolean trimStrings) {
        this(arrayDelimiter, emptyStringsAsNull, trimStrings, inUTC);
    }

    public Extractors(char arrayDelimiter, boolean emptyStringsAsNull, boolean trimStrings, Supplier<ZoneId> defaultTimeZone) {
        try {
            for (Field field : this.getClass().getDeclaredFields()) {
                Object value;
                if (!Modifier.isStatic(field.getModifiers()) || !((value = field.get(null)) instanceof Extractor)) continue;
                this.instances.put(field.getName(), (Extractor)value);
            }
            this.string = new StringExtractor(emptyStringsAsNull);
            this.add(this.string);
            this.long_ = new LongExtractor();
            this.add(this.long_);
            this.int_ = new IntExtractor(this.long_);
            this.add(this.int_);
            this.char_ = new CharExtractor();
            this.add(this.char_);
            this.short_ = new ShortExtractor(this.long_);
            this.add(this.short_);
            this.byte_ = new ByteExtractor(this.long_);
            this.add(this.byte_);
            this.boolean_ = new BooleanExtractor();
            this.add(this.boolean_);
            this.double_ = new DoubleExtractor();
            this.add(this.double_);
            this.float_ = new FloatExtractor(this.double_);
            this.add(this.float_);
            this.stringArray = new StringArrayExtractor(arrayDelimiter, trimStrings);
            this.add(this.stringArray);
            this.booleanArray = new BooleanArrayExtractor(arrayDelimiter);
            this.add(this.booleanArray);
            this.byteArray = new ByteArrayExtractor(arrayDelimiter);
            this.add(this.byteArray);
            this.shortArray = new ShortArrayExtractor(arrayDelimiter);
            this.add(this.shortArray);
            this.intArray = new IntArrayExtractor(arrayDelimiter);
            this.add(this.intArray);
            this.longArray = new LongArrayExtractor(arrayDelimiter);
            this.add(this.longArray);
            this.floatArray = new FloatArrayExtractor(arrayDelimiter);
            this.add(this.floatArray);
            this.doubleArray = new DoubleArrayExtractor(arrayDelimiter);
            this.add(this.doubleArray);
            this.point = new PointExtractor();
            this.add(this.point);
            this.pointArray = new PointArrayExtractor(arrayDelimiter);
            this.add(this.pointArray);
            this.date = new DateExtractor();
            this.add(this.date);
            this.dateArray = new DateArrayExtractor(arrayDelimiter);
            this.add(this.dateArray);
            this.time = new TimeExtractor(defaultTimeZone);
            this.add(this.time);
            this.timeArray = new TimeArrayExtractor(arrayDelimiter, defaultTimeZone);
            this.add(this.timeArray);
            this.dateTime = new DateTimeExtractor(defaultTimeZone);
            this.add(this.dateTime);
            this.dateTimeArray = new DateTimeArrayExtractor(arrayDelimiter, defaultTimeZone);
            this.add(this.dateTimeArray);
            this.localTime = new LocalTimeExtractor();
            this.add(this.localTime);
            this.localTimeArray = new LocalTimeArrayExtractor(arrayDelimiter);
            this.add(this.localTimeArray);
            this.localDateTime = new LocalDateTimeExtractor();
            this.add(this.localDateTime);
            this.localDateTimeArray = new LocalDateTimeArrayExtractor(arrayDelimiter);
            this.add(this.localDateTimeArray);
            this.duration = new DurationExtractor();
            this.add(this.duration);
            this.textValue = new TextValueExtractor(emptyStringsAsNull);
            this.add(this.textValue);
            this.durationArray = new DurationArrayExtractor(arrayDelimiter);
            this.add(this.durationArray);
        }
        catch (IllegalAccessException e) {
            throw new Error("Bug in reflection code gathering all extractors");
        }
    }

    public void add(Extractor<?> extractor) {
        this.instances.put(extractor.name().toUpperCase(), extractor);
    }

    public Extractor<?> valueOf(String name) {
        Extractor<?> instance = this.instances.get(name.toUpperCase());
        if (instance == null) {
            throw new IllegalArgumentException("'" + name + "'");
        }
        return instance;
    }

    public Extractor<String> string() {
        return this.string;
    }

    public LongExtractor long_() {
        return this.long_;
    }

    public IntExtractor int_() {
        return this.int_;
    }

    public CharExtractor char_() {
        return this.char_;
    }

    public ShortExtractor short_() {
        return this.short_;
    }

    public ByteExtractor byte_() {
        return this.byte_;
    }

    public BooleanExtractor boolean_() {
        return this.boolean_;
    }

    public FloatExtractor float_() {
        return this.float_;
    }

    public DoubleExtractor double_() {
        return this.double_;
    }

    public Extractor<String[]> stringArray() {
        return this.stringArray;
    }

    public Extractor<boolean[]> booleanArray() {
        return this.booleanArray;
    }

    public Extractor<byte[]> byteArray() {
        return this.byteArray;
    }

    public Extractor<short[]> shortArray() {
        return this.shortArray;
    }

    public Extractor<int[]> intArray() {
        return this.intArray;
    }

    public Extractor<long[]> longArray() {
        return this.longArray;
    }

    public Extractor<float[]> floatArray() {
        return this.floatArray;
    }

    public Extractor<double[]> doubleArray() {
        return this.doubleArray;
    }

    public PointExtractor point() {
        return this.point;
    }

    public PointArrayExtractor pointArray() {
        return this.pointArray;
    }

    public DateExtractor date() {
        return this.date;
    }

    public DateArrayExtractor dateArray() {
        return this.dateArray;
    }

    public TimeExtractor time() {
        return this.time;
    }

    public TimeArrayExtractor timeArray() {
        return this.timeArray;
    }

    public DateTimeExtractor dateTime() {
        return this.dateTime;
    }

    public DateTimeArrayExtractor dateTimeArray() {
        return this.dateTimeArray;
    }

    public LocalTimeExtractor localTime() {
        return this.localTime;
    }

    public LocalTimeArrayExtractor localTimeArray() {
        return this.localTimeArray;
    }

    public LocalDateTimeExtractor localDateTime() {
        return this.localDateTime;
    }

    public LocalDateTimeArrayExtractor localDateTimeArray() {
        return this.localDateTimeArray;
    }

    public DurationExtractor duration() {
        return this.duration;
    }

    public TextValueExtractor textValue() {
        return this.textValue;
    }

    public DurationArrayExtractor durationArray() {
        return this.durationArray;
    }

    private static long extractLong(char[] data, int originalOffset, int fullLength) {
        int length;
        long result = 0L;
        boolean negate = false;
        int offset = originalOffset;
        for (length = fullLength; length > 0 && Character.isWhitespace(data[offset]); --length) {
            ++offset;
        }
        while (length > 0 && Character.isWhitespace(data[offset + length - 1])) {
            --length;
        }
        if (length > 0 && data[offset] == '-') {
            negate = true;
            ++offset;
            --length;
        }
        if (length < 1) {
            throw new NumberFormatException("Not an integer: \"" + String.valueOf(data, originalOffset, fullLength) + "\"");
        }
        try {
            for (int i = 0; i < length; ++i) {
                result = result * 10L + (long)Extractors.digit(data[offset + i]);
            }
        }
        catch (NumberFormatException ignored) {
            throw new NumberFormatException("Not an integer: \"" + String.valueOf(data, originalOffset, fullLength) + "\"");
        }
        return negate ? -result : result;
    }

    private static int digit(char ch) {
        int digit = ch - 48;
        if (digit < 0 || digit > 9) {
            throw new NumberFormatException();
        }
        return digit;
    }

    private static boolean extractBoolean(char[] data, int originalOffset, int fullLength) {
        int length;
        int offset = originalOffset;
        for (length = fullLength; length > 0 && Character.isWhitespace(data[offset]); --length) {
            ++offset;
        }
        while (length > 0 && Character.isWhitespace(data[offset + length - 1])) {
            --length;
        }
        if (length != BOOLEAN_TRUE_CHARACTERS.length) {
            return false;
        }
        for (int i = 0; i < BOOLEAN_TRUE_CHARACTERS.length && i < length; ++i) {
            if (data[offset + i] == BOOLEAN_TRUE_CHARACTERS[i]) continue;
            return false;
        }
        return true;
    }

    static {
        Boolean.TRUE.toString().getChars(0, BOOLEAN_MATCH.length, BOOLEAN_MATCH, 0);
        inUTC = () -> ZoneOffset.UTC;
        BOOLEAN_TRUE_CHARACTERS = new char[Boolean.TRUE.toString().length()];
        Boolean.TRUE.toString().getChars(0, BOOLEAN_TRUE_CHARACTERS.length, BOOLEAN_TRUE_CHARACTERS, 0);
    }

    public static class DurationArrayExtractor
    extends ArrayExtractor<DurationArray> {
        private static final DurationArray EMPTY = Values.durationArray((DurationValue[])new DurationValue[0]);

        DurationArrayExtractor(char arrayDelimiter) {
            super(arrayDelimiter, "Duration");
        }

        @Override
        protected void extract0(char[] data, int offset, int length, CSVHeaderInformation optionalData) {
            int numberOfValues = this.numberOfValues(data, offset, length);
            if (numberOfValues <= 0) {
                this.value = EMPTY;
                return;
            }
            DurationValue[] localValue = new DurationValue[numberOfValues];
            int arrayIndex = 0;
            int charIndex = 0;
            while (arrayIndex < numberOfValues) {
                int numberOfChars = this.charsToNextDelimiter(data, offset + charIndex, length - charIndex);
                localValue[arrayIndex] = DurationValue.parse((CharSequence)CharBuffer.wrap(data, offset + charIndex, numberOfChars));
                charIndex += numberOfChars;
                ++arrayIndex;
                ++charIndex;
            }
            this.value = Values.durationArray((DurationValue[])localValue);
        }
    }

    public static class TextValueExtractor
    extends AbstractSingleValueExtractor<Value> {
        private Value value;
        private final boolean emptyStringsAsNull;
        public static final String NAME = "TextValue";

        TextValueExtractor(boolean emptyStringsAsNull) {
            super(NAME);
            this.emptyStringsAsNull = emptyStringsAsNull;
        }

        @Override
        protected boolean nullValue(int length, boolean hadQuotes) {
            return length == 0 && (!hadQuotes || this.emptyStringsAsNull);
        }

        @Override
        protected void clear() {
            this.value = Values.NO_VALUE;
        }

        @Override
        protected boolean extract0(char[] data, int offset, int length, CSVHeaderInformation optionalData) {
            this.value = Values.utf8Value((String)new String(data, offset, length));
            return true;
        }

        @Override
        public Value value() {
            return this.value;
        }
    }

    public static class DurationExtractor
    extends AbstractSingleAnyValueExtractor {
        public static final String NAME = "Duration";

        DurationExtractor() {
            super(NAME);
        }

        @Override
        protected boolean extract0(char[] data, int offset, int length, CSVHeaderInformation optionalData) {
            this.value = DurationValue.parse((CharSequence)CharBuffer.wrap(data, offset, length));
            return true;
        }

        @Override
        public AnyValue value() {
            return this.value;
        }
    }

    public static class LocalDateTimeArrayExtractor
    extends ArrayExtractor<LocalDateTimeArray> {
        private static final LocalDateTimeArray EMPTY = Values.localDateTimeArray((LocalDateTime[])new LocalDateTime[0]);

        LocalDateTimeArrayExtractor(char arrayDelimiter) {
            super(arrayDelimiter, "LocalDateTime");
        }

        @Override
        protected void extract0(char[] data, int offset, int length, CSVHeaderInformation optionalData) {
            int numberOfValues = this.numberOfValues(data, offset, length);
            if (numberOfValues <= 0) {
                this.value = EMPTY;
                return;
            }
            LocalDateTime[] localValue = new LocalDateTime[numberOfValues];
            int arrayIndex = 0;
            int charIndex = 0;
            while (arrayIndex < numberOfValues) {
                int numberOfChars = this.charsToNextDelimiter(data, offset + charIndex, length - charIndex);
                localValue[arrayIndex] = (LocalDateTime)LocalDateTimeValue.parse((CharSequence)CharBuffer.wrap(data, offset + charIndex, numberOfChars)).asObjectCopy();
                charIndex += numberOfChars;
                ++arrayIndex;
                ++charIndex;
            }
            this.value = Values.localDateTimeArray((LocalDateTime[])localValue);
        }
    }

    public static class LocalDateTimeExtractor
    extends AbstractSingleAnyValueExtractor {
        public static final String NAME = "LocalDateTime";

        LocalDateTimeExtractor() {
            super(NAME);
        }

        @Override
        protected boolean extract0(char[] data, int offset, int length, CSVHeaderInformation optionalData) {
            this.value = LocalDateTimeValue.parse((CharSequence)CharBuffer.wrap(data, offset, length));
            return true;
        }

        @Override
        public AnyValue value() {
            return this.value;
        }
    }

    public static class LocalTimeArrayExtractor
    extends ArrayExtractor<LocalTimeArray> {
        private static final LocalTimeArray EMPTY = Values.localTimeArray((LocalTime[])new LocalTime[0]);

        LocalTimeArrayExtractor(char arrayDelimiter) {
            super(arrayDelimiter, "LocalTime");
        }

        @Override
        protected void extract0(char[] data, int offset, int length, CSVHeaderInformation optionalData) {
            int numberOfValues = this.numberOfValues(data, offset, length);
            if (numberOfValues <= 0) {
                this.value = EMPTY;
                return;
            }
            LocalTime[] localValue = new LocalTime[numberOfValues];
            int arrayIndex = 0;
            int charIndex = 0;
            while (arrayIndex < numberOfValues) {
                int numberOfChars = this.charsToNextDelimiter(data, offset + charIndex, length - charIndex);
                localValue[arrayIndex] = (LocalTime)LocalTimeValue.parse((CharSequence)CharBuffer.wrap(data, offset + charIndex, numberOfChars)).asObjectCopy();
                charIndex += numberOfChars;
                ++arrayIndex;
                ++charIndex;
            }
            this.value = Values.localTimeArray((LocalTime[])localValue);
        }
    }

    public static class LocalTimeExtractor
    extends AbstractSingleAnyValueExtractor {
        public static final String NAME = "LocalTime";

        LocalTimeExtractor() {
            super(NAME);
        }

        @Override
        protected boolean extract0(char[] data, int offset, int length, CSVHeaderInformation optionalData) {
            this.value = LocalTimeValue.parse((CharSequence)CharBuffer.wrap(data, offset, length));
            return true;
        }

        @Override
        public AnyValue value() {
            return this.value;
        }
    }

    public static class DateTimeArrayExtractor
    extends ArrayExtractor<DateTimeArray> {
        private static final DateTimeArray EMPTY = Values.dateTimeArray((ZonedDateTime[])new ZonedDateTime[0]);
        private final Supplier<ZoneId> defaultTimeZone;

        DateTimeArrayExtractor(char arrayDelimiter, Supplier<ZoneId> defaultTimeZone) {
            super(arrayDelimiter, "DateTime");
            this.defaultTimeZone = defaultTimeZone;
        }

        @Override
        protected void extract0(char[] data, int offset, int length, CSVHeaderInformation optionalData) {
            int numberOfValues = this.numberOfValues(data, offset, length);
            if (numberOfValues <= 0) {
                this.value = EMPTY;
                return;
            }
            ZonedDateTime[] localValue = new ZonedDateTime[numberOfValues];
            int arrayIndex = 0;
            int charIndex = 0;
            while (arrayIndex < numberOfValues) {
                int numberOfChars = this.charsToNextDelimiter(data, offset + charIndex, length - charIndex);
                localValue[arrayIndex] = (ZonedDateTime)DateTimeValue.parse((CharSequence)CharBuffer.wrap(data, offset + charIndex, numberOfChars), this.defaultTimeZone, (CSVHeaderInformation)optionalData).asObjectCopy();
                charIndex += numberOfChars;
                ++arrayIndex;
                ++charIndex;
            }
            this.value = Values.dateTimeArray((ZonedDateTime[])localValue);
        }
    }

    public static class DateTimeExtractor
    extends AbstractSingleAnyValueExtractor {
        private final Supplier<ZoneId> defaultTimeZone;
        public static final String NAME = "DateTime";

        DateTimeExtractor(Supplier<ZoneId> defaultTimeZone) {
            super(NAME);
            this.defaultTimeZone = defaultTimeZone;
        }

        @Override
        protected boolean extract0(char[] data, int offset, int length, CSVHeaderInformation optionalData) {
            this.value = DateTimeValue.parse((CharSequence)CharBuffer.wrap(data, offset, length), this.defaultTimeZone, (CSVHeaderInformation)optionalData);
            return true;
        }

        @Override
        public AnyValue value() {
            return this.value;
        }
    }

    public static class TimeArrayExtractor
    extends ArrayExtractor<TimeArray> {
        private static final TimeArray EMPTY = Values.timeArray((OffsetTime[])new OffsetTime[0]);
        private final Supplier<ZoneId> defaultTimeZone;

        TimeArrayExtractor(char arrayDelimiter, Supplier<ZoneId> defaultTimeZone) {
            super(arrayDelimiter, "Time");
            this.defaultTimeZone = defaultTimeZone;
        }

        @Override
        protected void extract0(char[] data, int offset, int length, CSVHeaderInformation optionalData) {
            int numberOfValues = this.numberOfValues(data, offset, length);
            if (numberOfValues <= 0) {
                this.value = EMPTY;
                return;
            }
            OffsetTime[] localValue = new OffsetTime[numberOfValues];
            int arrayIndex = 0;
            int charIndex = 0;
            while (arrayIndex < numberOfValues) {
                int numberOfChars = this.charsToNextDelimiter(data, offset + charIndex, length - charIndex);
                localValue[arrayIndex] = (OffsetTime)TimeValue.parse((CharSequence)CharBuffer.wrap(data, offset + charIndex, numberOfChars), this.defaultTimeZone, (CSVHeaderInformation)optionalData).asObjectCopy();
                charIndex += numberOfChars;
                ++arrayIndex;
                ++charIndex;
            }
            this.value = Values.timeArray((OffsetTime[])localValue);
        }
    }

    public static class TimeExtractor
    extends AbstractSingleAnyValueExtractor {
        private final Supplier<ZoneId> defaultTimeZone;
        public static final String NAME = "Time";

        TimeExtractor(Supplier<ZoneId> defaultTimeZone) {
            super(NAME);
            this.defaultTimeZone = defaultTimeZone;
        }

        @Override
        protected boolean extract0(char[] data, int offset, int length, CSVHeaderInformation optionalData) {
            this.value = TimeValue.parse((CharSequence)CharBuffer.wrap(data, offset, length), this.defaultTimeZone, (CSVHeaderInformation)optionalData);
            return true;
        }

        @Override
        public AnyValue value() {
            return this.value;
        }
    }

    public static class DateArrayExtractor
    extends ArrayExtractor<DateArray> {
        private static final DateArray EMPTY = Values.dateArray((LocalDate[])new LocalDate[0]);

        DateArrayExtractor(char arrayDelimiter) {
            super(arrayDelimiter, "Date");
        }

        @Override
        protected void extract0(char[] data, int offset, int length, CSVHeaderInformation optionalData) {
            int numberOfValues = this.numberOfValues(data, offset, length);
            if (numberOfValues <= 0) {
                this.value = EMPTY;
                return;
            }
            LocalDate[] localValue = new LocalDate[numberOfValues];
            int arrayIndex = 0;
            int charIndex = 0;
            while (arrayIndex < numberOfValues) {
                int numberOfChars = this.charsToNextDelimiter(data, offset + charIndex, length - charIndex);
                localValue[arrayIndex] = (LocalDate)DateValue.parse((CharSequence)CharBuffer.wrap(data, offset + charIndex, numberOfChars)).asObjectCopy();
                charIndex += numberOfChars;
                ++arrayIndex;
                ++charIndex;
            }
            this.value = Values.dateArray((LocalDate[])localValue);
        }
    }

    public static class DateExtractor
    extends AbstractSingleAnyValueExtractor {
        public static final String NAME = "Date";

        DateExtractor() {
            super(NAME);
        }

        @Override
        protected boolean extract0(char[] data, int offset, int length, CSVHeaderInformation optionalData) {
            this.value = DateValue.parse((CharSequence)CharBuffer.wrap(data, offset, length));
            return true;
        }

        @Override
        public AnyValue value() {
            return this.value;
        }
    }

    public static class PointArrayExtractor
    extends ArrayExtractor<PointArray> {
        private static final PointArray EMPTY = Values.pointArray((Point[])new Point[0]);

        PointArrayExtractor(char arrayDelimiter) {
            super(arrayDelimiter, "Point");
        }

        @Override
        protected void extract0(char[] data, int offset, int length, CSVHeaderInformation optionalData) {
            int numberOfValues = this.numberOfValues(data, offset, length);
            if (numberOfValues <= 0) {
                this.value = EMPTY;
                return;
            }
            PointValue[] localValue = new PointValue[numberOfValues];
            int arrayIndex = 0;
            int charIndex = 0;
            while (arrayIndex < numberOfValues) {
                int numberOfChars = this.charsToNextDelimiter(data, offset + charIndex, length - charIndex);
                localValue[arrayIndex] = PointValue.parse((CharSequence)CharBuffer.wrap(data, offset + charIndex, numberOfChars), (CSVHeaderInformation)optionalData);
                charIndex += numberOfChars;
                ++arrayIndex;
                ++charIndex;
            }
            this.value = Values.pointArray((PointValue[])localValue);
        }
    }

    public static class PointExtractor
    extends AbstractSingleAnyValueExtractor {
        public static final String NAME = "Point";

        PointExtractor() {
            super(NAME);
        }

        @Override
        protected boolean extract0(char[] data, int offset, int length, CSVHeaderInformation optionalData) {
            this.value = PointValue.parse((CharSequence)CharBuffer.wrap(data, offset, length), (CSVHeaderInformation)optionalData);
            return true;
        }

        @Override
        public AnyValue value() {
            return this.value;
        }
    }

    private static class BooleanArrayExtractor
    extends ArrayExtractor<boolean[]> {
        private static final boolean[] EMPTY = new boolean[0];

        BooleanArrayExtractor(char arrayDelimiter) {
            super(arrayDelimiter, Boolean.TYPE.getSimpleName());
        }

        @Override
        protected void extract0(char[] data, int offset, int length, CSVHeaderInformation optionalData) {
            int numberOfValues = this.numberOfValues(data, offset, length);
            this.value = numberOfValues > 0 ? new boolean[numberOfValues] : EMPTY;
            int arrayIndex = 0;
            int charIndex = 0;
            while (arrayIndex < numberOfValues) {
                int numberOfChars = this.charsToNextDelimiter(data, offset + charIndex, length - charIndex);
                ((boolean[])this.value)[arrayIndex] = Extractors.extractBoolean(data, offset + charIndex, numberOfChars);
                charIndex += numberOfChars;
                ++arrayIndex;
                ++charIndex;
            }
        }
    }

    private static class DoubleArrayExtractor
    extends ArrayExtractor<double[]> {
        private static final double[] EMPTY = new double[0];

        DoubleArrayExtractor(char arrayDelimiter) {
            super(arrayDelimiter, Double.TYPE.getSimpleName());
        }

        @Override
        protected void extract0(char[] data, int offset, int length, CSVHeaderInformation optionalData) {
            int numberOfValues = this.numberOfValues(data, offset, length);
            this.value = numberOfValues > 0 ? new double[numberOfValues] : EMPTY;
            int arrayIndex = 0;
            int charIndex = 0;
            while (arrayIndex < numberOfValues) {
                int numberOfChars = this.charsToNextDelimiter(data, offset + charIndex, length - charIndex);
                ((double[])this.value)[arrayIndex] = Double.parseDouble(String.valueOf(data, offset + charIndex, numberOfChars));
                charIndex += numberOfChars;
                ++arrayIndex;
                ++charIndex;
            }
        }
    }

    private static class FloatArrayExtractor
    extends ArrayExtractor<float[]> {
        private static final float[] EMPTY = new float[0];

        FloatArrayExtractor(char arrayDelimiter) {
            super(arrayDelimiter, Float.TYPE.getSimpleName());
        }

        @Override
        protected void extract0(char[] data, int offset, int length, CSVHeaderInformation optionalData) {
            int numberOfValues = this.numberOfValues(data, offset, length);
            this.value = numberOfValues > 0 ? new float[numberOfValues] : EMPTY;
            int arrayIndex = 0;
            int charIndex = 0;
            while (arrayIndex < numberOfValues) {
                int numberOfChars = this.charsToNextDelimiter(data, offset + charIndex, length - charIndex);
                ((float[])this.value)[arrayIndex] = Float.parseFloat(String.valueOf(data, offset + charIndex, numberOfChars));
                charIndex += numberOfChars;
                ++arrayIndex;
                ++charIndex;
            }
        }
    }

    private static class LongArrayExtractor
    extends ArrayExtractor<long[]> {
        LongArrayExtractor(char arrayDelimiter) {
            super(arrayDelimiter, Long.TYPE.getSimpleName());
        }

        @Override
        protected void extract0(char[] data, int offset, int length, CSVHeaderInformation optionalData) {
            int numberOfValues = this.numberOfValues(data, offset, length);
            this.value = numberOfValues > 0 ? new long[numberOfValues] : PrimitiveLongCollections.EMPTY_LONG_ARRAY;
            int arrayIndex = 0;
            int charIndex = 0;
            while (arrayIndex < numberOfValues) {
                int numberOfChars = this.charsToNextDelimiter(data, offset + charIndex, length - charIndex);
                ((long[])this.value)[arrayIndex] = Extractors.extractLong(data, offset + charIndex, numberOfChars);
                charIndex += numberOfChars;
                ++arrayIndex;
                ++charIndex;
            }
        }
    }

    private static class IntArrayExtractor
    extends ArrayExtractor<int[]> {
        private static final int[] EMPTY = new int[0];

        IntArrayExtractor(char arrayDelimiter) {
            super(arrayDelimiter, Integer.TYPE.getSimpleName());
        }

        @Override
        protected void extract0(char[] data, int offset, int length, CSVHeaderInformation optionalData) {
            int numberOfValues = this.numberOfValues(data, offset, length);
            this.value = numberOfValues > 0 ? new int[numberOfValues] : EMPTY;
            int arrayIndex = 0;
            int charIndex = 0;
            while (arrayIndex < numberOfValues) {
                int numberOfChars = this.charsToNextDelimiter(data, offset + charIndex, length - charIndex);
                ((int[])this.value)[arrayIndex] = Numbers.safeCastLongToInt((long)Extractors.extractLong(data, offset + charIndex, numberOfChars));
                charIndex += numberOfChars;
                ++arrayIndex;
                ++charIndex;
            }
        }
    }

    private static class ShortArrayExtractor
    extends ArrayExtractor<short[]> {
        private static final short[] EMPTY = new short[0];

        ShortArrayExtractor(char arrayDelimiter) {
            super(arrayDelimiter, Short.TYPE.getSimpleName());
        }

        @Override
        protected void extract0(char[] data, int offset, int length, CSVHeaderInformation optionalData) {
            int numberOfValues = this.numberOfValues(data, offset, length);
            this.value = numberOfValues > 0 ? new short[numberOfValues] : EMPTY;
            int arrayIndex = 0;
            int charIndex = 0;
            while (arrayIndex < numberOfValues) {
                int numberOfChars = this.charsToNextDelimiter(data, offset + charIndex, length - charIndex);
                ((short[])this.value)[arrayIndex] = Numbers.safeCastLongToShort((long)Extractors.extractLong(data, offset + charIndex, numberOfChars));
                charIndex += numberOfChars;
                ++arrayIndex;
                ++charIndex;
            }
        }
    }

    private static class ByteArrayExtractor
    extends ArrayExtractor<byte[]> {
        private static final byte[] EMPTY = new byte[0];

        ByteArrayExtractor(char arrayDelimiter) {
            super(arrayDelimiter, Byte.TYPE.getSimpleName());
        }

        @Override
        protected void extract0(char[] data, int offset, int length, CSVHeaderInformation optionalData) {
            int numberOfValues = this.numberOfValues(data, offset, length);
            this.value = numberOfValues > 0 ? new byte[numberOfValues] : EMPTY;
            int arrayIndex = 0;
            int charIndex = 0;
            while (arrayIndex < numberOfValues) {
                int numberOfChars = this.charsToNextDelimiter(data, offset + charIndex, length - charIndex);
                ((byte[])this.value)[arrayIndex] = Numbers.safeCastLongToByte((long)Extractors.extractLong(data, offset + charIndex, numberOfChars));
                charIndex += numberOfChars;
                ++arrayIndex;
                ++charIndex;
            }
        }
    }

    private static class StringArrayExtractor
    extends ArrayExtractor<String[]> {
        private static final String[] EMPTY = new String[0];
        private final boolean trimStrings;

        StringArrayExtractor(char arrayDelimiter, boolean trimStrings) {
            super(arrayDelimiter, String.class.getSimpleName());
            this.trimStrings = trimStrings;
        }

        @Override
        protected void extract0(char[] data, int offset, int length, CSVHeaderInformation optionalData) {
            int numberOfValues = this.numberOfValues(data, offset, length);
            this.value = numberOfValues > 0 ? new String[numberOfValues] : EMPTY;
            int arrayIndex = 0;
            int charIndex = 0;
            while (arrayIndex < numberOfValues) {
                int numberOfChars = this.charsToNextDelimiter(data, offset + charIndex, length - charIndex);
                ((String[])this.value)[arrayIndex] = new String(data, offset + charIndex, numberOfChars);
                if (this.trimStrings) {
                    ((String[])this.value)[arrayIndex] = ((String[])this.value)[arrayIndex].trim();
                }
                charIndex += numberOfChars;
                ++arrayIndex;
                ++charIndex;
            }
        }
    }

    private static abstract class ArrayExtractor<T>
    extends AbstractExtractor<T> {
        protected final char arrayDelimiter;
        protected T value;

        ArrayExtractor(char arrayDelimiter, String componentTypeName) {
            super(componentTypeName + "[]");
            this.arrayDelimiter = arrayDelimiter;
        }

        @Override
        public T value() {
            return this.value;
        }

        @Override
        public boolean extract(char[] data, int offset, int length, boolean hadQuotes, CSVHeaderInformation optionalData) {
            this.extract0(data, offset, length, optionalData);
            return true;
        }

        @Override
        public boolean extract(char[] data, int offset, int length, boolean hadQuotes) {
            return this.extract(data, offset, length, hadQuotes, null);
        }

        protected abstract void extract0(char[] var1, int var2, int var3, CSVHeaderInformation var4);

        protected int charsToNextDelimiter(char[] data, int offset, int length) {
            for (int i = 0; i < length; ++i) {
                if (data[offset + i] != this.arrayDelimiter) continue;
                return i;
            }
            return length;
        }

        protected int numberOfValues(char[] data, int offset, int length) {
            int count = length > 0 ? 1 : 0;
            for (int i = 0; i < length; ++i) {
                if (data[offset + i] != this.arrayDelimiter) continue;
                ++count;
            }
            return count;
        }

        public int hashCode() {
            return this.getClass().hashCode();
        }

        public boolean equals(Object obj) {
            return obj != null && this.getClass().equals(obj.getClass());
        }
    }

    public static class DoubleExtractor
    extends AbstractSingleValueExtractor<Double> {
        private double value;

        DoubleExtractor() {
            super(Double.TYPE.getSimpleName());
        }

        @Override
        protected void clear() {
            this.value = 0.0;
        }

        @Override
        protected boolean extract0(char[] data, int offset, int length, CSVHeaderInformation optionalData) {
            try {
                this.value = Double.parseDouble(String.valueOf(data, offset, length));
            }
            catch (NumberFormatException ignored) {
                throw new NumberFormatException("Not a number: \"" + String.valueOf(data, offset, length) + "\"");
            }
            return true;
        }

        @Override
        public Double value() {
            return this.value;
        }

        public double doubleValue() {
            return this.value;
        }
    }

    public static class FloatExtractor
    extends AbstractSingleValueExtractor<Float> {
        private float value;

        FloatExtractor(DoubleExtractor doubleExtractor) {
            super(Float.TYPE.getSimpleName(), doubleExtractor);
        }

        @Override
        protected void clear() {
            this.value = 0.0f;
        }

        @Override
        protected boolean extract0(char[] data, int offset, int length, CSVHeaderInformation optionalData) {
            try {
                this.value = Float.parseFloat(String.valueOf(data, offset, length));
            }
            catch (NumberFormatException ignored) {
                throw new NumberFormatException("Not a number: \"" + String.valueOf(data, offset, length) + "\"");
            }
            return true;
        }

        @Override
        public Float value() {
            return Float.valueOf(this.value);
        }

        public float floatValue() {
            return this.value;
        }
    }

    public static class CharExtractor
    extends AbstractSingleValueExtractor<Character> {
        private char value;

        CharExtractor() {
            super(Character.TYPE.getSimpleName());
        }

        @Override
        protected void clear() {
            this.value = '\u0000';
        }

        @Override
        protected boolean extract0(char[] data, int offset, int length, CSVHeaderInformation optionalData) {
            if (length > 1) {
                throw new IllegalStateException("Was told to extract a character, but length:" + length);
            }
            this.value = data[offset];
            return true;
        }

        @Override
        public Character value() {
            return Character.valueOf(this.value);
        }

        public char charValue() {
            return this.value;
        }
    }

    public static class BooleanExtractor
    extends AbstractSingleValueExtractor<Boolean> {
        private boolean value;

        BooleanExtractor() {
            super(Boolean.TYPE.getSimpleName());
        }

        @Override
        protected void clear() {
            this.value = false;
        }

        @Override
        protected boolean extract0(char[] data, int offset, int length, CSVHeaderInformation optionalData) {
            this.value = Extractors.extractBoolean(data, offset, length);
            return true;
        }

        @Override
        public Boolean value() {
            return this.value;
        }

        public boolean booleanValue() {
            return this.value;
        }
    }

    public static class ByteExtractor
    extends AbstractSingleValueExtractor<Byte> {
        private byte value;

        ByteExtractor(LongExtractor longExtractor) {
            super(Byte.TYPE.getSimpleName(), longExtractor);
        }

        @Override
        protected void clear() {
            this.value = 0;
        }

        @Override
        protected boolean extract0(char[] data, int offset, int length, CSVHeaderInformation optionalData) {
            this.value = Numbers.safeCastLongToByte((long)Extractors.extractLong(data, offset, length));
            return true;
        }

        @Override
        public Byte value() {
            return this.value;
        }

        public int byteValue() {
            return this.value;
        }
    }

    public static class ShortExtractor
    extends AbstractSingleValueExtractor<Short> {
        private short value;

        ShortExtractor(LongExtractor longExtractor) {
            super(Short.TYPE.getSimpleName(), longExtractor);
        }

        @Override
        protected void clear() {
            this.value = 0;
        }

        @Override
        protected boolean extract0(char[] data, int offset, int length, CSVHeaderInformation optionalData) {
            this.value = Numbers.safeCastLongToShort((long)Extractors.extractLong(data, offset, length));
            return true;
        }

        @Override
        public Short value() {
            return this.value;
        }

        public short shortValue() {
            return this.value;
        }
    }

    public static class IntExtractor
    extends AbstractSingleValueExtractor<Integer> {
        private int value;

        IntExtractor(LongExtractor longExtractor) {
            super(Integer.TYPE.toString(), longExtractor);
        }

        @Override
        protected void clear() {
            this.value = 0;
        }

        @Override
        protected boolean extract0(char[] data, int offset, int length, CSVHeaderInformation optionalData) {
            this.value = Numbers.safeCastLongToInt((long)Extractors.extractLong(data, offset, length));
            return true;
        }

        @Override
        public Integer value() {
            return this.value;
        }

        public int intValue() {
            return this.value;
        }
    }

    public static class LongExtractor
    extends AbstractSingleValueExtractor<Long> {
        private long value;

        LongExtractor() {
            super(Long.TYPE.getSimpleName());
        }

        @Override
        protected void clear() {
            this.value = 0L;
        }

        @Override
        protected boolean extract0(char[] data, int offset, int length, CSVHeaderInformation optionalData) {
            this.value = Extractors.extractLong(data, offset, length);
            return true;
        }

        @Override
        public Long value() {
            return this.value;
        }

        public long longValue() {
            return this.value;
        }
    }

    public static class StringExtractor
    extends AbstractSingleValueExtractor<String> {
        private String value;
        private final boolean emptyStringsAsNull;

        public StringExtractor(boolean emptyStringsAsNull) {
            super(String.class.getSimpleName());
            this.emptyStringsAsNull = emptyStringsAsNull;
        }

        @Override
        protected void clear() {
            this.value = null;
        }

        @Override
        protected boolean nullValue(int length, boolean hadQuotes) {
            return length == 0 && (!hadQuotes || this.emptyStringsAsNull);
        }

        @Override
        protected boolean extract0(char[] data, int offset, int length, CSVHeaderInformation optionalData) {
            this.value = new String(data, offset, length);
            return true;
        }

        @Override
        public String value() {
            return this.value;
        }
    }

    private static abstract class AbstractSingleAnyValueExtractor
    extends AbstractSingleValueExtractor<AnyValue> {
        protected AnyValue value;

        AbstractSingleAnyValueExtractor(String toString) {
            super(toString);
        }

        @Override
        protected void clear() {
            this.value = Values.NO_VALUE;
        }

        @Override
        public AnyValue value() {
            return this.value;
        }
    }

    private static abstract class AbstractSingleValueExtractor<T>
    extends AbstractExtractor<T> {
        AbstractSingleValueExtractor(String toString) {
            super(toString, null);
        }

        AbstractSingleValueExtractor(String toString, Extractor<?> normalizedExtractor) {
            super(toString, normalizedExtractor);
        }

        @Override
        public final boolean extract(char[] data, int offset, int length, boolean hadQuotes, CSVHeaderInformation optionalData) {
            if (this.nullValue(length, hadQuotes)) {
                this.clear();
                return false;
            }
            return this.extract0(data, offset, length, optionalData);
        }

        @Override
        public final boolean extract(char[] data, int offset, int length, boolean hadQuotes) {
            return this.extract(data, offset, length, hadQuotes, null);
        }

        protected boolean nullValue(int length, boolean hadQuotes) {
            return length == 0;
        }

        protected abstract void clear();

        protected abstract boolean extract0(char[] var1, int var2, int var3, CSVHeaderInformation var4);
    }

    private static abstract class AbstractExtractor<T>
    implements Extractor<T> {
        private final String name;
        private final Extractor<?> normalizedExtractor;

        AbstractExtractor(String name) {
            this(name, null);
        }

        AbstractExtractor(String name, Extractor<?> normalizedExtractor) {
            this.name = name;
            this.normalizedExtractor = normalizedExtractor;
        }

        @Override
        public String name() {
            return this.name;
        }

        @Override
        public Extractor<T> clone() {
            try {
                return (Extractor)super.clone();
            }
            catch (CloneNotSupportedException e) {
                throw new CloneFailedException(Extractor.class.getName() + " implements " + Cloneable.class.getSimpleName() + ", at least this implementation assumes that. This doesn't seem to be the case anymore", (Throwable)e);
            }
        }

        @Override
        public Extractor<?> normalize() {
            return this.normalizedExtractor != null ? this.normalizedExtractor : this;
        }
    }
}

