/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.csv.reader;

import java.io.Closeable;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.LockSupport;

public abstract class ThreadAhead
extends Thread
implements Closeable {
    private static final long PARK_TIME = TimeUnit.MILLISECONDS.toNanos(100L);
    private final Thread owner;
    private volatile boolean hasReadAhead;
    private volatile boolean closed;
    private volatile boolean eof;
    private volatile IOException ioException;
    private final Closeable actual;

    protected ThreadAhead(Closeable actual) {
        this.actual = actual;
        this.setName(this.getClass().getSimpleName() + " for " + actual);
        this.owner = Thread.currentThread();
        this.setDaemon(true);
    }

    @Override
    public void close() throws IOException {
        this.closed = true;
        try {
            this.join();
        }
        catch (InterruptedException e) {
            throw new IOException(e);
        }
        finally {
            this.actual.close();
        }
    }

    protected void waitUntilReadAhead() throws IOException {
        this.assertHealthy();
        while (!this.hasReadAhead) {
            this.parkAWhile();
            this.assertHealthy();
        }
    }

    protected void assertHealthy() throws IOException {
        if (this.ioException != null) {
            throw new IOException("Error occurred in read-ahead thread", this.ioException);
        }
    }

    protected void parkAWhile() {
        LockSupport.parkNanos(PARK_TIME);
    }

    @Override
    public void run() {
        while (!this.closed) {
            if (this.hasReadAhead || this.eof) {
                this.parkAWhile();
                continue;
            }
            try {
                if (!this.readAhead()) {
                    this.eof = true;
                }
                this.hasReadAhead = true;
                LockSupport.unpark(this.owner);
            }
            catch (IOException e) {
                this.ioException = e;
                this.closed = true;
            }
            catch (Throwable e) {
                this.ioException = new IOException(e);
                this.closed = true;
            }
        }
    }

    protected abstract boolean readAhead() throws IOException;

    protected void pokeReader() {
        this.hasReadAhead = false;
        LockSupport.unpark(this);
    }
}

