/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.csv.reader;

import java.io.Closeable;
import java.io.IOException;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicReferenceArray;
import org.neo4j.csv.reader.CharReadable;
import org.neo4j.csv.reader.Source;

public class ProcessingSource
implements Closeable {
    private static final char[] UNALLOCATED = new char[0];
    private static final char[] IN_USE = new char[0];
    private final CharReadable reader;
    private final int chunkSize;
    private char[] backBuffer;
    private int backBufferCursor;
    private volatile long position;
    private final AtomicReferenceArray<char[]> buffers;

    public ProcessingSource(CharReadable reader, int chunkSize, int maxNumberOfBufferedChunks) {
        this.reader = reader;
        this.chunkSize = chunkSize;
        this.backBuffer = new char[chunkSize >> 4];
        this.buffers = new AtomicReferenceArray(maxNumberOfBufferedChunks);
        for (int i = 0; i < this.buffers.length(); ++i) {
            this.buffers.set(i, UNALLOCATED);
        }
    }

    public Source.Chunk nextChunk() throws IOException {
        Buffer buffer = this.newBuffer();
        int offset = 0;
        if (this.backBufferCursor > 0) {
            assert (this.backBufferCursor < this.chunkSize);
            System.arraycopy(this.backBuffer, 0, buffer.data, 0, this.backBufferCursor);
            offset += this.backBufferCursor;
            this.backBufferCursor = 0;
        }
        int leftToRead = this.chunkSize - offset;
        int read = this.reader.read(buffer.data, offset, leftToRead);
        if (read == leftToRead) {
            int newlineOffset = ProcessingSource.offsetOfLastNewline(buffer.data);
            if (newlineOffset > -1) {
                this.backBufferCursor = this.chunkSize - (newlineOffset + 1);
                System.arraycopy(buffer.data, newlineOffset + 1, this.backBuffer(this.backBufferCursor), 0, this.backBufferCursor);
                read -= this.backBufferCursor;
            } else {
                throw new IllegalStateException("Weird input data, no newline character in the whole buffer " + this.chunkSize + ", not supported a.t.m.");
            }
        }
        if (read > -1) {
            offset += read;
            this.position += (long)read;
        }
        return new ProcessingChunk(buffer, offset, this.reader.sourceDescription());
    }

    private char[] backBuffer(int length) {
        if (length > this.backBuffer.length) {
            this.backBuffer = Arrays.copyOf(this.backBuffer, length);
        }
        return this.backBuffer;
    }

    private Buffer newBuffer() {
        for (int i = 0; i < this.buffers.length(); ++i) {
            char[] current = this.buffers.get(i);
            if (current != UNALLOCATED && current == IN_USE) continue;
            this.buffers.set(i, IN_USE);
            return new Buffer(current == UNALLOCATED ? new char[this.chunkSize] : current, i);
        }
        return new Buffer(new char[this.chunkSize], -1);
    }

    @Override
    public void close() throws IOException {
        this.reader.close();
    }

    public long position() {
        return this.position;
    }

    private static int offsetOfLastNewline(char[] buffer) {
        for (int i = buffer.length - 1; i >= 0; --i) {
            if (buffer[i] != '\n') continue;
            return i;
        }
        return -1;
    }

    private static class Buffer {
        private final char[] data;
        private final int reuseIndex;

        Buffer(char[] data, int reuseIndex) {
            this.data = data;
            this.reuseIndex = reuseIndex;
        }
    }

    private class ProcessingChunk
    implements Source.Chunk {
        private final Buffer buffer;
        private final int length;
        private final String sourceDescription;

        ProcessingChunk(Buffer buffer, int length, String sourceDescription) {
            this.buffer = buffer;
            this.length = length;
            this.sourceDescription = sourceDescription;
        }

        @Override
        public int startPosition() {
            return 0;
        }

        @Override
        public String sourceDescription() {
            return this.sourceDescription;
        }

        @Override
        public int maxFieldSize() {
            return ProcessingSource.this.chunkSize;
        }

        @Override
        public int length() {
            return this.length;
        }

        @Override
        public char[] data() {
            return this.buffer.data;
        }

        @Override
        public int backPosition() {
            return 0;
        }

        @Override
        public void close() {
            if (this.buffer.reuseIndex != -1) {
                ProcessingSource.this.buffers.set(this.buffer.reuseIndex, this.buffer.data);
            }
        }
    }
}

