/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.csv.reader;

import org.neo4j.csv.reader.BufferedCharSeeker;
import org.neo4j.csv.reader.CharReadable;
import org.neo4j.csv.reader.CharSeeker;
import org.neo4j.csv.reader.Configuration;
import org.neo4j.csv.reader.ThreadAheadReadable;

public class CharSeekers {
    public static CharSeeker charSeeker(CharReadable reader, Configuration config, boolean readAhead) {
        if (readAhead) {
            reader = ThreadAheadReadable.threadAhead(reader, config.bufferSize());
        }
        return new BufferedCharSeeker(reader, config);
    }

    public static CharSeeker charSeeker(CharReadable reader, final int bufferSize, boolean readAhead, final char quotationCharacter) {
        return CharSeekers.charSeeker(reader, new Configuration.Overridden(Configuration.DEFAULT){

            @Override
            public char quotationCharacter() {
                return quotationCharacter;
            }

            @Override
            public int bufferSize() {
                return bufferSize;
            }
        }, readAhead);
    }
}

