/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.csv.reader;

import java.io.IOException;
import java.nio.CharBuffer;
import org.neo4j.csv.reader.CharReadable;
import org.neo4j.csv.reader.CharSeeker;
import org.neo4j.csv.reader.Extractor;
import org.neo4j.csv.reader.Mark;

public class BufferedCharSeeker
implements CharSeeker {
    private static final int KB = 1024;
    private static final int MB = 0x100000;
    public static final int DEFAULT_BUFFER_SIZE = 0x200000;
    public static final char DEFAULT_QUOTE_CHAR = '\"';
    private static final char EOL_CHAR = '\n';
    private static final char EOL_CHAR_2 = '\r';
    private static final char EOF_CHAR = '\uffff';
    private static final char BACK_SLASH = '\\';
    private final CharReadable reader;
    private final char[] buffer;
    private final CharBuffer charBuffer;
    private int bufferPos;
    private long lineStartPos;
    private int seekStartPos;
    private int lineNumber = 1;
    private boolean eof;
    private final char quoteChar;

    public BufferedCharSeeker(CharReadable reader) {
        this(reader, 0x200000, '\"');
    }

    public BufferedCharSeeker(CharReadable reader, int bufferSize) {
        this(reader, bufferSize, '\"');
    }

    public BufferedCharSeeker(CharReadable reader, int bufferSize, char quoteChar) {
        this.reader = reader;
        this.buffer = new char[bufferSize];
        this.charBuffer = CharBuffer.wrap(this.buffer);
        this.bufferPos = bufferSize;
        this.quoteChar = quoteChar;
    }

    @Override
    public boolean seek(Mark mark, int[] untilOneOfChars) throws IOException {
        if (this.eof) {
            return this.eof(mark);
        }
        this.seekStartPos = this.bufferPos;
        int endOffset = 1;
        int skippedChars = 0;
        int quoteDepth = 0;
        while (!this.eof) {
            int nextCh;
            int ch = this.nextChar(skippedChars);
            if (quoteDepth == 0) {
                if (ch == this.quoteChar && this.seekStartPos == this.bufferPos - 1) {
                    ++quoteDepth;
                    ++this.seekStartPos;
                    continue;
                }
                if (this.isNewLine(ch)) break;
                for (int i = 0; i < untilOneOfChars.length; ++i) {
                    if (ch != untilOneOfChars[i]) continue;
                    mark.set(this.lineNumber, this.seekStartPos, this.bufferPos - endOffset - skippedChars, ch);
                    return true;
                }
                continue;
            }
            if (ch == this.quoteChar) {
                nextCh = this.peekChar();
                if (nextCh == this.quoteChar) {
                    this.repositionChar(this.bufferPos++, ++skippedChars);
                    quoteDepth = quoteDepth == 1 ? 2 : 1;
                    continue;
                }
                ++endOffset;
                --quoteDepth;
                continue;
            }
            if (ch == 10 || ch == 13) {
                this.nextChar(skippedChars);
                continue;
            }
            if (ch != 92 || (nextCh = this.peekChar()) != this.quoteChar) continue;
            this.repositionChar(this.bufferPos++, ++skippedChars);
        }
        int valueLength = this.bufferPos - this.seekStartPos - 1;
        if (this.eof && valueLength == 0 && (long)this.seekStartPos == this.lineStartPos) {
            return this.eof(mark);
        }
        mark.set(this.lineNumber, this.seekStartPos, this.bufferPos - endOffset - (skippedChars += this.skipEolChars()), Mark.END_OF_LINE_CHARACTER);
        ++this.lineNumber;
        this.lineStartPos = this.bufferPos;
        return true;
    }

    private void repositionChar(int offset, int stepsBack) {
        this.buffer[offset - stepsBack] = this.buffer[offset];
    }

    private boolean isNewLine(int ch) {
        return ch == 10 || ch == 13;
    }

    private int peekChar() throws IOException {
        this.fillBufferIfWeHaveExhaustedIt();
        return this.buffer[this.bufferPos];
    }

    private boolean eof(Mark mark) {
        mark.set(this.lineNumber, -1L, -1L, Mark.END_OF_LINE_CHARACTER);
        return false;
    }

    @Override
    public <EXTRACTOR extends Extractor<?>> EXTRACTOR extract(Mark mark, EXTRACTOR extractor) {
        if (!this.tryExtract(mark, extractor)) {
            throw new IllegalStateException(extractor + " didn't extract value for " + mark + ". For values which are optional please use tryExtract method instead");
        }
        return extractor;
    }

    @Override
    public boolean tryExtract(Mark mark, Extractor<?> extractor) {
        long from = mark.startPosition();
        long to = mark.position();
        return extractor.extract(this.buffer, (int)from, (int)(to - from));
    }

    private int skipEolChars() throws IOException {
        int skipped = 0;
        while (this.isNewLine(this.nextChar(0))) {
            ++skipped;
        }
        --this.bufferPos;
        return skipped;
    }

    private int nextChar(int skippedChars) throws IOException {
        this.fillBufferIfWeHaveExhaustedIt();
        char ch = this.buffer[this.bufferPos++];
        if (skippedChars > 0) {
            this.repositionChar(this.bufferPos - 1, skippedChars);
        }
        if (ch == '\uffff') {
            this.eof = true;
        }
        return ch;
    }

    private void fillBufferIfWeHaveExhaustedIt() throws IOException {
        if (this.bufferPos >= this.buffer.length) {
            if (this.seekStartPos == 0) {
                throw new IllegalStateException("Tried to read in a value larger than buffer size " + this.buffer.length);
            }
            this.charBuffer.position(this.seekStartPos);
            this.charBuffer.compact();
            int remaining = this.charBuffer.remaining();
            int read = this.reader.read(this.buffer, this.charBuffer.position(), remaining);
            if (read < remaining) {
                this.buffer[this.charBuffer.position() + Math.max((int)read, (int)0)] = 65535;
            }
            this.bufferPos = this.charBuffer.position();
            this.seekStartPos = 0;
        }
    }

    @Override
    public void close() throws IOException {
        this.reader.close();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[buffer:" + this.charBuffer + ", seekPos:" + this.seekStartPos + ", line:" + this.lineNumber + "]";
    }
}

