/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.util.concurrent;

import java.util.Arrays;

public class SequenceArray {
    private static final long UNSET = -1L;
    private long[] array;
    private int cursor;
    private int itemsAhead;
    private final int longsPerItem;
    private int capacity;

    SequenceArray(int longsPerItem, int initialCapacity) {
        this.longsPerItem = longsPerItem;
        this.capacity = initialCapacity;
        this.array = new long[this.capacity * longsPerItem];
    }

    public void clear() {
        this.cursor = 0;
        this.itemsAhead = 0;
    }

    void offer(long baseNumber, long number, long[] meta) {
        int diff = (int)(number - baseNumber);
        this.ensureArrayCapacity(diff);
        int index = this.cursor + diff - 1;
        for (int i = this.cursor + this.itemsAhead; i < index; ++i) {
            this.array[this.index((int)i)] = -1L;
        }
        int absIndex = this.index(index);
        this.array[absIndex] = number;
        System.arraycopy(meta, 0, this.array, absIndex + 1, this.longsPerItem - 1);
        this.itemsAhead = Math.max(this.itemsAhead, diff);
    }

    private int index(int logicalIndex) {
        return logicalIndex % this.capacity * this.longsPerItem;
    }

    long pollHighestGapFree(long given, long[] meta) {
        long number = given;
        int length = this.itemsAhead - 1;
        int absIndex = 0;
        for (int i = 0; i < length; ++i) {
            this.advanceCursor();
            int tentativeAbsIndex = this.index(this.cursor);
            if (this.array[tentativeAbsIndex] == -1L) break;
            absIndex = tentativeAbsIndex;
            assert (this.array[absIndex] == ++number) : "Expected index " + this.cursor + " to be " + number + ", but was " + this.array[absIndex] + ". This is for i=" + i;
        }
        System.arraycopy(this.array, absIndex + 1, meta, 0, this.longsPerItem - 1);
        return number;
    }

    private void advanceCursor() {
        assert (this.itemsAhead > 0);
        --this.itemsAhead;
        this.cursor = this.advanceCursor(this.cursor);
    }

    private int advanceCursor(int cursor) {
        return (cursor + 1) % this.capacity;
    }

    private void ensureArrayCapacity(int capacity) {
        while (capacity > this.capacity) {
            int newCapacity = this.capacity * 2;
            long[] newArray = new long[newCapacity * this.longsPerItem];
            for (int i = 0; i < this.itemsAhead; ++i) {
                System.arraycopy(this.array, this.index(this.cursor + i), newArray, this.index(i), this.longsPerItem);
            }
            this.array = newArray;
            this.capacity = newCapacity;
            this.cursor = 0;
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < this.itemsAhead; ++i) {
            long value = this.array[this.index(this.cursor + i)];
            if (value == -1L) continue;
            builder.append(builder.length() > 0 ? "," : "").append(value);
        }
        return builder.toString();
    }

    boolean seen(long baseNumber, long number, long[] meta) {
        int diff = (int)(number - baseNumber);
        int index = this.cursor + diff - 1;
        if (index >= this.cursor + this.itemsAhead) {
            return false;
        }
        long[] arrayRef = this.array;
        int absIndex = this.index(index);
        long num = arrayRef[absIndex];
        if (num != number) {
            return false;
        }
        long[] metaCopy = Arrays.copyOfRange(arrayRef, absIndex + 1, absIndex + this.longsPerItem);
        return Arrays.equals(meta, metaCopy);
    }

    long[][] snapshot() {
        Object temp = new long[this.itemsAhead][];
        int remaining = this.itemsAhead - 1;
        int queueCursor = this.cursor + 1;
        int resultCursor = 0;
        while (remaining-- > 0) {
            int absIndex = this.index(queueCursor);
            long number = this.array[absIndex];
            if (number != -1L) {
                temp[resultCursor++] = Arrays.copyOfRange(this.array, absIndex, absIndex + this.longsPerItem);
            }
            queueCursor = this.advanceCursor(queueCursor);
        }
        if (resultCursor < ((long[][])temp).length) {
            temp = (long[][])Arrays.copyOf(temp, resultCursor);
        }
        return temp;
    }
}

