/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.util.concurrent;

import java.util.concurrent.locks.LockSupport;
import org.neo4j.internal.unsafe.UnsafeUtil;

public class BinaryLatch {
    private static final long stackOffset = UnsafeUtil.getFieldOffset(BinaryLatch.class, (String)"stack");
    private static final Node end = new Node();
    private static final Node released = new Node();
    private static final byte waiterStateSuccessor = 1;
    private static final byte waiterStateReleased = 2;
    private volatile Node stack;

    public void release() {
        Node waiters = (Node)UnsafeUtil.getAndSetObject((Object)this, (long)stackOffset, (Object)released);
        if (waiters == null) {
            return;
        }
        this.unparkSuccessor(waiters);
    }

    private void unparkSuccessor(Node waiters) {
        if (waiters.getClass() == Waiter.class) {
            Waiter waiter = (Waiter)waiters;
            waiter.state = 1;
            LockSupport.unpark(waiter.waitingThread);
        }
    }

    public void await() {
        Node state = this.stack;
        if (state != released) {
            Waiter waiter = new Waiter();
            state = (Node)UnsafeUtil.getAndSetObject((Object)this, (long)stackOffset, (Object)waiter);
            if (state == released) {
                Node others = (Node)UnsafeUtil.getAndSetObject((Object)this, (long)stackOffset, (Object)released);
                waiter.next = released;
                this.unparkAll(others);
            } else {
                waiter.next = state == null ? end : state;
                do {
                    LockSupport.park(this);
                } while (!this.isReleased(waiter));
            }
        }
    }

    private boolean isReleased(Waiter waiter) {
        Node next;
        if (waiter.state == 1) {
            this.unparkAll(waiter.next);
            return true;
        }
        Node state = this.stack;
        do {
            if (state == released) {
                if (waiter.state != 2) {
                    this.unparkAll(waiter.next);
                }
                return true;
            }
            while ((next = state.next) == null) {
            }
        } while ((state = next) != end);
        return false;
    }

    private void unparkAll(Node waiters) {
        while (waiters.getClass() == Waiter.class) {
            Node next;
            Waiter waiter = (Waiter)waiters;
            waiter.state = (byte)2;
            LockSupport.unpark(waiter.waitingThread);
            while ((next = waiters.next) == null) {
            }
            waiters = next;
        }
    }

    private static final class Waiter
    extends Node {
        final Thread waitingThread = Thread.currentThread();
        volatile byte state;

        private Waiter() {
        }
    }

    private static class Node {
        volatile Node next;

        private Node() {
        }
    }
}

