/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cli;

import java.io.IOException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.neo4j.cli.AbstractCommand;
import org.neo4j.cli.CommandFailedException;
import org.neo4j.cli.ExecutionContext;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.configuration.connectors.BoltConnector;
import org.neo4j.configuration.connectors.HttpConnector;
import org.neo4j.configuration.connectors.HttpsConnector;
import picocli.CommandLine;

public abstract class AbstractAdminCommand
extends AbstractCommand {
    public static final String COMMAND_CONFIG_FILE_NAME_PATTERN = "neo4j-admin-%s.conf";
    public static final String ADMIN_CONFIG_FILE_NAME = "neo4j-admin.conf";
    @CommandLine.Option(names={"--additional-config"}, paramLabel="<file>", description={"Configuration file with additional configuration."})
    private Path additionalConfig;

    protected AbstractAdminCommand(ExecutionContext ctx) {
        super(ctx);
    }

    public List<Path> getCommandConfigs() throws IllegalArgumentException {
        ArrayList<Path> configs = new ArrayList<Path>(3);
        if (this.additionalConfig != null) {
            if (!this.configFileExists(this.additionalConfig)) {
                throw new CommandFailedException(String.format("File %s does not exist", this.additionalConfig));
            }
            configs.add(this.additionalConfig);
        }
        this.commandConfigName().map(configName -> String.format(COMMAND_CONFIG_FILE_NAME_PATTERN, configName)).map(this.ctx.confDir()::resolve).filter(this::configFileExists).ifPresent(configs::add);
        Path adminConfig = this.ctx.confDir().resolve(ADMIN_CONFIG_FILE_NAME);
        if (this.configFileExists(adminConfig)) {
            configs.add(adminConfig);
        }
        return configs;
    }

    @Override
    protected List<Path> configFiles() {
        List<Path> commandConfigs = this.getCommandConfigs();
        commandConfigs.addAll(super.configFiles());
        return commandConfigs;
    }

    private boolean configFileExists(Path path) {
        return this.ctx.fs().fileExists(path) && !this.ctx.fs().isDirectory(path);
    }

    protected Optional<String> commandConfigName() {
        return Optional.empty();
    }

    protected Config.Builder createPrefilledConfigBuilder() {
        List<Path> commandConfigs = this.getCommandConfigs();
        Collections.reverse(commandConfigs);
        Config.Builder configBuilder = Config.newBuilder().fromFileNoThrow(this.ctx.confDir().resolve("neo4j.conf"));
        commandConfigs.forEach(arg_0 -> ((Config.Builder)configBuilder).fromFileNoThrow(arg_0));
        configBuilder.commandExpansion(this.allowCommandExpansion).set(GraphDatabaseSettings.neo4j_home, (Object)this.ctx.homeDir());
        configBuilder.set(BoltConnector.enabled, (Object)Boolean.FALSE);
        configBuilder.set(HttpConnector.enabled, (Object)Boolean.FALSE);
        configBuilder.set(HttpsConnector.enabled, (Object)Boolean.FALSE);
        return configBuilder;
    }

    protected Path requireExisting(Path p) {
        try {
            return p.toRealPath(new LinkOption[0]);
        }
        catch (IOException e) {
            throw new CommandFailedException(String.format("Path '%s' does not exist.", p), e);
        }
    }
}

