/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.commandline;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Path;
import org.neo4j.cli.CommandFailedException;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.io.fs.FileUtils;
import org.neo4j.logging.FormattedLogFormat;
import org.neo4j.logging.Level;
import org.neo4j.logging.LogTimeZone;
import org.neo4j.logging.log4j.Log4jLogProvider;
import org.neo4j.logging.log4j.LogConfig;
import org.neo4j.logging.log4j.Neo4jLoggerContext;

public final class Util {
    private Util() {
    }

    public static boolean isSameOrChildFile(Path parent, Path candidate) {
        Path canonicalCandidate = FileUtils.getCanonicalFile((Path)candidate);
        Path canonicalParentPath = FileUtils.getCanonicalFile((Path)parent);
        return canonicalCandidate.startsWith(canonicalParentPath);
    }

    public static void wrapIOException(IOException e) throws CommandFailedException {
        throw new CommandFailedException(String.format("Unable to load database: %s: %s", e.getClass().getSimpleName(), e.getMessage()), e);
    }

    public static Log4jLogProvider configuredLogProvider(Config config, OutputStream out) {
        Neo4jLoggerContext context = LogConfig.createBuilder((OutputStream)out, (Level)((Level)config.get(GraphDatabaseSettings.store_internal_log_level))).withTimezone((LogTimeZone)config.get(GraphDatabaseSettings.db_timezone)).build();
        return new Log4jLogProvider(context);
    }

    public static Log4jLogProvider configuredLogProvider(Config config, OutputStream out, FormattedLogFormat format) {
        Neo4jLoggerContext context = LogConfig.createBuilder((OutputStream)out, (Level)((Level)config.get(GraphDatabaseSettings.store_internal_log_level))).withFormat(format).withTimezone((LogTimeZone)config.get(GraphDatabaseSettings.db_timezone)).build();
        return new Log4jLogProvider(context);
    }
}

