/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cli;

import java.util.Objects;
import org.neo4j.cli.Command;
import org.neo4j.cli.CommandFailedException;
import org.neo4j.cli.ExecutionContext;
import org.neo4j.kernel.diagnostics.providers.SystemDiagnostics;
import org.neo4j.kernel.internal.Version;
import org.neo4j.logging.Logger;
import org.neo4j.logging.PrintStreamLogger;
import picocli.CommandLine;

@CommandLine.Command(headerHeading="%n", synopsisHeading="%n@|bold,underline USAGE|@%n%n", descriptionHeading="%n@|bold,underline DESCRIPTION|@%n%n", optionListHeading="%n@|bold,underline OPTIONS|@%n%n", parameterListHeading="%n@|bold,underline PARAMETERS|@%n%n", showDefaultValues=true, sortOptions=false)
public abstract class AbstractCommand
implements Command {
    @CommandLine.Option(names={"--verbose"}, arity="0", description={"Enable verbose output."})
    protected boolean verbose;
    protected final ExecutionContext ctx;
    @CommandLine.Spec
    protected CommandLine.Model.CommandSpec spec;

    protected AbstractCommand(ExecutionContext ctx) {
        this.ctx = Objects.requireNonNull(ctx);
    }

    protected abstract void execute() throws Exception;

    @Override
    public Integer call() throws Exception {
        if (this.verbose) {
            this.printVerboseHeader();
        }
        try {
            this.execute();
        }
        catch (CommandFailedException e) {
            if (this.verbose) {
                e.printStackTrace(this.ctx.err());
            } else {
                this.ctx.err().println(e.getMessage());
            }
            return e.getExitCode();
        }
        return 0;
    }

    private void printVerboseHeader() {
        PrintStreamLogger logger = new PrintStreamLogger(this.ctx.out());
        logger.log("neo4j " + Version.getNeo4jVersion());
        SystemDiagnostics.JAVA_VIRTUAL_MACHINE.dump((Logger)logger);
    }
}

