/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.commandline.admin;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import org.neo4j.commandline.admin.OutsideWorld;
import org.neo4j.io.IOUtils;
import org.neo4j.io.fs.DefaultFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;

public class RealOutsideWorld
implements OutsideWorld {
    FileSystemAbstraction fileSystemAbstraction = new DefaultFileSystemAbstraction();
    private final InputStream in;
    private final PrintStream out;
    private final PrintStream err;

    public RealOutsideWorld() {
        this(System.out, System.err, System.in);
    }

    public RealOutsideWorld(PrintStream out, PrintStream err, InputStream inStream) {
        this.in = inStream;
        this.out = out;
        this.err = err;
    }

    @Override
    public void stdOutLine(String text) {
        this.out.println(text);
    }

    @Override
    public void stdErrLine(String text) {
        this.err.println(text);
    }

    @Override
    public String readLine() {
        return System.console().readLine();
    }

    @Override
    public String promptLine(String fmt, Object ... args) {
        return System.console().readLine(fmt, args);
    }

    @Override
    public char[] promptPassword(String fmt, Object ... args) {
        return System.console().readPassword(fmt, args);
    }

    @Override
    public void exit(int status) {
        IOUtils.closeAllSilently((AutoCloseable[])new RealOutsideWorld[]{this});
        System.exit(status);
    }

    @Override
    public void printStacktrace(Exception exception) {
        exception.printStackTrace();
    }

    @Override
    public FileSystemAbstraction fileSystem() {
        return this.fileSystemAbstraction;
    }

    @Override
    public PrintStream errorStream() {
        return this.err;
    }

    @Override
    public void close() throws IOException {
        this.fileSystemAbstraction.close();
    }

    @Override
    public PrintStream outStream() {
        return this.out;
    }

    @Override
    public InputStream inStream() {
        return this.in;
    }
}

