/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.commandline.admin;

import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.NoSuchElementException;
import java.util.function.Supplier;
import org.neo4j.commandline.Util;
import org.neo4j.commandline.admin.AdminCommand;
import org.neo4j.commandline.admin.BlockerLocator;
import org.neo4j.commandline.admin.CommandFailed;
import org.neo4j.commandline.admin.CommandLocator;
import org.neo4j.commandline.admin.HelpCommandProvider;
import org.neo4j.commandline.admin.IncorrectUsage;
import org.neo4j.commandline.admin.OutsideWorld;
import org.neo4j.commandline.admin.RealOutsideWorld;
import org.neo4j.commandline.admin.Usage;
import org.neo4j.helpers.Args;

public class AdminTool {
    public static final int STATUS_SUCCESS = 0;
    public static final int STATUS_ERROR = 1;
    public static final String NEO4J_HOME = System.getenv().getOrDefault("NEO4J_HOME", "");
    public static final String NEO4J_CONF = System.getenv().getOrDefault("NEO4J_CONF", "");
    public static final String NEO4J_DEBUG = System.getenv().getOrDefault("NEO4J_DEBUG", null);
    public static final String scriptName = "neo4j-admin";
    private final CommandLocator commandLocator;
    private final BlockerLocator blockerLocator;
    private final OutsideWorld outsideWorld;
    private final boolean debug;
    private final Usage usage;

    public static void main(String[] args) throws IOException {
        Path homeDir = Paths.get(NEO4J_HOME, new String[0]);
        Path configDir = Paths.get(NEO4J_CONF, new String[0]);
        boolean debug = NEO4J_DEBUG != null;
        try (RealOutsideWorld outsideWorld = new RealOutsideWorld();){
            new AdminTool(CommandLocator.fromServiceLocator(), BlockerLocator.fromServiceLocator(), outsideWorld, debug).execute(homeDir, configDir, args);
        }
    }

    public AdminTool(CommandLocator commandLocator, BlockerLocator blockerLocator, OutsideWorld outsideWorld, boolean debug) {
        this.commandLocator = CommandLocator.withAdditionalCommand(this.help(), commandLocator);
        this.blockerLocator = blockerLocator;
        this.outsideWorld = outsideWorld;
        this.debug = debug;
        this.usage = new Usage(scriptName, this.commandLocator);
    }

    public void execute(Path homeDir, Path configDir, String ... args) {
        try {
            AdminCommand.Provider provider;
            if (args.length == 0) {
                this.badUsage("you must provide a command");
                return;
            }
            if (Args.parse((String[])args).has("version")) {
                this.outsideWorld.stdOutLine("neo4j-admin " + Util.neo4jVersion());
                this.success();
                return;
            }
            String name = args[0];
            String[] commandArgs = Arrays.copyOfRange(args, 1, args.length);
            try {
                provider = this.commandLocator.findProvider(name);
                for (AdminCommand.Blocker blocker : this.blockerLocator.findBlockers(name)) {
                    if (!blocker.doesBlock(homeDir, configDir)) continue;
                    this.commandFailed(new CommandFailed(blocker.explanation()));
                }
            }
            catch (NoSuchElementException e) {
                this.badUsage(String.format("unrecognized command: %s", name));
                return;
            }
            if (provider == null) {
                this.badUsage(String.format("unrecognized command: %s", name));
                return;
            }
            if (Args.parse((String[])commandArgs).has("help")) {
                this.outsideWorld.stdErrLine("unknown argument: --help");
                this.usage.printUsageForCommand(provider, this.outsideWorld::stdErrLine);
                this.failure();
            } else {
                AdminCommand command = provider.create(homeDir, configDir, this.outsideWorld);
                try {
                    command.execute(commandArgs);
                    this.success();
                }
                catch (IncorrectUsage e) {
                    this.badUsage(provider, e);
                }
                catch (CommandFailed e) {
                    this.commandFailed(e);
                }
            }
        }
        catch (RuntimeException e) {
            this.unexpected(e);
        }
    }

    private Supplier<AdminCommand.Provider> help() {
        return () -> new HelpCommandProvider(this.usage);
    }

    private void badUsage(AdminCommand.Provider command, IncorrectUsage e) {
        this.outsideWorld.stdErrLine(e.getMessage());
        this.outsideWorld.stdErrLine("");
        this.usage.printUsageForCommand(command, this.outsideWorld::stdErrLine);
        this.failure();
    }

    private void badUsage(String message) {
        this.outsideWorld.stdErrLine(message);
        this.usage.print(this.outsideWorld::stdErrLine);
        this.failure();
    }

    private void unexpected(RuntimeException e) {
        this.failure("unexpected error", e);
    }

    private void commandFailed(CommandFailed e) {
        this.failure("command failed", e, e.code());
    }

    private void failure() {
        this.outsideWorld.exit(1);
    }

    private void failure(String message, Exception e) {
        this.failure(message, e, 1);
    }

    private void failure(String message, Exception e, int code) {
        if (this.debug) {
            this.outsideWorld.printStacktrace(e);
        }
        this.failure(String.format("%s: %s", message, e.getMessage()), code);
    }

    private void failure(String message, int code) {
        this.outsideWorld.stdErrLine(message);
        this.outsideWorld.exit(code);
    }

    private void success() {
        this.outsideWorld.exit(0);
    }
}

