/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.commandline.arguments;

import java.util.Collection;
import java.util.stream.Collectors;
import org.neo4j.commandline.arguments.NamedArgument;
import org.neo4j.commandline.arguments.OptionalNamedArg;
import org.neo4j.helpers.Args;
import org.neo4j.kernel.impl.util.Converters;
import org.neo4j.kernel.impl.util.Validator;

public class OptionalNamedArgWithMetadata
extends OptionalNamedArg
implements NamedArgument {
    protected final String exampleMetaData;

    public OptionalNamedArgWithMetadata(String name, String exampleMetaData, String exampleValue, String defaultValue, String description) {
        super(name, exampleValue, defaultValue, description);
        this.exampleMetaData = exampleMetaData;
    }

    @Override
    public String optionsListing() {
        return String.format("--%s[%s]=<%s>", this.name, this.exampleMetaData, this.exampleValue);
    }

    @Override
    public String usage() {
        return String.format("[--%s[%s]=<%s>]", this.name, this.exampleMetaData, this.exampleValue);
    }

    @Override
    public String parse(Args parsedArgs) {
        throw new RuntimeException("Arguments with metadata only support multiple value parsing");
    }

    @Override
    public Collection<String> parseMultiple(Args parsedArgs) {
        Collection vals = parsedArgs.interpretOptionsWithMetadata(this.name, Converters.withDefault((Object)this.defaultValue), Converters.identity(), new Validator[0]);
        return vals.stream().map(Args.Option::value).collect(Collectors.toList());
    }
}

