/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.commandline.admin;

import java.util.Comparator;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import org.neo4j.commandline.admin.AdminCommand;

public abstract class AdminCommandSection {
    private static final AdminCommandSection GENERAL = new GeneralSection();

    @Nonnull
    public abstract String printable();

    public static AdminCommandSection general() {
        return GENERAL;
    }

    public int hashCode() {
        return this.printable().hashCode();
    }

    public boolean equals(Object other) {
        if (other instanceof AdminCommandSection) {
            return this.printable().equals(((AdminCommandSection)other).printable());
        }
        return false;
    }

    public final void printAllCommandsUnderSection(Consumer<String> output, List<AdminCommand.Provider> providers) {
        output.accept(this.printable());
        providers.sort(Comparator.comparing(AdminCommand.Provider::name));
        providers.forEach(provider -> provider.printSummary(s -> output.accept("    " + s)));
    }

    static class GeneralSection
    extends AdminCommandSection {
        GeneralSection() {
        }

        @Override
        @Nonnull
        public String printable() {
            return "General";
        }
    }
}

