/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.commandline.admin;

import java.nio.file.Path;
import java.util.NoSuchElementException;
import java.util.function.Consumer;
import org.neo4j.commandline.admin.AdminCommand;
import org.neo4j.commandline.admin.CommandLocator;
import org.neo4j.commandline.admin.IncorrectUsage;
import org.neo4j.commandline.admin.OutsideWorld;
import org.neo4j.commandline.admin.Usage;
import org.neo4j.commandline.arguments.Arguments;

public class HelpCommand
implements AdminCommand {
    private final Usage usage;
    private final Consumer<String> output;
    private final CommandLocator locator;

    public HelpCommand(Usage usage, Consumer<String> output, CommandLocator locator) {
        this.usage = usage;
        this.output = output;
        this.locator = locator;
    }

    @Override
    public void execute(String ... args) throws IncorrectUsage {
        if (args.length > 0) {
            try {
                AdminCommand.Provider commandProvider2 = this.locator.findProvider(args[0]);
                this.usage.printUsageForCommand(commandProvider2, this.output);
            }
            catch (NoSuchElementException e) {
                StringBuilder validCommands = new StringBuilder("");
                this.locator.getAllProviders().forEach(commandProvider -> validCommands.append(commandProvider.name()).append(" "));
                throw new IncorrectUsage(String.format("Unknown command: %s. Available commands are: %s\n", args[0], validCommands));
            }
        } else {
            this.usage.print(this.output);
        }
    }

    public static class Provider
    extends AdminCommand.Provider {
        private final Usage usage;

        public Provider(Usage usage) {
            super("help", new String[0]);
            this.usage = usage;
        }

        @Override
        public Arguments allArguments() {
            return new Arguments().withOptionalPositionalArgument(0, "command");
        }

        @Override
        public String description() {
            return "This help text, or help for the command specified in <command>.";
        }

        @Override
        public String summary() {
            return this.description();
        }

        @Override
        public AdminCommand create(Path homeDir, Path configDir, OutsideWorld outsideWorld) {
            return new HelpCommand(this.usage, outsideWorld::stdOutLine, CommandLocator.fromServiceLocator());
        }
    }
}

