/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.commandline.admin;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.NoSuchElementException;
import java.util.function.Supplier;
import org.neo4j.commandline.admin.AdminCommand;
import org.neo4j.commandline.admin.BlockerLocator;
import org.neo4j.commandline.admin.CommandFailed;
import org.neo4j.commandline.admin.CommandLocator;
import org.neo4j.commandline.admin.HelpCommandProvider;
import org.neo4j.commandline.admin.IncorrectUsage;
import org.neo4j.commandline.admin.OutsideWorld;
import org.neo4j.commandline.admin.RealOutsideWorld;
import org.neo4j.commandline.admin.Usage;

public class AdminTool {
    public static final String scriptName = "neo4j-admin";
    private final CommandLocator commandLocator;
    private final BlockerLocator blockerLocator;
    private final OutsideWorld outsideWorld;
    private final boolean debug;
    private final Usage usage;

    public static void main(String[] args) {
        Path homeDir = Paths.get(System.getenv().getOrDefault("NEO4J_HOME", ""), new String[0]);
        Path configDir = Paths.get(System.getenv().getOrDefault("NEO4J_CONF", ""), new String[0]);
        boolean debug = System.getenv("NEO4J_DEBUG") != null;
        new AdminTool(CommandLocator.fromServiceLocator(), BlockerLocator.fromServiceLocator(), new RealOutsideWorld(), debug).execute(homeDir, configDir, args);
    }

    public AdminTool(CommandLocator commandLocator, BlockerLocator blockerLocator, OutsideWorld outsideWorld, boolean debug) {
        this.commandLocator = CommandLocator.withAdditionalCommand(this.help(), commandLocator);
        this.blockerLocator = blockerLocator;
        this.outsideWorld = outsideWorld;
        this.debug = debug;
        this.usage = new Usage(scriptName, this.commandLocator);
    }

    public void execute(Path homeDir, Path configDir, String ... args) {
        try {
            AdminCommand.Provider provider;
            if (args.length == 0) {
                this.badUsage("you must provide a command");
                return;
            }
            String name = args[0];
            String[] commandArgs = Arrays.copyOfRange(args, 1, args.length);
            try {
                provider = this.commandLocator.findProvider(name);
                for (AdminCommand.Blocker blocker : this.blockerLocator.findBlockers(name)) {
                    if (!blocker.doesBlock(homeDir, configDir)) continue;
                    this.commandFailed(new CommandFailed(blocker.explanation()));
                }
            }
            catch (NoSuchElementException e) {
                this.badUsage(String.format("unrecognized command: %s", name));
                return;
            }
            AdminCommand command = provider.create(homeDir, configDir, this.outsideWorld);
            try {
                command.execute(commandArgs);
                this.success();
            }
            catch (IncorrectUsage e) {
                this.badUsage(provider, e);
            }
            catch (CommandFailed e) {
                this.commandFailed(e);
            }
        }
        catch (RuntimeException e) {
            this.unexpected(e);
        }
    }

    private Supplier<AdminCommand.Provider> help() {
        return () -> new HelpCommandProvider(this.usage);
    }

    private void badUsage(AdminCommand.Provider command, IncorrectUsage e) {
        this.outsideWorld.stdErrLine(e.getMessage());
        this.outsideWorld.stdErrLine("");
        this.usage.printUsageForCommand(command, this.outsideWorld::stdErrLine);
        this.failure();
    }

    private void badUsage(String message) {
        this.outsideWorld.stdErrLine(message);
        this.usage.print(this.outsideWorld::stdErrLine);
        this.failure();
    }

    private void unexpected(RuntimeException e) {
        this.failure("unexpected error", e);
    }

    private void commandFailed(CommandFailed e) {
        this.failure("command failed", e);
    }

    private void failure() {
        this.outsideWorld.exit(1);
    }

    private void failure(String message, Exception e) {
        if (this.debug) {
            this.outsideWorld.printStacktrace(e);
        }
        this.failure(String.format("%s: %s", message, e.getMessage()));
    }

    private void failure(String message) {
        this.outsideWorld.stdErrLine(message);
        this.outsideWorld.exit(1);
    }

    private void success() {
        this.outsideWorld.exit(0);
    }
}

