/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.commandline.admin;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.NoSuchElementException;
import java.util.function.Supplier;
import org.neo4j.commandline.admin.AdminCommand;
import org.neo4j.commandline.admin.CommandFailed;
import org.neo4j.commandline.admin.CommandLocator;
import org.neo4j.commandline.admin.HelpCommand;
import org.neo4j.commandline.admin.IncorrectUsage;
import org.neo4j.commandline.admin.Output;
import org.neo4j.commandline.admin.Result;
import org.neo4j.commandline.admin.Usage;

public class AdminTool {
    private final String scriptName = "neo4j-admin";
    private final CommandLocator locator;
    private final Output out;
    private final boolean debug;
    private final Usage usage;

    public static void main(String[] args) {
        Path homeDir = Paths.get(System.getenv("NEO4J_HOME"), new String[0]);
        Path configDir = Paths.get(System.getenv("NEO4J_CONF"), new String[0]);
        String extraHelp = System.getenv("NEO4J_EXTRA_HELP");
        boolean debug = System.getenv("NEO4J_DEBUG") != null;
        AdminTool tool = new AdminTool(CommandLocator.fromServiceLocator(), System.out::println, extraHelp, debug);
        Result result = tool.execute(homeDir, configDir, args);
        result.exit();
    }

    public AdminTool(CommandLocator locator, Output out, String extraHelp, boolean debug) {
        this.locator = CommandLocator.withAdditionalCommand(this.help(), locator);
        this.out = out;
        this.debug = debug;
        this.usage = new Usage("neo4j-admin", out, this.locator, extraHelp);
    }

    public Result execute(Path homeDir, Path configDir, String ... args) {
        try {
            AdminCommand.Provider provider;
            String name = args[0];
            String[] commandArgs = Arrays.copyOfRange(args, 1, args.length);
            try {
                provider = this.locator.findProvider(name);
            }
            catch (NoSuchElementException e) {
                return this.badUsage(name, commandArgs);
            }
            AdminCommand command = provider.create(homeDir, configDir);
            try {
                command.execute(commandArgs);
                return AdminTool.success();
            }
            catch (IncorrectUsage e) {
                return this.badUsage(provider, e);
            }
            catch (CommandFailed e) {
                return this.failure(e);
            }
        }
        catch (RuntimeException e) {
            return this.unexpected(e);
        }
    }

    private Supplier<AdminCommand.Provider> help() {
        return () -> new HelpCommand.Provider(this.usage);
    }

    private Result badUsage(AdminCommand.Provider command, IncorrectUsage e) {
        new Usage.CommandUsage(command, this.out, "neo4j-admin").print();
        return AdminTool.failure(e.getMessage());
    }

    private Result badUsage(String name, String[] commandArgs) {
        this.usage.print();
        String message = commandArgs.length == 0 ? String.format("unrecognized command: %s", name) : commandArgs[0];
        return AdminTool.failure(message);
    }

    private Result unexpected(RuntimeException e) {
        return this.failure(e, "unexpected error: " + e.getMessage());
    }

    private Result failure(Throwable e) {
        if (this.debug) {
            return this.failure(e, e.getMessage());
        }
        return AdminTool.failure(e.getMessage());
    }

    private Result failure(Throwable e, String message) {
        return () -> {
            e.printStackTrace();
            AdminTool.failure(message).exit();
        };
    }

    private static Result failure(String message) {
        return () -> {
            System.err.println(message);
            System.exit(1);
        };
    }

    private static Result success() {
        return () -> System.exit(0);
    }
}

