/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.com.storecopy;

import java.util.function.Supplier;
import org.neo4j.com.RequestContext;
import org.neo4j.com.ResourceReleaser;
import org.neo4j.com.Response;
import org.neo4j.com.TransactionObligationResponse;
import org.neo4j.com.TransactionStream;
import org.neo4j.com.TransactionStreamResponse;
import org.neo4j.cursor.IOCursor;
import org.neo4j.helpers.collection.Visitor;
import org.neo4j.kernel.impl.store.StoreId;
import org.neo4j.kernel.impl.transaction.CommittedTransactionRepresentation;
import org.neo4j.kernel.impl.transaction.log.LogicalTransactionStore;
import org.neo4j.kernel.impl.transaction.log.TransactionIdStore;

public class ResponsePacker {
    protected final LogicalTransactionStore transactionStore;
    protected final Supplier<StoreId> storeId;
    private final TransactionIdStore transactionIdStore;

    public ResponsePacker(LogicalTransactionStore transactionStore, TransactionIdStore transactionIdStore, Supplier<StoreId> storeId) {
        this.transactionStore = transactionStore;
        this.transactionIdStore = transactionIdStore;
        this.storeId = storeId;
    }

    public <T> Response<T> packTransactionStreamResponse(RequestContext context, T response) {
        long toStartFrom = context.lastAppliedTransaction() + 1L;
        long toEndAt = this.transactionIdStore.getLastCommittedTransactionId();
        TransactionStream transactions = visitor -> {
            if (toStartFrom > 1L && toStartFrom <= toEndAt) {
                this.extractTransactions(toStartFrom, this.filterVisitor((Visitor<CommittedTransactionRepresentation, Exception>)visitor, toEndAt));
            }
        };
        return new TransactionStreamResponse<T>(response, this.storeId.get(), transactions, ResourceReleaser.NO_OP);
    }

    public <T> Response<T> packTransactionObligationResponse(RequestContext context, T response) {
        return this.packTransactionObligationResponse(context, response, this.transactionIdStore.getLastCommittedTransactionId());
    }

    public <T> Response<T> packTransactionObligationResponse(RequestContext context, T response, long obligationTxId) {
        return new TransactionObligationResponse<T>(response, this.storeId.get(), obligationTxId, ResourceReleaser.NO_OP);
    }

    public <T> Response<T> packEmptyResponse(T response) {
        return new TransactionObligationResponse<T>(response, this.storeId.get(), 1L, ResourceReleaser.NO_OP);
    }

    protected Visitor<CommittedTransactionRepresentation, Exception> filterVisitor(Visitor<CommittedTransactionRepresentation, Exception> delegate, long txToEndAt) {
        return element -> {
            if (element.getCommitEntry().getTxId() > txToEndAt) {
                return false;
            }
            return delegate.visit(element);
        };
    }

    protected void extractTransactions(long startingAtTransactionId, Visitor<CommittedTransactionRepresentation, Exception> visitor) throws Exception {
        try (IOCursor cursor = this.transactionStore.getTransactions(startingAtTransactionId);){
            while (cursor.next() && !visitor.visit(cursor.get())) {
            }
        }
    }
}

