/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.com.storecopy;

import java.io.File;
import java.io.IOException;
import java.nio.file.OpenOption;
import java.util.Map;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.factory.GraphDatabaseFactory;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.IOLimiter;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.PagedFile;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.extension.KernelExtensionFactory;
import org.neo4j.kernel.impl.enterprise.EnterpriseFacadeFactory;
import org.neo4j.kernel.impl.factory.GraphDatabaseFacade;
import org.neo4j.kernel.impl.factory.GraphDatabaseFacadeFactory;
import org.neo4j.kernel.impl.factory.PlatformModule;
import org.neo4j.kernel.impl.logging.LogService;
import org.neo4j.kernel.monitoring.tracing.Tracers;

public class ExternallyManagedPageCache
implements PageCache {
    private final PageCache delegate;

    public ExternallyManagedPageCache(PageCache delegate) {
        this.delegate = delegate;
    }

    public void close() throws IOException {
    }

    public PagedFile map(File file, int pageSize, OpenOption ... openOptions) throws IOException {
        return this.delegate.map(file, pageSize, openOptions);
    }

    public void flushAndForce() throws IOException {
        this.delegate.flushAndForce();
    }

    public void flushAndForce(IOLimiter limiter) throws IOException {
        this.delegate.flushAndForce(limiter);
    }

    public int pageSize() {
        return this.delegate.pageSize();
    }

    public int maxCachedPages() {
        return this.delegate.maxCachedPages();
    }

    public static GraphDatabaseFactoryWithPageCacheFactory graphDatabaseFactoryWithPageCache(PageCache delegatePageCache) {
        return new GraphDatabaseFactoryWithPageCacheFactory(delegatePageCache);
    }

    public static class GraphDatabaseFactoryWithPageCacheFactory
    extends GraphDatabaseFactory {
        private final PageCache delegatePageCache;

        public GraphDatabaseFactoryWithPageCacheFactory(PageCache delegatePageCache) {
            this.delegatePageCache = delegatePageCache;
        }

        protected GraphDatabaseService newDatabase(File storeDir, Map<String, String> config, GraphDatabaseFacadeFactory.Dependencies dependencies) {
            return new EnterpriseFacadeFactory(){

                protected PlatformModule createPlatform(File storeDir, Map<String, String> params, GraphDatabaseFacadeFactory.Dependencies dependencies, GraphDatabaseFacade graphDatabaseFacade) {
                    return new PlatformModule(storeDir, params, this.databaseInfo(), dependencies, graphDatabaseFacade){

                        protected PageCache createPageCache(FileSystemAbstraction fileSystem, Config config, LogService logging, Tracers tracers) {
                            return new ExternallyManagedPageCache(delegatePageCache);
                        }
                    };
                }
            }.newFacade(storeDir, config, dependencies);
        }

        public GraphDatabaseFactoryWithPageCacheFactory setKernelExtensions(Iterable<KernelExtensionFactory<?>> newKernelExtensions) {
            this.getCurrentState().setKernelExtensions(newKernelExtensions);
            return this;
        }
    }
}

