/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.com;

import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.neo4j.helpers.Clock;

public abstract class ResourcePool<R> {
    public static final int DEFAULT_CHECK_INTERVAL = 60000;
    protected final LinkedList<R> unused = new LinkedList();
    private final Map<Thread, R> current = new ConcurrentHashMap<Thread, R>();
    private final Monitor<R> monitor;
    private final int minSize;
    private final CheckStrategy checkStrategy;
    private int currentPeakSize;
    private int targetSize;

    protected ResourcePool(int minSize) {
        this(minSize, new CheckStrategy.TimeoutCheckStrategy(60000L, Clock.SYSTEM_CLOCK), new Monitor.Adapter());
    }

    protected ResourcePool(int minSize, CheckStrategy strategy, Monitor<R> monitor) {
        this.minSize = minSize;
        this.currentPeakSize = 0;
        this.targetSize = minSize;
        this.checkStrategy = strategy;
        this.monitor = monitor;
    }

    protected abstract R create();

    protected void dispose(R resource) {
    }

    protected int currentSize() {
        return this.current.size();
    }

    protected boolean isAlive(R resource) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final R acquire() {
        Thread thread = Thread.currentThread();
        R resource = this.current.get(thread);
        if (resource == null) {
            LinkedList<R> garbage = null;
            LinkedList<R> linkedList = this.unused;
            synchronized (linkedList) {
                while ((resource = this.unused.poll()) != null && !this.isAlive(resource)) {
                    if (garbage == null) {
                        garbage = new LinkedList<R>();
                    }
                    garbage.add(resource);
                }
            }
            if (resource == null) {
                resource = this.create();
                this.monitor.created(resource);
            }
            this.current.put(thread, resource);
            this.monitor.acquired(resource);
            if (garbage != null) {
                for (Object dead : garbage) {
                    this.dispose(dead);
                    this.monitor.disposed(dead);
                }
            }
        }
        this.currentPeakSize = Math.max(this.currentPeakSize, this.current.size());
        if (this.checkStrategy.shouldCheck()) {
            this.targetSize = Math.max(this.minSize, this.currentPeakSize);
            this.monitor.updatedCurrentPeakSize(this.currentPeakSize);
            this.currentPeakSize = 0;
            this.monitor.updatedTargetSize(this.targetSize);
        }
        return resource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void release() {
        Thread thread = Thread.currentThread();
        R resource = this.current.remove(thread);
        if (resource != null) {
            boolean dead = false;
            LinkedList<R> linkedList = this.unused;
            synchronized (linkedList) {
                if (this.unused.size() < this.targetSize) {
                    this.unused.add(resource);
                } else {
                    dead = true;
                }
            }
            if (dead) {
                this.dispose(resource);
                this.monitor.disposed(resource);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void close(boolean force) {
        LinkedList<R> dead = new LinkedList<R>();
        LinkedList<R> linkedList = this.unused;
        synchronized (linkedList) {
            dead.addAll(this.unused);
            this.unused.clear();
        }
        if (force) {
            dead.addAll(this.current.values());
        }
        for (Object resource : dead) {
            this.dispose(resource);
        }
    }

    public static interface CheckStrategy {
        public boolean shouldCheck();

        public static class TimeoutCheckStrategy
        implements CheckStrategy {
            private final long interval;
            private volatile long lastCheckTime;
            private final Clock clock;

            public TimeoutCheckStrategy(long interval, Clock clock) {
                this.interval = interval;
                this.lastCheckTime = clock.currentTimeMillis();
                this.clock = clock;
            }

            @Override
            public boolean shouldCheck() {
                long currentTime = this.clock.currentTimeMillis();
                if (currentTime > this.lastCheckTime + this.interval) {
                    this.lastCheckTime = currentTime;
                    return true;
                }
                return false;
            }
        }
    }

    public static interface Monitor<R> {
        public void updatedCurrentPeakSize(int var1);

        public void updatedTargetSize(int var1);

        public void created(R var1);

        public void acquired(R var1);

        public void disposed(R var1);

        public static class Adapter<R>
        implements Monitor<R> {
            @Override
            public void updatedCurrentPeakSize(int currentPeakSize) {
            }

            @Override
            public void updatedTargetSize(int targetSize) {
            }

            @Override
            public void created(R resource) {
            }

            @Override
            public void acquired(R resource) {
            }

            @Override
            public void disposed(R resource) {
            }
        }
    }
}

