/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.codegen.source;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.tools.JavaFileObject;
import org.neo4j.codegen.ByteCodes;
import org.neo4j.codegen.ClassEmitter;
import org.neo4j.codegen.CodeGenerator;
import org.neo4j.codegen.CompilationFailureException;
import org.neo4j.codegen.TypeReference;
import org.neo4j.codegen.source.ClassSourceWriter;
import org.neo4j.codegen.source.Configuration;
import org.neo4j.codegen.source.JavaSourceFile;
import org.neo4j.codegen.source.SourceCompiler;

class SourceCodeGenerator
extends CodeGenerator {
    private final Configuration configuration;
    private final Map<TypeReference, StringBuilder> classes = new HashMap<TypeReference, StringBuilder>();
    private final SourceCompiler compiler;

    SourceCodeGenerator(ClassLoader parentClassLoader, Configuration configuration, SourceCompiler compiler) {
        super(parentClassLoader);
        this.configuration = configuration;
        this.compiler = compiler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected ClassEmitter generate(TypeReference type, TypeReference base, TypeReference[] interfaces) {
        StringBuilder target = new StringBuilder();
        SourceCodeGenerator sourceCodeGenerator = this;
        synchronized (sourceCodeGenerator) {
            StringBuilder old = this.classes.put(type, target);
            if (old != null) {
                this.classes.put(type, old);
                throw new IllegalStateException("Trying to generate class twice: " + type);
            }
        }
        ClassSourceWriter writer = new ClassSourceWriter(target, this.configuration);
        writer.declarePackage(type);
        writer.javadoc("Generated by " + this.getClass().getName());
        writer.publicClass(type);
        writer.extendClass(base);
        writer.implement(interfaces);
        writer.begin();
        return writer;
    }

    @Override
    protected Iterable<? extends ByteCodes> compile(ClassLoader classpathLoader) throws CompilationFailureException {
        return this.compiler.compile(this.sourceFiles(), classpathLoader);
    }

    private synchronized List<JavaSourceFile> sourceFiles() {
        ArrayList<JavaSourceFile> sourceFiles = new ArrayList<JavaSourceFile>(this.classes.size());
        for (Map.Entry<TypeReference, StringBuilder> entry : this.classes.entrySet()) {
            TypeReference reference = entry.getKey();
            StringBuilder source = entry.getValue();
            this.configuration.visit(reference, source);
            sourceFiles.add(new JavaSourceFile(this.configuration.sourceBase().uri(reference.packageName(), reference.name(), JavaFileObject.Kind.SOURCE), source));
        }
        return sourceFiles;
    }
}

