/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.codegen.source;

import java.util.Deque;
import java.util.LinkedList;
import java.util.function.Consumer;
import org.apache.commons.text.StringEscapeUtils;
import org.neo4j.codegen.Expression;
import org.neo4j.codegen.ExpressionVisitor;
import org.neo4j.codegen.FieldReference;
import org.neo4j.codegen.LocalVariable;
import org.neo4j.codegen.MethodEmitter;
import org.neo4j.codegen.MethodReference;
import org.neo4j.codegen.TypeReference;
import org.neo4j.codegen.source.ClassSourceWriter;

class MethodSourceWriter
implements MethodEmitter,
ExpressionVisitor {
    private static final Runnable BOTTOM = () -> {
        throw new IllegalStateException("Popped too many levels!");
    };
    private static final Runnable LEVEL = () -> {};
    private static final String INDENTATION = "    ";
    private final StringBuilder target;
    private final ClassSourceWriter classSourceWriter;
    private final Deque<Runnable> levels = new LinkedList<Runnable>();

    MethodSourceWriter(StringBuilder target, ClassSourceWriter classSourceWriter) {
        this.target = target;
        this.classSourceWriter = classSourceWriter;
        this.levels.push(BOTTOM);
        this.levels.push(LEVEL);
    }

    private StringBuilder indent() {
        int level = this.levels.size();
        while (level-- > 0) {
            this.target.append(INDENTATION);
        }
        return this.target;
    }

    private StringBuilder append(CharSequence text) {
        return this.target.append(text);
    }

    @Override
    public void done() {
        if (this.levels.size() != 1) {
            throw new IllegalStateException("unbalanced blocks!");
        }
        this.classSourceWriter.append(this.target);
    }

    @Override
    public void expression(Expression expression) {
        this.indent();
        expression.accept(this);
        this.target.append(";\n");
    }

    @Override
    public void put(Expression target, FieldReference field, Expression value) {
        this.indent();
        target.accept(this);
        this.append(".");
        this.append(field.name());
        this.append(" = ");
        value.accept(this);
        this.append(";\n");
    }

    @Override
    public void returns() {
        this.indent().append("return;\n");
    }

    @Override
    public void returns(Expression value) {
        this.indent().append("return ");
        value.accept(this);
        this.append(";\n");
    }

    @Override
    public void declare(LocalVariable local) {
        this.indent().append(local.type().fullName()).append(' ').append(local.name()).append(";\n");
    }

    @Override
    public void assignVariableInScope(LocalVariable local, Expression value) {
        this.indent().append(local.name()).append(" = ");
        value.accept(this);
        this.append(";\n");
    }

    @Override
    public void assign(LocalVariable variable, Expression value) {
        this.indent().append(variable.type().fullName()).append(' ').append(variable.name()).append(" = ");
        value.accept(this);
        this.append(";\n");
    }

    @Override
    public void beginWhile(Expression test) {
        this.indent().append("while( ");
        test.accept(this);
        this.append(" )\n");
        this.indent().append("{\n");
        this.levels.push(LEVEL);
    }

    @Override
    public void beginIf(Expression test) {
        this.indent().append("if ( ");
        test.accept(this);
        this.append(" )\n");
        this.indent().append("{\n");
        this.levels.push(LEVEL);
    }

    @Override
    public void beginBlock() {
        this.indent().append("{\n");
        this.levels.push(LEVEL);
    }

    @Override
    public <T> void tryCatchBlock(Consumer<T> body, Consumer<T> handler, LocalVariable exception, T block) {
        this.indent().append("try\n");
        this.indent().append("{\n");
        this.levels.push(LEVEL);
        body.accept(block);
        this.levels.pop();
        this.indent().append("}\n");
        this.indent().append("catch ( ").append(exception.type().fullName()).append(" ").append(exception.name()).append(" )\n");
        this.indent().append("{\n");
        this.levels.push(LEVEL);
        handler.accept(block);
        this.levels.pop();
        this.indent().append("}\n");
    }

    @Override
    public void throwException(Expression exception) {
        this.indent().append("throw ");
        exception.accept(this);
        this.append(";\n");
    }

    @Override
    public void endBlock() {
        Runnable action = this.levels.pop();
        this.indent().append("}\n");
        action.run();
    }

    @Override
    public void invoke(Expression target, MethodReference method, Expression[] arguments) {
        target.accept(this);
        if (!method.isConstructor()) {
            this.append(".").append(method.name());
        }
        this.arglist(arguments);
    }

    @Override
    public void invoke(MethodReference method, Expression[] arguments) {
        this.append(method.owner().fullName()).append('.').append(method.name());
        this.arglist(arguments);
    }

    private void arglist(Expression[] arguments) {
        this.append("(");
        String sep = " ";
        for (Expression argument : arguments) {
            this.append(sep);
            argument.accept(this);
            sep = ", ";
        }
        if (sep.length() > 1) {
            this.append(" ");
        }
        this.append(")");
    }

    @Override
    public void load(LocalVariable variable) {
        this.append(variable.name());
    }

    @Override
    public void getField(Expression target, FieldReference field) {
        target.accept(this);
        this.append(".").append(field.name());
    }

    @Override
    public void constant(Object value) {
        if (value == null) {
            this.append("null");
        } else if (value instanceof String) {
            this.append("\"").append(StringEscapeUtils.escapeJava((String)((String)value))).append('\"');
        } else if (value instanceof Integer) {
            this.append(value.toString());
        } else if (value instanceof Long) {
            this.append(value.toString()).append('L');
        } else if (value instanceof Double) {
            Double doubleValue = (Double)value;
            if (Double.isNaN(doubleValue)) {
                this.append("Double.NaN");
            } else if (doubleValue == Double.POSITIVE_INFINITY) {
                this.append("Double.POSITIVE_INFINITY");
            } else if (doubleValue == Double.NEGATIVE_INFINITY) {
                this.append("Double.NEGATIVE_INFINITY");
            } else {
                this.append(value.toString());
            }
        } else if (value instanceof Boolean) {
            this.append(value.toString());
        } else {
            throw new UnsupportedOperationException(value.getClass() + " constants");
        }
    }

    @Override
    public void getStatic(FieldReference field) {
        this.append(field.owner().fullName()).append(".").append(field.name());
    }

    @Override
    public void loadThis(String sourceName) {
        this.append(sourceName);
    }

    @Override
    public void newInstance(TypeReference type) {
        this.append("new ").append(type.fullName());
    }

    @Override
    public void not(Expression expression) {
        this.append("!( ");
        expression.accept(this);
        this.append(" )");
    }

    @Override
    public void ternary(Expression test, Expression onTrue, Expression onFalse) {
        this.append("((");
        test.accept(this);
        this.append(") ? (");
        onTrue.accept(this);
        this.append(") : (");
        onFalse.accept(this);
        this.append("))");
    }

    @Override
    public void equal(Expression lhs, Expression rhs) {
        this.binaryOperation(lhs, rhs, " == ");
    }

    @Override
    public void notEqual(Expression lhs, Expression rhs) {
        this.binaryOperation(lhs, rhs, " != ");
    }

    @Override
    public void isNull(Expression expression) {
        expression.accept(this);
        this.append(" == null");
    }

    @Override
    public void notNull(Expression expression) {
        expression.accept(this);
        this.append(" != null");
    }

    @Override
    public void or(Expression ... expressions) {
        this.boolOp(expressions, " || ");
    }

    @Override
    public void and(Expression ... expressions) {
        this.boolOp(expressions, " && ");
    }

    private void boolOp(Expression[] expressions, String op) {
        String sep = "";
        for (Expression expression : expressions) {
            this.append(sep);
            expression.accept(this);
            sep = op;
        }
    }

    @Override
    public void add(Expression lhs, Expression rhs) {
        this.binaryOperation(lhs, rhs, " + ");
    }

    @Override
    public void gt(Expression lhs, Expression rhs) {
        this.binaryOperation(lhs, rhs, " > ");
    }

    @Override
    public void gte(Expression lhs, Expression rhs) {
        this.binaryOperation(lhs, rhs, " >= ");
    }

    @Override
    public void lt(Expression lhs, Expression rhs) {
        this.binaryOperation(lhs, rhs, " < ");
    }

    @Override
    public void lte(Expression lhs, Expression rhs) {
        this.binaryOperation(lhs, rhs, " <= ");
    }

    @Override
    public void subtract(Expression lhs, Expression rhs) {
        lhs.accept(this);
        this.append(" - ");
        rhs.accept(this);
    }

    @Override
    public void multiply(Expression lhs, Expression rhs) {
        lhs.accept(this);
        this.append(" * ");
        rhs.accept(this);
    }

    private void div(Expression lhs, Expression rhs) {
        lhs.accept(this);
        this.append(" / ");
        rhs.accept(this);
    }

    @Override
    public void cast(TypeReference type, Expression expression) {
        this.append("(");
        this.append("(").append(type.fullName()).append(") ");
        expression.accept(this);
        this.append(")");
    }

    @Override
    public void instanceOf(TypeReference type, Expression expression) {
        expression.accept(this);
        this.append(" instanceof ").append(type.fullName());
    }

    @Override
    public void newArray(TypeReference type, Expression ... constants) {
        this.append("new ").append(type.fullName()).append("[]{");
        String sep = "";
        for (Expression constant : constants) {
            this.append(sep);
            constant.accept(this);
            sep = ", ";
        }
        this.append("}");
    }

    @Override
    public void longToDouble(Expression expression) {
        this.cast(TypeReference.typeReference(Double.TYPE), expression);
    }

    @Override
    public void pop(Expression expression) {
        expression.accept(this);
    }

    @Override
    public void box(Expression expression) {
        this.append("(/*box*/ ");
        expression.accept(this);
        this.append(")");
    }

    @Override
    public void unbox(Expression expression) {
        expression.accept(this);
    }

    private void binaryOperation(Expression lhs, Expression rhs, String operator) {
        lhs.accept(this);
        this.append(operator);
        rhs.accept(this);
    }
}

