/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.codegen.bytecode;

import java.lang.reflect.Modifier;
import org.neo4j.codegen.ByteCodeUtils;
import org.neo4j.codegen.Expression;
import org.neo4j.codegen.ExpressionVisitor;
import org.neo4j.codegen.FieldReference;
import org.neo4j.codegen.LocalVariable;
import org.neo4j.codegen.MethodReference;
import org.neo4j.codegen.TypeReference;
import org.neo4j.codegen.asm.Label;
import org.neo4j.codegen.asm.MethodVisitor;

class ByteCodeExpressionVisitor
implements ExpressionVisitor {
    private final MethodVisitor methodVisitor;

    ByteCodeExpressionVisitor(MethodVisitor methodVisitor) {
        this.methodVisitor = methodVisitor;
    }

    @Override
    public void invoke(Expression target, MethodReference method, Expression[] arguments) {
        target.accept(this);
        for (Expression argument : arguments) {
            argument.accept(this);
        }
        if (Modifier.isInterface(method.owner().modifiers())) {
            this.methodVisitor.visitMethodInsn(185, ByteCodeUtils.byteCodeName(method.owner()), method.name(), ByteCodeUtils.desc(method), true);
        } else if (method.isConstructor()) {
            this.methodVisitor.visitMethodInsn(183, ByteCodeUtils.byteCodeName(method.owner()), method.name(), ByteCodeUtils.desc(method), false);
        } else {
            this.methodVisitor.visitMethodInsn(182, ByteCodeUtils.byteCodeName(method.owner()), method.name(), ByteCodeUtils.desc(method), false);
        }
    }

    @Override
    public void invoke(MethodReference method, Expression[] arguments) {
        for (Expression argument : arguments) {
            argument.accept(this);
        }
        this.methodVisitor.visitMethodInsn(184, ByteCodeUtils.byteCodeName(method.owner()), method.name(), ByteCodeUtils.desc(method), Modifier.isInterface(method.owner().modifiers()));
    }

    @Override
    public void load(LocalVariable variable) {
        if (variable.type().isPrimitive()) {
            switch (variable.type().name()) {
                case "int": 
                case "byte": 
                case "short": 
                case "char": 
                case "boolean": {
                    this.methodVisitor.visitVarInsn(21, variable.index());
                    break;
                }
                case "long": {
                    this.methodVisitor.visitVarInsn(22, variable.index());
                    break;
                }
                case "float": {
                    this.methodVisitor.visitVarInsn(23, variable.index());
                    break;
                }
                case "double": {
                    this.methodVisitor.visitVarInsn(24, variable.index());
                    break;
                }
                default: {
                    this.methodVisitor.visitVarInsn(25, variable.index());
                    break;
                }
            }
        } else {
            this.methodVisitor.visitVarInsn(25, variable.index());
        }
    }

    @Override
    public void getField(Expression target, FieldReference field) {
        target.accept(this);
        this.methodVisitor.visitFieldInsn(180, ByteCodeUtils.byteCodeName(field.owner()), field.name(), ByteCodeUtils.typeName(field.type()));
    }

    @Override
    public void constant(Object value) {
        if (value == null) {
            this.methodVisitor.visitInsn(1);
        } else if (value instanceof Integer) {
            this.pushInteger((Integer)value);
        } else if (value instanceof Byte) {
            this.pushInteger(((Byte)value).byteValue());
        } else if (value instanceof Short) {
            this.pushInteger(((Short)value).shortValue());
        } else if (value instanceof Long) {
            this.pushLong((Long)value);
        } else if (value instanceof Double) {
            this.methodVisitor.visitLdcInsn(value);
        } else if (value instanceof Float) {
            this.methodVisitor.visitLdcInsn(value);
        } else if (value instanceof Boolean) {
            boolean b = (Boolean)value;
            this.methodVisitor.visitInsn(b ? 4 : 3);
        } else {
            this.methodVisitor.visitLdcInsn(value);
        }
    }

    @Override
    public void getStatic(FieldReference field) {
        this.methodVisitor.visitFieldInsn(178, ByteCodeUtils.byteCodeName(field.owner()), field.name(), ByteCodeUtils.typeName(field.type()));
    }

    @Override
    public void loadThis(String sourceName) {
        this.methodVisitor.visitVarInsn(25, 0);
    }

    @Override
    public void newInstance(TypeReference type) {
        this.methodVisitor.visitTypeInsn(187, ByteCodeUtils.byteCodeName(type));
        this.methodVisitor.visitInsn(89);
    }

    @Override
    public void not(Expression expression) {
        this.test(154, expression, Expression.TRUE, Expression.FALSE);
    }

    @Override
    public void isNull(Expression expression) {
        this.test(199, expression, Expression.TRUE, Expression.FALSE);
    }

    @Override
    public void notNull(Expression expression) {
        this.test(198, expression, Expression.TRUE, Expression.FALSE);
    }

    @Override
    public void ternary(Expression test, Expression onTrue, Expression onFalse) {
        this.test(153, test, onTrue, onFalse);
    }

    public void ternaryOnNull(Expression test, Expression onTrue, Expression onFalse) {
        this.test(199, test, onTrue, onFalse);
    }

    public void ternaryOnNonNull(Expression test, Expression onTrue, Expression onFalse) {
        this.test(198, test, onTrue, onFalse);
    }

    private void test(int test, Expression predicate, Expression onTrue, Expression onFalse) {
        predicate.accept(this);
        Label isFalse = new Label();
        this.methodVisitor.visitJumpInsn(test, isFalse);
        onTrue.accept(this);
        Label after = new Label();
        this.methodVisitor.visitJumpInsn(167, after);
        this.methodVisitor.visitLabel(isFalse);
        onFalse.accept(this);
        this.methodVisitor.visitLabel(after);
    }

    @Override
    public void equal(Expression lhs, Expression rhs) {
        this.equal(lhs, rhs, true);
    }

    @Override
    public void notEqual(Expression lhs, Expression rhs) {
        this.equal(lhs, rhs, false);
    }

    private void equal(Expression lhs, Expression rhs, boolean equal) {
        if (lhs.type().isPrimitive()) {
            assert (rhs.type().isPrimitive());
            switch (lhs.type().name()) {
                case "int": 
                case "byte": 
                case "short": 
                case "char": 
                case "boolean": {
                    this.assertSameType(lhs, rhs, "compare");
                    this.compareIntOrReferenceType(lhs, rhs, equal ? 160 : 159);
                    break;
                }
                case "long": {
                    this.assertSameType(lhs, rhs, "compare");
                    this.compareLongOrFloatType(lhs, rhs, 148, equal ? 154 : 153);
                    break;
                }
                case "float": {
                    this.assertSameType(lhs, rhs, "compare");
                    this.compareLongOrFloatType(lhs, rhs, 149, equal ? 154 : 153);
                    break;
                }
                case "double": {
                    this.assertSameType(lhs, rhs, "compare");
                    this.compareLongOrFloatType(lhs, rhs, 151, equal ? 154 : 153);
                    break;
                }
                default: {
                    this.compareIntOrReferenceType(lhs, rhs, equal ? 166 : 165);
                    break;
                }
            }
        } else {
            assert (!rhs.type().isPrimitive());
            this.compareIntOrReferenceType(lhs, rhs, equal ? 166 : 165);
        }
    }

    @Override
    public void or(Expression ... expressions) {
        assert (expressions.length >= 2);
        Label l0 = new Label();
        Label l1 = new Label();
        Label l2 = new Label();
        for (int i = 0; i < expressions.length; ++i) {
            expressions[i].accept(this);
            if (i >= expressions.length - 1) continue;
            this.methodVisitor.visitJumpInsn(154, l0);
        }
        this.methodVisitor.visitJumpInsn(153, l1);
        this.methodVisitor.visitLabel(l0);
        this.methodVisitor.visitInsn(4);
        this.methodVisitor.visitJumpInsn(167, l2);
        this.methodVisitor.visitLabel(l1);
        this.methodVisitor.visitInsn(3);
        this.methodVisitor.visitLabel(l2);
    }

    @Override
    public void and(Expression ... expressions) {
        assert (expressions.length >= 2);
        Label l0 = new Label();
        Label l1 = new Label();
        for (Expression expression : expressions) {
            expression.accept(this);
            this.methodVisitor.visitJumpInsn(153, l0);
        }
        this.methodVisitor.visitInsn(4);
        this.methodVisitor.visitJumpInsn(167, l1);
        this.methodVisitor.visitLabel(l0);
        this.methodVisitor.visitInsn(3);
        this.methodVisitor.visitLabel(l1);
    }

    @Override
    public void add(Expression lhs, Expression rhs) {
        this.assertSameType(lhs, rhs, "add");
        lhs.accept(this);
        rhs.accept(this);
        this.numberOperation(lhs.type(), () -> this.methodVisitor.visitInsn(96), () -> this.methodVisitor.visitInsn(97), () -> this.methodVisitor.visitInsn(98), () -> this.methodVisitor.visitInsn(99));
    }

    @Override
    public void gt(Expression lhs, Expression rhs) {
        this.assertSameType(lhs, rhs, "compare");
        this.numberOperation(lhs.type(), () -> this.compareIntOrReferenceType(lhs, rhs, 164), () -> this.compareLongOrFloatType(lhs, rhs, 148, 158), () -> this.compareLongOrFloatType(lhs, rhs, 149, 158), () -> this.compareLongOrFloatType(lhs, rhs, 151, 158));
    }

    @Override
    public void gte(Expression lhs, Expression rhs) {
        this.assertSameType(lhs, rhs, "compare");
        this.numberOperation(lhs.type(), () -> this.compareIntOrReferenceType(lhs, rhs, 161), () -> this.compareLongOrFloatType(lhs, rhs, 148, 155), () -> this.compareLongOrFloatType(lhs, rhs, 149, 155), () -> this.compareLongOrFloatType(lhs, rhs, 151, 155));
    }

    @Override
    public void lt(Expression lhs, Expression rhs) {
        this.assertSameType(lhs, rhs, "compare");
        this.numberOperation(lhs.type(), () -> this.compareIntOrReferenceType(lhs, rhs, 162), () -> this.compareLongOrFloatType(lhs, rhs, 148, 156), () -> this.compareLongOrFloatType(lhs, rhs, 150, 156), () -> this.compareLongOrFloatType(lhs, rhs, 152, 156));
    }

    @Override
    public void lte(Expression lhs, Expression rhs) {
        this.assertSameType(lhs, rhs, "compare");
        this.numberOperation(lhs.type(), () -> this.compareIntOrReferenceType(lhs, rhs, 163), () -> this.compareLongOrFloatType(lhs, rhs, 148, 157), () -> this.compareLongOrFloatType(lhs, rhs, 150, 157), () -> this.compareLongOrFloatType(lhs, rhs, 152, 157));
    }

    @Override
    public void subtract(Expression lhs, Expression rhs) {
        this.assertSameType(lhs, rhs, "subtract");
        lhs.accept(this);
        rhs.accept(this);
        this.numberOperation(lhs.type(), () -> this.methodVisitor.visitInsn(100), () -> this.methodVisitor.visitInsn(101), () -> this.methodVisitor.visitInsn(102), () -> this.methodVisitor.visitInsn(103));
    }

    @Override
    public void multiply(Expression lhs, Expression rhs) {
        this.assertSameType(lhs, rhs, "multiply");
        lhs.accept(this);
        rhs.accept(this);
        this.numberOperation(lhs.type(), () -> this.methodVisitor.visitInsn(104), () -> this.methodVisitor.visitInsn(105), () -> this.methodVisitor.visitInsn(106), () -> this.methodVisitor.visitInsn(107));
    }

    @Override
    public void cast(TypeReference type, Expression expression) {
        expression.accept(this);
        this.methodVisitor.visitTypeInsn(192, ByteCodeUtils.byteCodeName(type));
    }

    @Override
    public void newArray(TypeReference type, Expression ... exprs) {
        this.pushInteger(exprs.length);
        this.createArray(type);
        for (int i = 0; i < exprs.length; ++i) {
            this.methodVisitor.visitInsn(89);
            this.pushInteger(i);
            exprs[i].accept(this);
            this.arrayStore(type);
        }
    }

    @Override
    public void longToDouble(Expression expression) {
        expression.accept(this);
        this.methodVisitor.visitInsn(138);
    }

    @Override
    public void pop(Expression expression) {
        expression.accept(this);
        switch (expression.type().simpleName()) {
            case "long": 
            case "double": {
                this.methodVisitor.visitInsn(88);
                break;
            }
            default: {
                this.methodVisitor.visitInsn(87);
            }
        }
    }

    @Override
    public void box(Expression expression) {
        expression.accept(this);
        if (expression.type().isPrimitive()) {
            switch (expression.type().name()) {
                case "byte": {
                    this.methodVisitor.visitMethodInsn(184, "java/lang/Byte", "valueOf", "(B)Ljava/lang/Byte;", false);
                    break;
                }
                case "short": {
                    this.methodVisitor.visitMethodInsn(184, "java/lang/Short", "valueOf", "(S)Ljava/lang/Short;", false);
                    break;
                }
                case "int": {
                    this.methodVisitor.visitMethodInsn(184, "java/lang/Integer", "valueOf", "(I)Ljava/lang/Integer;", false);
                    break;
                }
                case "long": {
                    this.methodVisitor.visitMethodInsn(184, "java/lang/Long", "valueOf", "(J)Ljava/lang/Long;", false);
                    break;
                }
                case "char": {
                    this.methodVisitor.visitMethodInsn(184, "java/lang/Character", "valueOf", "(C)Ljava/lang/Character;", false);
                    break;
                }
                case "boolean": {
                    this.methodVisitor.visitMethodInsn(184, "java/lang/Boolean", "valueOf", "(Z)Ljava/lang/Boolean;", false);
                    break;
                }
                case "float": {
                    this.methodVisitor.visitMethodInsn(184, "java/lang/Float", "valueOf", "(F)Ljava/lang/Float;", false);
                    break;
                }
                case "double": {
                    this.methodVisitor.visitMethodInsn(184, "java/lang/Double", "valueOf", "(D)Ljava/lang/Double;", false);
                    break;
                }
            }
        }
    }

    @Override
    public void unbox(Expression expression) {
        expression.accept(this);
        switch (expression.type().fullName()) {
            case "java.lang.Byte": {
                this.methodVisitor.visitMethodInsn(182, "java/lang/Byte", "byteValue", "()B", false);
                break;
            }
            case "java.lang.Short": {
                this.methodVisitor.visitMethodInsn(182, "java/lang/Short", "shortValue", "()S", false);
                break;
            }
            case "java.lang.Integer": {
                this.methodVisitor.visitMethodInsn(182, "java/lang/Integer", "intValue", "()I", false);
                break;
            }
            case "java.lang.Long": {
                this.methodVisitor.visitMethodInsn(182, "java/lang/Long", "longValue", "()J", false);
                break;
            }
            case "java.lang.Character": {
                this.methodVisitor.visitMethodInsn(182, "java/lang/Character", "charValue", "()C", false);
                break;
            }
            case "java.lang.Boolean": {
                this.methodVisitor.visitMethodInsn(182, "java/lang/Boolean", "booleanValue", "()Z", false);
                break;
            }
            case "java.lang.Float": {
                this.methodVisitor.visitMethodInsn(182, "java/lang/Float", "floatValue", "()F", false);
                break;
            }
            case "java.lang.Double": {
                this.methodVisitor.visitMethodInsn(182, "java/lang/Double", "doubleValue", "()D", false);
                break;
            }
            default: {
                throw new IllegalStateException("Cannot unbox " + expression.type().fullName());
            }
        }
    }

    private void compareIntOrReferenceType(Expression lhs, Expression rhs, int opcode) {
        lhs.accept(this);
        rhs.accept(this);
        Label l0 = new Label();
        this.methodVisitor.visitJumpInsn(opcode, l0);
        this.methodVisitor.visitInsn(4);
        Label l1 = new Label();
        this.methodVisitor.visitJumpInsn(167, l1);
        this.methodVisitor.visitLabel(l0);
        this.methodVisitor.visitInsn(3);
        this.methodVisitor.visitLabel(l1);
    }

    private void compareLongOrFloatType(Expression lhs, Expression rhs, int opcode, int compare) {
        lhs.accept(this);
        rhs.accept(this);
        this.methodVisitor.visitInsn(opcode);
        Label l0 = new Label();
        this.methodVisitor.visitJumpInsn(compare, l0);
        this.methodVisitor.visitInsn(4);
        Label l1 = new Label();
        this.methodVisitor.visitJumpInsn(167, l1);
        this.methodVisitor.visitLabel(l0);
        this.methodVisitor.visitInsn(3);
        this.methodVisitor.visitLabel(l1);
    }

    private void pushInteger(int integer) {
        if (integer < 6 && integer >= -1) {
            this.methodVisitor.visitInsn(3 + integer);
        } else if (integer < 127 && integer > -128) {
            this.methodVisitor.visitIntInsn(16, integer);
        } else if (integer < Short.MAX_VALUE && integer > Short.MIN_VALUE) {
            this.methodVisitor.visitIntInsn(17, integer);
        } else {
            this.methodVisitor.visitLdcInsn(integer);
        }
    }

    private void pushLong(long integer) {
        if (integer == 0L) {
            this.methodVisitor.visitInsn(9);
        } else if (integer == 1L) {
            this.methodVisitor.visitInsn(10);
        } else {
            this.methodVisitor.visitLdcInsn(integer);
        }
    }

    private void createArray(TypeReference reference) {
        if (reference.isPrimitive()) {
            switch (reference.name()) {
                case "int": {
                    this.methodVisitor.visitIntInsn(188, 10);
                    break;
                }
                case "long": {
                    this.methodVisitor.visitIntInsn(188, 11);
                    break;
                }
                case "byte": {
                    this.methodVisitor.visitIntInsn(188, 8);
                    break;
                }
                case "short": {
                    this.methodVisitor.visitIntInsn(188, 9);
                    break;
                }
                case "char": {
                    this.methodVisitor.visitIntInsn(188, 5);
                    break;
                }
                case "float": {
                    this.methodVisitor.visitIntInsn(188, 6);
                    break;
                }
                case "double": {
                    this.methodVisitor.visitIntInsn(188, 7);
                    break;
                }
                case "boolean": {
                    this.methodVisitor.visitIntInsn(188, 4);
                    break;
                }
                default: {
                    this.methodVisitor.visitTypeInsn(189, ByteCodeUtils.byteCodeName(reference));
                    break;
                }
            }
        } else {
            this.methodVisitor.visitTypeInsn(189, ByteCodeUtils.byteCodeName(reference));
        }
    }

    private void arrayStore(TypeReference reference) {
        if (reference.isPrimitive()) {
            switch (reference.name()) {
                case "int": {
                    this.methodVisitor.visitInsn(79);
                    break;
                }
                case "long": {
                    this.methodVisitor.visitInsn(80);
                    break;
                }
                case "byte": {
                    this.methodVisitor.visitInsn(84);
                    break;
                }
                case "short": {
                    this.methodVisitor.visitInsn(86);
                    break;
                }
                case "char": {
                    this.methodVisitor.visitInsn(85);
                    break;
                }
                case "float": {
                    this.methodVisitor.visitInsn(81);
                    break;
                }
                case "double": {
                    this.methodVisitor.visitInsn(82);
                    break;
                }
                case "boolean": {
                    this.methodVisitor.visitInsn(84);
                    break;
                }
                default: {
                    this.methodVisitor.visitInsn(83);
                    break;
                }
            }
        } else {
            this.methodVisitor.visitInsn(83);
        }
    }

    private void numberOperation(TypeReference type, Runnable onInt, Runnable onLong, Runnable onFloat, Runnable onDouble) {
        if (!type.isPrimitive()) {
            throw new IllegalStateException("Cannot compare reference types");
        }
        switch (type.name()) {
            case "int": 
            case "byte": 
            case "short": 
            case "char": 
            case "boolean": {
                onInt.run();
                break;
            }
            case "long": {
                onLong.run();
                break;
            }
            case "float": {
                onFloat.run();
                break;
            }
            case "double": {
                onDouble.run();
                break;
            }
            default: {
                throw new IllegalStateException("Cannot compare reference types");
            }
        }
    }

    private void assertSameType(Expression lhs, Expression rhs, String operation) {
        if (!lhs.type().equals(rhs.type())) {
            throw new IllegalArgumentException(String.format("Can only %s values of the same type (lhs: %s, rhs: %s)", operation, lhs.type().toString(), rhs.type().toString()));
        }
    }
}

