/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.codegen.source;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.tools.Diagnostic;
import javax.tools.DiagnosticCollector;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileObject;
import org.neo4j.codegen.ByteCodes;
import org.neo4j.codegen.ClassEmitter;
import org.neo4j.codegen.CodeGenerator;
import org.neo4j.codegen.CompilationFailureException;
import org.neo4j.codegen.TypeReference;
import org.neo4j.codegen.source.ClassWriter;
import org.neo4j.codegen.source.Configuration;
import org.neo4j.codegen.source.FileManager;
import org.neo4j.codegen.source.JavaSourceFile;

class SourceCodeGenerator
extends CodeGenerator {
    private final Configuration configuration;
    private final Map<TypeReference, StringBuilder> classes = new HashMap<TypeReference, StringBuilder>();
    private final JavaCompiler compiler;

    SourceCodeGenerator(ClassLoader parentClassLoader, Configuration configuration, JavaCompiler javaCompiler) {
        super(parentClassLoader);
        this.configuration = configuration;
        this.compiler = javaCompiler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected ClassEmitter generate(TypeReference type, TypeReference base, TypeReference[] interfaces) {
        StringBuilder target = new StringBuilder().append("package ").append(type.packageName()).append(";\n");
        target.append("/** Generated by ").append(this.getClass().getName()).append(" */\n");
        target.append("public class ").append(type.simpleName()).append(" extends ").append(base.name()).append("\n");
        String prefix = "    implements ";
        for (TypeReference iFace : interfaces) {
            target.append(prefix).append(iFace.name());
            prefix = ", ";
        }
        if (prefix.length() == 2) {
            target.append("\n");
        }
        target.append("{\n");
        SourceCodeGenerator sourceCodeGenerator = this;
        synchronized (sourceCodeGenerator) {
            if (null != this.classes.put(type, target)) {
                throw new IllegalStateException("Trying to generate class twice: " + type);
            }
        }
        return new ClassWriter(target);
    }

    @Override
    protected Iterable<? extends ByteCodes> compile(ClassLoader classpathLoader) throws CompilationFailureException {
        DiagnosticCollector diagnostics = new DiagnosticCollector();
        FileManager fileManager = new FileManager(this.compiler.getStandardFileManager(diagnostics, this.configuration.locale(), this.configuration.chraset()));
        JavaCompiler.CompilationTask task = this.compiler.getTask(this.configuration.errorWriter(), fileManager, diagnostics, this.configuration.options(), null, this.sourceFiles());
        this.configuration.processors(task);
        if (task.call().booleanValue()) {
            this.configuration.warningsHandler().handle(diagnostics.getDiagnostics());
            return fileManager.bytecodes();
        }
        List<Diagnostic<?>> issues = diagnostics.getDiagnostics();
        throw new CompilationFailureException(issues);
    }

    private synchronized List<JavaSourceFile> sourceFiles() {
        ArrayList<JavaSourceFile> sourceFiles = new ArrayList<JavaSourceFile>(this.classes.size());
        for (Map.Entry<TypeReference, StringBuilder> entry : this.classes.entrySet()) {
            TypeReference reference = entry.getKey();
            StringBuilder source = entry.getValue();
            this.configuration.visit(reference, source);
            sourceFiles.add(new JavaSourceFile(this.configuration.sourceBase().uri(reference.packageName(), reference.simpleName(), JavaFileObject.Kind.SOURCE), source));
        }
        return sourceFiles;
    }
}

