/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cloud.storage.io;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Objects;
import org.neo4j.cloud.storage.io.WriteableChannel;

public class PathBasedInputStream
extends InputStream {
    private final Path path;
    private State state = State.OPEN;
    private InputStream input;

    public PathBasedInputStream(Path path) {
        this.path = Objects.requireNonNull(path);
    }

    @Override
    public long transferTo(OutputStream out) throws IOException {
        this.checkNotClosed();
        if (this.state == State.READING) {
            throw new IOException("Already read from the path: " + this.path);
        }
        if (out instanceof WriteableChannel) {
            WriteableChannel channel = (WriteableChannel)out;
            this.state = State.TRANSFERRING;
            return channel.transferFrom(this.path);
        }
        return this.setupReading().transferTo(out);
    }

    @Override
    public byte[] readAllBytes() throws IOException {
        return this.setupReading().readAllBytes();
    }

    @Override
    public int read() throws IOException {
        return this.setupReading().read();
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.setupReading().read(b);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        return this.setupReading().read(b, off, len);
    }

    @Override
    public byte[] readNBytes(int len) throws IOException {
        return this.setupReading().readNBytes(len);
    }

    @Override
    public int readNBytes(byte[] b, int off, int len) throws IOException {
        return this.setupReading().readNBytes(b, off, len);
    }

    @Override
    public void close() throws IOException {
        if (this.state == State.CLOSED) {
            return;
        }
        this.state = State.CLOSED;
        if (this.input != null) {
            this.input.close();
        }
    }

    private void checkNotClosed() throws IOException {
        if (this.state == State.CLOSED) {
            throw new IOException("Stream is already closed");
        }
    }

    private InputStream setupReading() throws IOException {
        this.checkNotClosed();
        if (this.state == State.TRANSFERRING) {
            throw new IOException("Stream is already being transferred from the path: " + this.path);
        }
        if (this.input == null) {
            this.state = State.READING;
            this.input = new BufferedInputStream(Files.newInputStream(this.path, new OpenOption[0]));
        }
        return this.input;
    }

    private static enum State {
        OPEN,
        TRANSFERRING,
        READING,
        CLOSED;

    }
}

