/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cloud.storage;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.eclipse.collections.api.factory.Lists;
import org.eclipse.collections.api.list.MutableList;
import org.neo4j.util.Preconditions;

public class PathRepresentation {
    public static final String SEPARATOR = "/";
    public static final String CURRENT = ".";
    public static final String PARENT = "..";
    public static final PathRepresentation ROOT = new PathRepresentation("/");
    public static final PathRepresentation EMPTY_PATH = new PathRepresentation("");
    public static final char PATH_SEPARATOR_CHAR = "/".charAt(0);
    public static final char CURRENT_DIR_CHAR = ".".charAt(0);
    public static final char PARENT_DIR_CHAR = "..".charAt(0);
    private final String path;

    private PathRepresentation(String path) {
        this.path = Objects.requireNonNull(path, "path may not be null");
    }

    private PathRepresentation(char[] chars) {
        this(new String(Objects.requireNonNull(chars, "path characters may not be null")));
    }

    static PathRepresentation of(char ... chars) {
        return new PathRepresentation(chars);
    }

    public static PathRepresentation of(String first, String ... more) {
        Preconditions.requireNonNull((Object)first, (String)"The first element of the path may not be null");
        Preconditions.requireNonNull((Object)more, (String)"The more elements of the path may not be null");
        Preconditions.requireNoNullElements((Object[])more);
        MutableList parts = Lists.mutable.of((Object[])more);
        parts.add(0, (Object)first);
        return new PathRepresentation(PathRepresentation.partsToPathString((MutableList<String>)parts));
    }

    public static String subpath(PathRepresentation path, int beginIndex, int endIndex) {
        List<String> elements = path.elements();
        int size = elements.size();
        Preconditions.checkArgument((beginIndex >= 0 ? 1 : 0) != 0, (String)"begin index may not be < 0");
        Preconditions.checkArgument((beginIndex < size ? 1 : 0) != 0, (String)"begin index may not be >= the number of path elements");
        Preconditions.checkArgument((endIndex <= size ? 1 : 0) != 0, (String)"end index may not be > the number of path elements");
        Preconditions.checkArgument((endIndex >= beginIndex ? 1 : 0) != 0, (String)"end index may not be <= the begin index");
        return String.join((CharSequence)SEPARATOR, elements.subList(beginIndex, endIndex));
    }

    public boolean isRoot() {
        return this.path.equals(SEPARATOR);
    }

    public boolean isAbsolute() {
        return PathRepresentation.isAbsolutePart(this.path);
    }

    public boolean isDirectory() {
        return this.path.isEmpty() || PathRepresentation.isDirectoryPart(this.path) || this.path.equals(CURRENT) || this.path.equals(PARENT) || this.path.endsWith(PATH_SEPARATOR_CHAR + CURRENT) || this.path.endsWith(PATH_SEPARATOR_CHAR + PARENT);
    }

    public boolean hasTrailingSeparator() {
        return PathRepresentation.isDirectoryPart(this.path);
    }

    public char[] chars() {
        return this.path.toCharArray();
    }

    public List<String> elements() {
        if (this.isRoot()) {
            return Collections.emptyList();
        }
        return Arrays.stream(this.path.split(SEPARATOR)).filter(s -> !s.trim().isEmpty()).toList();
    }

    public PathRepresentation subpath(int beginIndex, int endIndex) {
        String pathStr = PathRepresentation.subpath(this, beginIndex, endIndex);
        if (this.hasTrailingSeparator() || this.elements().size() > endIndex) {
            return new PathRepresentation(pathStr + SEPARATOR);
        }
        return new PathRepresentation(pathStr);
    }

    public PathRepresentation getParent() {
        int size = this.elements().size();
        if (this.isRoot() || this.equals(EMPTY_PATH)) {
            return null;
        }
        if (size == 1) {
            return this.isAbsolute() ? ROOT : null;
        }
        PathRepresentation subPath = this.subpath(0, size - 1);
        return this.isAbsolute() ? new PathRepresentation(SEPARATOR + subPath.path) : subPath;
    }

    public int length() {
        return this.path.length();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PathRepresentation that = (PathRepresentation)o;
        return this.path.equals(that.path);
    }

    public int hashCode() {
        return this.path.hashCode();
    }

    public String toString() {
        return this.path;
    }

    private static String partsToPathString(MutableList<String> allParts) {
        Object path = allParts.stream().flatMap(part -> Arrays.stream(part.split("/+"))).filter(p -> !p.isEmpty()).collect(Collectors.joining(SEPARATOR));
        if (PathRepresentation.isDirectoryPart((String)allParts.getLast()) && !PathRepresentation.isDirectoryPart((String)path)) {
            path = (String)path + SEPARATOR;
        }
        if (PathRepresentation.isAbsolutePart((String)allParts.getFirst()) && !PathRepresentation.isAbsolutePart((String)path)) {
            path = SEPARATOR + (String)path;
        }
        return path;
    }

    private static boolean isAbsolutePart(String path) {
        return path != null && !path.isEmpty() && path.charAt(0) == PATH_SEPARATOR_CHAR;
    }

    private static boolean isDirectoryPart(String path) {
        return !path.isEmpty() && path.charAt(path.length() - 1) == PATH_SEPARATOR_CHAR;
    }
}

